/*
 * $Id$
 *
 * Firebird Open Source JavaEE Connector - JDBC Driver
 *
 * Distributable under LGPL license.
 * You may obtain a copy of the License at http://www.gnu.org/copyleft/lgpl.html
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * LGPL License for more details.
 *
 * This file was created by members of the firebird development team.
 * All individual contributions remain the Copyright (C) of those
 * individuals.  Contributors to this file are either listed here or
 * can be obtained from a source control history command.
 *
 * All rights reserved.
 */
package org.firebirdsql.jna.fbclient;

import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.ptr.ShortByReference;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

/**
 * JNA Wrapper for library implementing <b>ibase.h</b>.
 * <p>
 * Do not use this version on Windows, use {@link org.firebirdsql.jna.fbclient.WinFbClientLibrary} instead.
 * </p>
 * <p>
 * This file was initially autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>, a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.
 * </p>
 * <p>
 * This file was modified manually, <strong>do not automatically regenerate!</strong> Some methods defined in {@code ibase.h}
 * deemed irrelevant for Jaybird were removed from the interface.
 * </p>
 * @since 3.0
 */
@SuppressWarnings("UnusedDeclaration")
public interface FbClientLibrary extends com.sun.jna.Library {

    /**
     * FbShutdown callback.
     * <p>
     * <b>Important:</b> On windows, use {@link org.firebirdsql.jna.fbclient.WinFbClientLibrary.FbShutdownStdCallback}
     * </p>
     */
	interface FbShutdownCallback extends Callback {
		int apply(int reason, int mask, Pointer arg);
	}
    /**
     * IscEvent callback.
     * <p>
     * <b>Important:</b> On windows, use {@link org.firebirdsql.jna.fbclient.WinFbClientLibrary.IscEventStdCallback}
     * </p>
     */
	interface IscEventCallback extends Callback {
		void apply(Pointer resultArgument, short eventBufferLength, Pointer eventsList);
	}
	/**
	 * Original signature : <code>ISC_STATUS isc_attach_database(ISC_STATUS*, short, const ISC_SCHAR*, isc_db_handle*, short, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:404</i>
	 */
    ISC_STATUS isc_attach_database(ISC_STATUS[] statusVector, short dbNameLength, byte[] dbName,
            IntByReference dbHandle, short paramBufferLength, byte[] paramBuffer);
	/**
	 * Original signature : <code>ISC_STATUS isc_array_get_slice(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, ISC_QUAD*, const ISC_ARRAY_DESC*, void*, ISC_LONG*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:417</i>
	 */
	ISC_STATUS isc_array_get_slice(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            GDS_QUAD_t arrayId, ISC_ARRAY_DESC desc, Pointer destArray, IntBuffer sliceLength);
	/**
	 * Original signature : <code>ISC_STATUS isc_array_lookup_bounds(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, const ISC_SCHAR*, const ISC_SCHAR*, ISC_ARRAY_DESC*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:425</i>
	 */
	ISC_STATUS isc_array_lookup_bounds(ISC_STATUS[] statusVector, IntByReference dbHandle,
            IntByReference trHandle, byte[] tableName, byte[] columnName, ISC_ARRAY_DESC desc);
	/**
	 * Original signature : <code>ISC_STATUS isc_array_lookup_desc(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, const ISC_SCHAR*, const ISC_SCHAR*, ISC_ARRAY_DESC*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:432</i>
	 */
	ISC_STATUS isc_array_lookup_desc(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            byte[] tableName, byte[] columnName, ISC_ARRAY_DESC desc);
	/**
	 * Original signature : <code>ISC_STATUS isc_array_set_desc(ISC_STATUS*, const ISC_SCHAR*, const ISC_SCHAR*, const short*, const short*, const short*, ISC_ARRAY_DESC*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:439</i>
	 */
	ISC_STATUS isc_array_set_desc(ISC_STATUS[] statusVector, byte[] tableName, byte[] columnName, short sqlDtype[],
            short sqlLength[], short dimensions[], ISC_ARRAY_DESC desc);
	/**
	 * Original signature : <code>ISC_STATUS isc_array_put_slice(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, ISC_QUAD*, const ISC_ARRAY_DESC*, void*, ISC_LONG*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:447</i>
	 */
	ISC_STATUS isc_array_put_slice(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            GDS_QUAD_t arrayId, ISC_ARRAY_DESC desc, Pointer sourceArray, IntBuffer sliceLength);
	/**
	 * Original signature : <code>void isc_blob_default_desc(ISC_BLOB_DESC*, const ISC_UCHAR*, const ISC_UCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:455</i>
	 */
	void isc_blob_default_desc(ISC_BLOB_DESC desc, byte[] tableName, byte[] columnName);
	/**
	 * Original signature : <code>ISC_STATUS isc_blob_gen_bpb(ISC_STATUS*, const ISC_BLOB_DESC*, const ISC_BLOB_DESC*, unsigned short, ISC_UCHAR*, unsigned short*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:459</i>
	 */
	ISC_STATUS isc_blob_gen_bpb(ISC_STATUS[] statusVector, ISC_BLOB_DESC toDesc,
            ISC_BLOB_DESC fromDesc, short bpbBufferLength, ByteBuffer bpbBuffer, ShortBuffer bpbLength);
	/**
	 * Original signature : <code>ISC_STATUS isc_blob_info(ISC_STATUS*, isc_blob_handle*, short, const ISC_SCHAR*, short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:466</i>
	 */
	ISC_STATUS isc_blob_info(ISC_STATUS[] statusVector, IntByReference blobHandle, short itemListBufferLength,
            byte[] itemListBuffer, short resultBufferLength, ByteBuffer resultBuffer);
	/**
	 * Original signature : <code>ISC_STATUS isc_blob_lookup_desc(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, const ISC_UCHAR*, const ISC_UCHAR*, ISC_BLOB_DESC*, ISC_UCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:473</i>
	 */
	ISC_STATUS isc_blob_lookup_desc(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            byte[] tableName, byte[] columnName, ISC_BLOB_DESC desc, ByteBuffer global);
	/**
	 * Original signature : <code>ISC_STATUS isc_blob_set_desc(ISC_STATUS*, const ISC_UCHAR*, const ISC_UCHAR*, short, short, short, ISC_BLOB_DESC*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:481</i>
	 */
	ISC_STATUS isc_blob_set_desc(ISC_STATUS[] statusVector, byte[] tableName, byte[] columnName, short subType,
            short charset, short segmentSize, ISC_BLOB_DESC desc);
	/**
	 * Original signature : <code>ISC_STATUS isc_cancel_blob(ISC_STATUS*, isc_blob_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:489</i>
	 */
	ISC_STATUS isc_cancel_blob(ISC_STATUS[] statusVector, IntByReference blobHandle);
	/**
	 * Original signature : <code>ISC_STATUS isc_cancel_events(ISC_STATUS*, isc_db_handle*, ISC_LONG*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:492</i>
	 */
	ISC_STATUS isc_cancel_events(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference eventId);
	/**
	 * Original signature : <code>ISC_STATUS isc_close_blob(ISC_STATUS*, isc_blob_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:496</i>
	 */
	ISC_STATUS isc_close_blob(ISC_STATUS[] statusVector, IntByReference blobHandle);
	/**
	 * Original signature : <code>ISC_STATUS isc_commit_retaining(ISC_STATUS*, isc_tr_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:499</i>
	 */
	ISC_STATUS isc_commit_retaining(ISC_STATUS[] statusVector, IntByReference trHandle);
	/**
	 * Original signature : <code>ISC_STATUS isc_commit_transaction(ISC_STATUS*, isc_tr_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:502</i>
	 */
	ISC_STATUS isc_commit_transaction(ISC_STATUS[] statusVector, IntByReference trHandle);
	/**
	 * Original signature : <code>ISC_STATUS isc_create_blob(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, isc_blob_handle*, ISC_QUAD*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:505</i>
	 */
	ISC_STATUS isc_create_blob(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            IntByReference blobHandle, GDS_QUAD_t blobId);
	/**
	 * Original signature : <code>ISC_STATUS isc_create_blob2(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, isc_blob_handle*, ISC_QUAD*, short, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:511</i>
	 */
	ISC_STATUS isc_create_blob2(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            IntByReference blobHandle, GDS_QUAD_t blobId, short bpbLength, byte[] bpb);
	/**
	 * Original signature : <code>ISC_STATUS isc_create_blob2(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, isc_blob_handle*, ISC_QUAD*, short, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:511</i>
	 */
	ISC_STATUS isc_create_blob2(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
			IntByReference blobHandle, LongByReference blobId, short bpbLength, byte[] bpb);
	/**
	 * Original signature : <code>ISC_STATUS isc_create_database(ISC_STATUS*, short, const ISC_SCHAR*, isc_db_handle*, short, const ISC_SCHAR*, short)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:519</i>
     * TODO: Interbase 6.0 API doc mentions this shouldn't be called
	 */
	ISC_STATUS isc_create_database(ISC_STATUS[] statusVector, short dbNameLength, byte[] dbName,
            IntByReference dbHandle, short paramBufferLength, byte[] paramBuffer, short dialect);
	/**
	 * Original signature : <code>ISC_STATUS isc_database_info(ISC_STATUS*, isc_db_handle*, short, const ISC_SCHAR*, short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:527</i>
	 */
	ISC_STATUS isc_database_info(ISC_STATUS[] statusVector, IntByReference dbHandle, short itemListBufferLength,
            byte[] itemListBuffer, short resultBufferLength, ByteBuffer resultBuffer);
	/**
	 * Original signature : <code>void isc_decode_date(const ISC_QUAD*, void*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:534</i>
	 */
	void isc_decode_date(GDS_QUAD_t ISC_QUADPtr1[], Pointer voidPtr1);
	/**
	 * Original signature : <code>void isc_decode_sql_date(const ISC_DATE*, void*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:537</i>
	 */
	void isc_decode_sql_date(int ISC_DATEPtr1[], Pointer voidPtr1);
	/**
	 * Original signature : <code>void isc_decode_sql_time(const ISC_TIME*, void*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:540</i>
	 */
	void isc_decode_sql_time(int ISC_TIMEPtr1[], Pointer voidPtr1);
	/**
	 * Original signature : <code>void isc_decode_timestamp(const ISC_TIMESTAMP*, void*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:543</i>
	 */
	void isc_decode_timestamp(ISC_TIMESTAMP ISC_TIMESTAMPPtr1, Pointer voidPtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_detach_database(ISC_STATUS*, isc_db_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:546</i>
	 */
	ISC_STATUS isc_detach_database(ISC_STATUS[] statusVector, IntByReference dbHandle);
	/**
	 * Original signature : <code>ISC_STATUS isc_drop_database(ISC_STATUS*, isc_db_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:549</i>
	 */
	ISC_STATUS isc_drop_database(ISC_STATUS[] statusVector, IntByReference dbHandle);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_allocate_statement(ISC_STATUS*, isc_db_handle*, isc_stmt_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:552</i>
	 */
	ISC_STATUS isc_dsql_allocate_statement(ISC_STATUS[] statusVector, IntByReference dbHandle,
            IntByReference stmtHandle);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_alloc_statement2(ISC_STATUS*, isc_db_handle*, isc_stmt_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:556</i>
	 */
	ISC_STATUS isc_dsql_alloc_statement2(ISC_STATUS[] statusVector, IntByReference dbHandle,
            IntByReference stmtHandle);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_describe(ISC_STATUS*, isc_stmt_handle*, unsigned short, XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:560</i>
	 */
	ISC_STATUS isc_dsql_describe(ISC_STATUS[] statusVector, IntByReference stmtHandle, short daVersion, XSQLDA xsqlda);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_describe_bind(ISC_STATUS*, isc_stmt_handle*, unsigned short, XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:565</i>
	 */
	ISC_STATUS isc_dsql_describe_bind(ISC_STATUS[] statusVector, IntByReference stmtHandle, short daVersion,
            XSQLDA xsqlda);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_exec_immed2(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, unsigned short, const ISC_SCHAR*, unsigned short, const XSQLDA*, const XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:570</i>
	 */
	ISC_STATUS isc_dsql_exec_immed2(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            short length, byte[] statement, short dialect, XSQLDA inXsqlda, XSQLDA outXsqlda);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_execute(ISC_STATUS*, isc_tr_handle*, isc_stmt_handle*, unsigned short, const XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:579</i>
	 */
	ISC_STATUS isc_dsql_execute(ISC_STATUS[] statusVector, IntByReference trHandle, IntByReference stmtHandle,
            short daVersion, XSQLDA xsqlda);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_execute2(ISC_STATUS*, isc_tr_handle*, isc_stmt_handle*, unsigned short, const XSQLDA*, const XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:585</i>
	 */
	ISC_STATUS isc_dsql_execute2(ISC_STATUS[] statusVector, IntByReference trHandle, IntByReference stmtHandle,
            short daVersion, XSQLDA inXsqlda, XSQLDA outXsqlda);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_execute_immediate(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, unsigned short, const ISC_SCHAR*, unsigned short, const XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:592</i>
	 */
	ISC_STATUS isc_dsql_execute_immediate(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            short length, byte[] statement, short dialect, XSQLDA xsqlda);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_fetch(ISC_STATUS*, isc_stmt_handle*, unsigned short, const XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:600</i>
	 */
	ISC_STATUS isc_dsql_fetch(ISC_STATUS[] statusVector, IntByReference stmtHandle, short daVersion, XSQLDA xsqlda);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_free_statement(ISC_STATUS*, isc_stmt_handle*, unsigned short)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:607</i>
	 */
	ISC_STATUS isc_dsql_free_statement(ISC_STATUS[] statusVector, IntByReference stmtHandle, short option);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_prepare(ISC_STATUS*, isc_tr_handle*, isc_stmt_handle*, unsigned short, const ISC_SCHAR*, unsigned short, XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:616</i>
	 */
	ISC_STATUS isc_dsql_prepare(ISC_STATUS[] statusVector, IntByReference trHandle,
            IntByReference stmtHandle, short length, byte[] statement, short dialect, XSQLDA xsqlda);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_set_cursor_name(ISC_STATUS*, isc_stmt_handle*, const ISC_SCHAR*, unsigned short)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:624</i>
	 */
	ISC_STATUS isc_dsql_set_cursor_name(ISC_STATUS[] statusVector, IntByReference stmtHandle, byte[] cursorName,
            short type);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_sql_info(ISC_STATUS*, isc_stmt_handle*, short, const ISC_SCHAR*, short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:629</i>
	 */
	ISC_STATUS isc_dsql_sql_info(ISC_STATUS[] statusVector, IntByReference stmtHandle, short itemListBufferLength,
            byte[] itemListBuffer, short responseBufferLength, ByteBuffer responseBuffer);
	/**
	 * Original signature : <code>ISC_STATUS ISC_EXPORT fb_dsql_set_timeout(ISC_STATUS*, isc_stmt_handle*, ISC_ULONG)</code><br>
	 * <i>native declaration : D:\DevSoft\FB_tests\Firebird-4.0.0.1691-0_x64\include\ibase.h:629</i>
	 */
	ISC_STATUS fb_dsql_set_timeout(ISC_STATUS[] statusVector, IntByReference stmtHandle, int timeoutMs);
	/**
	 * Original signature : <code>void isc_encode_date(const void*, ISC_QUAD*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:636</i>
	 */
	void isc_encode_date(Pointer voidPtr1, GDS_QUAD_t ISC_QUADPtr1);
	/**
	 * Original signature : <code>void isc_encode_sql_date(const void*, ISC_DATE*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:639</i>
	 */
	void isc_encode_sql_date(Pointer voidPtr1, IntBuffer ISC_DATEPtr1);
	/**
	 * Original signature : <code>void isc_encode_sql_time(const void*, ISC_TIME*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:642</i>
	 */
	void isc_encode_sql_time(Pointer voidPtr1, IntBuffer ISC_TIMEPtr1);
	/**
	 * Original signature : <code>void isc_encode_timestamp(const void*, ISC_TIMESTAMP*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:645</i>
	 */
	void isc_encode_timestamp(Pointer voidPtr1, ISC_TIMESTAMP ISC_TIMESTAMPPtr1);
	/**
	 * Original signature : <code>ISC_LONG isc_event_block(ISC_UCHAR**, ISC_UCHAR**, ISC_USHORT, null)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:648</i>
	 */
	int isc_event_block(PointerByReference eventBuffer, PointerByReference resultBuffer, short idCount,
            Object... eventNames);
	/**
	 * Original signature : <code>ISC_USHORT isc_event_block_a(ISC_SCHAR**, ISC_SCHAR**, ISC_USHORT, ISC_SCHAR**)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:652</i>
	 */
	short isc_event_block_a(PointerByReference eventBuffer, PointerByReference resultBuffer, short idCount,
            PointerByReference eventNames);
	/**
	 * Original signature : <code>void isc_event_block_s(ISC_SCHAR**, ISC_SCHAR**, ISC_USHORT, ISC_SCHAR**, ISC_USHORT*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:657</i>
	 */
	void isc_event_block_s(PointerByReference eventBuffer, PointerByReference resultBuffer, short idCount,
            PointerByReference eventNames, ShortBuffer ISC_USHORTPtr1);
	/**
	 * Original signature : <code>void isc_event_counts(ISC_ULONG*, short, ISC_UCHAR*, const ISC_UCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:663</i>
	 */
	void isc_event_counts(ISC_STATUS[] statusVector, short bufferLength, Pointer eventBuffer, Pointer resultBuffer);
	/**
	 * 17 May 2001 - isc_expand_dpb is DEPRECATED<br>
	 * Original signature : <code>void isc_expand_dpb(ISC_SCHAR**, short*, null)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:669</i>
	 */
	void isc_expand_dpb(PointerByReference dpb, ShortBuffer dpbSize, Object... items);
	/**
	 * Original signature : <code>int isc_modify_dpb(ISC_SCHAR**, short*, unsigned short, const ISC_SCHAR*, short)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:672</i>
	 */
	int isc_modify_dpb(PointerByReference ISC_SCHARPtrPtr1, ShortBuffer sPtr1, short u1, byte ISC_SCHARPtr1[], short s1);
	/**
	 * Original signature : <code>ISC_LONG isc_free(ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:678</i>
	 */
	int isc_free(Pointer ISC_SCHARPtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_get_segment(ISC_STATUS*, isc_blob_handle*, unsigned short*, unsigned short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:680</i>
	 */
	ISC_STATUS isc_get_segment(ISC_STATUS[] statusVector, IntByReference blobHandle, ShortByReference actualSegLength,
            short segBufferLength, ByteBuffer segBuffer);
	/**
	 * Original signature : <code>ISC_STATUS isc_get_slice(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, ISC_QUAD*, short, const ISC_SCHAR*, short, const ISC_LONG*, ISC_LONG, void*, ISC_LONG*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:686</i>
	 */
	ISC_STATUS isc_get_slice(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            GDS_QUAD_t arrayId, short s1, byte ISC_SCHARPtr1[], short s2, int ISC_LONGPtr1[], int ISC_LONG1,
            Pointer voidPtr1, IntBuffer ISC_LONGPtr2);
	/**
	 * CVC: This non-const signature is needed for compatibility, see gds.cpp.<br>
	 * Original signature : <code>ISC_LONG isc_interprete(ISC_SCHAR*, ISC_STATUS**)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:699</i>
	 */
	int isc_interprete(ByteBuffer buffer, PointerByReference statusVector);
	/**
	 * This const params version used in the engine and other places.<br>
	 * Original signature : <code>ISC_LONG fb_interpret(ISC_SCHAR*, unsigned int, const ISC_STATUS**)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:703</i>
	 */
	int fb_interpret(ByteBuffer buffer, int int1, PointerByReference statusVector);
	/**
	 * Original signature : <code>ISC_STATUS isc_open_blob(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, isc_blob_handle*, ISC_QUAD*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:707</i>
	 */
	ISC_STATUS isc_open_blob(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            IntByReference blobHandle, GDS_QUAD_t blobId);
	/**
	 * Original signature : <code>ISC_STATUS isc_open_blob2(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, isc_blob_handle*, ISC_QUAD*, ISC_USHORT, const ISC_UCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:713</i>
	 */
	ISC_STATUS isc_open_blob2(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            IntByReference blobHandle, GDS_QUAD_t blobId, short bpbLength, byte[] bpb);
	/**
	 * Original signature : <code>ISC_STATUS isc_open_blob2(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, isc_blob_handle*, ISC_QUAD*, ISC_USHORT, const ISC_UCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:713</i>
	 */
	ISC_STATUS isc_open_blob2(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
			IntByReference blobHandle, LongByReference blobId, short bpbLength, byte[] bpb);
	/**
	 * Original signature : <code>ISC_STATUS isc_prepare_transaction2(ISC_STATUS*, isc_tr_handle*, ISC_USHORT, const ISC_UCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:721</i>
	 */
	ISC_STATUS isc_prepare_transaction2(ISC_STATUS[] statusVector, IntByReference trHandle, short msgLength,
            byte[] message);
	/**
	 * Original signature : <code>ISC_STATUS isc_put_segment(ISC_STATUS*, isc_blob_handle*, unsigned short, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:731</i>
	 */
	ISC_STATUS isc_put_segment(ISC_STATUS[] statusVector, IntByReference blobHandle, short segBufferLength,
            byte[] segBuffer);
	/**
	 * Original signature : <code>ISC_STATUS isc_put_slice(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, ISC_QUAD*, short, const ISC_SCHAR*, short, const ISC_LONG*, ISC_LONG, void*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:736</i>
	 */
	ISC_STATUS isc_put_slice(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            GDS_QUAD_t arrayId, short s1, byte ISC_SCHARPtr1[], short s2, int ISC_LONGPtr1[], int ISC_LONG1,
            Pointer voidPtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_que_events(ISC_STATUS*, isc_db_handle*, ISC_LONG*, short, const ISC_UCHAR*, ISC_EVENT_CALLBACK, void*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:747</i>
     * TODO: Currently does not satisfy requirements in documentation!
	 */
	ISC_STATUS isc_que_events(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference eventId, short length,
            Pointer eventBuffer, IscEventCallback eventFunction, Pointer eventFunctionArg);
	/**
	 * Original signature : <code>ISC_STATUS isc_rollback_retaining(ISC_STATUS*, isc_tr_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:755</i>
	 */
	ISC_STATUS isc_rollback_retaining(ISC_STATUS[] statusVector, IntByReference trHandle);
	/**
	 * Original signature : <code>ISC_STATUS isc_rollback_transaction(ISC_STATUS*, isc_tr_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:758</i>
	 */
	ISC_STATUS isc_rollback_transaction(ISC_STATUS[] statusVector, IntByReference trHandle);
	/**
	 * Original signature : <code>ISC_STATUS isc_start_multiple(ISC_STATUS*, isc_tr_handle*, short, void*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:761</i>
	 */
	ISC_STATUS isc_start_multiple(ISC_STATUS[] statusVector, IntByReference trHandle, short dbHandleCount, Pointer teb);
	/**
	 * Original signature : <code>ISC_STATUS isc_start_transaction(ISC_STATUS*, isc_tr_handle*, short, null)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:766</i>
	 */
	ISC_STATUS isc_start_transaction(ISC_STATUS[] statusVector, IntByReference trHandle, short dbHandleCount, Object... teb);
	/**
	 * Original signature : <code>ISC_STATUS fb_disconnect_transaction(ISC_STATUS*, isc_tr_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:770</i>
	 */
    ISC_STATUS fb_disconnect_transaction(ISC_STATUS[] statusVector, IntByReference trHandle);
	/**
	 * Original signature : <code>ISC_LONG isc_sqlcode(const ISC_STATUS*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:772</i>
	 */
	int isc_sqlcode(ISC_STATUS statusVector[]);
	/**
	 * Original signature : <code>void isc_sqlcode_s(const ISC_STATUS*, ISC_ULONG*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:774</i>
	 */
	void isc_sqlcode_s(ISC_STATUS statusVector[], IntBuffer ISC_ULONGPtr1);
	/**
	 * Original signature : <code>void fb_sqlstate(char*, const ISC_STATUS*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:777</i>
	 */
	void fb_sqlstate(ByteBuffer charPtr1, ISC_STATUS statusVector[]);
	/**
	 * Original signature : <code>void isc_sql_interprete(short, ISC_SCHAR*, short)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:780</i>
	 */
	void isc_sql_interprete(short s1, ByteBuffer ISC_SCHARPtr1, short s2);
	/**
	 * Original signature : <code>ISC_STATUS isc_transaction_info(ISC_STATUS*, isc_tr_handle*, short, const ISC_SCHAR*, short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:784</i>
	 */
	ISC_STATUS isc_transaction_info(ISC_STATUS[] statusVector, IntByReference trHandle, short itemListBufferLength,
            byte[] itemListBuffer, short resultBufferLength, ByteBuffer resultBuffer);
	/**
	 * Original signature : <code>ISC_STATUS isc_transact_request(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, unsigned short, ISC_SCHAR*, unsigned short, ISC_SCHAR*, unsigned short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:791</i>
	 */
	ISC_STATUS isc_transact_request(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            short u1, ByteBuffer ISC_SCHARPtr1, short u2, ByteBuffer ISC_SCHARPtr2, short u3, ByteBuffer ISC_SCHARPtr3);
	/**
	 * Original signature : <code>ISC_LONG isc_vax_integer(const ISC_SCHAR*, short)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:801</i>
	 */
	int isc_vax_integer(byte ISC_SCHARPtr1[], short s1);
	/**
	 * Original signature : <code>ISC_INT64 isc_portable_integer(const ISC_UCHAR*, short)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:804</i>
	 */
	long isc_portable_integer(byte ISC_UCHARPtr1[], short s1);
	/**
	 * Original signature : <code>ISC_STATUS isc_add_user(ISC_STATUS*, const USER_SEC_DATA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:843</i>
	 */
	ISC_STATUS isc_add_user(ISC_STATUS[] statusVector, USER_SEC_DATA USER_SEC_DATAPtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_delete_user(ISC_STATUS*, const USER_SEC_DATA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:845</i>
	 */
	ISC_STATUS isc_delete_user(ISC_STATUS[] statusVector, USER_SEC_DATA USER_SEC_DATAPtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_modify_user(ISC_STATUS*, const USER_SEC_DATA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:847</i>
	 */
	ISC_STATUS isc_modify_user(ISC_STATUS[] statusVector, USER_SEC_DATA USER_SEC_DATAPtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_compile_request(ISC_STATUS*, isc_db_handle*, isc_req_handle*, short, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:853</i>
	 */
	ISC_STATUS isc_compile_request(ISC_STATUS[] statusVector, IntByReference dbHandle,
            IntByReference isc_req_handlePtr1, short s1, byte ISC_SCHARPtr1[]);
	/**
	 * Original signature : <code>ISC_STATUS isc_compile_request2(ISC_STATUS*, isc_db_handle*, isc_req_handle*, short, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:859</i>
	 */
	ISC_STATUS isc_compile_request2(ISC_STATUS[] statusVector, IntByReference dbHandle,
            IntByReference isc_req_handlePtr1, short s1, byte ISC_SCHARPtr1[]);
	/**
	 * Original signature : <code>ISC_STATUS isc_ddl(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, short, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:865</i>
	 */
	ISC_STATUS isc_ddl(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle, short s1,
            byte ISC_SCHARPtr1[]);
	/**
	 * Original signature : <code>ISC_STATUS isc_prepare_transaction(ISC_STATUS*, isc_tr_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:871</i>
	 */
	ISC_STATUS isc_prepare_transaction(ISC_STATUS[] statusVector, IntByReference trHandle);
	/**
	 * Original signature : <code>ISC_STATUS isc_receive(ISC_STATUS*, isc_req_handle*, short, short, void*, short)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:875</i>
	 */
	ISC_STATUS isc_receive(ISC_STATUS[] statusVector, IntByReference isc_req_handlePtr1, short s1, short s2,
            Pointer voidPtr1, short s3);
	/**
	 * Original signature : <code>ISC_STATUS isc_reconnect_transaction(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, short, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:882</i>
	 */
	ISC_STATUS isc_reconnect_transaction(ISC_STATUS[] statusVector, IntByReference dbHandle,
            IntByReference trHandle, short length, byte[] transactionIdBuffer);
	/**
	 * Original signature : <code>ISC_STATUS isc_release_request(ISC_STATUS*, isc_req_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:888</i>
	 */
	ISC_STATUS isc_release_request(ISC_STATUS[] statusVector, IntByReference isc_req_handlePtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_request_info(ISC_STATUS*, isc_req_handle*, short, short, const ISC_SCHAR*, short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:891</i>
	 */
	ISC_STATUS isc_request_info(ISC_STATUS[] statusVector, IntByReference isc_req_handlePtr1, short s1, short s2,
            byte ISC_SCHARPtr1[], short s3, ByteBuffer ISC_SCHARPtr2);
	/**
	 * Original signature : <code>ISC_STATUS isc_seek_blob(ISC_STATUS*, isc_blob_handle*, short, ISC_LONG, ISC_LONG*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:899</i>
	 */
	ISC_STATUS isc_seek_blob(ISC_STATUS[] statusVector, IntByReference blobHandle, short mode, int offset,
            IntByReference result);
	/**
	 * Original signature : <code>ISC_STATUS isc_send(ISC_STATUS*, isc_req_handle*, short, short, const void*, short)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:905</i>
	 */
	ISC_STATUS isc_send(ISC_STATUS[] statusVector, IntByReference isc_req_handlePtr1, short s1, short s2,
            Pointer voidPtr1, short s3);
	/**
	 * Original signature : <code>ISC_STATUS isc_start_and_send(ISC_STATUS*, isc_req_handle*, isc_tr_handle*, short, short, const void*, short)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:912</i>
	 */
	ISC_STATUS isc_start_and_send(ISC_STATUS[] statusVector, IntByReference isc_req_handlePtr1,
            IntByReference trHandle, short s1, short s2, Pointer voidPtr1, short s3);
	/**
	 * Original signature : <code>ISC_STATUS isc_start_request(ISC_STATUS*, isc_req_handle*, isc_tr_handle*, short)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:920</i>
	 */
	ISC_STATUS isc_start_request(ISC_STATUS[] statusVector, IntByReference isc_req_handlePtr1,
            IntByReference trHandle, short s1);
	/**
	 * Original signature : <code>ISC_STATUS isc_unwind_request(ISC_STATUS*, isc_tr_handle*, short)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:925</i>
	 */
	ISC_STATUS isc_unwind_request(ISC_STATUS[] statusVector, IntByReference trHandle, short s1);
	/**
	 * Original signature : <code>ISC_STATUS isc_wait_for_event(ISC_STATUS*, isc_db_handle*, short, const ISC_UCHAR*, ISC_UCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:929</i>
	 */
	ISC_STATUS isc_wait_for_event(ISC_STATUS[] statusVector, IntByReference dbHandle, short s1, byte ISC_UCHARPtr1[],
            ByteBuffer ISC_UCHARPtr2);
	/**
	 * Original signature : <code>ISC_STATUS isc_close(ISC_STATUS*, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:940</i>
	 */
	ISC_STATUS isc_close(ISC_STATUS[] statusVector, byte ISC_SCHARPtr1[]);
	/**
	 * Original signature : <code>ISC_STATUS isc_declare(ISC_STATUS*, const ISC_SCHAR*, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:943</i>
	 */
	ISC_STATUS isc_declare(ISC_STATUS[] statusVector, byte ISC_SCHARPtr1[], byte ISC_SCHARPtr2[]);
	/**
	 * Original signature : <code>ISC_STATUS isc_describe(ISC_STATUS*, const ISC_SCHAR*, XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:947</i>
	 */
	ISC_STATUS isc_describe(ISC_STATUS[] statusVector, byte ISC_SCHARPtr1[], XSQLDA XSQLDAPtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_describe_bind(ISC_STATUS*, const ISC_SCHAR*, XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:951</i>
	 */
	ISC_STATUS isc_describe_bind(ISC_STATUS[] statusVector, byte ISC_SCHARPtr1[], XSQLDA XSQLDAPtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_execute(ISC_STATUS*, isc_tr_handle*, const ISC_SCHAR*, XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:955</i>
	 */
	ISC_STATUS isc_execute(ISC_STATUS[] statusVector, IntByReference trHandle, byte ISC_SCHARPtr1[],
            XSQLDA XSQLDAPtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_execute_immediate(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, short*, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:960</i>
	 */
	ISC_STATUS isc_execute_immediate(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            ShortBuffer sPtr1, byte ISC_SCHARPtr1[]);
	/**
	 * Original signature : <code>ISC_STATUS isc_fetch(ISC_STATUS*, const ISC_SCHAR*, XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:966</i>
	 */
	ISC_STATUS isc_fetch(ISC_STATUS[] statusVector, byte ISC_SCHARPtr1[], XSQLDA XSQLDAPtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_open(ISC_STATUS*, isc_tr_handle*, const ISC_SCHAR*, XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:970</i>
	 */
	ISC_STATUS isc_open(ISC_STATUS[] statusVector, IntByReference trHandle, byte ISC_SCHARPtr1[], XSQLDA XSQLDAPtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_prepare(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, const ISC_SCHAR*, const short*, const ISC_SCHAR*, XSQLDA*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:975</i>
	 */
	ISC_STATUS isc_prepare(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            byte ISC_SCHARPtr1[], short cPtr1[], byte ISC_SCHARPtr2[], XSQLDA XSQLDAPtr1);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_execute_m(ISC_STATUS*, isc_tr_handle*, isc_stmt_handle*, unsigned short, const ISC_SCHAR*, unsigned short, unsigned short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:988</i>
	 */
	ISC_STATUS isc_dsql_execute_m(ISC_STATUS[] statusVector, IntByReference trHandle,
            IntByReference stmtHandle, short inBlrLength, byte[] inBlr, short inMsgType, short inMsgLength,
            ByteBuffer inMsg);
    /**
     * Original signature : <code>ISC_STATUS isc_dsql_execute_m(ISC_STATUS*, isc_tr_handle*, isc_stmt_handle*, unsigned short, const ISC_SCHAR*, unsigned short, unsigned short, ISC_SCHAR*)</code><br>
     * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:988</i>
     */
    ISC_STATUS isc_dsql_execute_m(ISC_STATUS[] statusVector, IntByReference trHandle,
            IntByReference stmtHandle, short inBlrLength, byte[] inBlr, short inMsgType, short inMsgLength,
            byte[] inMsg);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_execute2_m(ISC_STATUS*, isc_tr_handle*, isc_stmt_handle*, unsigned short, const ISC_SCHAR*, unsigned short, unsigned short, ISC_SCHAR*, unsigned short, ISC_SCHAR*, unsigned short, unsigned short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:997</i>
	 */
	ISC_STATUS isc_dsql_execute2_m(ISC_STATUS[] statusVector, IntByReference trHandle,
            IntByReference stmtHandle, short inBlrLength, byte[] inBlr, short inMsgType, short inMsgLength,
            ByteBuffer inMsg, short outBlrLength, ByteBuffer outBlr, short outMsgType, short outMsgLength, ByteBuffer outMsg);
    /**
     * Original signature : <code>ISC_STATUS isc_dsql_execute2_m(ISC_STATUS*, isc_tr_handle*, isc_stmt_handle*, unsigned short, const ISC_SCHAR*, unsigned short, unsigned short, ISC_SCHAR*, unsigned short, ISC_SCHAR*, unsigned short, unsigned short, ISC_SCHAR*)</code><br>
     * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:997</i>
     */
    ISC_STATUS isc_dsql_execute2_m(ISC_STATUS[] statusVector, IntByReference trHandle,
            IntByReference stmtHandle, short inBlrLength, byte[] inBlr, short inMsgType, short inMsgLength,
            byte[] inMsg, short outBlrLength, byte[] outBlr, short outMsgType, short outMsgLength, ByteBuffer outMsg);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_execute_immediate_m(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, unsigned short, const ISC_SCHAR*, unsigned short, unsigned short, ISC_SCHAR*, unsigned short, unsigned short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1011</i>
	 */
	ISC_STATUS isc_dsql_execute_immediate_m(ISC_STATUS[] statusVector, IntByReference dbHandle,
            IntByReference trHandle, short u1, byte ISC_SCHARPtr1[], short u2, short u3, ByteBuffer ISC_SCHARPtr2,
            short u4, short u5, ByteBuffer ISC_SCHARPtr3);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_exec_immed3_m(ISC_STATUS*, isc_db_handle*, isc_tr_handle*, unsigned short, const ISC_SCHAR*, unsigned short, unsigned short, ISC_SCHAR*, unsigned short, unsigned short, const ISC_SCHAR*, unsigned short, ISC_SCHAR*, unsigned short, unsigned short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1023</i>
	 */
	ISC_STATUS isc_dsql_exec_immed3_m(ISC_STATUS[] statusVector, IntByReference dbHandle, IntByReference trHandle,
            short u1, byte ISC_SCHARPtr1[], short u2, short u3, ByteBuffer ISC_SCHARPtr2, short u4, short u5,
            byte ISC_SCHARPtr3[], short u6, ByteBuffer ISC_SCHARPtr4, short u7, short u8, ByteBuffer ISC_SCHARPtr5);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_fetch_m(ISC_STATUS*, isc_stmt_handle*, unsigned short, ISC_SCHAR*, unsigned short, unsigned short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1040</i>
	 */
	ISC_STATUS isc_dsql_fetch_m(ISC_STATUS[] statusVector, IntByReference stmtHandle, short u1,
            ByteBuffer ISC_SCHARPtr1, short u2, short u3, ByteBuffer ISC_SCHARPtr2);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_insert_m(ISC_STATUS*, isc_stmt_handle*, unsigned short, const ISC_SCHAR*, unsigned short, unsigned short, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1048</i>
	 */
	ISC_STATUS isc_dsql_insert_m(ISC_STATUS[] statusVector, IntByReference stmtHandle, short u1,
            byte ISC_SCHARPtr1[], short u2, short u3, byte ISC_SCHARPtr2[]);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_prepare_m(ISC_STATUS*, isc_tr_handle*, isc_stmt_handle*, unsigned short, const ISC_SCHAR*, unsigned short, unsigned short, const ISC_SCHAR*, unsigned short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1056</i>
	 */
	ISC_STATUS isc_dsql_prepare_m(ISC_STATUS[] statusVector, IntByReference trHandle,
            IntByReference stmtHandle, short length, byte[] statement, short dialect, short itemListBufferLength,
            byte[] itemListBuffer, short resultBufferLength, ByteBuffer resultBuffer);
	/**
	 * Original signature : <code>ISC_STATUS isc_dsql_release(ISC_STATUS*, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1067</i>
	 */
	ISC_STATUS isc_dsql_release(ISC_STATUS[] statusVector, byte ISC_SCHARPtr1[]);
	/**
	 * Original signature : <code>ISC_STATUS isc_service_attach(ISC_STATUS*, unsigned short, const ISC_SCHAR*, isc_svc_handle*, unsigned short, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1259</i>
	 */
	ISC_STATUS isc_service_attach(ISC_STATUS[] statusVector, short serviceLength, byte[] service,
            IntByReference svcHandle, short spbLength, byte[] spb);
	/**
	 * Original signature : <code>ISC_STATUS isc_service_detach(ISC_STATUS*, isc_svc_handle*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1266</i>
	 */
	ISC_STATUS isc_service_detach(ISC_STATUS[] statusVector, IntByReference svcHandle);
	/**
	 * Original signature : <code>ISC_STATUS isc_service_query(ISC_STATUS*, isc_svc_handle*, isc_resv_handle*, unsigned short, const ISC_SCHAR*, unsigned short, const ISC_SCHAR*, unsigned short, ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1269</i>
	 */
	ISC_STATUS isc_service_query(ISC_STATUS[] statusVector, IntByReference svcHandle, IntByReference reserved,
            short sendSpbLength, byte[] sendSpb, short requestSpbLength, byte[] requestSpb, short bufferLength,
            ByteBuffer buffer);
	/**
	 * Original signature : <code>ISC_STATUS isc_service_start(ISC_STATUS*, isc_svc_handle*, isc_resv_handle*, unsigned short, const ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1279</i>
	 */
	ISC_STATUS isc_service_start(ISC_STATUS[] statusVector, IntByReference svcHandle, IntByReference reserved,
            short spbLength, byte[] spb);
	/**
	 * Original signature : <code>int fb_shutdown(unsigned int, const int)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1289</i>
	 */
	int fb_shutdown(int int1, int int2);
	/**
	 * Original signature : <code>ISC_STATUS fb_shutdown_callback(ISC_STATUS*, FB_SHUTDOWN_CALLBACK, const int, void*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1291</i>
	 */
    ISC_STATUS fb_shutdown_callback(ISC_STATUS[] statusVector, FbShutdownCallback FB_SHUTDOWN_CALLBACK1, int int1,
            Pointer voidPtr1);
	/**
	 * Original signature : <code>ISC_STATUS fb_cancel_operation(ISC_STATUS*, isc_db_handle*, ISC_USHORT)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1296</i>
	 */
    ISC_STATUS fb_cancel_operation(ISC_STATUS[] statusVector, IntByReference dbHandle, short kind);
	/**
	 * Original signature : <code>void isc_get_client_version(ISC_SCHAR*)</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1304</i>
	 */
	void isc_get_client_version(ByteBuffer ISC_SCHARPtr1);
	/**
	 * Original signature : <code>int isc_get_client_major_version()</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1305</i>
	 */
	int isc_get_client_major_version();
	/**
	 * Original signature : <code>int isc_get_client_minor_version()</code><br>
	 * <i>native declaration : C:\Program Files\Firebird\Firebird_2_5\include\ibase.h:1306</i>
	 */
	int isc_get_client_minor_version();
}
