/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.firebirdsql.jdbc.parser.ReservedWords;
import org.firebirdsql.jdbc.parser.SqlTokenizer;
import org.firebirdsql.jdbc.parser.Token;
import org.firebirdsql.jdbc.parser.TokenVisitor;
import org.firebirdsql.jdbc.parser.VisitorRegistrar;

public final class SqlParser
implements VisitorRegistrar {
    private static final Logger log = Logger.getLogger(SqlParser.class.getName());
    private final Set<TokenVisitor> visitors = new CopyOnWriteArraySet<TokenVisitor>();
    private final Iterator<Token> tokenIterator;
    private boolean started;
    private boolean completed;
    private boolean parsing;

    SqlParser(Iterator<Token> tokenIterator) {
        this.tokenIterator = tokenIterator;
    }

    public static Builder withReservedWords(ReservedWords reservedWords) {
        return new Builder(SqlTokenizer.withReservedWords(reservedWords));
    }

    public void parse() {
        if (this.started) {
            throw new IllegalStateException("Parsing was already started");
        }
        this.resumeParsing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeParsing() {
        if (this.completed) {
            throw new IllegalStateException("Parsing was already completed");
        }
        if (this.parsing) {
            throw new IllegalStateException("Parsing already in progress");
        }
        if (this.visitors.isEmpty()) {
            throw new IllegalStateException("Parser has no visitors");
        }
        if (!this.started) {
            this.started = true;
        }
        try {
            this.parsing = true;
            Iterator<Token> tokenIterator = this.tokenIterator;
            Set<TokenVisitor> visitors = this.visitors;
            while (!visitors.isEmpty() && tokenIterator.hasNext()) {
                this.notifyToken(tokenIterator.next());
            }
            if (!tokenIterator.hasNext()) {
                this.completed = true;
                this.notifyComplete();
            }
        }
        finally {
            this.parsing = false;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isParsing() {
        return this.parsing;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    private void notifyToken(Token token) {
        for (TokenVisitor visitor : this.visitors) {
            try {
                visitor.visitToken(token, this);
            }
            catch (Exception e) {
                log.log(Level.WARNING, String.format("Ignored exception notifying visitor %s of token %s", visitor, token), e);
            }
        }
    }

    private void notifyComplete() {
        for (TokenVisitor visitor : this.visitors) {
            try {
                visitor.complete(this);
            }
            catch (Exception e) {
                log.log(Level.WARNING, String.format("Ignored exception notifying visitor %s of completion", visitor), e);
            }
        }
    }

    public SqlParser add(TokenVisitor tokenVisitor) {
        this.addVisitor(tokenVisitor);
        return this;
    }

    @Override
    public void addVisitor(TokenVisitor tokenVisitor) {
        this.visitors.add(tokenVisitor);
    }

    @Override
    public void removeVisitor(TokenVisitor tokenVisitor) {
        this.visitors.remove(tokenVisitor);
    }

    public static class Builder {
        private final SqlTokenizer.Builder tokenizerBuilder;
        private List<TokenVisitor> visitors;

        private Builder(SqlTokenizer.Builder tokenizerBuilder) {
            this.tokenizerBuilder = tokenizerBuilder;
        }

        public Builder withVisitor(TokenVisitor visitor) {
            if (this.visitors == null) {
                this.visitors = new ArrayList<TokenVisitor>();
            }
            this.visitors.add(visitor);
            return this;
        }

        public Builder withVisitors(TokenVisitor ... visitors) {
            if (this.visitors == null) {
                this.visitors = new ArrayList<TokenVisitor>();
            }
            this.visitors.addAll(Arrays.asList(visitors));
            return this;
        }

        public SqlParser of(String statementText) {
            SqlParser parser = new SqlParser(this.tokenizerBuilder.of(statementText));
            if (this.visitors != null) {
                for (TokenVisitor tokenVisitor : this.visitors) {
                    parser.add(tokenVisitor);
                }
            }
            return parser;
        }
    }
}

