/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.impl.wire.EncryptedStreamSupport;
import org.firebirdsql.gds.impl.wire.FbDeflaterOutputStream;
import org.firebirdsql.gds.impl.wire.Xdrable;

public final class XdrOutputStream
extends BufferedOutputStream
implements EncryptedStreamSupport {
    private static final int BUF_SIZE = Short.MAX_VALUE;
    public static final int SPACE_BYTE = 32;
    public static final int NULL_BYTE = 0;
    private static final int TEXT_PAD_LENGTH = Short.MAX_VALUE;
    private static final byte[] TEXT_PAD = XdrOutputStream.createPadding(Short.MAX_VALUE, 32);
    private static final int ZERO_PAD_LENGTH = 3;
    private static final byte[] ZERO_PADDING = new byte[3];
    private boolean compressed;
    private boolean encrypted;
    private final byte[] writeBuffer = new byte[8];

    public XdrOutputStream(OutputStream out) {
        super(out, Short.MAX_VALUE);
    }

    public XdrOutputStream(OutputStream out, int bufferSize) {
        super(out, bufferSize);
    }

    public void writeAlignment(int length) throws IOException {
        this.write(ZERO_PADDING, 0, 4 - length & 3);
    }

    public void writeZeroPadding(int length) throws IOException {
        byte[] padding = length <= 3 ? ZERO_PADDING : new byte[length];
        this.write(padding, 0, length);
    }

    public void writeSpacePadding(int length) throws IOException {
        byte[] padding = length <= Short.MAX_VALUE ? TEXT_PAD : XdrOutputStream.createPadding(length, 32);
        this.write(padding, 0, length);
    }

    public void writePadding(int length, int padByte) throws IOException {
        if (padByte == 32) {
            this.writeSpacePadding(length);
        } else if (padByte == 0) {
            this.writeZeroPadding(length);
        } else {
            byte[] padding = XdrOutputStream.createPadding(length, (byte)padByte);
            this.write(padding, 0, length);
        }
    }

    private static byte[] createPadding(int length, int padByte) {
        byte[] padding = new byte[length];
        Arrays.fill(padding, (byte)padByte);
        return padding;
    }

    public void writeBuffer(byte[] buffer) throws IOException {
        if (buffer == null) {
            this.writeInt(0);
        } else {
            int len = buffer.length;
            this.writeInt(len);
            this.write(buffer, 0, len, 4 - len & 3);
        }
    }

    public void writeString(String s, Encoding encoding) throws IOException {
        if (encoding != null) {
            byte[] buffer = encoding.encodeToCharset(s);
            this.writeBuffer(buffer);
        } else {
            this.writeBuffer(s.getBytes());
        }
    }

    public void writeTyped(int type, Xdrable item) throws IOException {
        int size;
        if (item == null) {
            this.writeInt(1);
            this.write(type);
            size = 1;
        } else {
            size = item.getLength() + 1;
            this.writeInt(size);
            this.write(type);
            item.write(this);
        }
        this.writeAlignment(size);
    }

    public void writeTyped(ParameterBuffer parameterBuffer) throws IOException {
        this.writeTyped(parameterBuffer.getType(), parameterBuffer.toXdrable());
    }

    public void writeLong(long v) throws IOException {
        byte[] buffer = this.writeBuffer;
        buffer[0] = (byte)(v >>> 56);
        buffer[1] = (byte)(v >>> 48);
        buffer[2] = (byte)(v >>> 40);
        buffer[3] = (byte)(v >>> 32);
        buffer[4] = (byte)(v >>> 24);
        buffer[5] = (byte)(v >>> 16);
        buffer[6] = (byte)(v >>> 8);
        buffer[7] = (byte)v;
        this.write(buffer, 0, 8);
    }

    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    public void write(byte[] b, int offset, int len, int pad) throws IOException {
        this.write(b, offset, len);
        this.writeSpacePadding(pad);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.buf = new byte[1];
        }
    }

    public synchronized void enableCompression() throws IOException {
        if (this.compressed) {
            throw new IOException("Output stream already compressed");
        }
        this.out = new FbDeflaterOutputStream(this.out);
        this.compressed = true;
    }

    @Override
    public synchronized void setCipher(Cipher cipher) throws IOException {
        if (this.encrypted) {
            throw new IOException("Output stream already encrypted");
        }
        this.flush();
        OutputStream currentStream = this.out;
        if (currentStream instanceof EncryptedStreamSupport) {
            ((EncryptedStreamSupport)((Object)currentStream)).setCipher(cipher);
        } else {
            this.out = new CipherOutputStream(currentStream, cipher);
        }
        this.encrypted = true;
    }

    public void writeDirect(byte[] data) throws IOException {
        this.out.write(data);
        this.out.flush();
    }
}

