/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.Date;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.AbstractWithTimeZoneField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TypeConversionException;

class FBTimestampTzField
extends AbstractWithTimeZoneField {
    FBTimestampTzField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    OffsetDateTime getOffsetDateTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getTimeZoneCodec().decodeOffsetDateTime(this.getFieldData());
    }

    @Override
    void setOffsetDateTime(OffsetDateTime offsetDateTime) {
        this.setFieldData(this.getTimeZoneCodec().encodeOffsetDateTime(offsetDateTime));
    }

    @Override
    OffsetTime getOffsetTime() throws SQLException {
        OffsetDateTime offsetDateTime = this.getOffsetDateTime();
        return offsetDateTime != null ? offsetDateTime.toOffsetTime() : null;
    }

    @Override
    void setOffsetTime(OffsetTime offsetTime) {
        ZoneOffset offset = offsetTime.getOffset();
        OffsetDateTime today = OffsetDateTime.now(offset);
        OffsetDateTime timeToday = OffsetDateTime.of(today.toLocalDate(), offsetTime.toLocalTime(), offset);
        this.setOffsetDateTime(timeToday);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getOffsetDateTime();
    }

    @Override
    public Date getDate() throws SQLException {
        OffsetDateTime offsetDateTime = this.getOffsetDateTime();
        if (offsetDateTime == null) {
            return null;
        }
        return new Date(offsetDateTime.toInstant().toEpochMilli());
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        return this.getDate();
    }

    @Override
    public void setDate(Date value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        OffsetDateTime offsetDateTime = value.toLocalDate().atStartOfDay().atZone(this.getDefaultZoneId()).toOffsetDateTime();
        this.setOffsetDateTime(offsetDateTime);
    }

    @Override
    public void setDate(Date value, Calendar cal) throws SQLException {
        this.setDate(value);
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getOffsetDateTime());
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        try {
            this.setStringParse(value);
        }
        catch (DateTimeParseException e) {
            throw new TypeConversionException("Unable to convert value '" + value + "' to type TIMESTAMP WITH TIME ZONE", e);
        }
    }
}

