/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FBStringField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TypeConversionException;

public class FBLongVarCharField
extends FBStringField
implements FBFlushableField {
    private static final int BUFF_SIZE = 4096;
    private FBBlob blob;
    private long length;
    private byte[] bytes;
    private InputStream binaryStream;
    private Reader characterStream;

    FBLongVarCharField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            if (this.blob != null) {
                this.blob.free();
            }
        }
        finally {
            this.blob = null;
            this.bytes = null;
            this.binaryStream = null;
            this.characterStream = null;
            this.length = 0L;
        }
    }

    @Override
    public Blob getBlob() throws SQLException {
        if (this.blob != null) {
            return this.blob;
        }
        if (this.isNull()) {
            return null;
        }
        this.blob = new FBBlob(this.gdsHelper, this.getDatatypeCoder().decodeLong(this.getFieldData()));
        return this.blob;
    }

    @Override
    public Clob getClob() throws SQLException {
        FBBlob blob = (FBBlob)this.getBlob();
        if (blob == null) {
            return null;
        }
        return new FBClob(blob);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBytes() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == null) {
            return null;
        }
        try (InputStream in = blob.getBinaryStream();){
            int counter;
            if (in == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buff = new byte[4096];
            while ((counter = in.read(buff)) != -1) {
                bout.write(buff, 0, counter);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        catch (IOException ioex) {
            throw new TypeConversionException("Error converting to array of bytes. " + ioex.getMessage());
        }
    }

    @Override
    public byte[] getCachedData() throws SQLException {
        if (this.isNull()) {
            return this.bytes;
        }
        return this.getBytes();
    }

    @Override
    public FBFlushableField.CachedObject getCachedObject() throws SQLException {
        if (this.isNull()) {
            return new FBFlushableField.CachedObject(this.bytes, this.binaryStream, this.characterStream, this.length);
        }
        byte[] bytes = this.getBytes();
        return new FBFlushableField.CachedObject(bytes, null, null, bytes.length);
    }

    @Override
    public void setCachedObject(FBFlushableField.CachedObject cachedObject) throws SQLException {
        this.setNull();
        this.bytes = cachedObject.bytes;
        this.binaryStream = cachedObject.binaryStream;
        this.characterStream = cachedObject.characterStream;
        this.length = cachedObject.length;
    }

    @Override
    public String getString() throws SQLException {
        byte[] data = this.getBytes();
        if (data == null) {
            return null;
        }
        return this.getDatatypeCoder().decodeString(data);
    }

    @Override
    public void setBlob(FBBlob blob) throws SQLException {
        this.setNull();
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
        this.blob = blob;
    }

    @Override
    public void setClob(FBClob clob) throws SQLException {
        FBBlob blob = clob.getWrappedBlob();
        this.setBlob(blob);
    }

    @Override
    protected void setCharacterStreamInternal(Reader in, long length) throws SQLException {
        this.setNull();
        if (in != null) {
            this.characterStream = in;
            this.length = length;
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        this.setNull();
        if (value != null) {
            this.setBytes(this.getDatatypeCoder().encodeString(value));
        }
    }

    @Override
    public void setBytes(byte[] value) throws SQLException {
        this.setNull();
        if (value != null) {
            this.bytes = value;
            this.length = value.length;
        }
    }

    @Override
    protected void setBinaryStreamInternal(InputStream in, long length) throws SQLException {
        this.setNull();
        if (in != null) {
            this.binaryStream = in;
            this.length = length;
        }
    }

    @Override
    public void flushCachedData() throws SQLException {
        if (this.binaryStream != null) {
            this.copyBinaryStream(this.binaryStream, this.length);
        } else if (this.characterStream != null) {
            this.copyCharacterStream(this.characterStream, this.length);
        } else if (this.bytes != null) {
            this.copyBytes(this.bytes, (int)this.length);
        } else if (this.blob == null) {
            this.setNull();
        }
        this.characterStream = null;
        this.binaryStream = null;
        this.bytes = null;
        this.length = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull() {
        super.setNull();
        try {
            if (this.blob != null) {
                this.blob.free();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.blob = null;
            this.binaryStream = null;
            this.characterStream = null;
            this.bytes = null;
            this.length = 0L;
        }
    }

    private void copyBinaryStream(InputStream in, long length) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyStream(in, length);
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
    }

    private void copyCharacterStream(Reader in, long length) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        Encoding encoding = this.getDatatypeCoder().getEncoding();
        blob.copyCharacterStream(in, length, encoding);
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
    }

    private void copyBytes(byte[] bytes, int length) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyBytes(bytes, 0, length);
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
    }
}

