/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.ptr.IntByReference;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.ServiceParameterBufferImp;
import org.firebirdsql.gds.impl.ServiceRequestBufferImp;
import org.firebirdsql.gds.ng.AbstractFbService;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.ParameterConverter;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.jna.JnaAttachment;
import org.firebirdsql.gds.ng.jna.JnaParameterConverter;
import org.firebirdsql.gds.ng.jna.JnaServiceConnection;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.ISC_STATUS;

public final class JnaService
extends AbstractFbService<JnaServiceConnection>
implements JnaAttachment {
    private static final ParameterConverter<?, JnaServiceConnection> PARAMETER_CONVERTER = new JnaParameterConverter();
    public static final int STATUS_VECTOR_SIZE = 20;
    private final FbClientLibrary clientLibrary;
    private final IntByReference handle = new IntByReference(0);
    private final ISC_STATUS[] statusVector = new ISC_STATUS[20];

    public JnaService(JnaServiceConnection connection) {
        super(connection, connection.createDatatypeCoder());
        this.clientLibrary = connection.getClientLibrary();
    }

    @Override
    public ServiceParameterBuffer createServiceParameterBuffer() {
        return new ServiceParameterBufferImp(ServiceParameterBufferImp.SpbMetaData.SPB_VERSION_2, this.getEncoding());
    }

    @Override
    public ServiceRequestBuffer createServiceRequestBuffer() {
        return new ServiceRequestBufferImp(ServiceRequestBufferImp.SrbMetaData.SRB_VERSION_2, this.getEncoding());
    }

    @Override
    protected void checkConnected() throws SQLException {
        if (!this.isAttached()) {
            throw FbExceptionBuilder.forException(337248274).toFlatSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getServiceInfo(ServiceParameterBuffer serviceParameterBuffer, ServiceRequestBuffer serviceRequestBuffer, int maxBufferLength) throws SQLException {
        try {
            byte[] serviceParameterBufferBytes = serviceParameterBuffer == null ? null : serviceParameterBuffer.toBytesWithType();
            byte[] serviceRequestBufferBytes = serviceRequestBuffer == null ? null : serviceRequestBuffer.toBytes();
            ByteBuffer responseBuffer = ByteBuffer.allocateDirect(maxBufferLength);
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.clientLibrary.isc_service_query(this.statusVector, this.handle, new IntByReference(0), (short)(serviceParameterBufferBytes != null ? serviceParameterBufferBytes.length : 0), serviceParameterBufferBytes, (short)(serviceRequestBufferBytes != null ? serviceRequestBufferBytes.length : 0), serviceRequestBufferBytes, (short)maxBufferLength, responseBuffer);
                this.processStatusVector();
            }
            byte[] responseArray = new byte[maxBufferLength];
            responseBuffer.get(responseArray);
            return responseArray;
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startServiceAction(ServiceRequestBuffer serviceRequestBuffer) throws SQLException {
        try {
            byte[] serviceRequestBufferBytes = serviceRequestBuffer == null ? null : serviceRequestBuffer.toBytes();
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                this.clientLibrary.isc_service_start(this.statusVector, this.handle, new IntByReference(0), (short)(serviceRequestBufferBytes != null ? serviceRequestBufferBytes.length : 0), serviceRequestBufferBytes);
                this.processStatusVector();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach() throws SQLException {
        try {
            if (this.isAttached()) {
                throw new SQLException("Already attached to a service");
            }
            ServiceParameterBuffer spb = PARAMETER_CONVERTER.toServiceParameterBuffer((JnaServiceConnection)this.connection);
            byte[] serviceName = this.getEncoding().encodeToCharset(((JnaServiceConnection)this.connection).getAttachUrl());
            byte[] spbArray = spb.toBytesWithType();
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                try {
                    this.clientLibrary.isc_service_attach(this.statusVector, (short)serviceName.length, serviceName, this.handle, (short)spbArray.length, spbArray);
                    this.processStatusVector();
                }
                catch (SQLException ex) {
                    this.safelyDetach();
                    throw ex;
                }
                catch (Exception ex) {
                    this.safelyDetach();
                    throw new FbExceptionBuilder().exception(335544721).messageParameter(((JnaServiceConnection)this.connection).getServerName()).cause(ex).toSQLException();
                }
                this.setAttached();
                this.afterAttachActions();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected void afterAttachActions() throws SQLException {
        this.getServiceInfo((ServiceParameterBuffer)null, this.getDescribeServiceRequestBuffer(), 1024, this.getServiceInformationProcessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalDetach() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.clientLibrary.isc_service_detach(this.statusVector, this.handle);
                this.processStatusVector();
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new FbExceptionBuilder().exception(335544721).messageParameter(((JnaServiceConnection)this.connection).getServerName()).cause(ex).toSQLException();
            }
            finally {
                this.setDetached();
            }
        }
    }

    @Override
    public int getHandle() {
        return this.handle.getValue();
    }

    public IntByReference getJnaHandle() {
        return this.handle;
    }

    @Override
    public void setNetworkTimeout(int milliseconds) throws SQLException {
        throw new FBDriverNotCapableException("Setting network timeout not supported in native implementation");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new FBDriverNotCapableException("Getting network timeout not supported in native implementation");
    }

    private void processStatusVector() throws SQLException {
        this.processStatusVector(this.statusVector, this.getServiceWarningCallback());
    }

    public void processStatusVector(ISC_STATUS[] statusVector, WarningMessageCallback warningMessageCallback) throws SQLException {
        if (warningMessageCallback == null) {
            warningMessageCallback = this.getServiceWarningCallback();
        }
        ((JnaServiceConnection)this.connection).processStatusVector(statusVector, warningMessageCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.isAttached()) {
                this.safelyDetach();
            }
        }
        finally {
            super.finalize();
        }
    }
}

