/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

public enum StatementType {
    NONE(0),
    SELECT(1){

        @Override
        public boolean isTypeWithCursor() {
            return true;
        }

        @Override
        public boolean isTypeWithUpdateCounts() {
            return true;
        }
    }
    ,
    INSERT(2){

        @Override
        public boolean isTypeWithUpdateCounts() {
            return true;
        }
    }
    ,
    UPDATE(3){

        @Override
        public boolean isTypeWithUpdateCounts() {
            return true;
        }
    }
    ,
    DELETE(4){

        @Override
        public boolean isTypeWithUpdateCounts() {
            return true;
        }
    }
    ,
    DDL(5),
    GET_SEGMENT(6),
    PUT_SEGMENT(7),
    STORED_PROCEDURE(8){

        @Override
        public boolean isTypeWithSingletonResult() {
            return true;
        }

        @Override
        public boolean isTypeWithUpdateCounts() {
            return true;
        }
    }
    ,
    START_TRANSACTION(9),
    COMMIT(10),
    ROLLBACK(11),
    SELECT_FOR_UPDATE(12){

        @Override
        public boolean isTypeWithCursor() {
            return true;
        }

        @Override
        public boolean isTypeWithUpdateCounts() {
            return true;
        }
    }
    ,
    SET_GENERATOR(13),
    SAVE_POINT(14);

    private static final StatementType[] ID_TO_TYPE;
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 14;
    private final int statementTypeCode;

    private StatementType(int statementTypeCode) {
        this.statementTypeCode = statementTypeCode;
    }

    public int getStatementTypeCode() {
        return this.statementTypeCode;
    }

    public boolean isTypeWithCursor() {
        return false;
    }

    public boolean isTypeWithSingletonResult() {
        return false;
    }

    public boolean isTypeWithUpdateCounts() {
        return false;
    }

    public static StatementType valueOf(int statementTypeCode) {
        if (statementTypeCode < 0 || statementTypeCode > 14) {
            throw new IllegalArgumentException(String.format("No StatementType with code %d", statementTypeCode));
        }
        StatementType value = ID_TO_TYPE[statementTypeCode];
        if (value == null) {
            throw new IllegalArgumentException(String.format("No StatementType with code %d", statementTypeCode));
        }
        return value;
    }

    static {
        StatementType[] tempTypes = new StatementType[15];
        StatementType[] arr$ = StatementType.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StatementType type;
            tempTypes[type.getStatementTypeCode()] = type = arr$[i$];
        }
        ID_TO_TYPE = tempTypes;
    }
}

