/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.impl.AbstractGDS;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.management.FBManagerMBean;

public class FBManager
implements FBManagerMBean {
    private static final int DEFAULT_PORT = 3050;
    private static final Logger log = LoggerFactory.getLogger(FBManager.class, false);
    private GDS gds;
    private DatabaseParameterBuffer c;
    private String host = "localhost";
    private Integer port;
    private String fileName;
    private String userName;
    private String password;
    private boolean forceCreate = false;
    private boolean createOnStart = false;
    private boolean dropOnStop = false;
    private String state = "Stopped";
    private static final String STOPPED = "Stopped";
    private static final String STARTED = "Started";
    private GDSType type;

    public FBManager() {
        this(((AbstractGDS)GDSFactory.getDefaultGDS()).getType());
    }

    public FBManager(GDSType type) {
        this.type = type;
    }

    public FBManager(String type) {
        this.type = GDSType.getType(type);
    }

    public void start() throws Exception {
        this.gds = GDSFactory.getGDSForType(this.type);
        this.c = this.gds.createDatabaseParameterBuffer();
        this.c.addArgument(58, new byte[]{120, 10, 0, 0});
        this.c.addArgument(63, new byte[]{3, 0, 0, 0});
        this.state = STARTED;
        if (this.isCreateOnStart()) {
            this.createDatabase(this.getFileName(), this.getUserName(), this.getPassword());
        }
    }

    public void stop() throws Exception {
        if (this.isDropOnStop()) {
            this.dropDatabase(this.getFileName(), this.getUserName(), this.getPassword());
        }
        this.c = null;
        this.gds.close();
        this.gds = null;
        this.state = STOPPED;
    }

    public String getState() {
        return this.state;
    }

    public String getName() {
        return "Firebird Database manager";
    }

    public void setServer(String host) {
        this.host = host;
    }

    public String getServer() {
        return this.host;
    }

    public String getType() {
        return this.type.toString();
    }

    public void setPort(int port) {
        this.port = new Integer(port);
    }

    public int getPort() {
        return this.port != null ? this.port : 3050;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setType(String type) {
        GDSType gdsType = GDSType.getType(type);
        if (gdsType == null) {
            throw new RuntimeException("Unrecognized type '" + type + "'");
        }
        this.type = gdsType;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isCreateOnStart() {
        return this.createOnStart;
    }

    public void setCreateOnStart(boolean createOnStart) {
        this.createOnStart = createOnStart;
    }

    public boolean isDropOnStop() {
        return this.dropOnStop;
    }

    public void setDropOnStop(boolean dropOnStop) {
        this.dropOnStop = dropOnStop;
    }

    public boolean isForceCreate() {
        return this.forceCreate;
    }

    public void setForceCreate(boolean forceCreate) {
        this.forceCreate = forceCreate;
    }

    public void createDatabase(String fileName, String user, String password) throws Exception {
        DatabaseParameterBuffer dpb;
        IscDbHandle db = null;
        db = this.gds.createIscDbHandle();
        try {
            dpb = this.c.deepCopy();
            dpb.addArgument(28, user);
            dpb.addArgument(29, password);
            this.gds.iscAttachDatabase(this.getConnectString(fileName), db, dpb);
            if (!this.forceCreate) {
                this.gds.iscDetachDatabase(db);
                return;
            }
            this.gds.iscDropDatabase(db);
        }
        catch (GDSException e) {
            // empty catch block
        }
        db = this.gds.createIscDbHandle();
        try {
            dpb = this.c.deepCopy();
            dpb.addArgument(28, user);
            dpb.addArgument(29, password);
            this.gds.iscCreateDatabase(this.getConnectString(fileName), db, dpb);
            this.gds.iscDetachDatabase(db);
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Exception creating database", e);
            }
            throw e;
        }
    }

    public void dropDatabase(String fileName, String user, String password) throws Exception {
        try {
            IscDbHandle db = this.gds.createIscDbHandle();
            DatabaseParameterBuffer dpb = this.c.deepCopy();
            dpb.addArgument(28, user);
            dpb.addArgument(29, password);
            this.gds.iscAttachDatabase(this.getConnectString(fileName), db, dpb);
            this.gds.iscDropDatabase(db);
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Exception dropping database", e);
            }
            throw e;
        }
    }

    public boolean isDatabaseExists(String fileName, String user, String password) throws Exception {
        IscDbHandle db = null;
        db = this.gds.createIscDbHandle();
        try {
            DatabaseParameterBuffer dpb = this.c.deepCopy();
            dpb.addArgument(28, user);
            dpb.addArgument(29, password);
            this.gds.iscAttachDatabase(this.getConnectString(fileName), db, dpb);
            this.gds.iscDetachDatabase(db);
            return true;
        }
        catch (GDSException e) {
            return false;
        }
    }

    private String getConnectString(String filename) throws GDSException {
        return GDSFactory.getDatabasePath(this.type, this.host, this.port, filename);
    }
}

