/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.validation;

import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;
import org.eclipse.xtext.validation.Issue;
import org.junit.jupiter.api.Assertions;

public class RosettaValidationTestHelper
extends ValidationTestHelper {
    public RosettaValidationTestHelper() {
        super(ValidationTestHelper.Mode.EXACT);
    }

    public void assertIssues(EObject model, String issuesExpectation) {
        List issues = this.validate(model);
        issues.sort(Comparator.comparing(Issue::getOffset).thenComparing(Issue::getMessage));
        String issuesRepresentation = this.getIssuesAsString(model, issues, new StringBuilder()).toString().trim();
        Assertions.assertEquals((Object)issuesExpectation.trim(), (Object)issuesRepresentation);
        Assertions.assertNotEquals((Object)"", (Object)issuesRepresentation, (String)"No issues were found. When asserting for issues, the expected issues may not be empty. Use the method ValidationTestHelper#assertNoIssues instead.");
    }

    protected StringBuilder doGetIssuesAsString(Resource resource, Iterable<Issue> issues, StringBuilder result) {
        for (Issue issue : issues) {
            URI uri = issue.getUriToProblem();
            result.append(issue.getSeverity());
            result.append(" (");
            result.append(issue.getCode());
            result.append(") '");
            result.append(issue.getMessage());
            result.append("'");
            result.append(" at ").append(issue.getLineNumber()).append(":").append(issue.getColumn()).append(", length ").append(issue.getLength());
            if (uri != null) {
                EObject eObject = resource.getResourceSet().getEObject(uri, true);
                result.append(", on ");
                result.append(eObject.eClass().getName());
            }
            result.append("\n");
        }
        return result;
    }
}

