/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.util;

import com.regnosys.rosetta.builtin.RosettaBuiltinsService;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.rosetta.util.DottedPath;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.testing.util.ParseHelper;
import org.eclipse.xtext.testing.util.ResourceHelper;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;

public class ModelHelper {
    @Inject
    private ParseHelper<RosettaModel> parseHelper;
    @Inject
    private ValidationTestHelper validationTestHelper;
    @Inject
    private RosettaBuiltinsService builtins;
    @Inject
    private ResourceHelper resourceHelper;
    public static final String commonTestTypes = ModelHelper.getVersionInfo() + "metaType scheme string\n";
    private final DottedPath rootpack = DottedPath.splitOnDots((String)"com.rosetta.test.model");

    private static String getVersionInfo() {
        return "namespace \"com.rosetta.test.model\"\nversion \"test\"\n";
    }

    public final DottedPath rootPackage() {
        return this.rootpack;
    }

    public RosettaModel parseRosetta(CharSequence model) {
        Object m = model;
        if (!model.toString().trim().startsWith("namespace")) {
            m = ModelHelper.getVersionInfo() + "\n" + String.valueOf(m);
        }
        ResourceSet resourceSet = this.testResourceSet();
        RosettaModel parsed = this.safeParse((CharSequence)m, resourceSet);
        EcoreUtil2.resolveAll((EObject)parsed);
        return parsed;
    }

    public List<RosettaModel> parseRosetta(CharSequence ... models) {
        ResourceSet resourceSet = this.testResourceSet();
        ArrayList<RosettaModel> result = new ArrayList<RosettaModel>();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (CharSequence it : models) {
            String trimmed = it.toString().trim();
            CharSequence content = trimmed.startsWith("namespace") || trimmed.startsWith("override") ? it : ModelHelper.getVersionInfo() + "\n" + String.valueOf(it);
            try {
                resources.add(this.resourceHelper.resource(content, resourceSet));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (Resource r : resources) {
            result.add((RosettaModel)r.getContents().getFirst());
        }
        return result;
    }

    public RosettaModel parseRosettaWithNoErrors(CharSequence model) {
        RosettaModel parsed = this.parseRosetta(model);
        this.validationTestHelper.assertNoErrors((EObject)parsed);
        return parsed;
    }

    public List<RosettaModel> parseRosettaWithNoErrors(CharSequence ... models) {
        List<RosettaModel> parsed = this.parseRosetta(models);
        for (RosettaModel rm : parsed) {
            this.validationTestHelper.assertNoErrors((EObject)rm);
        }
        return parsed;
    }

    public RosettaModel parseRosettaWithNoIssues(CharSequence model) {
        RosettaModel parsed = this.parseRosetta(model);
        this.validationTestHelper.assertNoIssues((EObject)parsed);
        return parsed;
    }

    public List<RosettaModel> parseRosettaWithNoIssues(CharSequence ... models) {
        List<RosettaModel> parsed = this.parseRosetta(models);
        for (RosettaModel rm : parsed) {
            this.validationTestHelper.assertNoIssues((EObject)rm);
        }
        return parsed;
    }

    public RosettaModel combineAndParseRosetta(CharSequence ... models) {
        StringBuilder m = new StringBuilder(ModelHelper.getVersionInfo());
        for (CharSequence model : models) {
            m.append("\n").append(model);
        }
        ResourceSet resourceSet = this.testResourceSet();
        RosettaModel parsed = this.safeParse(m, resourceSet);
        this.validationTestHelper.assertNoErrors((EObject)parsed);
        return parsed;
    }

    public ResourceSet testResourceSet() {
        RosettaModel parsed = this.safeParse(commonTestTypes, null);
        ResourceSet resourceSet = parsed.eResource().getResourceSet();
        resourceSet.getResource(this.builtins.basicTypesURI, true);
        resourceSet.getResource(this.builtins.annotationsURI, true);
        return resourceSet;
    }

    private RosettaModel safeParse(CharSequence content, ResourceSet resourceSet) {
        try {
            if (resourceSet != null) {
                return (RosettaModel)this.parseHelper.parse(content, resourceSet);
            }
            return (RosettaModel)this.parseHelper.parse(content);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse Rosetta model content.", e);
        }
    }
}

