/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.testmodel;

import com.regnosys.rosetta.rosetta.RegulatoryDocumentReference;
import com.regnosys.rosetta.rosetta.RosettaCorpus;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaScope;
import com.regnosys.rosetta.rosetta.RosettaTypeAlias;
import com.regnosys.rosetta.rosetta.RosettaTypeWithConditions;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.tests.util.ExpressionParser;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;

public class RosettaTestModel {
    private final String source;
    private final RosettaModel model;
    private final IResourceDescriptionsProvider indexAccess;
    private final ExpressionParser expressionParser;

    public RosettaTestModel(CharSequence source, RosettaModel model, IResourceDescriptionsProvider indexAccess, ExpressionParser expressionParser) {
        this.source = source.toString();
        this.model = model;
        this.indexAccess = indexAccess;
        this.expressionParser = expressionParser;
    }

    public RosettaModel getModel() {
        return this.model;
    }

    public Resource getResource() {
        return this.model.eResource();
    }

    public ResourceSet getResourceSet() {
        return this.getResource().getResourceSet();
    }

    public RosettaExpression parseExpression(CharSequence expressionSource, String ... attributes) {
        return this.expressionParser.parseExpression(expressionSource, List.of(this.model), List.of(attributes));
    }

    public RosettaScope getScope(String name) {
        for (IEObjectDescription descr : this.indexAccess.getResourceDescriptions(this.getResourceSet()).getExportedObjectsByType(RosettaPackage.eINSTANCE.getRosettaScope())) {
            if (!name.equals(descr.getName().getLastSegment())) continue;
            return (RosettaScope)descr.getEObjectOrProxy();
        }
        throw new NoSuchElementException("No scope named '" + name + "' found in model.\n\n" + this.source);
    }

    public Data getType(String name) {
        return this.getNamedElement(Data.class, name);
    }

    public RosettaEnumeration getEnum(String name) {
        return this.getNamedElement(RosettaEnumeration.class, name);
    }

    public RosettaTypeAlias getTypeAlias(String name) {
        return this.getNamedElement(RosettaTypeAlias.class, name);
    }

    public Function getFunction(String name) {
        return this.getNamedElement(Function.class, name);
    }

    public RosettaRule getRule(String name) {
        return this.getNamedElement(RosettaRule.class, name);
    }

    public RosettaReport getReport(String body, String ... corpusList) {
        return this.getElementMatching(RosettaReport.class, x -> {
            RegulatoryDocumentReference ref = x.getRegulatoryBody();
            if (!body.equals(ref.getBody().getName())) {
                return false;
            }
            if (corpusList.length != ref.getCorpusList().size()) {
                return false;
            }
            for (int i = 0; i < corpusList.length; ++i) {
                if (corpusList[i].equals(((RosettaCorpus)ref.getCorpusList().get(i)).getName())) continue;
                return false;
            }
            return true;
        }, () -> new NoSuchElementException("No report with body " + body + " and corpus list " + Arrays.toString(corpusList) + " found in model.\n\n" + this.source));
    }

    public Condition getCondition(String typeName, String conditionName) {
        RosettaTypeWithConditions t = this.getNamedElement(RosettaTypeWithConditions.class, typeName);
        return this.getNamedElement((List<? extends EObject>)t.getConditions(), Condition.class, conditionName);
    }

    public RosettaExternalRuleSource getRuleSource(String name) {
        return this.getNamedElement(RosettaExternalRuleSource.class, name);
    }

    private <T extends EObject> T getElementMatching(List<? extends EObject> elements, Class<T> clazz, Predicate<T> match, Supplier<? extends RuntimeException> exceptionSupplier) {
        return (T)elements.stream().filter(clazz::isInstance).map(clazz::cast).filter(match).findAny().orElseThrow(exceptionSupplier);
    }

    private <T extends EObject> T getElementMatching(Class<T> clazz, Predicate<T> match, Supplier<? extends RuntimeException> exceptionSupplier) {
        return this.getElementMatching((List<? extends EObject>)this.model.getElements(), clazz, match, exceptionSupplier);
    }

    private <T extends RosettaNamed> T getNamedElement(List<? extends EObject> elements, Class<T> clazz, String name) {
        RosettaNamed elem = this.getElementMatching(elements, RosettaNamed.class, x -> name.equals(x.getName()), () -> new NoSuchElementException("No element named '" + name + "' found in model.\n\n" + this.source));
        if (!clazz.isInstance(elem)) {
            throw new ClassCastException("The element named '" + name + "' is of type " + elem.getClass().getSimpleName() + ", not " + clazz.getSimpleName() + ".\n\n" + this.source);
        }
        return (T)((RosettaNamed)clazz.cast(elem));
    }

    private <T extends RosettaRootElement & RosettaNamed> T getNamedElement(Class<T> clazz, String name) {
        return (T)((RosettaRootElement)this.getNamedElement((List<? extends EObject>)this.model.getElements(), clazz, name));
    }
}

