/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.tests.testmodel;

import com.google.inject.Injector;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.RJavaEnum;
import com.regnosys.rosetta.generator.java.types.RJavaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.tests.compiler.InMemoryJavacCompiler;
import com.regnosys.rosetta.tests.testmodel.RosettaTestModel;
import com.regnosys.rosetta.tests.util.ExpressionJavaEvaluatorService;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RObjectFactory;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.LabelProvider;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.util.types.JavaType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class JavaTestModel {
    private final RosettaTestModel rosettaModel;
    private final Map<String, String> javaSourceCode;
    private InMemoryJavacCompiler inMemoryCompiler = null;
    private Map<String, Class<?>> javaClasses = null;
    private final RObjectFactory rObjectFactory;
    private final JavaTypeTranslator typeTranslator;
    private final ExpressionJavaEvaluatorService evaluatorService;
    private final Injector injector;

    public JavaTestModel(RosettaTestModel rosettaModel, Map<String, String> javaSourceCode, RObjectFactory rObjectFactory, JavaTypeTranslator typeTranslator, ExpressionJavaEvaluatorService evaluatorService, Injector injector) {
        this.rosettaModel = rosettaModel;
        this.javaSourceCode = javaSourceCode;
        this.rObjectFactory = rObjectFactory;
        this.typeTranslator = typeTranslator;
        this.evaluatorService = evaluatorService;
        this.injector = injector;
    }

    private String getSource(JavaType javaType) {
        String source = this.javaSourceCode.get(javaType.toString());
        if (source == null) {
            throw new NoSuchElementException("No Java source found for " + String.valueOf(javaType) + ".\n\n" + this.javaSourceCode.keySet().stream().collect(Collectors.joining("\n")));
        }
        return source;
    }

    private void assertCompiled() {
        if (this.javaClasses == null) {
            throw new IllegalStateException("Model is not compiled yet. Please call `JavaTestModel::compile` before loading classes.");
        }
    }

    private <T> Class<? extends T> getClass(Class<T> superClass, JavaType javaType) {
        this.assertCompiled();
        Class<?> javaClass = this.javaClasses.get(javaType.toString());
        if (javaClass == null) {
            throw new NoSuchElementException("No Java class found for " + String.valueOf(javaType) + ".\n\n" + this.javaClasses.keySet().stream().collect(Collectors.joining("\n")));
        }
        return javaClass.asSubclass(superClass);
    }

    public JavaTestModel compile() {
        if (this.javaClasses != null) {
            throw new IllegalStateException("Model was already compiled!");
        }
        this.inMemoryCompiler = InMemoryJavacCompiler.newInstance().useParentClassLoader(this.getClass().getClassLoader()).useOptions("--release", "8", "-Xlint:all", "-Xdiags:verbose");
        this.javaSourceCode.forEach((className, sourceCode) -> this.inMemoryCompiler.addSource((String)className, (String)sourceCode));
        this.javaClasses = this.inMemoryCompiler.compileAll();
        return this;
    }

    public <T> T evaluateExpression(Class<T> resultType, CharSequence expr) {
        return resultType.cast(this.evaluateExpression(JavaType.from(resultType), expr));
    }

    public Object evaluateExpression(JavaType resultType, CharSequence expr) {
        this.assertCompiled();
        return this.evaluatorService.evaluate(expr, this.rosettaModel.getModel(), resultType, this.inMemoryCompiler.getClassloader());
    }

    public RosettaTestModel getRosettaModel() {
        return this.rosettaModel;
    }

    public JavaType getTypeJavaType(String name) {
        Data type = this.rosettaModel.getType(name);
        RDataType t = this.rObjectFactory.buildRDataType(type);
        return this.typeTranslator.toJavaReferenceType(t);
    }

    public String getTypeJavaSource(String name) {
        return this.getSource(this.getTypeJavaType(name));
    }

    public Class<? extends RosettaModelObject> getTypeJavaClass(String name) {
        return this.getClass(RosettaModelObject.class, this.getTypeJavaType(name));
    }

    private RJavaEnum getEnumJavaType(String name) {
        RosettaEnumeration enumeration = this.rosettaModel.getEnum(name);
        REnumType t = this.rObjectFactory.buildREnumType(enumeration);
        return this.typeTranslator.toJavaReferenceType(t);
    }

    public String getEnumJavaSource(String name) {
        return this.getSource((JavaType)this.getEnumJavaType(name));
    }

    public Class<? extends Enum<?>> getEnumJavaClass(String name) {
        return this.getClass(Enum.class, (JavaType)this.getEnumJavaType(name));
    }

    public Object getEnumJavaValue(String enumName, String valueName) {
        RJavaEnum enumJavaType = this.getEnumJavaType(enumName);
        Class<Enum> enumJavaClass = this.getClass(Enum.class, (JavaType)enumJavaType);
        RJavaEnumValue enumValueRepr = enumJavaType.getEnumValues().stream().filter(v -> valueName.equals(v.getRosettaName())).findAny().orElseThrow(() -> new NoSuchElementException("The enum " + enumName + " does not have a value named " + valueName));
        for (Enum enumConst : enumJavaClass.getEnumConstants()) {
            if (!enumConst.toString().equals(enumValueRepr.getName()) && !enumConst.toString().equals(enumValueRepr.getDisplayName())) continue;
            return enumConst;
        }
        return null;
    }

    private JavaType getFunctionJavaType(String name) {
        Function func = this.rosettaModel.getFunction(name);
        RFunction f = this.rObjectFactory.buildRFunction(func);
        return this.typeTranslator.toFunctionJavaClass(f);
    }

    public String getFunctionJavaSource(String name) {
        return this.getSource(this.getFunctionJavaType(name));
    }

    public Class<? extends RosettaFunction> getFunctionJavaClass(String name) {
        return this.getClass(RosettaFunction.class, this.getFunctionJavaType(name));
    }

    public RosettaFunction getFunctionJavaInstance(String name) {
        return (RosettaFunction)this.injector.getInstance(this.getFunctionJavaClass(name));
    }

    private JavaType getFunctionJavaLabelProviderType(String name) {
        Function func = this.rosettaModel.getFunction(name);
        RFunction f = this.rObjectFactory.buildRFunction(func);
        return this.typeTranslator.toLabelProviderJavaClass(f);
    }

    public String getFunctionJavaLabelProviderSource(String name) {
        return this.getSource(this.getFunctionJavaLabelProviderType(name));
    }

    public Class<? extends LabelProvider> getFunctionJavaLabelProviderClass(String name) {
        return this.getClass(LabelProvider.class, this.getFunctionJavaLabelProviderType(name));
    }

    public LabelProvider getFunctionJavaLabelProviderInstance(String name) {
        return (LabelProvider)this.injector.getInstance(this.getFunctionJavaLabelProviderClass(name));
    }

    private JavaType getRuleJavaType(String name) {
        RosettaRule rule = this.rosettaModel.getRule(name);
        RFunction f = this.rObjectFactory.buildRFunction(rule);
        return this.typeTranslator.toFunctionJavaClass(f);
    }

    public String getRuleJavaSource(String name) {
        return this.getSource(this.getRuleJavaType(name));
    }

    public Class<? extends RosettaFunction> getRuleJavaClass(String name) {
        return this.getClass(RosettaFunction.class, this.getRuleJavaType(name));
    }

    public RosettaFunction getRuleJavaInstance(String name) {
        return (RosettaFunction)this.injector.getInstance(this.getRuleJavaClass(name));
    }

    private JavaType getReportJavaType(String body, String ... corpusList) {
        RosettaReport report = this.rosettaModel.getReport(body, corpusList);
        RFunction f = this.rObjectFactory.buildRFunction(report);
        return this.typeTranslator.toFunctionJavaClass(f);
    }

    public String getReportJavaSource(String body, String ... corpusList) {
        return this.getSource(this.getReportJavaType(body, corpusList));
    }

    public Class<? extends RosettaFunction> getReportJavaClass(String body, String ... corpusList) {
        return this.getClass(RosettaFunction.class, this.getReportJavaType(body, corpusList));
    }

    public RosettaFunction getReportJavaInstance(String body, String ... corpusList) {
        return (RosettaFunction)this.injector.getInstance(this.getReportJavaClass(body, corpusList));
    }

    private JavaType getConditionJavaType(String typeName, String conditionName) {
        Condition condition = this.rosettaModel.getCondition(typeName, conditionName);
        return this.typeTranslator.toConditionJavaClass(condition);
    }

    public String getConditionJavaSource(String typeName, String conditionName) {
        return this.getSource(this.getConditionJavaType(typeName, conditionName));
    }

    public Class<?> getConditionJavaClass(String typeName, String conditionName) {
        return this.getClass(Object.class, this.getConditionJavaType(typeName, conditionName));
    }

    public Object getConditionJavaInstance(String typeName, String conditionName) {
        return this.injector.getInstance(this.getConditionJavaClass(typeName, conditionName));
    }

    public void writeClasses(String directory) {
        for (Map.Entry<String, String> entry : this.javaSourceCode.entrySet()) {
            String name = entry.getKey();
            String pathName = name.replace('.', File.separatorChar);
            Path path = Paths.get("target", directory, "java", pathName + ".java");
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, entry.getValue().getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

