/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.util.types.generated;

import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaTypeDeclaration;
import com.rosetta.util.types.JavaTypeVariable;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class GeneratedJavaGenericTypeDeclaration<T>
extends JavaGenericTypeDeclaration<T> {
    private final GeneratedJavaClass<T> baseType;
    private final List<JavaTypeVariable> parameters;

    public GeneratedJavaGenericTypeDeclaration(GeneratedJavaClass<T> baseType, String ... typeParameterNames) {
        Objects.requireNonNull(baseType);
        Validate.noNullElements((Object[])typeParameterNames);
        this.baseType = baseType;
        this.parameters = Arrays.stream(typeParameterNames).map(n -> new JavaTypeVariable(this, (String)n, new JavaReferenceType[0])).collect(Collectors.toList());
    }

    @Override
    public JavaClass<T> getBaseType() {
        return this.baseType;
    }

    @Override
    public List<JavaTypeVariable> getParameters() {
        return this.parameters;
    }

    @Override
    public JavaClass<? super T> getSuperclassDeclaration() {
        return JavaClass.OBJECT;
    }

    @Override
    public JavaClass<? super T> getSuperclass() {
        return this.getSuperclassDeclaration();
    }

    @Override
    public List<JavaClass<?>> getInterfaceDeclarations() {
        return Collections.emptyList();
    }

    @Override
    public List<JavaClass<?>> getInterfaces() {
        return this.getInterfaceDeclarations();
    }

    @Override
    public Class<? extends T> loadClass(ClassLoader classLoader) throws ClassNotFoundException {
        return this.baseType.loadClass(classLoader);
    }

    @Override
    public boolean extendsDeclaration(JavaTypeDeclaration<?> other) {
        return this.equals(other) || JavaClass.OBJECT.equals(other);
    }

    @Override
    public boolean isFinal() {
        return false;
    }
}

