/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.mapper;

import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListItem;
import com.rosetta.model.lib.mapper.MapperPath;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MapperListOfLists<T> {
    private final List<MapperListItem<T, ?>> items;

    protected MapperListOfLists(List<MapperListItem<T, ?>> items) {
        this.items = items;
    }

    public static <T> MapperListOfLists<T> of(List<List<T>> ts) {
        ArrayList items = new ArrayList();
        if (ts != null) {
            for (List<T> ele : ts) {
                if (ele == null) continue;
                items.add(new MapperListItem(ele, MapperPath.builder().addRoot(ele.getClass()), false, Optional.empty()));
            }
        }
        return new MapperListOfLists<T>(items);
    }

    public MapperListOfLists<T> filterList(Predicate<MapperC<T>> predicate) {
        return new MapperListOfLists<T>(this.items.stream().filter(item -> predicate.test(MapperC.of(item.getMappedObjects()))).collect(Collectors.toList()));
    }

    public MapperListOfLists<T> filterListNullSafe(Function<MapperC<T>, Boolean> predicate) {
        return new MapperListOfLists<T>(this.items.stream().filter(item -> {
            Boolean result = (Boolean)predicate.apply(MapperC.of(item.getMappedObjects()));
            return result != null && result != false;
        }).collect(Collectors.toList()));
    }

    public <F> MapperC<F> mapListToItem(Function<MapperC<T>, MapperS<F>> mappingFunc) {
        return MapperC.of(this.items.stream().map(item -> (MapperS)mappingFunc.apply(MapperC.of(item.getMappedObjects()))).map(MapperS::get).collect(Collectors.toList()));
    }

    public <F> MapperListOfLists<F> mapListToList(Function<MapperC<T>, MapperC<F>> mappingFunc) {
        return MapperListOfLists.of(this.items.stream().map(item -> (MapperC)mappingFunc.apply(MapperC.of(item.getMappedObjects()))).map(MapperC::getMulti).collect(Collectors.toList()));
    }

    public <F> F apply(Function<MapperListOfLists<T>, F> f) {
        return f.apply(this);
    }

    public MapperC<T> flattenList() {
        return MapperC.of(this.items.stream().map(item -> item.getMappedObjects()).flatMap(Collection::stream).collect(Collectors.toList()));
    }
}

