/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.mapper;

import com.rosetta.model.lib.mapper.AbstractMapperItem;
import com.rosetta.model.lib.mapper.MapperPath;
import com.rosetta.model.lib.mapper.NamedFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class MapperItem<T, P>
extends AbstractMapperItem<P> {
    private final T mappedObject;

    static <C, P> MapperItem<C, P> getMapperItem(MapperItem<? extends P, ?> parentItem, NamedFunction<P, C> mappingFunc) {
        if (!parentItem.isError()) {
            P parent = parentItem.getMappedObject();
            Object child = mappingFunc.apply(parent);
            MapperPath path = parentItem.getPath().toBuilder().addFunctionName(mappingFunc.getName());
            boolean error = child == null;
            return new MapperItem(child, path, error, Optional.of(parentItem));
        }
        return MapperItem.getErrorMapperItem(parentItem.getPath());
    }

    static <C, P> MapperItem<C, P> getCheckedMapperItem(MapperItem<? extends P, ?> parentItem, NamedFunction<P, C> mappingFunc, Class<? extends Exception> errorClass) {
        if (!parentItem.isError()) {
            Object child;
            P parent = parentItem.getMappedObject();
            try {
                child = mappingFunc.apply(parent);
            }
            catch (Exception e) {
                if (!errorClass.isInstance(e)) {
                    throw e;
                }
                child = null;
            }
            MapperPath path = parentItem.getPath().toBuilder().addFunctionName(mappingFunc.getName());
            boolean error = child == null;
            return new MapperItem(child, path, error, Optional.of(parentItem));
        }
        return MapperItem.getErrorMapperItem(parentItem.getPath());
    }

    static <C, P> List<MapperItem<? extends C, ?>> getMapperItems(MapperItem<? extends P, ?> parentItem, NamedFunction<P, List<? extends C>> mappingFunc) {
        if (!parentItem.isError()) {
            ArrayList childItems = new ArrayList();
            P parent = parentItem.getMappedObject();
            List children = (List)mappingFunc.apply(parent);
            if (children != null && !children.isEmpty()) {
                for (int j = 0; j < children.size(); ++j) {
                    Object child = children.get(j);
                    MapperPath path = parentItem.getPath().toBuilder().addListFunctionName(mappingFunc.getName(), j);
                    boolean error = child == null;
                    childItems.add(new MapperItem(child, path, error, Optional.of(parentItem)));
                }
                return childItems;
            }
            MapperPath childPath = parentItem.getPath().toBuilder().addFunctionName(mappingFunc.getName());
            return Collections.singletonList(MapperItem.getErrorMapperItem(childPath));
        }
        return Collections.singletonList(MapperItem.getErrorMapperItem(parentItem.getPath()));
    }

    private static <C, P> MapperItem<C, P> getErrorMapperItem(MapperPath path) {
        return new MapperItem<Object, P>(null, path, true, Optional.empty());
    }

    MapperItem(T mappedObject, MapperPath path, boolean error, Optional<MapperItem<? extends P, ?>> parentItem) {
        super(path, error, parentItem);
        this.mappedObject = mappedObject;
    }

    public T getMappedObject() {
        return this.mappedObject;
    }

    public MapperItem<Object, ?> upcast() {
        return new MapperItem<T, P>(this.mappedObject, this.getPath(), this.isError(), this.getParentItem());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mappedObject == null ? 0 : this.mappedObject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapperItem other = (MapperItem)obj;
        return !(this.mappedObject == null ? other.mappedObject != null : !this.mappedObject.equals(other.mappedObject));
    }

    public String toString() {
        return "MapperItem [mappedObject=" + this.mappedObject + "]";
    }
}

