/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.expression;

import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;

public class ComparisonResult
implements Mapper<Boolean> {
    private final boolean result;
    private final boolean emptyOperand;
    private final String error;

    public static ComparisonResult success() {
        return new ComparisonResult(true, false, null);
    }

    public static ComparisonResult successEmptyOperand(String error) {
        return new ComparisonResult(true, true, error);
    }

    public static ComparisonResult failure(String error) {
        return new ComparisonResult(false, false, error);
    }

    public static ComparisonResult failureEmptyOperand(String error) {
        return new ComparisonResult(false, true, error);
    }

    public static ComparisonResult of(Mapper<Boolean> result) {
        return new ComparisonResult(result.getMulti().stream().allMatch(r -> r == true), false, null);
    }

    private ComparisonResult(boolean result, boolean emptyOperand, String error) {
        this.result = result;
        this.emptyOperand = emptyOperand;
        this.error = error;
    }

    @Override
    public Boolean get() {
        return this.result;
    }

    @Override
    public Boolean getOrDefault(Boolean defaultValue) {
        return this.result;
    }

    public String getError() {
        return this.error;
    }

    public ComparisonResult and(ComparisonResult other) {
        return this.and(this, other);
    }

    public ComparisonResult andIgnoreEmptyOperand(ComparisonResult other) {
        return this.combineIgnoreEmptyOperand(other, this::and);
    }

    private ComparisonResult and(ComparisonResult r1, ComparisonResult r2) {
        boolean newResult = r1.result && r2.result;
        String newError = "";
        if (!r1.result) {
            newError = newError + r1.error;
        }
        if (!r2.result) {
            if (!r1.result) {
                newError = newError + " and ";
            }
            newError = newError + r2.error;
        }
        return new ComparisonResult(newResult, false, newError);
    }

    public ComparisonResult or(ComparisonResult other) {
        return this.or(this, other);
    }

    public ComparisonResult orIgnoreEmptyOperand(ComparisonResult other) {
        return this.combineIgnoreEmptyOperand(other, this::or);
    }

    private ComparisonResult or(ComparisonResult r1, ComparisonResult r2) {
        boolean newResult = r1.result || r2.result;
        String newError = "";
        newError = newError + r1.error;
        newError = newError + " and ";
        newError = newError + r2.error;
        return new ComparisonResult(newResult, false, newResult ? null : newError);
    }

    private ComparisonResult combineIgnoreEmptyOperand(ComparisonResult other, BinaryOperator<ComparisonResult> combineFunc) {
        if (this.emptyOperand && other.emptyOperand) {
            return ComparisonResult.failureEmptyOperand(this.error + " and " + other.error);
        }
        if (this.emptyOperand) {
            return other;
        }
        if (other.emptyOperand) {
            return this;
        }
        return (ComparisonResult)combineFunc.apply(this, other);
    }

    @Override
    public List<Boolean> getMulti() {
        return Collections.singletonList(this.get());
    }

    @Override
    public Optional<?> getParent() {
        return Optional.empty();
    }

    @Override
    public List<?> getParentMulti() {
        return Collections.emptyList();
    }

    @Override
    public int resultCount() {
        return this.emptyOperand ? 0 : 1;
    }

    public MapperS<Boolean> asMapper() {
        return this.emptyOperand ? MapperS.ofNull() : MapperS.of(this.get());
    }

    @Override
    public List<Mapper.Path> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public List<Mapper.Path> getErrorPaths() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getErrors() {
        return Collections.singletonList(this.getError());
    }
}

