/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.shared.listeners;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.finos.legend.pure.m3.exception.PureExecutionException;
import org.finos.legend.pure.runtime.java.shared.listeners.ExecutionEndListener;
import org.finos.legend.pure.runtime.java.shared.listeners.ExecutionEndListenerState;
import org.finos.legend.pure.runtime.java.shared.listeners.ExecutionEndListenerStateException;
import org.finos.legend.pure.runtime.java.shared.listeners.IdentifableExecutionEndListner;

public class ExecutionListeners {
    private MutableList<ExecutionEndListener> executionEndListeners = Lists.mutable.of();
    private MutableList<IdentifableExecutionEndListner> identifableExecutionEndListeners = Lists.mutable.of();

    public void registerExecutionEndListener(ExecutionEndListener executionEndListener) {
        this.executionEndListeners.add((Object)executionEndListener);
    }

    public void unregisterExecutionEndListener(ExecutionEndListener executionEndListener) {
        this.executionEndListeners.remove((Object)executionEndListener);
    }

    public void registerIdentifableExecutionEndListener(IdentifableExecutionEndListner executionEndListener) {
        this.validateNewExecutionEndListener(executionEndListener);
        this.identifableExecutionEndListeners.add((Object)executionEndListener);
    }

    private void validateNewExecutionEndListener(IdentifableExecutionEndListner executionEndListener) {
        if (this.identifableExecutionEndListeners.anySatisfy((Predicate & Serializable)l -> Objects.equals(l.getId(), executionEndListener.getId()))) {
            throw new PureExecutionException("IdentifableExecutionEndListner with Id: " + executionEndListener.getId() + " is already registered");
        }
    }

    public void unRegisterIdentifableExecutionEndListener(String eventId) {
        this.identifableExecutionEndListeners.removeIf((Predicate & Serializable)l -> Objects.equals(eventId, l.getId()));
    }

    private ListIterable<ExecutionEndListener> allEndListeners() {
        return Lists.mutable.withAll(this.executionEndListeners).withAll(this.identifableExecutionEndListeners);
    }

    private void clearAllEndListners() {
        this.executionEndListeners = Lists.mutable.empty();
        this.identifableExecutionEndListeners = Lists.mutable.empty();
    }

    public void executionEnd(Exception exception) {
        ListIterable executionEndStates = this.allEndListeners().collect((Function & Serializable)executionEndListener -> {
            try {
                return executionEndListener.executionEnd(exception);
            }
            catch (Exception ex) {
                return new ExecutionEndListenerState(true, ex.getMessage());
            }
        });
        MutableList exceptionalState = executionEndStates.select(ExecutionEndListenerState.UNEXPECTED_END_STATE).collect(ExecutionEndListenerState.TO_END_LISTENER_STATE_MESSAGE).toList();
        if (!exceptionalState.isEmpty()) {
            throw new ExecutionEndListenerStateException("Error: " + exceptionalState.makeString());
        }
        this.clearAllEndListners();
    }
}

