/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.shared.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.impl.factory.Lists;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.runtime.java.shared.http.HttpMethod;
import org.finos.legend.pure.runtime.java.shared.http.SimpleHttpResponse;
import org.finos.legend.pure.runtime.java.shared.http.URLScheme;

public class HttpRawHelper {
    public static SimpleHttpResponse executeHttpService(String host, int port, String path, HttpMethod httpMethod, String mimeType, String body) {
        return HttpRawHelper.executeHttpService(URLScheme.http, host, port, path, httpMethod, mimeType, body);
    }

    public static SimpleHttpResponse executeHttpService(URLScheme scheme, String host, int port, String path, HttpMethod httpMethod, String mimeType, String body) {
        URIBuilder uriBuilder = new URIBuilder().setScheme(scheme.name()).setHost(host).setPort(port).setPath(path);
        URI uri = null;
        try {
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            String errMsg = String.format("Cannot build URI from url (%s, %d, %s)", host, port, path);
            throw new RuntimeException(errMsg, e);
        }
        return HttpRawHelper.executeRequest(httpMethod, uri, mimeType, body);
    }

    private static SimpleHttpResponse executeRequest(HttpMethod httpMethod, URI uri, String mimeType, String body) {
        SimpleHttpResponse simpleHttpResponse;
        block14: {
            HttpGet request;
            switch (httpMethod) {
                case GET: {
                    request = new HttpGet(uri);
                    break;
                }
                case PUT: {
                    HttpPut putRequest = new HttpPut(uri);
                    HttpRawHelper.setRequestBody((HttpEntityEnclosingRequestBase)putRequest, mimeType, body);
                    request = putRequest;
                    break;
                }
                case POST: {
                    HttpPost postRequest = new HttpPost(uri);
                    HttpRawHelper.setRequestBody((HttpEntityEnclosingRequestBase)postRequest, mimeType, body);
                    request = postRequest;
                    break;
                }
                case DELETE: {
                    request = new HttpDelete(uri);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("The HTTP method " + (Object)((Object)httpMethod) + " is not supported");
                }
            }
            BasicCookieStore cookieStore = new BasicCookieStore();
            HttpClientBuilder clientBuilder = HttpClients.custom().setDefaultCookieStore((CookieStore)cookieStore);
            CloseableHttpClient httpClient = clientBuilder.build();
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
            try {
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                HttpEntity entity = httpResponse.getEntity();
                String responseContent = entity == null ? "" : EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                simpleHttpResponse = new SimpleHttpResponse(statusCode, responseContent);
                if (httpResponse == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (httpResponse != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error: service call for URL: '" + request.getURI() + "' failed: " + e.getMessage(), e);
                }
            }
            httpResponse.close();
        }
        return simpleHttpResponse;
    }

    private static void setRequestBody(HttpEntityEnclosingRequestBase putRequest, String mimeType, String body) {
        if (body != null) {
            ContentType contentType = mimeType == null ? ContentType.APPLICATION_JSON : ContentType.create((String)mimeType, (String)"UTF-8");
            putRequest.setEntity((HttpEntity)new StringEntity(body, contentType));
        }
    }

    public static CoreInstance toHttpResponseInstance(SimpleHttpResponse response, ProcessorSupport processorSupport) {
        CoreInstance statusInstance = processorSupport.newCoreInstance(Integer.toString(response.getStatusCode()), "Integer", null);
        CoreInstance entityInstance = processorSupport.newCoreInstance(response.getEntityContent(), "String", null);
        CoreInstance coreInstance = processorSupport.newEphemeralAnonymousCoreInstance("meta::pure::functions::io::http::HTTPResponse");
        Instance.setValuesForProperty((CoreInstance)coreInstance, (String)"statusCode", (ListIterable)Lists.immutable.of((Object)statusInstance), (ProcessorSupport)processorSupport);
        Instance.setValuesForProperty((CoreInstance)coreInstance, (String)"entity", (ListIterable)Lists.immutable.of((Object)entityInstance), (ProcessorSupport)processorSupport);
        return coreInstance;
    }
}

