/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.shared.hash;

import org.apache.commons.codec.digest.DigestUtils;
import org.finos.legend.pure.runtime.java.shared.hash.HashType;

public class HashingUtil {
    private HashingUtil() {
    }

    public static String hash(String text, HashType hashType) throws RuntimeException {
        if (hashType == HashType.MD5) {
            return HashingUtil.md5Hash(text);
        }
        if (hashType == HashType.SHA1) {
            return HashingUtil.sha1Hash(text);
        }
        if (hashType == HashType.SHA256) {
            return HashingUtil.sha256Hash(text);
        }
        throw new RuntimeException("Unhandled hashType: " + hashType.name());
    }

    private static String md5Hash(String text) {
        return DigestUtils.md5Hex((String)text);
    }

    private static String sha1Hash(String text) {
        return DigestUtils.sha1Hex((String)text);
    }

    private static String sha256Hash(String text) {
        return DigestUtils.sha256Hex((String)text);
    }
}

