/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.testHelper;

import java.io.Serializable;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.finos.legend.pure.m3.execution.test.PureTestBuilder;
import org.finos.legend.pure.m3.execution.test.TestCollection;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.serialization.filesystem.repository.CodeRepository;
import org.finos.legend.pure.m3.serialization.filesystem.repository.CodeRepositoryProviderHelper;
import org.finos.legend.pure.m3.serialization.filesystem.repository.CodeRepositorySet;
import org.finos.legend.pure.m3.serialization.filesystem.usercodestorage.MutableRepositoryCodeStorage;
import org.finos.legend.pure.m3.serialization.filesystem.usercodestorage.RepositoryCodeStorage;
import org.finos.legend.pure.m3.serialization.filesystem.usercodestorage.classpath.ClassLoaderCodeStorage;
import org.finos.legend.pure.m3.serialization.filesystem.usercodestorage.composite.CompositeCodeStorage;
import org.finos.legend.pure.m3.serialization.runtime.GraphLoader;
import org.finos.legend.pure.m3.serialization.runtime.Message;
import org.finos.legend.pure.m3.serialization.runtime.PureRuntime;
import org.finos.legend.pure.m3.serialization.runtime.PureRuntimeBuilder;
import org.finos.legend.pure.m3.serialization.runtime.binary.PureRepositoryJarLibrary;
import org.finos.legend.pure.m3.serialization.runtime.binary.SimplePureRepositoryJarLibrary;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.FunctionExecutionInterpreted;

public class PureTestBuilderInterpreted {
    public static TestSuite buildSuite(String ... all) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        CodeRepositorySet.Builder builder = CodeRepositorySet.newBuilder().withCodeRepositories((Iterable)CodeRepositoryProviderHelper.findCodeRepositories((ClassLoader)classLoader, (boolean)true));
        RichIterable codeRepositories = builder.build().getRepositories();
        CompositeCodeStorage codeStorage = new CompositeCodeStorage(new RepositoryCodeStorage[]{new ClassLoaderCodeStorage((Iterable)codeRepositories)});
        FunctionExecutionInterpreted functionExecution = new FunctionExecutionInterpreted();
        PureRuntime runtime = new PureRuntimeBuilder((MutableRepositoryCodeStorage)codeStorage).build();
        Message message = new Message("");
        functionExecution.init(runtime, message);
        SimplePureRepositoryJarLibrary jarLibrary = SimplePureRepositoryJarLibrary.newLibrary((Iterable)GraphLoader.findJars((MutableList)Lists.mutable.withAll((Iterable)codeRepositories.select((Predicate & Serializable)c -> c.getName() != null && (c.getName().startsWith("platform") || c.getName().startsWith("core"))).collect(CodeRepository::getName)), (ClassLoader)Thread.currentThread().getContextClassLoader(), (Message)message));
        GraphLoader loader = new GraphLoader(runtime.getModelRepository(), runtime.getContext(), runtime.getIncrementalCompiler().getParserLibrary(), runtime.getIncrementalCompiler().getDslLibrary(), runtime.getSourceRegistry(), runtime.getURLPatternLibrary(), (PureRepositoryJarLibrary)jarLibrary);
        loader.loadAll(message);
        ExecutionSupport executionSupport = new ExecutionSupport();
        PureTestBuilder.F2 p = (a, b) -> functionExecution.start((CoreInstance)a, (ListIterable<? extends CoreInstance>)Lists.mutable.empty());
        TestSuite suite = new TestSuite();
        ArrayIterate.forEach((Object[])all, (Procedure & Serializable)path -> {
            TestCollection col = TestCollection.collectTests((String)path, (ProcessorSupport)functionExecution.getProcessorSupport(), (Predicate & Serializable)ci -> PureTestBuilder.satisfiesConditionsInterpreted((CoreInstance)ci, (ProcessorSupport)functionExecution.getProcessorSupport(), (String[])new String[0]));
            suite.addTest((Test)PureTestBuilder.buildSuite((TestCollection)col, (PureTestBuilder.F2)p, (org.finos.legend.pure.m3.execution.ExecutionSupport)executionSupport));
        });
        return suite;
    }
}

