/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.profiler;

import java.io.Serializable;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.Stacks;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.impl.map.strategy.mutable.UnifiedMapWithHashingStrategy;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.tools.SpacePrinter;
import org.finos.legend.pure.m3.tools.TimePrinter;
import org.finos.legend.pure.m3.tools.TimeTracker;
import org.finos.legend.pure.m3.tools.tree.TreeNode;
import org.finos.legend.pure.m3.tools.tree.TreePrinter;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.runtime.java.interpreted.profiler.IdentityHashingStrategy;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

public class ActiveProfiler
implements Profiler {
    private static final HashingStrategy<CoreInstance> IDENTITY_HASHING_STRATEGY = new IdentityHashingStrategy();
    MutableMap<CoreInstance, MethodStat> treeNodeCache = UnifiedMapWithHashingStrategy.newMap(IDENTITY_HASHING_STRATEGY);
    StringBuffer buffer = new StringBuffer();
    MutableStack<TimeTracker> stack = Stacks.mutable.empty();
    MutableMap<String, MethodStat> map = Maps.mutable.empty();
    MethodStat root;
    private final ProcessorSupport processorSupport;
    private final boolean showTime;

    public ActiveProfiler(ProcessorSupport processorSupport, boolean showTime) {
        this.processorSupport = processorSupport;
        this.showTime = showTime;
    }

    @Override
    public void start(CoreInstance coreInstance) {
        this.buffer.append("\n################################################## Profiler report ##################################################\n");
        this.stack.push((Object)new TimeTracker("T"));
        this.root = new MethodStat(Instance.getValueForMetaPropertyToOneResolved((CoreInstance)coreInstance, (String)"func", (String)"name", (ProcessorSupport)this.processorSupport).getName(), this.showTime);
        this.treeNodeCache.put((Object)coreInstance, (Object)this.root);
    }

    @Override
    public void startExecutingFunctionExpression(CoreInstance instance, CoreInstance parent) {
        MethodStat stat = (MethodStat)this.treeNodeCache.get((Object)instance);
        if (stat == null) {
            stat = new MethodStat(Instance.getValueForMetaPropertyToOneResolved((CoreInstance)instance, (String)"func", (String)"name", (ProcessorSupport)this.processorSupport).getName() + (Instance.instanceOf((CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)instance, (String)"func", (ProcessorSupport)this.processorSupport), (String)"meta::pure::metamodel::function::property::Property", (ProcessorSupport)this.processorSupport) ? "(P)" : ""), this.showTime);
            this.treeNodeCache.put((Object)instance, (Object)stat);
            MethodStat parentStat = (MethodStat)this.treeNodeCache.get((Object)parent);
            parentStat.addChild(stat);
        }
        String funcName = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)instance, (String)"func", (String)"name", (ProcessorSupport)this.processorSupport).getName();
        this.stack.push((Object)new TimeTracker(funcName));
    }

    @Override
    public void finishedExecutingFunctionExpression(CoreInstance instance) {
        String funcName = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)instance, (String)"func", (String)"name", (ProcessorSupport)this.processorSupport).getName();
        long res = new TimeTracker(funcName).diffLong((TimeTracker)this.stack.pop());
        MethodStat stat = (MethodStat)this.map.getIfAbsentPut((Object)funcName, (Function0 & Serializable)() -> new MethodStat(funcName, this.showTime));
        stat.incCount();
        stat.addTime(res);
        MethodStat treeStat = (MethodStat)this.treeNodeCache.get((Object)instance);
        treeStat.incCount();
        treeStat.addTime(res);
    }

    @Override
    public void end(CoreInstance coreInstance) {
        long res = new TimeTracker("T").diffLong((TimeTracker)this.stack.pop());
        MethodStat treeStat = (MethodStat)this.treeNodeCache.get((Object)coreInstance);
        treeStat.incCount();
        treeStat.addTime(res);
        if (this.showTime) {
            int max = this.map.valuesView().collectInt((IntFunction & Serializable)m -> ((MethodStat)m).method.length()).maxIfEmpty(0) + 2;
            this.buffer.append(this.map.valuesView().toSortedList((o1, o2) -> Long.compare(((MethodStat)o2).time, ((MethodStat)o1).time)).collect((Function & Serializable)methodStat -> "       " + SpacePrinter.print((String)((MethodStat)methodStat).method, (int)max) + " " + TimePrinter.makeItHuman((long)((MethodStat)methodStat).time) + "  " + ((MethodStat)methodStat).count).makeString("\n"));
            this.buffer.append("\n\n");
        }
        this.buffer.append(TreePrinter.printTree((TreeNode)this.root, (String)"       "));
        this.buffer.append("\n################################################## Finished Report ##################################################").append(this.showTime ? ": " + res : "").append("\n");
    }

    public String getReport() {
        return this.buffer.toString();
    }

    private static class MethodStat
    implements TreeNode<MethodStat> {
        private final MutableList<MethodStat> children = Lists.mutable.empty();
        private final String method;
        private int count;
        private long time;
        private final boolean showTime;

        private MethodStat(String method, boolean showTime) {
            this.method = method;
            this.showTime = showTime;
        }

        public void incCount() {
            ++this.count;
        }

        public void addTime(long res) {
            this.time += res;
        }

        public void addChild(MethodStat child) {
            this.children.add((Object)child);
        }

        public MutableList<MethodStat> getChildren() {
            return this.children;
        }

        public MethodStat getChildAt(int index) {
            return (MethodStat)this.children.get(index);
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public int indexOf(MethodStat node) {
            return this.children.indexOf((Object)node);
        }

        public String toString() {
            return this.count + " " + this.method + (this.showTime ? " " + TimePrinter.makeItHuman((long)this.time) : "");
        }
    }
}

