/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives.grammar.string;

import java.util.Stack;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.finos.legend.pure.m3.compiler.Context;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.ValueSpecificationBootstrap;
import org.finos.legend.pure.m4.ModelRepository;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.NativeFunction;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

public class JoinStrings
extends NativeFunction {
    private final ModelRepository repository;

    public JoinStrings(ModelRepository repository) {
        this.repository = repository;
    }

    @Override
    public CoreInstance execute(ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, Context context, ProcessorSupport processorSupport) {
        ListIterable strings = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"values", (ProcessorSupport)processorSupport);
        String prefix = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(1)), (String)"values", (ProcessorSupport)processorSupport).getName();
        String suffix = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(3)), (String)"values", (ProcessorSupport)processorSupport).getName();
        int stringCount = strings.size();
        switch (stringCount) {
            case 0: {
                if (prefix.isEmpty()) {
                    return (CoreInstance)params.get(3);
                }
                if (suffix.isEmpty()) {
                    return (CoreInstance)params.get(1);
                }
                return ValueSpecificationBootstrap.newStringLiteral((ModelRepository)this.repository, (String)(prefix + suffix), (ProcessorSupport)processorSupport);
            }
            case 1: {
                if (prefix.isEmpty() && suffix.isEmpty()) {
                    return ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)((CoreInstance)strings.get(0)), (boolean)true, (ProcessorSupport)processorSupport);
                }
                return ValueSpecificationBootstrap.newStringLiteral((ModelRepository)this.repository, (String)(prefix + ((CoreInstance)strings.get(0)).getName() + suffix), (ProcessorSupport)processorSupport);
            }
        }
        String separator = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(2)), (String)"values", (ProcessorSupport)processorSupport).getName();
        StringBuilder builder = new StringBuilder(prefix.length() + suffix.length() + stringCount * (8 + separator.length()));
        builder.append(prefix);
        if (separator.isEmpty()) {
            for (int i = 0; i < stringCount; ++i) {
                builder.append(((CoreInstance)strings.get(i)).getName());
            }
        } else {
            builder.append(((CoreInstance)strings.get(0)).getName());
            for (int i = 1; i < stringCount; ++i) {
                builder.append(separator);
                builder.append(((CoreInstance)strings.get(i)).getName());
            }
        }
        builder.append(suffix);
        return ValueSpecificationBootstrap.newStringLiteral((ModelRepository)this.repository, (String)builder.toString(), (ProcessorSupport)processorSupport);
    }
}

