/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives.grammar.math;

import java.util.Stack;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.finos.legend.pure.m3.compiler.Context;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.ValueSpecificationBootstrap;
import org.finos.legend.pure.m3.navigation.valuespecification.ValueSpecification;
import org.finos.legend.pure.m4.ModelRepository;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.NativeFunction;
import org.finos.legend.pure.runtime.java.interpreted.natives.NumericUtilities;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.math.NumericAccumulator;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

public class Times
extends NativeFunction {
    private final ModelRepository repository;

    public Times(ModelRepository repository) {
        this.repository = repository;
    }

    @Override
    public CoreInstance execute(ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, Context context, ProcessorSupport processorSupport) {
        ListIterable numbers = ValueSpecification.getValues((CoreInstance)((CoreInstance)params.get(0)), (ProcessorSupport)processorSupport);
        int size = numbers.size();
        switch (size) {
            case 0: {
                return ValueSpecificationBootstrap.newIntegerLiteral((ModelRepository)this.repository, (int)1, (ProcessorSupport)processorSupport);
            }
            case 1: {
                return ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)((CoreInstance)numbers.get(0)), (boolean)true, (ProcessorSupport)processorSupport);
            }
        }
        NumericAccumulator accumulator = NumericAccumulator.newAccumulator(NumericUtilities.toJavaNumber((CoreInstance)numbers.get(0), processorSupport));
        boolean bigDecimalToPureDecimal = numbers.anySatisfy(NumericUtilities.IS_DECIMAL_CORE_INSTANCE(processorSupport));
        for (int i = 1; i < size; ++i) {
            accumulator.multiply(NumericUtilities.toJavaNumber((CoreInstance)numbers.get(i), processorSupport));
        }
        return NumericUtilities.toPureNumberValueExpression(accumulator.getValue(), bigDecimalToPureDecimal, this.repository, processorSupport);
    }
}

