/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives.grammar.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class NumericAccumulator {
    private NumberWrapper number;

    private NumericAccumulator(NumberWrapper number) {
        this.number = number;
    }

    public Number getValue() {
        return this.number.getValue();
    }

    public void add(Number number) {
        if (number == null) {
            throw new NullPointerException("Cannot add null");
        }
        if (number instanceof BigDecimal) {
            this.add((BigDecimal)number);
        } else if (number instanceof Double) {
            this.add(number.doubleValue());
        } else if (number instanceof Float) {
            this.add(number.floatValue());
        } else if (number instanceof BigInteger) {
            this.add((BigInteger)number);
        } else if (number instanceof Long) {
            this.add(number.longValue());
        } else if (number instanceof Integer) {
            this.add(number.intValue());
        } else {
            throw new IllegalArgumentException("Unhandled number: " + number);
        }
    }

    public void add(BigDecimal number) {
        this.number = this.number.add(number);
    }

    public void add(double number) {
        this.number = this.number.add(number);
    }

    public void add(float number) {
        this.number = this.number.add(number);
    }

    public void add(BigInteger number) {
        this.number = this.number.add(number);
    }

    public void add(long number) {
        this.number = this.number.add(number);
    }

    public void add(int number) {
        this.number = this.number.add(number);
    }

    public void subtract(Number number) {
        if (number == null) {
            throw new NullPointerException("Cannot subtract null");
        }
        if (number instanceof BigDecimal) {
            this.subtract((BigDecimal)number);
        } else if (number instanceof Double) {
            this.subtract(number.doubleValue());
        } else if (number instanceof Float) {
            this.subtract(number.floatValue());
        } else if (number instanceof BigInteger) {
            this.subtract((BigInteger)number);
        } else if (number instanceof Long) {
            this.subtract(number.longValue());
        } else if (number instanceof Integer) {
            this.subtract(number.intValue());
        } else {
            throw new IllegalArgumentException("Unhandled number: " + number);
        }
    }

    public void subtract(BigDecimal number) {
        this.number = this.number.subtract(number);
    }

    public void subtract(double number) {
        this.number = this.number.subtract(number);
    }

    public void subtract(float number) {
        this.number = this.number.subtract(number);
    }

    public void subtract(BigInteger number) {
        this.number = this.number.subtract(number);
    }

    public void subtract(long number) {
        this.number = this.number.subtract(number);
    }

    public void subtract(int number) {
        this.number = this.number.subtract(number);
    }

    public void multiply(Number number) {
        if (number == null) {
            throw new NullPointerException("Cannot multiply by null");
        }
        if (number instanceof BigDecimal) {
            this.multiply((BigDecimal)number);
        } else if (number instanceof Double) {
            this.multiply(number.doubleValue());
        } else if (number instanceof Float) {
            this.multiply(number.floatValue());
        } else if (number instanceof BigInteger) {
            this.multiply((BigInteger)number);
        } else if (number instanceof Long) {
            this.multiply(number.longValue());
        } else if (number instanceof Integer) {
            this.multiply(number.intValue());
        } else {
            throw new IllegalArgumentException("Unhandled number: " + number);
        }
    }

    public void multiply(BigDecimal number) {
        this.number = this.number.multiply(number);
    }

    public void multiply(double number) {
        this.number = this.number.multiply(number);
    }

    public void multiply(float number) {
        this.number = this.number.multiply(number);
    }

    public void multiply(BigInteger number) {
        this.number = this.number.multiply(number);
    }

    public void multiply(long number) {
        this.number = this.number.multiply(number);
    }

    public void multiply(int number) {
        this.number = this.number.multiply(number);
    }

    public void divide(Number number) {
        if (number == null) {
            throw new NullPointerException("Cannot divide by null");
        }
        if (number instanceof BigDecimal) {
            this.divide((BigDecimal)number);
        } else if (number instanceof Double) {
            this.divide(number.doubleValue());
        } else if (number instanceof Float) {
            this.divide(number.floatValue());
        } else if (number instanceof BigInteger) {
            this.divide((BigInteger)number);
        } else if (number instanceof Long) {
            this.divide(number.longValue());
        } else if (number instanceof Integer) {
            this.divide(number.intValue());
        } else {
            throw new IllegalArgumentException("Unhandled number: " + number);
        }
    }

    public void divide(BigDecimal number) {
        this.number = this.number.divide(number);
    }

    public void divide(double number) {
        this.number = this.number.divide(number);
    }

    public void divide(float number) {
        this.number = this.number.divide(number);
    }

    public void divide(BigInteger number) {
        this.number = this.number.divide(number);
    }

    public void divide(long number) {
        this.number = this.number.divide(number);
    }

    public void divide(int number) {
        this.number = this.number.divide(number);
    }

    public void pow(Number number) {
        if (number == null) {
            throw new NullPointerException("Cannot divide by null");
        }
        if (number instanceof BigDecimal) {
            this.pow((BigDecimal)number);
        } else if (number instanceof Double) {
            this.pow(number.doubleValue());
        } else if (number instanceof Float) {
            this.pow(number.floatValue());
        } else if (number instanceof BigInteger) {
            this.pow((BigInteger)number);
        } else if (number instanceof Long) {
            this.pow(number.longValue());
        } else if (number instanceof Integer) {
            this.pow(number.intValue());
        } else {
            throw new IllegalArgumentException("Unhandled number: " + number);
        }
    }

    public void pow(BigDecimal number) {
        this.number = this.number.pow(number);
    }

    public void pow(double number) {
        this.number = this.number.pow(number);
    }

    public void pow(float number) {
        this.number = this.number.pow(number);
    }

    public void pow(BigInteger number) {
        this.number = this.number.pow(number);
    }

    public void pow(long number) {
        this.number = this.number.pow(number);
    }

    public void pow(int number) {
        this.number = this.number.pow(number);
    }

    public static NumericAccumulator newAccumulator(Number initialValue) {
        if (initialValue == null) {
            throw new NullPointerException("Initial value cannot be null");
        }
        if (initialValue instanceof BigDecimal) {
            return NumericAccumulator.newAccumulator((BigDecimal)initialValue);
        }
        if (initialValue instanceof Double) {
            return NumericAccumulator.newAccumulator(initialValue.doubleValue());
        }
        if (initialValue instanceof Float) {
            return NumericAccumulator.newAccumulator(initialValue.floatValue());
        }
        if (initialValue instanceof BigInteger) {
            return NumericAccumulator.newAccumulator((BigInteger)initialValue);
        }
        if (initialValue instanceof Long) {
            return NumericAccumulator.newAccumulator(initialValue.longValue());
        }
        if (initialValue instanceof Integer) {
            return NumericAccumulator.newAccumulator(initialValue.intValue());
        }
        throw new IllegalArgumentException("Unhandled number: " + initialValue);
    }

    public static NumericAccumulator newAccumulator(BigDecimal initialValue) {
        if (initialValue == null) {
            throw new NullPointerException("Initial value cannot be null");
        }
        return new NumericAccumulator(new BigDecimalWrapper(initialValue));
    }

    public static NumericAccumulator newAccumulator(double initialValue) {
        return new NumericAccumulator(new DoubleWrapper(initialValue));
    }

    public static NumericAccumulator newAccumulator(float initialValue) {
        return NumericAccumulator.newAccumulator((double)initialValue);
    }

    public static NumericAccumulator newAccumulator(BigInteger initialValue) {
        if (initialValue == null) {
            throw new NullPointerException("Initial value cannot be null");
        }
        return new NumericAccumulator(new BigIntegerWrapper(initialValue));
    }

    public static NumericAccumulator newAccumulator(long initialValue) {
        return new NumericAccumulator(new LongWrapper(initialValue));
    }

    public static NumericAccumulator newAccumulator(int initialValue) {
        return NumericAccumulator.newAccumulator((long)initialValue);
    }

    private static class LongWrapper
    extends NumberWrapper {
        private long value;

        private LongWrapper(long initialValue) {
            this.value = initialValue;
        }

        @Override
        Long getValue() {
            return this.value;
        }

        @Override
        NumberWrapper negate() {
            if (this.value == Long.MIN_VALUE) {
                return new BigIntegerWrapper(this.value).negate();
            }
            this.value = -this.value;
            return this;
        }

        @Override
        NumberWrapper add(BigDecimal number) {
            return new BigDecimalWrapper(this.value).add(number);
        }

        @Override
        NumberWrapper add(double number) {
            return new BigDecimalWrapper(this.value).add(number);
        }

        @Override
        NumberWrapper add(BigInteger number) {
            return new BigIntegerWrapper(this.value).add(number);
        }

        @Override
        NumberWrapper add(long number) {
            long newValue = this.value + number;
            if (LongWrapper.additionHasOverflowed(this.value, number, newValue)) {
                return new BigIntegerWrapper(this.value).add(number);
            }
            this.value = newValue;
            return this;
        }

        @Override
        NumberWrapper add(int number) {
            return this.add((long)number);
        }

        @Override
        NumberWrapper subtract(BigDecimal number) {
            return new BigDecimalWrapper(this.value).subtract(number);
        }

        @Override
        NumberWrapper subtract(double number) {
            return new BigDecimalWrapper(this.value).subtract(number);
        }

        @Override
        NumberWrapper subtract(BigInteger number) {
            return new BigIntegerWrapper(this.value).subtract(number);
        }

        @Override
        NumberWrapper subtract(long number) {
            long newValue = this.value - number;
            if (LongWrapper.subtractionHasUnderflowed(this.value, number, newValue)) {
                return new BigIntegerWrapper(this.value).subtract(number);
            }
            this.value = newValue;
            return this;
        }

        @Override
        NumberWrapper subtract(int number) {
            return this.subtract((long)number);
        }

        @Override
        NumberWrapper multiply(BigDecimal number) {
            return new BigDecimalWrapper(this.value).multiply(number);
        }

        @Override
        NumberWrapper multiply(double number) {
            return new BigDecimalWrapper(this.value).multiply(number);
        }

        @Override
        NumberWrapper multiply(BigInteger number) {
            return new BigIntegerWrapper(this.value).multiply(number);
        }

        @Override
        NumberWrapper multiply(long number) {
            if (LongWrapper.isMultiplicationSafe(this.value, number)) {
                this.value *= number;
                return this;
            }
            return new BigIntegerWrapper(this.value).multiply(number);
        }

        @Override
        NumberWrapper multiply(int number) {
            return this.multiply((long)number);
        }

        @Override
        NumberWrapper divide(BigDecimal number) {
            return new BigDecimalWrapper(this.value).divide(number);
        }

        @Override
        NumberWrapper divide(double number) {
            return new BigDecimalWrapper(this.value).divide(number);
        }

        @Override
        NumberWrapper divide(BigInteger number) {
            return new BigDecimalWrapper(this.value).divide(number);
        }

        @Override
        NumberWrapper divide(long number) {
            if (this.value % number == 0L) {
                this.value /= number;
                return this;
            }
            return new BigDecimalWrapper(this.value).divide(number);
        }

        @Override
        NumberWrapper divide(int number) {
            return this.divide((long)number);
        }

        @Override
        NumberWrapper pow(BigDecimal number) {
            return new BigDecimalWrapper(this.value).pow(number);
        }

        @Override
        NumberWrapper pow(int number) {
            return this.pow((long)number);
        }

        @Override
        NumberWrapper pow(long number) {
            return new BigIntegerWrapper(this.value).pow(number);
        }

        @Override
        NumberWrapper pow(double number) {
            return new BigDecimalWrapper(this.value).pow(number);
        }

        @Override
        NumberWrapper pow(BigInteger number) {
            return new BigIntegerWrapper(this.value).pow(number);
        }

        private static boolean additionHasOverflowed(long x, long y, long result) {
            if (x > 0L) {
                return y > 0L && result < 0L;
            }
            if (x < 0L) {
                return y < 0L && result > 0L;
            }
            return false;
        }

        private static boolean subtractionHasUnderflowed(long x, long y, long result) {
            if (x > 0L) {
                return y < 0L && result < 0L;
            }
            if (x < 0L) {
                return y > 0L && result > 0L;
            }
            return false;
        }

        private static boolean isMultiplicationSafe(long x, long y) {
            if (x == 0L || y == 0L) {
                return true;
            }
            if (x > 0L) {
                if (y > 0L) {
                    return x <= Long.MAX_VALUE / y;
                }
                return x <= Long.MIN_VALUE / y;
            }
            if (y > 0L) {
                return x >= Long.MIN_VALUE / y;
            }
            return x >= Long.MAX_VALUE / y;
        }
    }

    private static class BigIntegerWrapper
    extends NumberWrapper {
        private BigInteger value;

        private BigIntegerWrapper(BigInteger initialValue) {
            this.value = initialValue;
        }

        private BigIntegerWrapper(long initialValue) {
            this(new BigInteger(Long.toString(initialValue)));
        }

        @Override
        BigInteger getValue() {
            return this.value;
        }

        @Override
        NumberWrapper negate() {
            this.value = this.value.negate();
            return this;
        }

        @Override
        NumberWrapper add(BigDecimal number) {
            return new BigDecimalWrapper(this.value).add(number);
        }

        @Override
        NumberWrapper add(double number) {
            return new BigDecimalWrapper(this.value).add(number);
        }

        @Override
        NumberWrapper add(BigInteger number) {
            this.value = this.value.add(number);
            return this;
        }

        @Override
        NumberWrapper add(long number) {
            return this.add(new BigInteger(Long.toString(number)));
        }

        @Override
        NumberWrapper add(int number) {
            return this.add(new BigInteger(Integer.toString(number)));
        }

        @Override
        NumberWrapper subtract(BigDecimal number) {
            return new BigDecimalWrapper(this.value).subtract(number);
        }

        @Override
        NumberWrapper subtract(double number) {
            return new BigDecimalWrapper(this.value).subtract(number);
        }

        @Override
        NumberWrapper subtract(BigInteger number) {
            this.value = this.value.subtract(number);
            return this;
        }

        @Override
        NumberWrapper subtract(long number) {
            return this.subtract(new BigInteger(Long.toString(number)));
        }

        @Override
        NumberWrapper subtract(int number) {
            return this.subtract(new BigInteger(Integer.toString(number)));
        }

        @Override
        NumberWrapper multiply(BigDecimal number) {
            return new BigDecimalWrapper(this.value).multiply(number);
        }

        @Override
        NumberWrapper multiply(double number) {
            return new BigDecimalWrapper(this.value).multiply(number);
        }

        @Override
        NumberWrapper multiply(BigInteger number) {
            this.value = this.value.multiply(number);
            return this;
        }

        @Override
        NumberWrapper multiply(long number) {
            return this.multiply(new BigInteger(Long.toString(number)));
        }

        @Override
        NumberWrapper multiply(int number) {
            return this.multiply(new BigInteger(Integer.toString(number)));
        }

        @Override
        NumberWrapper divide(BigDecimal number) {
            return new BigDecimalWrapper(this.value).divide(number);
        }

        @Override
        NumberWrapper divide(double number) {
            return new BigDecimalWrapper(this.value).divide(number);
        }

        @Override
        NumberWrapper divide(BigInteger number) {
            return new BigDecimalWrapper(this.value).divide(number);
        }

        @Override
        NumberWrapper divide(long number) {
            return this.divide(new BigDecimal(Long.toString(number)));
        }

        @Override
        NumberWrapper divide(int number) {
            return this.divide(new BigDecimal(Integer.toString(number)));
        }

        @Override
        NumberWrapper pow(BigDecimal number) {
            return new BigDecimalWrapper(this.value).pow(number);
        }

        @Override
        NumberWrapper pow(int number) {
            return new BigIntegerWrapper(this.value.pow(number));
        }

        @Override
        NumberWrapper pow(long number) {
            return this.pow(new BigDecimal(number));
        }

        @Override
        NumberWrapper pow(double number) {
            return this.pow(BigDecimal.valueOf(number));
        }

        @Override
        NumberWrapper pow(BigInteger number) {
            return this.pow(new BigDecimal(number));
        }
    }

    private static class DoubleWrapper
    extends NumberWrapper {
        private double value;

        private DoubleWrapper(double number) {
            this.value = number;
        }

        @Override
        Double getValue() {
            return this.value;
        }

        @Override
        NumberWrapper negate() {
            double newValue = -this.value;
            if (Double.isInfinite(newValue)) {
                return new BigDecimalWrapper(this.value).negate();
            }
            this.value = newValue;
            return this;
        }

        @Override
        NumberWrapper add(BigDecimal number) {
            return new BigDecimalWrapper(this.value).add(number);
        }

        @Override
        NumberWrapper add(double number) {
            double newValue = this.value + number;
            if (Double.isInfinite(newValue)) {
                return new BigDecimalWrapper(this.value).add(number);
            }
            this.value = newValue;
            return this;
        }

        @Override
        NumberWrapper add(BigInteger number) {
            return new BigDecimalWrapper(this.value).add(number);
        }

        @Override
        NumberWrapper add(long number) {
            double newValue = this.value + (double)number;
            if (Double.isInfinite(newValue)) {
                return new BigDecimalWrapper(this.value).add(number);
            }
            this.value = newValue;
            return this;
        }

        @Override
        NumberWrapper add(int number) {
            double newValue = this.value + (double)number;
            if (Double.isInfinite(newValue)) {
                return new BigDecimalWrapper(this.value).add(number);
            }
            this.value = newValue;
            return this;
        }

        @Override
        NumberWrapper subtract(BigDecimal number) {
            return new BigDecimalWrapper(this.value).subtract(number);
        }

        @Override
        NumberWrapper subtract(double number) {
            double newValue = this.value - number;
            if (Double.isInfinite(newValue)) {
                return new BigDecimalWrapper(this.value).subtract(number);
            }
            this.value = newValue;
            return this;
        }

        @Override
        NumberWrapper subtract(BigInteger number) {
            return new BigDecimalWrapper(this.value).subtract(number);
        }

        @Override
        NumberWrapper subtract(long number) {
            double newValue = this.value - (double)number;
            if (Double.isInfinite(newValue)) {
                return new BigDecimalWrapper(this.value).subtract(number);
            }
            this.value = newValue;
            return this;
        }

        @Override
        NumberWrapper subtract(int number) {
            double newValue = this.value - (double)number;
            if (Double.isInfinite(newValue)) {
                return new BigDecimalWrapper(this.value).subtract(number);
            }
            this.value = newValue;
            return this;
        }

        @Override
        NumberWrapper multiply(BigDecimal number) {
            return new BigDecimalWrapper(this.value).multiply(number);
        }

        @Override
        NumberWrapper multiply(double number) {
            double newValue = this.value * number;
            if (Double.isInfinite(newValue)) {
                return new BigDecimalWrapper(this.value).multiply(number);
            }
            this.value = newValue;
            return this;
        }

        @Override
        NumberWrapper multiply(BigInteger number) {
            return new BigDecimalWrapper(this.value).multiply(number);
        }

        @Override
        NumberWrapper multiply(long number) {
            double newValue = this.value * (double)number;
            if (Double.isInfinite(newValue)) {
                return new BigDecimalWrapper(this.value).multiply(number);
            }
            this.value = newValue;
            return this;
        }

        @Override
        NumberWrapper multiply(int number) {
            double newValue = this.value * (double)number;
            if (Double.isInfinite(newValue)) {
                return new BigDecimalWrapper(this.value).multiply(number);
            }
            this.value = newValue;
            return this;
        }

        @Override
        NumberWrapper divide(BigDecimal number) {
            return new BigDecimalWrapper(this.value).divide(number);
        }

        @Override
        NumberWrapper divide(double number) {
            this.value /= number;
            return this;
        }

        @Override
        NumberWrapper divide(BigInteger number) {
            return new BigDecimalWrapper(this.value).divide(number);
        }

        @Override
        NumberWrapper divide(long number) {
            this.value /= (double)number;
            return this;
        }

        @Override
        NumberWrapper divide(int number) {
            this.value /= (double)number;
            return this;
        }

        @Override
        NumberWrapper pow(BigDecimal number) {
            return this.pow(number.doubleValue());
        }

        @Override
        NumberWrapper pow(int number) {
            return this.pow(new BigDecimal(number));
        }

        @Override
        NumberWrapper pow(long number) {
            return this.pow(new BigDecimal(number));
        }

        @Override
        NumberWrapper pow(double number) {
            this.value = StrictMath.pow(this.value, number);
            return this;
        }

        @Override
        NumberWrapper pow(BigInteger number) {
            return this.pow(new BigDecimal(number));
        }
    }

    private static class BigDecimalWrapper
    extends NumberWrapper {
        private BigDecimal value;

        private BigDecimalWrapper(BigDecimal initialValue) {
            this.value = initialValue;
        }

        private BigDecimalWrapper(double initialValue) {
            this(BigDecimal.valueOf(initialValue));
        }

        private BigDecimalWrapper(BigInteger initialValue) {
            this(new BigDecimal(initialValue));
        }

        private BigDecimalWrapper(long initialValue) {
            this(new BigDecimal(initialValue));
        }

        @Override
        Number getValue() {
            return this.value;
        }

        @Override
        BigDecimalWrapper negate() {
            this.value = this.value.negate();
            return this;
        }

        @Override
        NumberWrapper add(BigDecimal number) {
            this.value = this.value.add(number);
            return this;
        }

        @Override
        NumberWrapper add(double number) {
            return this.add(BigDecimal.valueOf(number));
        }

        @Override
        NumberWrapper add(BigInteger number) {
            return this.add(new BigDecimal(number));
        }

        @Override
        NumberWrapper add(long number) {
            return this.add(new BigDecimal(number));
        }

        @Override
        NumberWrapper add(int number) {
            return this.add(new BigDecimal(number));
        }

        @Override
        NumberWrapper subtract(BigDecimal number) {
            this.value = this.value.subtract(number);
            return this;
        }

        @Override
        NumberWrapper subtract(double number) {
            return this.subtract(BigDecimal.valueOf(number));
        }

        @Override
        NumberWrapper subtract(BigInteger number) {
            return this.subtract(new BigDecimal(number));
        }

        @Override
        NumberWrapper subtract(long number) {
            return this.subtract(new BigDecimal(number));
        }

        @Override
        NumberWrapper subtract(int number) {
            return this.subtract(new BigDecimal(number));
        }

        @Override
        NumberWrapper multiply(BigDecimal number) {
            this.value = this.value.multiply(number);
            return this;
        }

        @Override
        NumberWrapper multiply(double number) {
            return this.multiply(BigDecimal.valueOf(number));
        }

        @Override
        NumberWrapper multiply(BigInteger number) {
            return this.multiply(new BigDecimal(number));
        }

        @Override
        NumberWrapper multiply(long number) {
            return this.multiply(new BigDecimal(number));
        }

        @Override
        NumberWrapper multiply(int number) {
            return this.multiply(new BigDecimal(number));
        }

        @Override
        NumberWrapper divide(BigDecimal number) {
            try {
                this.value = this.value.divide(number);
            }
            catch (ArithmeticException e) {
                this.value = this.value.divide(number, MathContext.DECIMAL128);
            }
            return this;
        }

        @Override
        NumberWrapper divide(double number) {
            return this.divide(BigDecimal.valueOf(number));
        }

        @Override
        NumberWrapper divide(BigInteger number) {
            return this.divide(new BigDecimal(number));
        }

        @Override
        NumberWrapper divide(long number) {
            return this.divide(new BigDecimal(number));
        }

        @Override
        NumberWrapper divide(int number) {
            return this.divide(new BigDecimal(number));
        }

        @Override
        NumberWrapper pow(BigDecimal number) {
            this.value = new BigDecimal(StrictMath.pow(this.value.doubleValue(), number.doubleValue()));
            return this;
        }

        @Override
        NumberWrapper pow(int number) {
            return this.pow(new BigDecimal(number));
        }

        @Override
        NumberWrapper pow(long number) {
            return this.pow(new BigDecimal(number));
        }

        @Override
        NumberWrapper pow(double number) {
            return this.pow(BigDecimal.valueOf(number));
        }

        @Override
        NumberWrapper pow(BigInteger number) {
            return this.pow(new BigDecimal(number));
        }
    }

    private static abstract class NumberWrapper {
        private NumberWrapper() {
        }

        abstract Number getValue();

        abstract NumberWrapper negate();

        abstract NumberWrapper add(BigDecimal var1);

        abstract NumberWrapper add(double var1);

        NumberWrapper add(float number) {
            return this.add((double)number);
        }

        abstract NumberWrapper add(BigInteger var1);

        abstract NumberWrapper add(long var1);

        abstract NumberWrapper add(int var1);

        abstract NumberWrapper subtract(BigDecimal var1);

        abstract NumberWrapper subtract(double var1);

        NumberWrapper subtract(float number) {
            return this.subtract((double)number);
        }

        abstract NumberWrapper subtract(BigInteger var1);

        abstract NumberWrapper subtract(long var1);

        abstract NumberWrapper subtract(int var1);

        abstract NumberWrapper multiply(BigDecimal var1);

        abstract NumberWrapper multiply(double var1);

        NumberWrapper multiply(float number) {
            return this.multiply((double)number);
        }

        abstract NumberWrapper multiply(BigInteger var1);

        abstract NumberWrapper multiply(long var1);

        abstract NumberWrapper multiply(int var1);

        abstract NumberWrapper divide(BigDecimal var1);

        abstract NumberWrapper divide(double var1);

        NumberWrapper divide(float number) {
            return this.divide((double)number);
        }

        abstract NumberWrapper divide(BigInteger var1);

        abstract NumberWrapper divide(long var1);

        abstract NumberWrapper divide(int var1);

        abstract NumberWrapper pow(int var1);

        abstract NumberWrapper pow(long var1);

        NumberWrapper pow(float number) {
            return this.pow((double)number);
        }

        abstract NumberWrapper pow(double var1);

        abstract NumberWrapper pow(BigInteger var1);

        abstract NumberWrapper pow(BigDecimal var1);
    }
}

