/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives.grammar.lang;

import java.util.Stack;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.tuple.Tuples;
import org.finos.legend.pure.m3.compiler.Context;
import org.finos.legend.pure.m3.exception.PureExecutionException;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.PackageableElement.PackageableElement;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.ValueSpecificationBootstrap;
import org.finos.legend.pure.m3.navigation.generictype.GenericType;
import org.finos.legend.pure.m3.navigation.measure.Measure;
import org.finos.legend.pure.m3.navigation.multiplicity.Multiplicity;
import org.finos.legend.pure.m3.navigation.property.Property;
import org.finos.legend.pure.m3.navigation.type.Type;
import org.finos.legend.pure.m3.navigation.valuespecification.ValueSpecification;
import org.finos.legend.pure.m4.ModelRepository;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.m4.coreinstance.SourceInformation;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.Executor;
import org.finos.legend.pure.runtime.java.interpreted.FunctionExecutionInterpreted;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.DefaultConstraintHandler;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.MapCoreInstance;
import org.finos.legend.pure.runtime.java.interpreted.natives.NativeFunction;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

public class New
extends NativeFunction {
    private final FunctionExecutionInterpreted functionExecution;
    private final ModelRepository repository;

    public New(ModelRepository repository, FunctionExecutionInterpreted functionExecution) {
        this.functionExecution = functionExecution;
        this.repository = repository;
    }

    @Override
    public CoreInstance execute(ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, Context context, ProcessorSupport processorSupport) throws PureExecutionException {
        ImmutableList keyValues;
        CoreInstance __genericType = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"genericType", (String)"typeArguments", (ProcessorSupport)processorSupport);
        CoreInstance classifier = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)__genericType, (String)"rawType", (ProcessorSupport)processorSupport);
        if (classifier.equals(processorSupport.package_getByUserPath("meta::pure::functions::collection::Map"))) {
            CoreInstance mapRawType = processorSupport.package_getByUserPath("meta::pure::functions::collection::Map");
            MapCoreInstance map = new MapCoreInstance((ListIterable<? extends CoreInstance>)Lists.immutable.empty(), "", functionExpressionToUseInStack.getSourceInformation(), mapRawType, -1, this.repository, false, processorSupport);
            CoreInstance genericType = processorSupport.newGenericType(null, (CoreInstance)map, false);
            Instance.addValueToProperty((CoreInstance)genericType, (String)"rawType", (CoreInstance)mapRawType, (ProcessorSupport)processorSupport);
            Instance.addValueToProperty((CoreInstance)genericType, (String)"typeArguments", (Iterable)((CoreInstance)params.get(0)).getValueForMetaPropertyToOne("genericType").getValueForMetaPropertyToOne("typeArguments").getValueForMetaPropertyToMany("typeArguments"), (ProcessorSupport)processorSupport);
            genericType = GenericType.makeTypeArgumentAsConcreteAsPossible((CoreInstance)genericType, (MapIterable)((MutableMap)resolvedTypeParameters.elementAt(resolvedTypeParameters.size() - (resolvedTypeParameters.size() >= 2 ? 2 : 1))).asUnmodifiable(), (MapIterable)Maps.immutable.of(), (ProcessorSupport)processorSupport);
            Instance.addValueToProperty((CoreInstance)map, (String)"classifierGenericType", (CoreInstance)genericType, (ProcessorSupport)processorSupport);
            return ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)map, (boolean)ValueSpecification.isExecutable((CoreInstance)((CoreInstance)params.get(0)), (ProcessorSupport)processorSupport), (ProcessorSupport)processorSupport);
        }
        instantiationContext.push(classifier);
        String id = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(1)), (String)"values", (ProcessorSupport)processorSupport).getName();
        Object object = keyValues = params.size() > 2 ? Instance.getValueForMetaPropertyToManyResolved((CoreInstance)((CoreInstance)params.get(2)), (String)"values", (ProcessorSupport)processorSupport) : Lists.immutable.with();
        if (Type.isBottomType((CoreInstance)classifier, (ProcessorSupport)processorSupport)) {
            throw new PureExecutionException(functionExpressionToUseInStack.getSourceInformation(), "Cannot instantiate " + PackageableElement.getUserPathForPackageableElement((CoreInstance)classifier, (String)"::"));
        }
        CoreInstance genericType = classifier.getValueForMetaPropertyToOne("classifierGenericType").getValueForMetaPropertyToOne("typeArguments");
        ListIterable typeArguments = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)genericType, (String)"typeArguments", (ProcessorSupport)processorSupport);
        ListIterable multiplicityArguments = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)genericType, (String)"multiplicityArguments", (ProcessorSupport)processorSupport);
        CoreInstance instance = id.isEmpty() ? this.repository.newEphemeralAnonymousCoreInstance(functionExpressionToUseInStack.getSourceInformation(), classifier) : this.repository.newEphemeralCoreInstance(id, classifier, null);
        CoreInstance genericTypeType = processorSupport.package_getByUserPath("meta::pure::metamodel::type::generics::GenericType");
        CoreInstance classifierGenericType = this.repository.newEphemeralAnonymousCoreInstance(functionExpressionToUseInStack.getSourceInformation(), genericTypeType);
        Instance.addValueToProperty((CoreInstance)classifierGenericType, (String)"rawType", (CoreInstance)classifier, (ProcessorSupport)processorSupport);
        for (CoreInstance typeArgument : typeArguments) {
            Instance.addValueToProperty((CoreInstance)classifierGenericType, (String)"typeArguments", (CoreInstance)typeArgument, (ProcessorSupport)processorSupport);
        }
        for (CoreInstance multiplicityArgument : multiplicityArguments) {
            CoreInstance concreteMultiplicityArgument = Multiplicity.makeMultiplicityAsConcreteAsPossible((CoreInstance)multiplicityArgument, (MapIterable)resolvedMultiplicityParameters.peek().asUnmodifiable());
            Instance.addValueToProperty((CoreInstance)classifierGenericType, (String)"multiplicityArguments", (CoreInstance)concreteMultiplicityArgument, (ProcessorSupport)processorSupport);
        }
        classifierGenericType = GenericType.makeTypeArgumentAsConcreteAsPossible((CoreInstance)classifierGenericType, (MapIterable)resolvedTypeParameters.peek().asUnmodifiable(), (MapIterable)Maps.immutable.of(), (ProcessorSupport)processorSupport);
        Instance.addValueToProperty((CoreInstance)instance, (String)"classifierGenericType", (CoreInstance)classifierGenericType, (ProcessorSupport)processorSupport);
        VariableContext evaluationVariableContext = this.getParentOrEmptyVariableContext(variableContext);
        MapIterable propertiesByName = processorSupport.class_getSimplePropertiesByName(classifier);
        for (CoreInstance keyValue : keyValues) {
            CoreInstance keyInstance = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)keyValue, (String)"key", (ProcessorSupport)processorSupport);
            String key = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)keyInstance, (String)"values", (ProcessorSupport)processorSupport).getName();
            SourceInformation sourceInfoForErrors = keyInstance.getSourceInformation();
            CoreInstance property = (CoreInstance)propertiesByName.get((Object)key);
            if (property == null) {
                throw new PureExecutionException(sourceInfoForErrors, "The property '" + key + "' can't be found in the type '" + classifier.getName() + "' or in its hierarchy.");
            }
            CoreInstance expression = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)keyValue, (String)"expression", (ProcessorSupport)processorSupport);
            this.setValuesToProperty(expression, keyInstance, property, instance, sourceInfoForErrors, classifierGenericType, evaluationVariableContext, resolvedTypeParameters, resolvedMultiplicityParameters, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport, context, processorSupport);
        }
        for (CoreInstance property : propertiesByName) {
            if (property.getValueForMetaPropertyToOne("defaultValue") == null || instance.getValueForMetaPropertyToMany(property.getName()).size() != 0) continue;
            CoreInstance expression = Property.getDefaultValueExpression((CoreInstance)property.getValueForMetaPropertyToOne("defaultValue"));
            SourceInformation sourceInfoForErrors = expression.getSourceInformation();
            if (Instance.instanceOf((CoreInstance)expression, (String)"meta::pure::metamodel::import::EnumStub", (ProcessorSupport)processorSupport)) {
                ListIterable values = Property.getDefaultValue((CoreInstance)property.getValueForMetaPropertyToOne("defaultValue"));
                for (CoreInstance value : values) {
                    Instance.addValueToProperty((CoreInstance)instance, (String)property.getName(), (CoreInstance)value.getValueForMetaPropertyToOne("resolvedEnum"), (ProcessorSupport)processorSupport);
                }
                continue;
            }
            this.setValuesToProperty(expression, expression, property, instance, sourceInfoForErrors, classifierGenericType, evaluationVariableContext, resolvedTypeParameters, resolvedMultiplicityParameters, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport, context, processorSupport);
        }
        instantiationContext.registerValidation(() -> New.validatePropertyValueMultiplicities(instance, classifier, functionExpressionToUseInStack.getSourceInformation(), processorSupport));
        New.updateReverseProperties(instance, functionExpressionToUseInStack.getSourceInformation(), processorSupport);
        CoreInstance value = ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)instance, (boolean)true, (ProcessorSupport)processorSupport);
        instantiationContext.popAndExecuteProcedures(value);
        if (instantiationContext.isEmpty()) {
            instantiationContext.runValidations();
            instantiationContext.reset();
        }
        return DefaultConstraintHandler.handleConstraints(classifier, value, functionExpressionToUseInStack.getSourceInformation(), this.functionExecution, resolvedTypeParameters, resolvedMultiplicityParameters, variableContext, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport);
    }

    private void setValuesToProperty(CoreInstance expression, CoreInstance keyInstance, CoreInstance property, CoreInstance instance, SourceInformation sourceInfoForErrors, CoreInstance classifierGenericType, VariableContext evaluationVariableContext, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, Context context, ProcessorSupport processorSupport) {
        CoreInstance propertyMultiplicity;
        CoreInstance concretePropertyMultiplicity;
        CoreInstance propertyGenericType = GenericType.resolvePropertyReturnType((CoreInstance)Instance.extractGenericTypeFromInstance((CoreInstance)instance, (ProcessorSupport)processorSupport), (CoreInstance)property, (ProcessorSupport)processorSupport);
        Executor executor = FunctionExecutionInterpreted.findValueSpecificationExecutor(expression, functionExpressionToUseInStack, processorSupport, this.functionExecution);
        CoreInstance evaluatedExpression = executor.execute(expression, resolvedTypeParameters, resolvedMultiplicityParameters, functionExpressionToUseInStack, evaluationVariableContext, profiler, instantiationContext, executionSupport, this.functionExecution, processorSupport);
        ListIterable values = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)evaluatedExpression, (String)"values", (ProcessorSupport)processorSupport);
        if (Measure.isUnitOrMeasureInstance((CoreInstance)evaluatedExpression, (ProcessorSupport)processorSupport)) {
            values = Lists.mutable.with((Object[])new CoreInstance[]{evaluatedExpression});
        }
        if (values.notEmpty() && !ValueSpecification.isExecutable((CoreInstance)evaluatedExpression, (ProcessorSupport)processorSupport) && Instance.instancesOf((Iterable)values, (String)"meta::pure::metamodel::valuespecification::ValueSpecification", (ProcessorSupport)processorSupport)) {
            ImmutableList immutableList = values = ValueSpecification.instanceOf((CoreInstance)evaluatedExpression, (String)"meta::pure::metamodel::type::Nil", (ProcessorSupport)processorSupport) ? Lists.immutable.empty() : Lists.immutable.with((Object)evaluatedExpression);
        }
        if ((concretePropertyMultiplicity = this.resolveToConcreteMultiplicity(propertyMultiplicity = Property.resolveInstancePropertyReturnMultiplicity((CoreInstance)instance, (CoreInstance)property, (ProcessorSupport)processorSupport), resolvedMultiplicityParameters)) == null) {
            throw new PureExecutionException(keyInstance.getSourceInformation(), "Error instantiating the type '" + GenericType.print((CoreInstance)classifierGenericType, (ProcessorSupport)processorSupport) + "'. Could not resolve multiplicity for the property '" + Property.getPropertyName((CoreInstance)property) + "': " + Multiplicity.print((CoreInstance)propertyMultiplicity));
        }
        New.validateRangeUsingMultiplicity(instance, property, concretePropertyMultiplicity, values.size(), sourceInfoForErrors, processorSupport);
        CoreInstance concretePropertyGenericType = this.resolveToConcreteGenericType(propertyGenericType, resolvedTypeParameters, resolvedMultiplicityParameters, processorSupport);
        if (concretePropertyGenericType == null) {
            throw new PureExecutionException(keyInstance.getSourceInformation(), "Error instantiating the type '" + GenericType.print((CoreInstance)classifierGenericType, (ProcessorSupport)processorSupport) + "'. Could not resolve type for the property '" + Property.getPropertyName((CoreInstance)property) + "': " + GenericType.print((CoreInstance)propertyGenericType, (ProcessorSupport)processorSupport));
        }
        for (CoreInstance value : values) {
            New.validateType(concretePropertyGenericType, value, expression, processorSupport);
            Instance.addValueToProperty((CoreInstance)instance, (String)property.getName(), (CoreInstance)value, (ProcessorSupport)processorSupport);
        }
    }

    private CoreInstance resolveToConcreteGenericType(CoreInstance genericType, Stack<MutableMap<String, CoreInstance>> resolvedTypeParametersStack, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParametersStack, ProcessorSupport processorSupport) {
        if (GenericType.isGenericTypeFullyConcrete((CoreInstance)genericType, (ProcessorSupport)processorSupport)) {
            return genericType;
        }
        CoreInstance resolved = genericType;
        for (int i = resolvedTypeParametersStack.size() - 2; i >= 0; --i) {
            MapIterable resolvedTypeParameters = (MapIterable)resolvedTypeParametersStack.elementAt(i);
            MapIterable resolvedMultiplicityParameters = (MapIterable)resolvedMultiplicityParametersStack.elementAt(i);
            if (!resolvedTypeParameters.notEmpty() && !resolvedMultiplicityParameters.notEmpty() || !GenericType.isGenericTypeFullyConcrete((CoreInstance)(resolved = GenericType.makeTypeArgumentAsConcreteAsPossible((CoreInstance)resolved, (MapIterable)resolvedTypeParameters, (MapIterable)resolvedMultiplicityParameters, (ProcessorSupport)processorSupport)), (ProcessorSupport)processorSupport)) continue;
            return resolved;
        }
        return null;
    }

    private CoreInstance resolveToConcreteMultiplicity(CoreInstance multiplicity, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParametersStack) {
        if (Multiplicity.isMultiplicityConcrete((CoreInstance)multiplicity)) {
            return multiplicity;
        }
        String parameter = Multiplicity.getMultiplicityParameter((CoreInstance)multiplicity);
        for (int i = resolvedMultiplicityParametersStack.size() - 2; i >= 0; --i) {
            CoreInstance resolved;
            MapIterable resolvedMultiplicityParameters = (MapIterable)resolvedMultiplicityParametersStack.elementAt(i);
            if (!resolvedMultiplicityParameters.notEmpty() || (resolved = (CoreInstance)resolvedMultiplicityParameters.get((Object)parameter)) == null) continue;
            if (Multiplicity.isMultiplicityConcrete((CoreInstance)resolved)) {
                return resolved;
            }
            parameter = Multiplicity.getMultiplicityParameter((CoreInstance)resolved);
        }
        return null;
    }

    public static void updateReverseProperties(CoreInstance instance, SourceInformation sourceInfoForErrors, ProcessorSupport processorSupport) throws PureExecutionException {
        New.updateReverseProperties(instance, sourceInfoForErrors, processorSupport, false);
    }

    public static void updateReverseProperties(CoreInstance instance, SourceInformation sourceInfoForErrors, ProcessorSupport processorSupport, boolean skipMultiplicityChecks) throws PureExecutionException {
        CoreInstance associationClass = processorSupport.package_getByUserPath("meta::pure::metamodel::relationship::Association");
        for (String propertyName : instance.getKeys()) {
            ListIterable associationProperties;
            CoreInstance property;
            CoreInstance propertyOwner;
            ListIterable values = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)instance, (String)propertyName, (ProcessorSupport)processorSupport);
            if (!values.notEmpty() || !Instance.instanceOf((CoreInstance)(propertyOwner = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)(property = processorSupport.class_findPropertyUsingGeneralization(processorSupport.getClassifier(instance), propertyName)), (String)"owner", (ProcessorSupport)processorSupport)), (CoreInstance)associationClass, (ProcessorSupport)processorSupport)) continue;
            CoreInstance reverseProperty = (CoreInstance)associationProperties.get(property == (associationProperties = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)propertyOwner, (String)"properties", (ProcessorSupport)processorSupport)).get(0) ? 1 : 0);
            String reversePropertyName = Property.getPropertyName((CoreInstance)reverseProperty);
            for (CoreInstance value : values) {
                ListIterable currentValues = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)value, (String)reversePropertyName, (ProcessorSupport)processorSupport);
                if (currentValues.contains((Object)instance)) continue;
                int newSize = currentValues.size() + 1;
                CoreInstance reversePropertyGenericType = GenericType.resolvePropertyReturnType((CoreInstance)Instance.extractGenericTypeFromInstance((CoreInstance)value, (ProcessorSupport)processorSupport), (CoreInstance)reverseProperty, (ProcessorSupport)processorSupport);
                New.validateType(reversePropertyGenericType, instance, value, processorSupport);
                if (!skipMultiplicityChecks) {
                    New.validateRangeUsingMultiplicity(value, reverseProperty, Property.resolveInstancePropertyReturnMultiplicity((CoreInstance)instance, (CoreInstance)reverseProperty, (ProcessorSupport)processorSupport), newSize, sourceInfoForErrors, processorSupport);
                }
                Instance.addValueToProperty((CoreInstance)value, (String)reversePropertyName, (CoreInstance)instance, (ProcessorSupport)processorSupport);
            }
        }
    }

    private static void validateType(CoreInstance propertyGenericType, CoreInstance value, CoreInstance expression, ProcessorSupport processorSupport) throws PureExecutionException {
        boolean isUnitOrMeasure = Measure.isUnitOrMeasureInstance((CoreInstance)value, (ProcessorSupport)processorSupport);
        CoreInstance valGenericType = Instance.instanceOf((CoreInstance)value, (String)"meta::pure::metamodel::valuespecification::NonExecutableValueSpecification", (ProcessorSupport)processorSupport) ? Instance.getValueForMetaPropertyToOneResolved((CoreInstance)value, (String)"genericType", (ProcessorSupport)processorSupport) : (isUnitOrMeasure ? Instance.getValueForMetaPropertyToOneResolved((CoreInstance)value, (String)"genericType", (ProcessorSupport)processorSupport) : Instance.extractGenericTypeFromInstance((CoreInstance)value, (ProcessorSupport)processorSupport));
        New.validateTypeFromGenericType(propertyGenericType, valGenericType, expression, processorSupport);
    }

    static void validateTypeFromGenericType(CoreInstance propertyGenericType, CoreInstance valGenericType, CoreInstance expression, ProcessorSupport processorSupport) throws PureExecutionException {
        boolean compatible;
        try {
            compatible = GenericType.isGenericCompatibleWith((CoreInstance)valGenericType, (CoreInstance)propertyGenericType, (ProcessorSupport)processorSupport);
        }
        catch (Exception e) {
            String valTypeString = GenericType.print((CoreInstance)valGenericType, (boolean)false, (ProcessorSupport)processorSupport);
            String propertyTypeString = GenericType.print((CoreInstance)propertyGenericType, (boolean)false, (ProcessorSupport)processorSupport);
            if (valTypeString.equals(propertyTypeString)) {
                valTypeString = GenericType.print((CoreInstance)valGenericType, (boolean)true, (ProcessorSupport)processorSupport);
                propertyTypeString = GenericType.print((CoreInstance)propertyGenericType, (boolean)true, (ProcessorSupport)processorSupport);
            }
            throw new PureExecutionException(expression.getSourceInformation(), "Error checking if value type '" + valTypeString + "' is compatible with property type '" + propertyTypeString + "'", (Throwable)e);
        }
        if (!compatible) {
            String propertyTypeString;
            String valTypeString = GenericType.print((CoreInstance)valGenericType, (boolean)false, (ProcessorSupport)processorSupport);
            if (valTypeString.equals(propertyTypeString = GenericType.print((CoreInstance)propertyGenericType, (boolean)false, (ProcessorSupport)processorSupport))) {
                valTypeString = GenericType.print((CoreInstance)valGenericType, (boolean)true, (ProcessorSupport)processorSupport);
                propertyTypeString = GenericType.print((CoreInstance)propertyGenericType, (boolean)true, (ProcessorSupport)processorSupport);
            }
            throw new PureExecutionException(expression.getSourceInformation(), "Type Error: '" + valTypeString + "' not a subtype of '" + propertyTypeString + "'" + (expression.getSourceInformation() == null ? expression.print("") : ""));
        }
    }

    static void validateRangeUsingMultiplicity(CoreInstance instance, CoreInstance keyValue, CoreInstance property, ListIterable<? extends CoreInstance> values, ProcessorSupport processorSupport) throws PureExecutionException {
        New.validateRangeUsingMultiplicity(instance, property, Property.resolveInstancePropertyReturnMultiplicity((CoreInstance)instance, (CoreInstance)property, (ProcessorSupport)processorSupport), values.size(), Instance.getValueForMetaPropertyToOneResolved((CoreInstance)keyValue, (String)"key", (ProcessorSupport)processorSupport).getSourceInformation(), processorSupport);
    }

    private static void validateRangeUsingMultiplicity(CoreInstance instance, CoreInstance property, CoreInstance propertyMultiplicity, int valueCount, SourceInformation sourceInfoForExceptions, ProcessorSupport processorSupport) throws PureExecutionException {
        if (!Multiplicity.isValid((CoreInstance)propertyMultiplicity, (int)valueCount)) {
            throw new PureExecutionException(sourceInfoForExceptions, "Error instantiating the type '" + GenericType.print((CoreInstance)Instance.extractGenericTypeFromInstance((CoreInstance)instance, (ProcessorSupport)processorSupport), (ProcessorSupport)processorSupport) + "'. The property '" + Property.getPropertyName((CoreInstance)property) + "' has a multiplicity range of " + Multiplicity.print((CoreInstance)propertyMultiplicity) + " when the given list has a cardinality equal to " + valueCount);
        }
    }

    public static void validatePropertyValueMultiplicities(CoreInstance instance, CoreInstance classifier, SourceInformation sourceInfo, ProcessorSupport processorSupport) throws PureExecutionException {
        New.validatePropertyValueMultiplicities(instance, classifier, (RichIterable<CoreInstance>)processorSupport.class_getSimpleProperties(classifier), sourceInfo, processorSupport);
    }

    public static void validatePropertyValueMultiplicities(CoreInstance instance, CoreInstance classifier, RichIterable<CoreInstance> propertiesToValidate, SourceInformation sourceInfo, ProcessorSupport processorSupport) throws PureExecutionException {
        MutableMap mismatches = Maps.mutable.with();
        for (Object property : propertiesToValidate) {
            ListIterable values;
            CoreInstance multiplicity = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)property, (String)"multiplicity", (ProcessorSupport)processorSupport);
            if (!Multiplicity.isMultiplicityConcrete((CoreInstance)multiplicity) || Multiplicity.isValid((CoreInstance)multiplicity, (int)(values = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)instance, (CoreInstance)property, (ProcessorSupport)processorSupport)).size())) continue;
            mismatches.put((Object)Property.getPropertyName((CoreInstance)property), (Object)Tuples.pair((Object)Multiplicity.print((CoreInstance)multiplicity, (boolean)false), (Object)values.size()));
        }
        if (mismatches.notEmpty()) {
            StringBuilder message = new StringBuilder().append("Error instantiating class '").append(classifier.getName()).append("'.  The following properties have multiplicity violations:");
            if (mismatches.size() == 1) {
                Object property;
                property = (String)mismatches.keysView().getAny();
                Pair mismatch = (Pair)mismatches.get(property);
                String multiplicity = (String)mismatch.getOne();
                Integer count = (Integer)mismatch.getTwo();
                message.append(" '").append((String)property).append("' requires ").append(multiplicity).append(" value");
                if (!"1".equals(multiplicity)) {
                    message.append('s');
                }
                message.append(", got ").append(count);
            } else {
                for (String property : mismatches.keysView().toSortedList()) {
                    Pair mismatch = (Pair)mismatches.get((Object)property);
                    String multiplicity = (String)mismatch.getOne();
                    Integer count = (Integer)mismatch.getTwo();
                    message.append("\n\t'").append(property).append("' requires ").append(multiplicity).append(" value");
                    if (!"1".equals(multiplicity)) {
                        message.append('s');
                    }
                    message.append(", got ").append(count);
                }
            }
            throw new PureExecutionException(sourceInfo, message.toString());
        }
    }
}

