/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives.grammar.lang;

import java.util.Stack;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Lists;
import org.finos.legend.pure.m3.compiler.Context;
import org.finos.legend.pure.m3.exception.PureExecutionException;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.PackageableElement.PackageableElement;
import org.finos.legend.pure.m3.navigation.PrimitiveUtilities;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.ValueSpecificationBootstrap;
import org.finos.legend.pure.m4.ModelRepository;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.m4.coreinstance.primitive.BooleanCoreInstance;
import org.finos.legend.pure.m4.coreinstance.primitive.DateCoreInstance;
import org.finos.legend.pure.m4.coreinstance.primitive.DecimalCoreInstance;
import org.finos.legend.pure.m4.coreinstance.primitive.FloatCoreInstance;
import org.finos.legend.pure.m4.coreinstance.primitive.IntegerCoreInstance;
import org.finos.legend.pure.m4.coreinstance.primitive.StringCoreInstance;
import org.finos.legend.pure.m4.coreinstance.primitive.date.PureDate;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.NativeFunction;
import org.finos.legend.pure.runtime.java.interpreted.natives.NumericUtilities;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

public class Compare
extends NativeFunction {
    private static final ImmutableList<String> PRIMITIVE_TYPE_COMPARISON_ORDER = Lists.immutable.with((Object)"Integer", (Object)"Float", (Object)"Number", (Object)"DateTime", (Object)"StrictDate", (Object)"Date", (Object)"Boolean", (Object)"String");
    private final ModelRepository repository;

    public Compare(ModelRepository repository) {
        this.repository = repository;
    }

    @Override
    public CoreInstance execute(ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, Context context, ProcessorSupport processorSupport) throws PureExecutionException {
        CoreInstance param1 = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"values", (ProcessorSupport)processorSupport);
        CoreInstance param2 = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(1)), (String)"values", (ProcessorSupport)processorSupport);
        return ValueSpecificationBootstrap.newIntegerLiteral((ModelRepository)this.repository, (int)Compare.compare(param1, param2, processorSupport), (ProcessorSupport)processorSupport);
    }

    public static int compare(CoreInstance instance1, CoreInstance instance2, ProcessorSupport processorSupport) {
        CoreInstance type2;
        if (instance1 == instance2) {
            return 0;
        }
        Number num1 = Compare.getNumberValue(instance1, processorSupport);
        Number num2 = Compare.getNumberValue(instance2, processorSupport);
        if (num1 != null) {
            return num2 == null ? -1 : NumericUtilities.compare(num1, num2);
        }
        if (num2 != null) {
            return 1;
        }
        PureDate date1 = Compare.getDateValue(instance1, processorSupport);
        PureDate date2 = Compare.getDateValue(instance2, processorSupport);
        if (date1 != null) {
            return date2 == null ? -1 : date1.compareTo(date2);
        }
        if (date2 != null) {
            return 1;
        }
        Boolean boolean1 = Compare.getBooleanValue(instance1, processorSupport);
        Boolean boolean2 = Compare.getBooleanValue(instance2, processorSupport);
        if (boolean1 != null) {
            return boolean2 == null ? -1 : boolean1.compareTo(boolean2);
        }
        if (boolean2 != null) {
            return 1;
        }
        String string1 = Compare.getStringValue(instance1, processorSupport);
        String string2 = Compare.getStringValue(instance2, processorSupport);
        if (string1 != null) {
            return string2 == null ? -1 : string1.compareTo(string2);
        }
        if (string2 != null) {
            return 1;
        }
        CoreInstance type1 = processorSupport.getClassifier(instance1);
        if (type1 == (type2 = processorSupport.getClassifier(instance2))) {
            return instance1.getName().compareTo(instance2.getName());
        }
        if (Instance.instanceOf((CoreInstance)type1, (String)"meta::pure::metamodel::type::PrimitiveType", (ProcessorSupport)processorSupport)) {
            if (!Instance.instanceOf((CoreInstance)type2, (String)"meta::pure::metamodel::type::PrimitiveType", (ProcessorSupport)processorSupport)) {
                return -1;
            }
            int index1 = PRIMITIVE_TYPE_COMPARISON_ORDER.indexOf((Object)type1.getName());
            int index2 = PRIMITIVE_TYPE_COMPARISON_ORDER.indexOf((Object)type2.getName());
            return Integer.compare(index1, index2);
        }
        if (Instance.instanceOf((CoreInstance)type2, (String)"meta::pure::metamodel::type::PrimitiveType", (ProcessorSupport)processorSupport)) {
            return 1;
        }
        String path1 = PackageableElement.getUserPathForPackageableElement((CoreInstance)type1);
        String path2 = PackageableElement.getUserPathForPackageableElement((CoreInstance)type2);
        return path1.compareTo(path2);
    }

    private static Number getNumberValue(CoreInstance instance, ProcessorSupport processorSupport) {
        if (instance instanceof IntegerCoreInstance) {
            return (Number)((IntegerCoreInstance)instance).getValue();
        }
        if (instance instanceof FloatCoreInstance) {
            return (Number)((FloatCoreInstance)instance).getValue();
        }
        if (instance instanceof DecimalCoreInstance) {
            return (Number)((DecimalCoreInstance)instance).getValue();
        }
        if (Instance.instanceOf((CoreInstance)instance, (String)"Integer", (ProcessorSupport)processorSupport)) {
            return PrimitiveUtilities.getIntegerValue((CoreInstance)instance);
        }
        if (Instance.instanceOf((CoreInstance)instance, (String)"Float", (ProcessorSupport)processorSupport)) {
            return PrimitiveUtilities.getFloatValue((CoreInstance)instance);
        }
        if (Instance.instanceOf((CoreInstance)instance, (String)"Decimal", (ProcessorSupport)processorSupport)) {
            return PrimitiveUtilities.getDecimalValue((CoreInstance)instance);
        }
        return null;
    }

    private static PureDate getDateValue(CoreInstance instance, ProcessorSupport processorSupport) {
        if (instance instanceof DateCoreInstance) {
            return (PureDate)((DateCoreInstance)instance).getValue();
        }
        if (Instance.instanceOf((CoreInstance)instance, (String)"Date", (ProcessorSupport)processorSupport)) {
            return PrimitiveUtilities.getDateValue((CoreInstance)instance);
        }
        return null;
    }

    private static Boolean getBooleanValue(CoreInstance instance, ProcessorSupport processorSupport) {
        return instance instanceof BooleanCoreInstance || Instance.instanceOf((CoreInstance)instance, (String)"Boolean", (ProcessorSupport)processorSupport) ? Boolean.valueOf(PrimitiveUtilities.getBooleanValue((CoreInstance)instance)) : null;
    }

    private static String getStringValue(CoreInstance instance, ProcessorSupport processorSupport) {
        return instance instanceof StringCoreInstance || Instance.instanceOf((CoreInstance)instance, (String)"String", (ProcessorSupport)processorSupport) ? PrimitiveUtilities.getStringValue((CoreInstance)instance) : null;
    }
}

