/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives.grammar.collection;

import java.util.Stack;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Lists;
import org.finos.legend.pure.m3.compiler.Context;
import org.finos.legend.pure.m3.exception.PureExecutionException;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.PrimitiveUtilities;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.ValueSpecificationBootstrap;
import org.finos.legend.pure.m4.ModelRepository;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.NativeFunction;
import org.finos.legend.pure.runtime.java.interpreted.natives.NumericUtilities;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.math.NumericAccumulator;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

public class Range
extends NativeFunction {
    private final ModelRepository repository;

    public Range(ModelRepository repository) {
        this.repository = repository;
    }

    @Override
    public CoreInstance execute(ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, Context context, ProcessorSupport processorSupport) throws PureExecutionException {
        Number start = PrimitiveUtilities.getIntegerValue((CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"values", (ProcessorSupport)processorSupport));
        Number stop = PrimitiveUtilities.getIntegerValue((CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(1)), (String)"values", (ProcessorSupport)processorSupport));
        Number step = PrimitiveUtilities.getIntegerValue((CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(2)), (String)"values", (ProcessorSupport)processorSupport));
        MutableList result = Lists.mutable.with();
        NumericAccumulator accumulator = NumericAccumulator.newAccumulator(start);
        int stepSign = NumericUtilities.compare(step, 0);
        if (stepSign > 0) {
            Number value = accumulator.getValue();
            while (NumericUtilities.compare(value, stop) < 0) {
                result.add((Object)NumericUtilities.toPureNumber(value, false, this.repository));
                accumulator.add(step);
                value = accumulator.getValue();
            }
        } else if (stepSign < 0) {
            Number value = accumulator.getValue();
            while (NumericUtilities.compare(value, stop) > 0) {
                result.add((Object)NumericUtilities.toPureNumber(value, false, this.repository));
                accumulator.add(step);
                value = accumulator.getValue();
            }
        } else {
            throw new PureExecutionException(functionExpressionToUseInStack.getSourceInformation(), "range step must not be 0");
        }
        return ValueSpecificationBootstrap.wrapValueSpecification((RichIterable)result, (boolean)true, (ProcessorSupport)processorSupport);
    }
}

