/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives.basics.string;

import java.util.Stack;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Lists;
import org.finos.legend.pure.m3.compiler.Context;
import org.finos.legend.pure.m3.exception.PureExecutionException;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.PrimitiveUtilities;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.ValueSpecificationBootstrap;
import org.finos.legend.pure.m3.tools.FormatTools;
import org.finos.legend.pure.m4.ModelRepository;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.m4.coreinstance.primitive.date.PureDate;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.FunctionExecutionInterpreted;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.NativeFunction;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

public class Format
extends NativeFunction {
    private final ModelRepository repository;
    private final FunctionExecutionInterpreted functionExecution;

    public Format(ModelRepository repository, FunctionExecutionInterpreted functionExecution) {
        this.repository = repository;
        this.functionExecution = functionExecution;
    }

    @Override
    public CoreInstance execute(ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, Context context, ProcessorSupport processorSupport) throws PureExecutionException {
        String formatString = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"values", (ProcessorSupport)processorSupport).getName();
        ListIterable formatArgs = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)((CoreInstance)params.get(1)), (String)"values", (ProcessorSupport)processorSupport);
        return ValueSpecificationBootstrap.newStringLiteral((ModelRepository)this.repository, (String)this.format(formatString, (ListIterable<? extends CoreInstance>)formatArgs, resolvedTypeParameters, resolvedMultiplicityParameters, this.getParentOrEmptyVariableContext(variableContext), functionExpressionToUseInStack, profiler, processorSupport, instantiationContext, executionSupport), (ProcessorSupport)processorSupport);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String format(String formatString, ListIterable<? extends CoreInstance> formatArgs, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, ProcessorSupport processorSupport, InstantiationContext instantiationContext, ExecutionSupport executionSupport) throws PureExecutionException {
        CoreInstance toStringFunction = processorSupport.package_getByUserPath("meta::pure::functions::string::toString_Any_1__String_1_");
        CoreInstance toRepresentationFunction = processorSupport.package_getByUserPath("meta::pure::functions::string::toRepresentation_Any_1__String_1_");
        int argCounter = 0;
        int index = 0;
        int length = formatString.length();
        StringBuilder builder = new StringBuilder(length * 2);
        try {
            block12: while (index < length) {
                char character;
                if ((character = formatString.charAt(index++)) == '%') {
                    switch (formatString.charAt(index++)) {
                        case '%': {
                            builder.append('%');
                            continue block12;
                        }
                        case 's': {
                            CoreInstance arg = (CoreInstance)formatArgs.get(argCounter++);
                            ImmutableList params = Lists.immutable.with((Object)ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)arg, (boolean)true, (ProcessorSupport)processorSupport));
                            CoreInstance argString = this.functionExecution.executeLambdaFromNative(toStringFunction, (ListIterable<? extends CoreInstance>)params, resolvedTypeParameters, resolvedMultiplicityParameters, variableContext, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport);
                            builder.append(Instance.getValueForMetaPropertyToOneResolved((CoreInstance)argString, (String)"values", (ProcessorSupport)processorSupport).getName());
                            continue block12;
                        }
                        case 'r': {
                            CoreInstance arg = (CoreInstance)formatArgs.get(argCounter++);
                            ImmutableList params = Lists.immutable.with((Object)ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)arg, (boolean)true, (ProcessorSupport)processorSupport));
                            CoreInstance argString = this.functionExecution.executeLambdaFromNative(toRepresentationFunction, (ListIterable<? extends CoreInstance>)params, resolvedTypeParameters, resolvedMultiplicityParameters, variableContext, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport);
                            builder.append(Instance.getValueForMetaPropertyToOneResolved((CoreInstance)argString, (String)"values", (ProcessorSupport)processorSupport).getName());
                            continue block12;
                        }
                        case 'd': {
                            CoreInstance arg = (CoreInstance)formatArgs.get(argCounter++);
                            if (!Instance.instanceOf((CoreInstance)arg, (String)"Integer", (ProcessorSupport)processorSupport)) {
                                throw new IllegalArgumentException("Expected Integer, got: " + arg);
                            }
                            FormatTools.appendIntegerString((StringBuilder)builder, (String)arg.getName(), (int)0);
                            continue block12;
                        }
                        case 't': {
                            CoreInstance arg = (CoreInstance)formatArgs.get(argCounter++);
                            if (!Instance.instanceOf((CoreInstance)arg, (String)"Date", (ProcessorSupport)processorSupport)) {
                                throw new IllegalArgumentException("Expected Date, got: " + arg);
                            }
                            PureDate date = PrimitiveUtilities.getDateValue((CoreInstance)arg);
                            int dateFormatEnd = FormatTools.findEndOfDateFormatString((String)formatString, (int)index);
                            if (dateFormatEnd == -1) {
                                builder.append(date);
                                continue block12;
                            }
                            date.format((Appendable)builder, formatString.substring(index + 1, dateFormatEnd));
                            index = dateFormatEnd + 1;
                            continue block12;
                        }
                        case '0': {
                            CoreInstance arg;
                            int j = index;
                            while (Character.isDigit(formatString.charAt(j))) {
                                ++j;
                            }
                            if (formatString.charAt(j) != 'd') {
                                throw new IllegalArgumentException("Invalid format specifier: %" + formatString.substring(index, j + 1));
                            }
                            int zeroPad = Integer.valueOf(formatString.substring(index, j));
                            if (!Instance.instanceOf((CoreInstance)(arg = (CoreInstance)formatArgs.get(argCounter++)), (String)"Integer", (ProcessorSupport)processorSupport)) {
                                throw new IllegalArgumentException("Expected Integer, got: " + arg);
                            }
                            FormatTools.appendIntegerString((StringBuilder)builder, (String)arg.getName(), (int)zeroPad);
                            index = j + 1;
                            continue block12;
                        }
                        case 'f': {
                            CoreInstance arg = (CoreInstance)formatArgs.get(argCounter++);
                            if (!Instance.instanceOf((CoreInstance)arg, (String)"Float", (ProcessorSupport)processorSupport)) {
                                throw new IllegalArgumentException("Expected Float, got: " + arg);
                            }
                            FormatTools.appendFloatString((StringBuilder)builder, (String)arg.getName());
                            continue block12;
                        }
                        case '.': {
                            CoreInstance arg;
                            int j = index;
                            while (Character.isDigit(formatString.charAt(j))) {
                                ++j;
                            }
                            if (formatString.charAt(j) != 'f') {
                                throw new IllegalArgumentException("Invalid format specifier: %" + formatString.substring(index, j + 1));
                            }
                            int precision = Integer.valueOf(formatString.substring(index, j));
                            if (!Instance.instanceOf((CoreInstance)(arg = (CoreInstance)formatArgs.get(argCounter++)), (String)"Float", (ProcessorSupport)processorSupport)) {
                                throw new IllegalArgumentException("Expected Float, got: " + arg);
                            }
                            FormatTools.appendFloatString((StringBuilder)builder, (String)arg.getName(), (int)precision);
                            index = j + 1;
                            continue block12;
                        }
                    }
                    throw new IllegalArgumentException("Invalid format specifier: %" + formatString.charAt(index - 1));
                }
                builder.append(character);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new PureExecutionException(functionExpressionToUseInStack.getSourceInformation(), "Too few arguments passed to format function. Format expression \"" + formatString + "\", number of arguments [" + formatArgs.size() + "]");
        }
        if (argCounter < formatArgs.size()) {
            throw new PureExecutionException(functionExpressionToUseInStack.getSourceInformation(), "Unused format args. [" + formatArgs.size() + "] arguments provided to expression \"" + formatString + "\"");
        }
        return builder.toString();
    }
}

