/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives.basics.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Stack;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.finos.legend.pure.m3.compiler.Context;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m4.ModelRepository;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.NativeFunction;
import org.finos.legend.pure.runtime.java.interpreted.natives.NumericUtilities;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

public class Abs
extends NativeFunction {
    private final ModelRepository repository;

    public Abs(ModelRepository repository) {
        this.repository = repository;
    }

    @Override
    public CoreInstance execute(ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, Context context, ProcessorSupport processorSupport) {
        CoreInstance number = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"values", (ProcessorSupport)processorSupport);
        boolean bigDecimalToPureDecimal = NumericUtilities.IS_DECIMAL_CORE_INSTANCE(processorSupport).accept((Object)number);
        Number javaNumber = NumericUtilities.toJavaNumber(number, processorSupport);
        if (javaNumber instanceof Integer) {
            return NumericUtilities.toPureNumberValueExpression(Math.abs((Integer)javaNumber), bigDecimalToPureDecimal, this.repository, processorSupport);
        }
        if (javaNumber instanceof Long) {
            return NumericUtilities.toPureNumberValueExpression(Math.abs((Long)javaNumber), bigDecimalToPureDecimal, this.repository, processorSupport);
        }
        if (javaNumber instanceof Double) {
            return NumericUtilities.toPureNumberValueExpression(Math.abs((Double)javaNumber), bigDecimalToPureDecimal, this.repository, processorSupport);
        }
        if (javaNumber instanceof Float) {
            return NumericUtilities.toPureNumberValueExpression(Float.valueOf(Math.abs(((Float)javaNumber).floatValue())), bigDecimalToPureDecimal, this.repository, processorSupport);
        }
        if (javaNumber instanceof BigInteger) {
            return NumericUtilities.toPureNumberValueExpression(((BigInteger)javaNumber).abs(), bigDecimalToPureDecimal, this.repository, processorSupport);
        }
        if (javaNumber instanceof BigDecimal) {
            return NumericUtilities.toPureNumberValueExpression(((BigDecimal)javaNumber).abs(), bigDecimalToPureDecimal, this.repository, processorSupport);
        }
        throw new IllegalArgumentException("Unhandled number: " + javaNumber);
    }
}

