/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives.basics.lang;

import java.util.Stack;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.finos.legend.pure.m3.compiler.Context;
import org.finos.legend.pure.m3.compiler.postprocessing.inference.TypeInference;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.FunctionCoreInstanceWrapper;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.LambdaFunctionCoreInstanceWrapper;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.type.FunctionType;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.valuespecification.ValueSpecification;
import org.finos.legend.pure.m3.exception.PureExecutionException;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.generictype.GenericType;
import org.finos.legend.pure.m3.navigation.generictype.match.GenericTypeMatch;
import org.finos.legend.pure.m3.navigation.generictype.match.ParameterMatchBehavior;
import org.finos.legend.pure.m3.navigation.multiplicity.Multiplicity;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.m4.coreinstance.SourceInformation;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.FunctionExecutionInterpreted;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.NativeFunction;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

public class Evaluate
extends NativeFunction {
    private final FunctionExecutionInterpreted functionExecution;

    public Evaluate(FunctionExecutionInterpreted functionExecution) {
        this.functionExecution = functionExecution;
    }

    @Override
    public CoreInstance execute(ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, Context context, ProcessorSupport processorSupport) throws PureExecutionException {
        if (Instance.instanceOf((CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"values", (ProcessorSupport)processorSupport), (String)"meta::pure::metamodel::type::Nil", (ProcessorSupport)processorSupport)) {
            throw new PureExecutionException(functionExpressionToUseInStack.getSourceInformation(), "Evaluate can't take an instance of Nil as a function");
        }
        CoreInstance functionToApplyTo = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"values", (ProcessorSupport)processorSupport);
        FunctionType fType = (FunctionType)processorSupport.function_getFunctionType(functionToApplyTo);
        MutableList parametersSignature = fType._parameters().toList();
        MutableList funcParams = Lists.mutable.ofInitialCapacity(params.size());
        SourceInformation sourceInformation = functionExpressionToUseInStack.getSourceInformation();
        int size = params.size();
        for (int i = 1; i < size; ++i) {
            Evaluate.validateValueToSignature((CoreInstance)params.get(i), (CoreInstance)parametersSignature.get(i - 1), sourceInformation, processorSupport);
            funcParams.add((Object)((ValueSpecification)params.get(i)));
        }
        TypeInference.mapSpecToInstance((ListIterable)parametersSignature, (ListIterable)funcParams, resolvedTypeParameters, resolvedMultiplicityParameters, (ProcessorSupport)processorSupport);
        CoreInstance result = Instance.instanceOf((CoreInstance)functionToApplyTo, (String)"meta::pure::metamodel::function::LambdaFunction", (ProcessorSupport)processorSupport) ? this.functionExecution.executeLambda(LambdaFunctionCoreInstanceWrapper.toLambdaFunction((CoreInstance)functionToApplyTo), (ListIterable<? extends CoreInstance>)funcParams, resolvedTypeParameters, resolvedMultiplicityParameters, this.getParentOrEmptyVariableContext(variableContext), functionExpressionToUseInStack, profiler, instantiationContext, executionSupport) : this.functionExecution.executeFunctionExecuteParams(FunctionCoreInstanceWrapper.toFunction((CoreInstance)functionToApplyTo), (ListIterable<? extends CoreInstance>)funcParams, resolvedTypeParameters, resolvedMultiplicityParameters, this.getParentOrEmptyVariableContext(variableContext), functionExpressionToUseInStack, profiler, instantiationContext, executionSupport);
        resolvedTypeParameters.pop();
        resolvedMultiplicityParameters.pop();
        return result;
    }

    public static void validateValueToSignature(CoreInstance value, CoreInstance signature, SourceInformation sourceInfo, ProcessorSupport processorSupport) throws PureExecutionException {
        CoreInstance signatureMultiplicity = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)signature, (String)"multiplicity", (ProcessorSupport)processorSupport);
        CoreInstance valueMultiplicity = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)value, (String)"multiplicity", (ProcessorSupport)processorSupport);
        try {
            if (Multiplicity.isMultiplicityConcrete((CoreInstance)signatureMultiplicity) && !Multiplicity.subsumes((CoreInstance)signatureMultiplicity, (CoreInstance)valueMultiplicity)) {
                throw new PureExecutionException(sourceInfo, "Error during dynamic function evaluation. The multiplicity " + Multiplicity.print((CoreInstance)valueMultiplicity) + " is not compatible with the multiplicity " + Multiplicity.print((CoreInstance)signatureMultiplicity) + " for parameter:" + signature.getValueForMetaPropertyToOne("name").getName());
            }
        }
        catch (RuntimeException e) {
            throw new PureExecutionException(sourceInfo, "Error evaluating multiplicities: " + Multiplicity.print((CoreInstance)valueMultiplicity) + ", " + Multiplicity.print((CoreInstance)signatureMultiplicity), (Throwable)e);
        }
        CoreInstance signatureGenericType = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)signature, (String)"genericType", (ProcessorSupport)processorSupport);
        CoreInstance valueGenericType = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)value, (String)"genericType", (ProcessorSupport)processorSupport);
        try {
            if (!GenericTypeMatch.genericTypeMatches((CoreInstance)signatureGenericType, (CoreInstance)valueGenericType, (boolean)true, (ParameterMatchBehavior)ParameterMatchBehavior.MATCH_ANYTHING, (ParameterMatchBehavior)ParameterMatchBehavior.MATCH_CAUTIOUSLY, (ProcessorSupport)processorSupport)) {
                throw new PureExecutionException(sourceInfo, "Error during dynamic function evaluation. The type " + GenericType.print((CoreInstance)valueGenericType, (ProcessorSupport)processorSupport) + " is not compatible with the type " + GenericType.print((CoreInstance)signatureGenericType, (ProcessorSupport)processorSupport));
            }
        }
        catch (RuntimeException e) {
            throw new PureExecutionException(sourceInfo, "Error evaluating generic types: " + GenericType.print((CoreInstance)valueGenericType, (ProcessorSupport)processorSupport) + ", " + GenericType.print((CoreInstance)signatureGenericType, (ProcessorSupport)processorSupport), (Throwable)e);
        }
    }
}

