/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives.basics.lang;

import java.util.Stack;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.utility.Iterate;
import org.finos.legend.pure.m3.compiler.Context;
import org.finos.legend.pure.m3.compiler.validation.validator.PropertyValidator;
import org.finos.legend.pure.m3.exception.PureExecutionException;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.ValueSpecificationBootstrap;
import org.finos.legend.pure.m3.navigation.property.Property;
import org.finos.legend.pure.m4.ModelRepository;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.m4.exception.PureCompilationException;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.FunctionExecutionInterpreted;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.DefaultConstraintHandler;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.NativeFunction;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.lang.New;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

public class DynamicNew
extends NativeFunction {
    private final ModelRepository repository;
    private final boolean isGenericType;
    private final FunctionExecutionInterpreted functionExecution;

    public DynamicNew(ModelRepository repository, boolean isGenericType, FunctionExecutionInterpreted functionExecutionInterpreted) {
        this.repository = repository;
        this.isGenericType = isGenericType;
        this.functionExecution = functionExecutionInterpreted;
    }

    public DynamicNew(FunctionExecutionInterpreted functionExecution, ModelRepository repository) {
        this(repository, false, functionExecution);
    }

    @Override
    public CoreInstance execute(ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, Context context, ProcessorSupport processorSupport) throws PureExecutionException {
        CoreInstance genericType = this.isGenericType ? Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"values", (ProcessorSupport)processorSupport) : Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"genericType", (String)"typeArguments", (ProcessorSupport)processorSupport);
        ListIterable keyValues = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)((CoreInstance)params.get(1)), (String)"values", (ProcessorSupport)processorSupport);
        CoreInstance classifier = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)genericType, (String)"rawType", (ProcessorSupport)processorSupport);
        CoreInstance instance = this.repository.newEphemeralAnonymousCoreInstance(functionExpressionToUseInStack.getSourceInformation(), classifier);
        if (this.isGenericType) {
            Instance.addValueToProperty((CoreInstance)instance, (String)"classifierGenericType", (CoreInstance)genericType, (ProcessorSupport)processorSupport);
        }
        boolean shouldValidate = Iterate.isEmpty((Iterable)Instance.getValueForMetaPropertyToManyResolved((CoreInstance)genericType, (String)"typeArguments", (ProcessorSupport)processorSupport));
        MapIterable propertiesByName = processorSupport.class_getSimplePropertiesByName(classifier);
        for (CoreInstance keyValue : keyValues) {
            String key = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)keyValue, (String)"key", (ProcessorSupport)processorSupport).getName();
            CoreInstance property = processorSupport.class_findPropertyUsingGeneralization(classifier, key);
            if (property == null) {
                throw new PureExecutionException(Instance.getValueForMetaPropertyToOneResolved((CoreInstance)keyValue, (String)"key", (ProcessorSupport)processorSupport).getSourceInformation(), "The property '" + key + "' can't be found in the type '" + classifier.getName() + "' or in its hierarchy.");
            }
            ListIterable values = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)keyValue, (String)"value", (ProcessorSupport)processorSupport);
            Instance.setValuesForProperty((CoreInstance)instance, (String)key, (ListIterable)values, (ProcessorSupport)processorSupport);
            if (!shouldValidate) continue;
            try {
                PropertyValidator.validateMultiplicityRange((CoreInstance)instance, (CoreInstance)property, (ListIterable)values, (ProcessorSupport)processorSupport);
                for (CoreInstance val : values) {
                    PropertyValidator.validateTypeRange((CoreInstance)instance, (CoreInstance)property, (CoreInstance)val, (ProcessorSupport)processorSupport);
                }
            }
            catch (PureCompilationException ex) {
                throw new PureExecutionException("Unable to create a new instance of class '" + classifier.getName() + "'. Invalid value '" + values.collect((Function)new Function<CoreInstance, String>(){

                    public String valueOf(CoreInstance object) {
                        return object.printWithoutDebug("", 1);
                    }
                }).makeString(",") + "' provided for class property '" + key + "': " + ex.getInfo());
            }
        }
        for (CoreInstance property : propertiesByName) {
            if (property.getValueForMetaPropertyToOne("defaultValue") == null || instance.getValueForMetaPropertyToMany(property.getName()).size() != 0) continue;
            CoreInstance expression = Property.getDefaultValueExpression((CoreInstance)property.getValueForMetaPropertyToOne("defaultValue"));
            ListIterable values = Property.getDefaultValue((CoreInstance)property.getValueForMetaPropertyToOne("defaultValue"));
            for (CoreInstance value : values) {
                if (Instance.instanceOf((CoreInstance)expression, (String)"meta::pure::metamodel::import::EnumStub", (ProcessorSupport)processorSupport)) {
                    Instance.addValueToProperty((CoreInstance)instance, (String)property.getName(), (CoreInstance)value.getValueForMetaPropertyToOne("resolvedEnum"), (ProcessorSupport)processorSupport);
                    continue;
                }
                Instance.addValueToProperty((CoreInstance)instance, (String)property.getName(), (CoreInstance)value, (ProcessorSupport)processorSupport);
            }
        }
        New.updateReverseProperties(instance, functionExpressionToUseInStack.getSourceInformation(), processorSupport);
        CoreInstance override = null;
        if (params.size() > 5) {
            override = processorSupport.newAnonymousCoreInstance(functionExpressionToUseInStack.getSourceInformation(), "meta::pure::metamodel::type::ConstraintsGetterOverride");
            Instance.addValueToProperty((CoreInstance)override, (String)"constraintsManager", (CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(5)), (String)"values", (ProcessorSupport)processorSupport), (ProcessorSupport)processorSupport);
        } else if (params.size() > 2) {
            override = processorSupport.newAnonymousCoreInstance(functionExpressionToUseInStack.getSourceInformation(), "meta::pure::metamodel::type::GetterOverride");
        }
        if (override != null) {
            Instance.addValueToProperty((CoreInstance)override, (String)"getterOverrideToOne", (CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(2)), (String)"values", (ProcessorSupport)processorSupport), (ProcessorSupport)processorSupport);
            Instance.addValueToProperty((CoreInstance)override, (String)"getterOverrideToMany", (CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(3)), (String)"values", (ProcessorSupport)processorSupport), (ProcessorSupport)processorSupport);
            Instance.addValueToProperty((CoreInstance)override, (String)"hiddenPayload", (CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(4)), (String)"values", (ProcessorSupport)processorSupport), (ProcessorSupport)processorSupport);
            Instance.addValueToProperty((CoreInstance)instance, (String)"elementOverride", (CoreInstance)override, (ProcessorSupport)processorSupport);
        }
        CoreInstance value = ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)instance, (boolean)true, (ProcessorSupport)processorSupport);
        return DefaultConstraintHandler.handleConstraints(classifier, value, functionExpressionToUseInStack.getSourceInformation(), this.functionExecution, resolvedTypeParameters, resolvedMultiplicityParameters, variableContext, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport);
    }
}

