/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives.basics.lang;

import java.util.Stack;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.finos.legend.pure.m3.compiler.Context;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.type.Measure;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.type.Unit;
import org.finos.legend.pure.m3.exception.PureExecutionException;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.generictype.GenericType;
import org.finos.legend.pure.m3.navigation.generictype.match.GenericTypeMatch;
import org.finos.legend.pure.m3.navigation.generictype.match.ParameterMatchBehavior;
import org.finos.legend.pure.m4.ModelRepository;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.NativeFunction;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

public class Cast
extends NativeFunction {
    private ModelRepository repository;

    public Cast(ModelRepository repository) {
        this.repository = repository;
    }

    @Override
    public CoreInstance execute(ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, Context context, ProcessorSupport processorSupport) throws PureExecutionException {
        CoreInstance valuesParam = (CoreInstance)params.get(0);
        CoreInstance sourceGenericType = valuesParam.getValueForMetaPropertyToOne("genericType");
        CoreInstance targetGenericType = ((CoreInstance)params.get(1)).getValueForMetaPropertyToOne("genericType");
        targetGenericType = this.makeGenericTypeAsConcreteAsPossible(targetGenericType, resolvedTypeParameters, resolvedMultiplicityParameters, processorSupport);
        CoreInstance inst = this.repository.newAnonymousCoreInstance(functionExpressionToUseInStack.getSourceInformation(), processorSupport.getClassifier(valuesParam));
        Instance.addValueToProperty((CoreInstance)inst, (String)"genericType", (CoreInstance)targetGenericType, (ProcessorSupport)processorSupport);
        Instance.addValueToProperty((CoreInstance)inst, (String)"multiplicity", (CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)valuesParam, (String)"multiplicity", (ProcessorSupport)processorSupport), (ProcessorSupport)processorSupport);
        if (GenericTypeMatch.genericTypeMatches((CoreInstance)targetGenericType, (CoreInstance)sourceGenericType, (boolean)true, (ParameterMatchBehavior)ParameterMatchBehavior.MATCH_CAUTIOUSLY, (ParameterMatchBehavior)ParameterMatchBehavior.MATCH_CAUTIOUSLY, (ProcessorSupport)processorSupport)) {
            CoreInstance sourceRawType = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)sourceGenericType, (String)"rawType", (ProcessorSupport)processorSupport);
            CoreInstance targetRawType = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)targetGenericType, (String)"rawType", (ProcessorSupport)processorSupport);
            if (sourceRawType instanceof Unit && targetRawType instanceof Measure) {
                Instance.setValueForProperty((CoreInstance)inst, (String)"genericType", (CoreInstance)sourceGenericType, (ProcessorSupport)processorSupport);
            }
            Instance.setValuesForProperty((CoreInstance)inst, (String)"values", (ListIterable)valuesParam.getValueForMetaPropertyToMany("values"), (ProcessorSupport)processorSupport);
        } else {
            ListIterable values = valuesParam.getValueForMetaPropertyToMany("values");
            for (CoreInstance val : values) {
                CoreInstance valGenericType = Instance.extractGenericTypeFromInstance((CoreInstance)val, (ProcessorSupport)processorSupport);
                if (GenericTypeMatch.genericTypeMatches((CoreInstance)targetGenericType, (CoreInstance)valGenericType, (boolean)true, (ParameterMatchBehavior)ParameterMatchBehavior.MATCH_ANYTHING, (ParameterMatchBehavior)ParameterMatchBehavior.MATCH_ANYTHING, (ProcessorSupport)processorSupport)) continue;
                throw new PureExecutionException(functionExpressionToUseInStack.getSourceInformation(), "Cast exception: " + GenericType.print((CoreInstance)valGenericType, (ProcessorSupport)processorSupport) + " cannot be cast to " + GenericType.print((CoreInstance)targetGenericType, (ProcessorSupport)processorSupport));
            }
            Instance.setValuesForProperty((CoreInstance)inst, (String)"values", (ListIterable)valuesParam.getValueForMetaPropertyToMany("values"), (ProcessorSupport)processorSupport);
        }
        return inst;
    }

    private CoreInstance makeGenericTypeAsConcreteAsPossible(CoreInstance genericType, Stack<MutableMap<String, CoreInstance>> resolvedTypeParametersStack, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParametersStack, ProcessorSupport processorSupport) {
        if (GenericType.isGenericTypeFullyConcrete((CoreInstance)genericType, (ProcessorSupport)processorSupport)) {
            return genericType;
        }
        CoreInstance result = genericType;
        for (int i = resolvedTypeParametersStack.size() - 2; i >= 0; --i) {
            MutableMap resolvedTypeParameters = (MutableMap)resolvedTypeParametersStack.elementAt(i);
            MutableMap resolvedMultiplicityParameters = (MutableMap)resolvedMultiplicityParametersStack.elementAt(i);
            if (!resolvedTypeParameters.notEmpty() && !resolvedMultiplicityParameters.notEmpty() || !GenericType.isGenericTypeFullyConcrete((CoreInstance)(result = GenericType.makeTypeArgumentAsConcreteAsPossible((CoreInstance)result, (MapIterable)resolvedTypeParameters, (MapIterable)resolvedMultiplicityParameters, (ProcessorSupport)processorSupport)), (ProcessorSupport)processorSupport)) continue;
            return result;
        }
        return result;
    }
}

