/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives.basics.io;

import java.util.Stack;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Lists;
import org.finos.legend.pure.m3.compiler.Context;
import org.finos.legend.pure.m3.execution.Console;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.PrimitiveUtilities;
import org.finos.legend.pure.m3.navigation.Printer;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.ValueSpecificationBootstrap;
import org.finos.legend.pure.m3.navigation.measure.Measure;
import org.finos.legend.pure.m4.ModelRepository;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.FunctionExecutionInterpreted;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.NativeFunction;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

public class Print
extends NativeFunction {
    private ModelRepository repository;
    private Console console;

    public Print(FunctionExecutionInterpreted functionExecution, ModelRepository repository) {
        this.repository = repository;
        this.console = functionExecution.getConsole();
    }

    @Override
    public CoreInstance execute(ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, Context context, ProcessorSupport processorSupport) {
        if (this.console.isEnabled()) {
            ListIterable toPrint = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"values", (ProcessorSupport)processorSupport);
            CoreInstance stringType = processorSupport.package_getByUserPath("String");
            ImmutableSet primitiveTypeClassifiers = ModelRepository.PRIMITIVE_TYPE_NAMES.collect((Function)new Function<String, CoreInstance>(){

                public CoreInstance valueOf(String s) {
                    return Print.this.repository.getTopLevel(s);
                }
            });
            int max = PrimitiveUtilities.getIntegerValue((CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(1)), (String)"values", (ProcessorSupport)processorSupport)).intValue();
            if (toPrint.size() == 1) {
                String name;
                CoreInstance toPrintVal = (CoreInstance)toPrint.get(0);
                String result = this.console.isConsole() ? (Instance.instanceOf((CoreInstance)toPrintVal, (CoreInstance)stringType, (ProcessorSupport)processorSupport) ? ("\n".equals(name = toPrintVal.getName()) || name.isEmpty() ? name : '\'' + name + '\'') : (primitiveTypeClassifiers.contains((Object)processorSupport.getClassifier(toPrintVal)) ? toPrintVal.getName() : Printer.print((CoreInstance)toPrintVal, (String)"", (int)max, (ProcessorSupport)processorSupport))) : toPrintVal.getName();
                CoreInstance potentialUnitType = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.getFirst()), (String)"genericType", (String)"rawType", (ProcessorSupport)processorSupport);
                if (Measure.isUnitOrMeasureInstance((CoreInstance)((CoreInstance)params.getFirst()), (ProcessorSupport)processorSupport)) {
                    CoreInstance numericValue = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.getFirst()), (String)"values", (String)"values", (ProcessorSupport)processorSupport);
                    result = null == numericValue ? potentialUnitType.getName() : numericValue.getName() + " " + potentialUnitType.getName();
                }
                this.console.print((Object)result);
            } else {
                StringBuilder builder = new StringBuilder();
                if (this.console.isConsole()) {
                    builder.append("[\n");
                }
                for (CoreInstance instance : toPrint) {
                    if (Instance.instanceOf((CoreInstance)instance, (CoreInstance)stringType, (ProcessorSupport)processorSupport)) {
                        builder.append("   ");
                        String name = instance.getName().replace("\n", "\n   ");
                        if ("\n".equals(name) || name.isEmpty()) {
                            builder.append(name);
                        } else {
                            builder.append('\'');
                            builder.append(name);
                            builder.append('\'');
                        }
                    } else if (primitiveTypeClassifiers.contains((Object)processorSupport.getClassifier(instance))) {
                        builder.append("   ");
                        builder.append(instance.getName());
                    } else {
                        Printer.print((Appendable)builder, (CoreInstance)instance, (String)"   ", (int)max, (ProcessorSupport)processorSupport);
                    }
                    builder.append('\n');
                }
                if (this.console.isConsole()) {
                    builder.append("]");
                }
                this.console.print((Object)builder);
            }
        }
        return ValueSpecificationBootstrap.wrapValueSpecification((RichIterable)Lists.immutable.with(), (boolean)true, (ProcessorSupport)processorSupport);
    }

    public Console getConsole() {
        return this.console;
    }
}

