/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.factory.Lists;
import org.finos.legend.pure.m3.navigation.PackageableElement.PackageableElement;
import org.finos.legend.pure.m3.navigation.PrimitiveUtilities;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.ValueSpecificationBootstrap;
import org.finos.legend.pure.m4.ModelRepository;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;

public class NumericUtilities {
    public static Predicate<CoreInstance> IS_DECIMAL_CORE_INSTANCE(final ProcessorSupport processorSupport) {
        return new Predicate<CoreInstance>(){

            public boolean accept(CoreInstance each) {
                return "Decimal".equals(PackageableElement.getUserPathForPackageableElement((CoreInstance)processorSupport.getClassifier(each)));
            }
        };
    }

    public static Predicate<CoreInstance> IS_FLOAT_CORE_INSTANCE(final ProcessorSupport processorSupport) {
        return new Predicate<CoreInstance>(){

            public boolean accept(CoreInstance each) {
                return "Float".equals(PackageableElement.getUserPathForPackageableElement((CoreInstance)processorSupport.getClassifier(each)));
            }
        };
    }

    private NumericUtilities() {
    }

    public static CoreInstance toPureNumberValueExpression(Number javaNumber, boolean bigDecimalToPureDecimal, ModelRepository repository, ProcessorSupport processorSupport) {
        return ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)NumericUtilities.toPureNumber(javaNumber, bigDecimalToPureDecimal, repository), (boolean)true, (ProcessorSupport)processorSupport);
    }

    public static CoreInstance toPureNumber(Number javaNumber, boolean bigDecimalToPureDecimal, ModelRepository repository) {
        if (javaNumber == null) {
            throw new IllegalArgumentException("Cannot create Pure number from null");
        }
        if (javaNumber instanceof BigDecimal) {
            return bigDecimalToPureDecimal ? NumericUtilities.newPureDecimal((BigDecimal)javaNumber, repository) : NumericUtilities.newPureFloat((BigDecimal)javaNumber, repository);
        }
        if (javaNumber instanceof Double) {
            return NumericUtilities.newPureFloat(javaNumber.doubleValue(), repository);
        }
        if (javaNumber instanceof Float) {
            return NumericUtilities.newPureFloat(javaNumber.floatValue(), repository);
        }
        if (javaNumber instanceof BigInteger) {
            return NumericUtilities.newPureInteger((BigInteger)javaNumber, repository);
        }
        if (javaNumber instanceof Long) {
            return NumericUtilities.newPureInteger(javaNumber.longValue(), repository);
        }
        if (javaNumber instanceof Integer) {
            return NumericUtilities.newPureInteger(javaNumber.intValue(), repository);
        }
        throw new IllegalArgumentException("Not a number: " + javaNumber);
    }

    public static CoreInstance newPureFloat(BigDecimal number, ModelRepository repository) {
        if (number == null) {
            throw new IllegalArgumentException("Cannot create Float from null");
        }
        return repository.newFloatCoreInstance(number);
    }

    public static CoreInstance newPureFloat(double number, ModelRepository repository) {
        return NumericUtilities.newPureFloat(new BigDecimal(Double.toString(number)), repository);
    }

    public static CoreInstance newPureFloat(float number, ModelRepository repository) {
        return NumericUtilities.newPureFloat(new BigDecimal(Float.toString(number)), repository);
    }

    public static CoreInstance newPureDecimal(BigDecimal number, ModelRepository repository) {
        if (number == null) {
            throw new IllegalArgumentException("Cannot create Decimal from null");
        }
        return repository.newDecimalCoreInstance(number);
    }

    public static CoreInstance newPureInteger(BigInteger number, ModelRepository repository) {
        if (number == null) {
            throw new IllegalArgumentException("Cannot create Integer from null");
        }
        return repository.newIntegerCoreInstance(number);
    }

    public static CoreInstance newPureInteger(long number, ModelRepository repository) {
        return repository.newIntegerCoreInstance(number);
    }

    public static CoreInstance newPureInteger(int number, ModelRepository repository) {
        return repository.newIntegerCoreInstance(number);
    }

    public static Number toJavaNumber(CoreInstance pureNumber, ProcessorSupport processorSupport) {
        String typeName = processorSupport.getClassifier(pureNumber).getName();
        if ("Integer".equals(typeName)) {
            return PrimitiveUtilities.getIntegerValue((CoreInstance)pureNumber);
        }
        if ("Float".equals(typeName)) {
            return PrimitiveUtilities.getFloatValue((CoreInstance)pureNumber);
        }
        if ("Decimal".equals(typeName)) {
            return PrimitiveUtilities.getDecimalValue((CoreInstance)pureNumber);
        }
        throw new IllegalArgumentException("Not a number: " + pureNumber);
    }

    public static ListIterable<Number> toJavaNumber(ListIterable<? extends CoreInstance> pureNumbers, ProcessorSupport processorSupport) {
        MutableList javaNumbers = Lists.mutable.empty();
        for (CoreInstance pureNumber : pureNumbers) {
            javaNumbers.add((Object)NumericUtilities.toJavaNumber(pureNumber, processorSupport));
        }
        return javaNumbers;
    }

    public static int compare(Number left, Number right) {
        if (left instanceof Integer || left instanceof Long) {
            if (right instanceof Integer || right instanceof Long) {
                return Long.compare(left.longValue(), right.longValue());
            }
            if (right instanceof Float || right instanceof Double) {
                return new BigDecimal(left.longValue()).compareTo(BigDecimal.valueOf(right.doubleValue()));
            }
            if (right instanceof BigInteger) {
                return new BigInteger(left.toString()).compareTo((BigInteger)right);
            }
            if (right instanceof BigDecimal) {
                return new BigDecimal(left.longValue()).compareTo((BigDecimal)right);
            }
            throw new RuntimeException("Number of an unhandled type: " + right);
        }
        if (left instanceof Float || left instanceof Double) {
            if (right instanceof Integer || right instanceof Long) {
                return BigDecimal.valueOf(left.doubleValue()).compareTo(BigDecimal.valueOf(right.longValue()));
            }
            if (right instanceof Float || right instanceof Double) {
                return Double.compare(left.doubleValue(), right.doubleValue());
            }
            if (right instanceof BigInteger) {
                return new BigDecimal(left.doubleValue()).compareTo(new BigDecimal((BigInteger)right));
            }
            if (right instanceof BigDecimal) {
                return BigDecimal.valueOf(left.doubleValue()).compareTo((BigDecimal)right);
            }
            throw new RuntimeException("Number of an unhandled type: " + right);
        }
        if (left instanceof BigInteger) {
            if (right instanceof Integer || right instanceof Long) {
                return ((BigInteger)left).compareTo(new BigInteger(right.toString()));
            }
            if (right instanceof Float || right instanceof Double) {
                return new BigDecimal((BigInteger)left).compareTo(BigDecimal.valueOf(right.doubleValue()));
            }
            if (right instanceof BigInteger) {
                return ((BigInteger)left).compareTo((BigInteger)right);
            }
            if (right instanceof BigDecimal) {
                return new BigDecimal((BigInteger)left).compareTo((BigDecimal)right);
            }
            throw new RuntimeException("Number of an unhandled type: " + right);
        }
        if (left instanceof BigDecimal) {
            if (right instanceof Integer || right instanceof Long) {
                return ((BigDecimal)left).compareTo(new BigDecimal(right.longValue()));
            }
            if (right instanceof Float || right instanceof Double) {
                return ((BigDecimal)left).compareTo(BigDecimal.valueOf(right.doubleValue()));
            }
            if (right instanceof BigInteger) {
                return ((BigDecimal)left).compareTo(new BigDecimal((BigInteger)right));
            }
            if (right instanceof BigDecimal) {
                return ((BigDecimal)left).compareTo((BigDecimal)right);
            }
            throw new RuntimeException("Number of an unhandled type: " + right);
        }
        throw new RuntimeException("Number of an unhandled type: " + left);
    }
}

