/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives;

import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.factory.Multimaps;
import org.eclipse.collections.impl.factory.Stacks;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;

public class InstantiationContext {
    private final MutableStack<Object> stack = Stacks.mutable.empty();
    private final MutableMap<Object, CoreInstance> newInstancesByNewFunction = Maps.mutable.empty();
    private final MutableMultimap<CoreInstance, Object> stackObjectByClassifier;
    private final MutableList<Runnable> validations;

    public InstantiationContext() {
        this.stackObjectByClassifier = Multimaps.mutable.list.empty();
        this.validations = Lists.mutable.empty();
    }

    public void push(CoreInstance classifier) {
        Object object = new Object();
        this.stack.push(object);
        this.stackObjectByClassifier.put((Object)classifier, object);
    }

    public void popAndExecuteProcedures(CoreInstance instance) {
        Object stackObject = this.stack.pop();
        this.newInstancesByNewFunction.put(stackObject, (Object)instance);
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public void runValidations() {
        if (this.isEmpty()) {
            this.validations.each((Procedure)new Procedure<Runnable>(){

                public void value(Runnable runnable) {
                    runnable.run();
                }
            });
        }
    }

    public void reset() {
        this.stack.clear();
        this.newInstancesByNewFunction.clear();
        this.stackObjectByClassifier.clear();
        this.validations.clear();
    }

    public void registerValidation(Runnable runnable) {
        this.validations.add((Object)runnable);
    }
}

