/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted.natives;

import java.util.Stack;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.finos.legend.pure.m3.exception.PureExecutionException;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.PrimitiveUtilities;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation._class._Class;
import org.finos.legend.pure.m3.navigation.valuespecification.ValueSpecification;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.m4.coreinstance.SourceInformation;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.FunctionExecutionInterpreted;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;
import org.finos.legend.pure.runtime.java.interpreted.profiler.VoidProfiler;

public class DefaultConstraintHandler {
    private DefaultConstraintHandler() {
    }

    public static CoreInstance handleConstraints(CoreInstance _class, CoreInstance instance, SourceInformation sourceInformation, FunctionExecutionInterpreted functionExecution, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport) throws PureExecutionException {
        ProcessorSupport processorSupport = functionExecution.getProcessorSupport();
        boolean executable = ValueSpecification.isExecutable((CoreInstance)instance, (ProcessorSupport)processorSupport);
        CoreInstance evaluatedSource = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)instance, (String)"values", (ProcessorSupport)processorSupport);
        CoreInstance override = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)evaluatedSource, (String)"elementOverride", (ProcessorSupport)processorSupport);
        return override != null && Instance.getValueForMetaPropertyToOneResolved((CoreInstance)override, (String)"constraintsManager", (ProcessorSupport)processorSupport) != null ? functionExecution.executeLambdaFromNative(Instance.getValueForMetaPropertyToOneResolved((CoreInstance)override, (String)"constraintsManager", (ProcessorSupport)processorSupport), (ListIterable<? extends CoreInstance>)Lists.mutable.with((Object[])new CoreInstance[]{instance}), resolvedTypeParameters, resolvedMultiplicityParameters, variableContext, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport) : DefaultConstraintHandler.defaultHandleConstraints(_class, instance, sourceInformation, functionExecution, instantiationContext, executionSupport);
    }

    private static CoreInstance defaultHandleConstraints(CoreInstance _class, CoreInstance instance, SourceInformation sourceInformation, FunctionExecutionInterpreted functionExecution, InstantiationContext instantiationContext, ExecutionSupport executionSupport) throws PureExecutionException {
        VariableContext ctx = VariableContext.newVariableContext();
        try {
            ctx.registerValue("this", instance);
        }
        catch (VariableContext.VariableNameConflictException e) {
            throw new PureExecutionException(null, e.getMessage());
        }
        for (CoreInstance constraint : _Class.computeConstraintsInHierarchy((CoreInstance)_class, (ProcessorSupport)functionExecution.getProcessorSupport())) {
            CoreInstance definition = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)constraint, (String)"functionDefinition", (ProcessorSupport)functionExecution.getProcessorSupport()).getValueForMetaPropertyToOne("expressionSequence");
            String ruleId = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)constraint, (String)"name", (ProcessorSupport)functionExecution.getProcessorSupport()).getName();
            CoreInstance owner = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)constraint, (String)"owner", (ProcessorSupport)functionExecution.getProcessorSupport());
            if (owner != null && !"Global".equals(owner.getName())) continue;
            CoreInstance result = functionExecution.executeValueSpecification(definition, new Stack<MutableMap<String, CoreInstance>>(), new Stack<MutableMap<String, CoreInstance>>(), null, ctx, VoidProfiler.VOID_PROFILER, instantiationContext, executionSupport);
            CoreInstance constraintClass = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)definition, (String)"usageContext", (ProcessorSupport)functionExecution.getProcessorSupport()).getValueForMetaPropertyToOne("class");
            CoreInstance messageFunction = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)constraint, (String)"messageFunction", (ProcessorSupport)functionExecution.getProcessorSupport());
            if (PrimitiveUtilities.getBooleanValue((CoreInstance)result.getValueForMetaPropertyToOne("values"))) continue;
            StringBuilder message = new StringBuilder("Constraint :[" + ruleId + "] violated in the Class " + constraintClass.getName());
            if (messageFunction != null) {
                message.append(", Message: ");
                message.append(PrimitiveUtilities.getStringValue((CoreInstance)functionExecution.executeValueSpecification(messageFunction.getValueForMetaPropertyToOne("expressionSequence"), new Stack<MutableMap<String, CoreInstance>>(), new Stack<MutableMap<String, CoreInstance>>(), null, ctx, VoidProfiler.VOID_PROFILER, instantiationContext, executionSupport).getValueForMetaPropertyToOne("values")));
            }
            throw new PureExecutionException(sourceInformation, message.toString());
        }
        return instance;
    }
}

