/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted;

import java.io.PrintStream;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.factory.Sets;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;

public class VariableContext {
    private final VariableContext parent;
    private MutableMap<String, CoreInstance> mapping;
    private boolean functionScopeLimitMarker = false;

    private VariableContext(VariableContext parent) {
        this.parent = parent;
    }

    private VariableContext(VariableContext parent, String name, CoreInstance value) {
        this(parent);
        this.mapping = Maps.mutable.with((Object)name, (Object)value);
    }

    public CoreInstance getValue(String name) {
        CoreInstance value = this.getLocalValue(name);
        return value != null || this.parent == null || this.functionScopeLimitMarker ? value : this.parent.getValue(name);
    }

    public void markVariableScopeBoundary() {
        this.functionScopeLimitMarker = true;
    }

    public CoreInstance getLocalValue(String name) {
        return this.mapping == null ? null : (CoreInstance)this.mapping.get((Object)name);
    }

    public void registerValue(String name, CoreInstance value) throws VariableNameConflictException {
        if (this.mapping == null) {
            this.mapping = Maps.mutable.with((Object)name, (Object)value);
        } else {
            CoreInstance previous = (CoreInstance)this.mapping.put((Object)name, (Object)value);
            if (previous != null) {
                this.mapping.put((Object)name, (Object)previous);
                throw new VariableNameConflictException(name);
            }
        }
    }

    public VariableContext getParent() {
        return this.parent;
    }

    public MutableSet<String> getVariableNames() {
        if (this.parent == null) {
            return this.getLocalVariableNames();
        }
        MutableSet<String> names = this.parent.getVariableNames();
        if (this.mapping != null) {
            names.addAllIterable((Iterable)this.mapping.keysView());
        }
        return names;
    }

    public MutableSet<String> getLocalVariableNames() {
        return this.mapping == null ? Sets.mutable.with() : Sets.mutable.withAll((Iterable)this.mapping.keysView());
    }

    public void print(PrintStream printStream) {
        if (this.mapping != null) {
            printStream.println("   " + this.mapping.keysView().makeString(",") + ":freeze:" + this.functionScopeLimitMarker);
            if (this.parent != null && this.parent.mapping != null) {
                printStream.print("   parent:");
                this.parent.print(printStream);
            }
        }
    }

    public static VariableContext newVariableContext() {
        return VariableContext.newVariableContext(null);
    }

    public static VariableContext newVariableContext(VariableContext parent) {
        return new VariableContext(parent);
    }

    public static VariableContext newVariableContextWith(VariableContext parent, String name, CoreInstance value) {
        return new VariableContext(parent, name, value);
    }

    public static class VariableNameConflictException
    extends Exception {
        private VariableNameConflictException(String name) {
            super("'" + name + "' has already been defined!");
        }
    }
}

