/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted;

import java.util.Stack;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.finos.legend.pure.m3.exception.PureExecutionException;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.function.Function;
import org.finos.legend.pure.m3.navigation.measure.Measure;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.Executor;
import org.finos.legend.pure.runtime.java.interpreted.FunctionExecutionInterpreted;
import org.finos.legend.pure.runtime.java.interpreted.LambdaWithContext;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

class InstanceValueExecutor
implements Executor {
    static final InstanceValueExecutor INSTANCE = new InstanceValueExecutor();

    private InstanceValueExecutor() {
    }

    @Override
    public CoreInstance execute(CoreInstance instance, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, CoreInstance functionExpressionToUseInStack, VariableContext variableContext, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, FunctionExecutionInterpreted functionExecutionInterpreted, ProcessorSupport processorSupport) throws PureExecutionException {
        CoreInstance newInstanceValue = instance.getRepository().newEphemeralAnonymousCoreInstance(instance.getSourceInformation(), processorSupport.package_getByUserPath("meta::pure::metamodel::valuespecification::InstanceValue"));
        Instance.addValueToProperty((CoreInstance)newInstanceValue, (String)"genericType", (CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)instance, (String)"genericType", (ProcessorSupport)processorSupport), (ProcessorSupport)processorSupport);
        Instance.addValueToProperty((CoreInstance)newInstanceValue, (String)"multiplicity", (CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)instance, (String)"multiplicity", (ProcessorSupport)processorSupport), (ProcessorSupport)processorSupport);
        ListIterable values = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)instance, (String)"values", (ProcessorSupport)processorSupport);
        FastList processedValues = FastList.newList((int)values.size());
        for (CoreInstance value : values) {
            if (Instance.instanceOf((CoreInstance)value, (String)"meta::pure::metamodel::valuespecification::ValueSpecification", (ProcessorSupport)processorSupport)) {
                Executor executor = FunctionExecutionInterpreted.findValueSpecificationExecutor(value, functionExpressionToUseInStack, processorSupport, functionExecutionInterpreted);
                CoreInstance result = executor.execute(value, resolvedTypeParameters, resolvedMultiplicityParameters, functionExpressionToUseInStack, variableContext, profiler, instantiationContext, executionSupport, functionExecutionInterpreted, processorSupport);
                if (Measure.isUnitOrMeasureInstance((CoreInstance)result, (ProcessorSupport)processorSupport)) {
                    processedValues.add((Object)result);
                    continue;
                }
                processedValues.addAllIterable((Iterable)Instance.getValueForMetaPropertyToManyResolved((CoreInstance)result, (String)"values", (ProcessorSupport)processorSupport));
                continue;
            }
            if (Function.isLambda((CoreInstance)value, (ProcessorSupport)processorSupport) && !(value instanceof LambdaWithContext)) {
                if (value.getValueForMetaPropertyToMany("openVariables").notEmpty()) {
                    processedValues.add((Object)new LambdaWithContext(value, variableContext));
                    continue;
                }
                processedValues.add((Object)value);
                continue;
            }
            processedValues.add((Object)value);
        }
        Instance.setValuesForProperty((CoreInstance)newInstanceValue, (String)"values", (ListIterable)processedValues, (ProcessorSupport)processorSupport);
        return newInstanceValue;
    }
}

