/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted;

import java.util.Stack;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.Function;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.FunctionCoreInstanceWrapper;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.valuespecification.FunctionExpression;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.valuespecification.FunctionExpressionCoreInstanceWrapper;
import org.finos.legend.pure.m3.exception.PureExecutionException;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.generictype.GenericType;
import org.finos.legend.pure.m3.navigation.multiplicity.Multiplicity;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.Executor;
import org.finos.legend.pure.runtime.java.interpreted.FunctionExecutionInterpreted;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;

class FunctionExpressionExecutor
implements Executor {
    static final FunctionExpressionExecutor INSTANCE = new FunctionExpressionExecutor();

    private FunctionExpressionExecutor() {
    }

    @Override
    public CoreInstance execute(CoreInstance instance, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, CoreInstance functionExpressionToUseInStack, VariableContext variableContext, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport, FunctionExecutionInterpreted functionExecutionInterpreted, ProcessorSupport processorSupport) throws PureExecutionException {
        ListIterable parameters;
        boolean deferExecution;
        profiler.startExecutingFunctionExpression(instance, functionExpressionToUseInStack);
        FunctionExpression functionExpression = FunctionExpressionCoreInstanceWrapper.toFunctionExpression((CoreInstance)instance);
        ListIterable params = (ListIterable)functionExpression._parametersValues();
        Function function = FunctionCoreInstanceWrapper.toFunction((CoreInstance)functionExpression._funcCoreInstance());
        UnifiedMap localResolvedTypeParameters = UnifiedMap.newMap();
        UnifiedMap localResolvedMultiplicityParameters = UnifiedMap.newMap();
        this.resolveLocalTypeAndMultiplicityParams(functionExpression, instance, processorSupport, (ListIterable<? extends CoreInstance>)params, function, (MutableMap<String, CoreInstance>)localResolvedTypeParameters, (MutableMap<String, CoreInstance>)localResolvedMultiplicityParameters);
        boolean bl = deferExecution = Instance.instanceOf((CoreInstance)function, (String)"meta::pure::metamodel::function::NativeFunction", (ProcessorSupport)processorSupport) && functionExecutionInterpreted.getNativeFunction(function.getName()) != null && functionExecutionInterpreted.getNativeFunction(function.getName()).deferParameterExecution();
        if (deferExecution || params.isEmpty()) {
            parameters = params;
        } else {
            FastList newParams = FastList.newList((int)params.size());
            for (CoreInstance instance1 : params) {
                Executor executor = FunctionExecutionInterpreted.findValueSpecificationExecutor(instance1, instance, processorSupport, functionExecutionInterpreted);
                newParams.add((Object)executor.execute(instance1, resolvedTypeParameters, resolvedMultiplicityParameters, instance, variableContext, profiler, instantiationContext, executionSupport, functionExecutionInterpreted, processorSupport));
            }
            parameters = newParams;
        }
        resolvedTypeParameters.push(this.resolveTypeParamsFromParent(resolvedTypeParameters, resolvedMultiplicityParameters, (MutableMap<String, CoreInstance>)localResolvedTypeParameters, functionExpressionToUseInStack, processorSupport));
        resolvedMultiplicityParameters.push(this.resolveMultiplicityParametersFromParent(resolvedMultiplicityParameters, (MutableMap<String, CoreInstance>)localResolvedMultiplicityParameters, functionExpressionToUseInStack));
        CoreInstance result = functionExecutionInterpreted.executeFunction(true, (Function<CoreInstance>)function, (ListIterable<? extends CoreInstance>)parameters, resolvedTypeParameters, resolvedMultiplicityParameters, variableContext, instance, profiler, instantiationContext, executionSupport);
        resolvedTypeParameters.pop();
        resolvedMultiplicityParameters.pop();
        profiler.finishedExecutingFunctionExpression(instance);
        return result;
    }

    private void resolveLocalTypeAndMultiplicityParams(FunctionExpression functionExpression, CoreInstance functionExpressionToUseInStack, ProcessorSupport processorSupport, ListIterable<? extends CoreInstance> params, Function function, MutableMap<String, CoreInstance> localResolvedTypeParameters, MutableMap<String, CoreInstance> localResolvedMultiplicityParameters) {
        block6: {
            CoreInstance functionType;
            block5: {
                int i;
                functionType = processorSupport.function_getFunctionType((CoreInstance)function);
                if (!Instance.instanceOf((CoreInstance)function, (String)"meta::pure::metamodel::function::property::QualifiedProperty", (ProcessorSupport)processorSupport) && !"copy_T_1__String_1__KeyExpression_MANY__T_1_".equals(function.getName()) && !"new_Class_1__String_1__KeyExpression_MANY__T_1_".equals(function.getName()) && !"new_Class_1__String_1__T_1_".equals(function.getName())) break block5;
                CoreInstance genericType = Instance.instanceOf((CoreInstance)function, (String)"meta::pure::metamodel::function::property::QualifiedProperty", (ProcessorSupport)processorSupport) || "copy_T_1__String_1__KeyExpression_MANY__T_1_".equals(function.getName()) ? Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"genericType", (ProcessorSupport)processorSupport) : Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)params.get(0)), (String)"genericType", (String)"typeArguments", (ProcessorSupport)processorSupport);
                CoreInstance classifier = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)genericType, (String)"rawType", (ProcessorSupport)processorSupport);
                ListIterable new_TypeParameters = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)classifier, (String)"typeParameters", (ProcessorSupport)processorSupport);
                ListIterable new_MultiplicityParameters = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)classifier, (String)"multiplicityParameters", (ProcessorSupport)processorSupport);
                ListIterable new_TypeArguments = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)genericType, (String)"typeArguments", (ProcessorSupport)processorSupport);
                ListIterable new_MultiplicityArguments = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)genericType, (String)"multiplicityArguments", (ProcessorSupport)processorSupport);
                int size = new_TypeParameters.size();
                for (i = 0; i < size; ++i) {
                    localResolvedTypeParameters.put((Object)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)new_TypeParameters.get(i)), (String)"name", (ProcessorSupport)processorSupport).getName(), (Object)((CoreInstance)new_TypeArguments.get(i)));
                }
                size = new_MultiplicityParameters.size();
                for (i = 0; i < size; ++i) {
                    localResolvedMultiplicityParameters.put((Object)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)new_MultiplicityParameters.get(i)), (String)"values", (ProcessorSupport)processorSupport).getName(), (Object)((CoreInstance)new_MultiplicityArguments.get(i)));
                }
                break block6;
            }
            ListIterable typeArguments = (ListIterable)functionExpression._resolvedTypeParameters();
            ListIterable typeParameters = functionType.getValueForMetaPropertyToMany("typeParameters");
            int typeParamsSize = typeParameters.size();
            if (typeArguments.size() != typeParamsSize) {
                throw new PureExecutionException(functionExpressionToUseInStack.getSourceInformation(), "Mismatch between type parameter count (" + typeParamsSize + ") and type argument count (" + typeArguments.size() + ")");
            }
            for (int i = 0; i < typeParamsSize; ++i) {
                localResolvedTypeParameters.put((Object)((CoreInstance)typeParameters.get(i)).getValueForMetaPropertyToOne("name").getName(), (Object)((CoreInstance)typeArguments.get(i)));
            }
            ListIterable multiplicityArguments = (ListIterable)functionExpression._resolvedMultiplicityParameters();
            ListIterable multiplicityParameters = functionType.getValueForMetaPropertyToMany("multiplicityParameters");
            int multiplicityParamsSize = multiplicityParameters.size();
            if (multiplicityArguments.size() != multiplicityParamsSize) break block6;
            for (int i = 0; i < multiplicityParamsSize; ++i) {
                localResolvedMultiplicityParameters.put((Object)((CoreInstance)multiplicityParameters.get(i)).getValueForMetaPropertyToOne("values").getName(), (Object)((CoreInstance)multiplicityArguments.get(i)));
            }
        }
    }

    private MutableMap<String, CoreInstance> resolveTypeParamsFromParent(Stack<MutableMap<String, CoreInstance>> stackType, Stack<MutableMap<String, CoreInstance>> stackMul, MutableMap<String, CoreInstance> typeParameters, CoreInstance functionExpressionToUseInStack, ProcessorSupport processorSupport) {
        if (typeParameters.isEmpty() || stackType.isEmpty()) {
            return typeParameters;
        }
        UnifiedMap result = UnifiedMap.newMap((int)typeParameters.size());
        for (String key : typeParameters.keysView()) {
            CoreInstance ci = (CoreInstance)typeParameters.get((Object)key);
            for (int size = stackType.size() - 1; size >= 0 && !GenericType.isGenericTypeFullyConcrete((CoreInstance)ci, (ProcessorSupport)processorSupport); --size) {
                ci = GenericType.makeTypeArgumentAsConcreteAsPossible((CoreInstance)GenericType.copyGenericType((CoreInstance)((CoreInstance)typeParameters.get((Object)key)), (boolean)false, (ProcessorSupport)processorSupport), (MapIterable)((MutableMap)stackType.get(size)).asUnmodifiable(), (MapIterable)((MutableMap)stackMul.get(size)).asUnmodifiable(), (ProcessorSupport)processorSupport);
            }
            if (!GenericType.isGenericTypeFullyConcrete((CoreInstance)ci, (ProcessorSupport)processorSupport)) {
                throw new PureExecutionException(functionExpressionToUseInStack == null ? null : functionExpressionToUseInStack.getSourceInformation(), "Can't resolve some type parameters in: " + GenericType.print((CoreInstance)ci, (ProcessorSupport)processorSupport));
            }
            result.put((Object)key, (Object)ci);
        }
        return result;
    }

    private MutableMap<String, CoreInstance> resolveMultiplicityParametersFromParent(Stack<MutableMap<String, CoreInstance>> stack, MutableMap<String, CoreInstance> multiplicityParameters, CoreInstance functionExpressionToUseInStack) {
        if (multiplicityParameters.isEmpty() || stack.isEmpty()) {
            return multiplicityParameters;
        }
        UnifiedMap result = UnifiedMap.newMap((int)multiplicityParameters.size());
        multiplicityParameters.forEachKeyValue((Procedure2)new Procedure2<String, CoreInstance>((MutableMap)result, stack, functionExpressionToUseInStack){
            final /* synthetic */ MutableMap val$result;
            final /* synthetic */ Stack val$stack;
            final /* synthetic */ CoreInstance val$functionExpressionToUseInStack;
            {
                this.val$result = mutableMap;
                this.val$stack = stack;
                this.val$functionExpressionToUseInStack = coreInstance;
            }

            public void value(String parameter, CoreInstance multiplicity) {
                if (Multiplicity.isMultiplicityConcrete((CoreInstance)multiplicity)) {
                    this.val$result.put((Object)parameter, (Object)multiplicity);
                } else {
                    CoreInstance resolvedMultiplicity = FunctionExpressionExecutor.this.resolveMultiplicityParameter(Multiplicity.getMultiplicityParameter((CoreInstance)multiplicity), this.val$stack);
                    if (resolvedMultiplicity == null) {
                        throw new PureExecutionException(this.val$functionExpressionToUseInStack == null ? null : this.val$functionExpressionToUseInStack.getSourceInformation(), "Cannot resolve multiplicity parameter: " + Multiplicity.getMultiplicityParameter((CoreInstance)multiplicity));
                    }
                    this.val$result.put((Object)parameter, (Object)resolvedMultiplicity);
                }
            }
        });
        return result;
    }

    private CoreInstance resolveMultiplicityParameter(String param, Stack<MutableMap<String, CoreInstance>> stack) {
        for (int i = stack.size() - 1; i >= 0; --i) {
            MapIterable resolvedMultiplicityParameters = (MapIterable)stack.elementAt(i);
            CoreInstance multiplicity = (CoreInstance)resolvedMultiplicityParameters.get((Object)param);
            if (multiplicity == null) continue;
            if (Multiplicity.isMultiplicityConcrete((CoreInstance)multiplicity)) {
                return multiplicity;
            }
            param = Multiplicity.getMultiplicityParameter((CoreInstance)multiplicity);
        }
        return null;
    }
}

