/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.FunctionCoreInstanceWrapper;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.FunctionDefinitionCoreInstanceWrapper;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.LambdaFunction;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.LambdaFunctionCoreInstanceWrapper;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.NativeFunctionCoreInstanceWrapper;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.PackageableFunction;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.property.Property;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.property.PropertyCoreInstanceWrapper;
import org.finos.legend.pure.m3.exception.PureAssertFailException;
import org.finos.legend.pure.m3.exception.PureExecutionException;
import org.finos.legend.pure.m3.execution.Console;
import org.finos.legend.pure.m3.execution.ExecutionPlatform;
import org.finos.legend.pure.m3.execution.FunctionExecution;
import org.finos.legend.pure.m3.execution.OutputWriter;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.M3ProcessorSupport;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation.ValueSpecificationBootstrap;
import org.finos.legend.pure.m3.navigation.function.Function;
import org.finos.legend.pure.m3.navigation.multiplicity.Multiplicity;
import org.finos.legend.pure.m3.navigation.valuespecification.ValueSpecification;
import org.finos.legend.pure.m3.serialization.filesystem.usercodestorage.RepositoryCodeStorage;
import org.finos.legend.pure.m3.serialization.runtime.Message;
import org.finos.legend.pure.m3.serialization.runtime.PureRuntime;
import org.finos.legend.pure.m3.statelistener.ExecutionActivityListener;
import org.finos.legend.pure.m3.statelistener.VoidExecutionActivityListener;
import org.finos.legend.pure.m4.ModelRepository;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.m4.coreinstance.SourceInformation;
import org.finos.legend.pure.m4.exception.PureException;
import org.finos.legend.pure.runtime.java.interpreted.ClusteredValueSpecificationExecutor;
import org.finos.legend.pure.runtime.java.interpreted.ConsoleInterpreted;
import org.finos.legend.pure.runtime.java.interpreted.ExecutionSupport;
import org.finos.legend.pure.runtime.java.interpreted.Executor;
import org.finos.legend.pure.runtime.java.interpreted.FunctionExpressionExecutor;
import org.finos.legend.pure.runtime.java.interpreted.InstanceValueExecutor;
import org.finos.legend.pure.runtime.java.interpreted.LambdaWithContext;
import org.finos.legend.pure.runtime.java.interpreted.NonExecutableValueSpecificationExecutor;
import org.finos.legend.pure.runtime.java.interpreted.OutputWriterInterpreted;
import org.finos.legend.pure.runtime.java.interpreted.RoutedValueSpecificationExecutor;
import org.finos.legend.pure.runtime.java.interpreted.VariableContext;
import org.finos.legend.pure.runtime.java.interpreted.VariableExpressionExecutor;
import org.finos.legend.pure.runtime.java.interpreted.extension.InterpretedExtension;
import org.finos.legend.pure.runtime.java.interpreted.extension.InterpretedExtensionLoader;
import org.finos.legend.pure.runtime.java.interpreted.natives.InstantiationContext;
import org.finos.legend.pure.runtime.java.interpreted.natives.NativeFunction;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.collection.Add;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.collection.At;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.collection.Concatenate;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.collection.Fold;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.collection.Init;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.collection.RemoveDuplicates;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.collection.Sort;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.collection.Tail;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.io.Print;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.lang.Cast;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.lang.DynamicNew;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.lang.DynamicNewGenericType;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.lang.Evaluate;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.lang.EvaluateAny;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.lang.If;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.lang.Match;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.math.Abs;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.meta.EvaluateAndDeactivate;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.meta.GenericType;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.meta.GenericTypeClass;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.meta.GetUnitValue;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.meta.Id;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.meta.InstanceOf;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.meta.NewUnit;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.string.Format;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.string.Length;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.string.Replace;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.string.Split;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.string.StartsWith;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.string.SubString;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.string.ToString;
import org.finos.legend.pure.runtime.java.interpreted.natives.basics.tests.Assert;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar._boolean.conjunctions.And;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar._boolean.conjunctions.Not;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar._boolean.conjunctions.Or;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar._boolean.equality.Eq;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar._boolean.equality.Equal;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar._boolean.equality.Is;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar._boolean.inequalities.LessThan;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar._boolean.inequalities.LessThanOrEqualTo;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.collection.Filter;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.collection.First;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.collection.IsEmpty;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.collection.Map;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.collection.Range;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.collection.Size;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.lang.Compare;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.lang.Copy;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.lang.ExtractEnumValue;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.lang.GetAll;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.lang.Let;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.lang.New;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.math.Divide;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.math.DivideDecimal;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.math.Minus;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.math.Plus;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.math.Times;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.multiplicity.ToOne;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.multiplicity.ToOneMany;
import org.finos.legend.pure.runtime.java.interpreted.natives.grammar.string.JoinStrings;
import org.finos.legend.pure.runtime.java.interpreted.profiler.Profiler;
import org.finos.legend.pure.runtime.java.interpreted.profiler.VoidProfiler;

@ExecutionPlatform(name="Interpreted")
public class FunctionExecutionInterpreted
implements FunctionExecution {
    private static final int DEFAULT_MAX_SQL_ROWS = 200;
    private final AtomicBoolean cancelExecution = new AtomicBoolean(false);
    private final ExecutionActivityListener executionActivityListener;
    private PureRuntime runtime;
    private Console console = new ConsoleInterpreted();
    private ProcessorSupport processorSupport;
    private RepositoryCodeStorage storage;
    private Message message;
    private MutableMap<String, NativeFunction> nativeFunctions;
    private final int maxSQLRows;
    private MutableList<InterpretedExtension> extensions;

    public FunctionExecutionInterpreted() {
        this((ExecutionActivityListener)VoidExecutionActivityListener.VOID_EXECUTION_ACTIVITY_LISTENER);
    }

    public FunctionExecutionInterpreted(ExecutionActivityListener executionActivityListener) {
        this(200, executionActivityListener);
    }

    public FunctionExecutionInterpreted(int maxSQLRows, ExecutionActivityListener executionActivityListener) {
        this.maxSQLRows = maxSQLRows < 0 ? 0 : maxSQLRows;
        this.executionActivityListener = executionActivityListener == null ? VoidExecutionActivityListener.VOID_EXECUTION_ACTIVITY_LISTENER : executionActivityListener;
        this.extensions = InterpretedExtensionLoader.extensions();
    }

    public void setProcessorSupport(M3ProcessorSupport processorSupport) {
        this.processorSupport = processorSupport;
        this.runtime.getIncrementalCompiler().setProcessorSupport(processorSupport);
    }

    public void init(PureRuntime runtime, Message message) {
        this.runtime = runtime;
        this.processorSupport = new M3ProcessorSupport(this.runtime.getContext(), this.runtime.getModelRepository());
        this.nativeFunctions = UnifiedMap.newMap();
        ModelRepository repository = runtime.getModelRepository();
        this.storage = runtime.getCodeStorage();
        this.message = message;
        this.registerGrammarNatives(repository);
        this.registerBasicNatives(repository);
        for (Pair extraNative : this.extensions.flatCollect((org.eclipse.collections.api.block.function.Function & Serializable)e -> e.getExtraNatives())) {
            this.nativeFunctions.put((Object)((String)extraNative.getOne()), (Object)((NativeFunction)((Function2)extraNative.getTwo()).value((Object)this, (Object)repository)));
        }
    }

    private void registerGrammarNatives(ModelRepository repository) {
        this.nativeFunctions.put((Object)"and_Boolean_1__Boolean_1__Boolean_1_", (Object)new And(repository, this));
        this.nativeFunctions.put((Object)"or_Boolean_1__Boolean_1__Boolean_1_", (Object)new Or(repository, this));
        this.nativeFunctions.put((Object)"not_Boolean_1__Boolean_1_", (Object)new Not(repository));
        this.nativeFunctions.put((Object)"eq_Any_1__Any_1__Boolean_1_", (Object)new Eq(repository));
        this.nativeFunctions.put((Object)"equal_Any_MANY__Any_MANY__Boolean_1_", (Object)new Equal(repository));
        this.nativeFunctions.put((Object)"is_Any_1__Any_1__Boolean_1_", (Object)new Is(repository));
        this.nativeFunctions.put((Object)"lessThan_Number_1__Number_1__Boolean_1_", (Object)new LessThan(repository));
        this.nativeFunctions.put((Object)"lessThanEqual_Number_1__Number_1__Boolean_1_", (Object)new LessThanOrEqualTo(repository));
        this.nativeFunctions.put((Object)"filter_T_MANY__Function_1__T_MANY_", (Object)new Filter(this));
        this.nativeFunctions.put((Object)"first_T_MANY__T_$0_1$_", (Object)new First());
        this.nativeFunctions.put((Object)"isEmpty_Any_MANY__Boolean_1_", (Object)new IsEmpty(repository));
        Map c = new Map(this);
        this.nativeFunctions.put((Object)"map_T_m__Function_1__V_m_", (Object)c);
        this.nativeFunctions.put((Object)"map_T_MANY__Function_1__V_MANY_", (Object)c);
        this.nativeFunctions.put((Object)"map_T_$0_1$__Function_1__V_$0_1$_", (Object)c);
        this.nativeFunctions.put((Object)"range_Integer_1__Integer_1__Integer_1__Integer_MANY_", (Object)new Range(repository));
        this.nativeFunctions.put((Object)"size_Any_MANY__Integer_1_", (Object)new Size(repository));
        this.nativeFunctions.put((Object)"compare_T_1__T_1__Integer_1_", (Object)new Compare(repository));
        this.nativeFunctions.put((Object)"copy_T_1__String_1__KeyExpression_MANY__T_1_", (Object)new Copy(repository, this));
        this.nativeFunctions.put((Object)"copy_T_1__String_1__T_1_", (Object)new Copy(repository, this));
        this.nativeFunctions.put((Object)"extractEnumValue_Enumeration_1__String_1__T_1_", (Object)new ExtractEnumValue());
        this.nativeFunctions.put((Object)"getAll_Class_1__T_MANY_", (Object)new GetAll());
        this.nativeFunctions.put((Object)"getAllVersions_Class_1__T_MANY_", (Object)new GetAll());
        this.nativeFunctions.put((Object)"getAllVersionsInRange_Class_1__Date_1__Date_1__T_MANY_", (Object)new GetAll());
        this.nativeFunctions.put((Object)"getAll_Class_1__Date_1__T_MANY_", (Object)new GetAll());
        this.nativeFunctions.put((Object)"getAll_Class_1__Date_1__Date_1__T_MANY_", (Object)new GetAll());
        this.nativeFunctions.put((Object)"deepFetchGetAll_Class_1__DeepFetchTempTable_1__T_MANY_", (Object)new GetAll());
        this.nativeFunctions.put((Object)"letFunction_String_1__T_m__T_m_", (Object)new Let());
        this.nativeFunctions.put((Object)"new_Class_1__String_1__KeyExpression_MANY__T_1_", (Object)new New(repository, this));
        this.nativeFunctions.put((Object)"new_Class_1__String_1__T_1_", (Object)new New(repository, this));
        this.nativeFunctions.put((Object)"divide_Number_1__Number_1__Float_1_", (Object)new Divide(repository));
        this.nativeFunctions.put((Object)"divide_Decimal_1__Decimal_1__Integer_1__Decimal_1_", (Object)new DivideDecimal(repository));
        Minus minus = new Minus(repository);
        this.nativeFunctions.put((Object)"minus_Integer_MANY__Integer_1_", (Object)minus);
        this.nativeFunctions.put((Object)"minus_Float_MANY__Float_1_", (Object)minus);
        this.nativeFunctions.put((Object)"minus_Decimal_MANY__Decimal_1_", (Object)minus);
        this.nativeFunctions.put((Object)"minus_Number_MANY__Number_1_", (Object)minus);
        Plus plus = new Plus(repository);
        this.nativeFunctions.put((Object)"plus_Integer_MANY__Integer_1_", (Object)plus);
        this.nativeFunctions.put((Object)"plus_Float_MANY__Float_1_", (Object)plus);
        this.nativeFunctions.put((Object)"plus_Decimal_MANY__Decimal_1_", (Object)plus);
        this.nativeFunctions.put((Object)"plus_Number_MANY__Number_1_", (Object)plus);
        Times times = new Times(repository);
        this.nativeFunctions.put((Object)"times_Integer_MANY__Integer_1_", (Object)times);
        this.nativeFunctions.put((Object)"times_Float_MANY__Float_1_", (Object)times);
        this.nativeFunctions.put((Object)"times_Decimal_MANY__Decimal_1_", (Object)times);
        this.nativeFunctions.put((Object)"times_Number_MANY__Number_1_", (Object)times);
        this.nativeFunctions.put((Object)"toOne_T_MANY__T_1_", (Object)new ToOne(repository));
        this.nativeFunctions.put((Object)"toOne_T_MANY__String_1__T_1_", (Object)new ToOne(repository));
        this.nativeFunctions.put((Object)"toOneMany_T_MANY__T_$1_MANY$_", (Object)new ToOneMany(repository));
        this.nativeFunctions.put((Object)"toOneMany_T_MANY__String_1__T_$1_MANY$_", (Object)new ToOneMany(repository));
        this.nativeFunctions.put((Object)"joinStrings_String_MANY__String_1__String_1__String_1__String_1_", (Object)new JoinStrings(repository));
    }

    private void registerBasicNatives(ModelRepository repository) {
        this.nativeFunctions.put((Object)"concatenate_T_MANY__T_MANY__T_MANY_", (Object)new Concatenate(this, repository));
        this.nativeFunctions.put((Object)"add_T_MANY__T_1__T_$1_MANY$_", (Object)new Add());
        this.nativeFunctions.put((Object)"add_T_MANY__Integer_1__T_1__T_$1_MANY$_", (Object)new Add());
        this.nativeFunctions.put((Object)"at_T_MANY__Integer_1__T_1_", (Object)new At());
        this.nativeFunctions.put((Object)"fold_T_MANY__Function_1__V_m__V_m_", (Object)new Fold(this));
        this.nativeFunctions.put((Object)"init_T_MANY__T_MANY_", (Object)new Init());
        this.nativeFunctions.put((Object)"removeDuplicates_T_MANY__Function_$0_1$__Function_$0_1$__T_MANY_", (Object)new RemoveDuplicates(this));
        this.nativeFunctions.put((Object)"sort_T_m__Function_$0_1$__Function_$0_1$__T_m_", (Object)new Sort(this));
        this.nativeFunctions.put((Object)"tail_T_MANY__T_MANY_", (Object)new Tail());
        this.nativeFunctions.put((Object)"print_Any_MANY__Integer_1__Nil_0_", (Object)new Print(this, repository));
        this.nativeFunctions.put((Object)"cast_Any_m__T_1__T_m_", (Object)new Cast(repository));
        this.nativeFunctions.put((Object)"eval_Function_1__V_m_", (Object)new Evaluate(this));
        this.nativeFunctions.put((Object)"eval_Function_1__T_n__V_m_", (Object)new Evaluate(this));
        this.nativeFunctions.put((Object)"eval_Function_1__T_n__U_p__V_m_", (Object)new Evaluate(this));
        this.nativeFunctions.put((Object)"eval_Function_1__T_n__U_p__W_q__V_m_", (Object)new Evaluate(this));
        this.nativeFunctions.put((Object)"eval_Function_1__T_n__U_p__W_q__X_r__V_m_", (Object)new Evaluate(this));
        this.nativeFunctions.put((Object)"eval_Function_1__T_n__U_p__W_q__X_r__Y_s__V_m_", (Object)new Evaluate(this));
        this.nativeFunctions.put((Object)"eval_Function_1__T_n__U_p__W_q__X_r__Y_s__Z_t__V_m_", (Object)new Evaluate(this));
        this.nativeFunctions.put((Object)"eval_Function_1__S_n__T_o__U_p__W_q__X_r__Y_s__Z_t__V_m_", (Object)new Evaluate(this));
        this.nativeFunctions.put((Object)"if_Boolean_1__Function_1__Function_1__T_m_", (Object)new If(this));
        this.nativeFunctions.put((Object)"match_Any_MANY__Function_$1_MANY$__T_m_", (Object)new Match(this, repository));
        this.nativeFunctions.put((Object)"dynamicNew_Class_1__KeyValue_MANY__Any_1_", (Object)new DynamicNew(this, repository));
        this.nativeFunctions.put((Object)"dynamicNew_GenericType_1__KeyValue_MANY__Any_1_", (Object)new DynamicNewGenericType(this, repository));
        this.nativeFunctions.put((Object)"dynamicNew_Class_1__KeyValue_MANY__Function_$0_1$__Function_$0_1$__Any_$0_1$__Any_1_", (Object)new DynamicNew(this, repository));
        this.nativeFunctions.put((Object)"dynamicNew_GenericType_1__KeyValue_MANY__Function_$0_1$__Function_$0_1$__Any_$0_1$__Any_1_", (Object)new DynamicNewGenericType(this, repository));
        this.nativeFunctions.put((Object)"dynamicNew_Class_1__KeyValue_MANY__Function_$0_1$__Function_$0_1$__Any_$0_1$__Function_$0_1$__Any_1_", (Object)new DynamicNew(this, repository));
        this.nativeFunctions.put((Object)"dynamicNew_GenericType_1__KeyValue_MANY__Function_$0_1$__Function_$0_1$__Any_$0_1$__Function_$0_1$__Any_1_", (Object)new DynamicNewGenericType(this, repository));
        this.nativeFunctions.put((Object)"evaluate_Function_1__List_MANY__Any_MANY_", (Object)new EvaluateAny(this, repository));
        Abs abs = new Abs(repository);
        this.nativeFunctions.put((Object)"abs_Integer_1__Integer_1_", (Object)abs);
        this.nativeFunctions.put((Object)"abs_Float_1__Float_1_", (Object)abs);
        this.nativeFunctions.put((Object)"abs_Decimal_1__Decimal_1_", (Object)abs);
        this.nativeFunctions.put((Object)"abs_Number_1__Number_1_", (Object)abs);
        this.nativeFunctions.put((Object)"evaluateAndDeactivate_T_m__T_m_", (Object)new EvaluateAndDeactivate());
        this.nativeFunctions.put((Object)"genericType_Any_MANY__GenericType_1_", (Object)new GenericType());
        this.nativeFunctions.put((Object)"genericTypeClass_GenericType_1__Class_1_", (Object)new GenericTypeClass(repository));
        this.nativeFunctions.put((Object)"getUnitValue_Any_1__Number_1_", (Object)new GetUnitValue(this, repository));
        this.nativeFunctions.put((Object)"id_Any_1__String_1_", (Object)new Id(repository));
        this.nativeFunctions.put((Object)"instanceOf_Any_1__Type_1__Boolean_1_", (Object)new InstanceOf(repository));
        this.nativeFunctions.put((Object)"newUnit_Unit_1__Number_1__Any_1_", (Object)new NewUnit(this, repository));
        this.nativeFunctions.put((Object)"format_String_1__Any_MANY__String_1_", (Object)new Format(repository, this));
        this.nativeFunctions.put((Object)"length_String_1__Integer_1_", (Object)new Length(repository));
        this.nativeFunctions.put((Object)"replace_String_1__String_1__String_1__String_1_", (Object)new Replace(repository));
        this.nativeFunctions.put((Object)"split_String_1__String_1__String_MANY_", (Object)new Split(repository));
        this.nativeFunctions.put((Object)"startsWith_String_1__String_1__Boolean_1_", (Object)new StartsWith(repository));
        SubString substring = new SubString(repository);
        this.nativeFunctions.put((Object)"substring_String_1__Integer_1__String_1_", (Object)substring);
        this.nativeFunctions.put((Object)"substring_String_1__Integer_1__Integer_1__String_1_", (Object)substring);
        this.nativeFunctions.put((Object)"toString_Any_1__String_1_", (Object)new ToString(repository, this));
        this.nativeFunctions.put((Object)"assert_Boolean_1__Function_1__Boolean_1_", (Object)new Assert(this));
    }

    public RepositoryCodeStorage getStorage() {
        return this.storage;
    }

    public Message getMessage() {
        return this.message;
    }

    public int getMaxSQLRows() {
        return this.maxSQLRows;
    }

    public ExecutionActivityListener getExecutionActivityListener() {
        return this.executionActivityListener;
    }

    public void addNativeFunction(String signature, NativeFunction function) {
        this.nativeFunctions.put((Object)signature, (Object)function);
    }

    public CoreInstance start(CoreInstance function, ListIterable<? extends CoreInstance> arguments) {
        this.cancelExecution.set(false);
        Exception isException = null;
        ExecutionSupport executionSupport = new ExecutionSupport();
        try {
            CoreInstance result;
            CoreInstance coreInstance = result = this.executeFunction(false, (org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.Function<CoreInstance>)FunctionCoreInstanceWrapper.toFunction((CoreInstance)function), arguments, new Stack<MutableMap<String, CoreInstance>>(), new Stack<MutableMap<String, CoreInstance>>(), VariableContext.newVariableContext(), null, VoidProfiler.VOID_PROFILER, new InstantiationContext(), executionSupport);
            return coreInstance;
        }
        catch (Exception ex) {
            isException = ex;
            throw ex;
        }
        finally {
            executionSupport.executionEnd(isException);
        }
    }

    public void start(CoreInstance func, ListIterable<? extends CoreInstance> arguments, OutputStream outputStream, OutputWriter writer) {
        CoreInstance result = this.start(func, arguments);
        try {
            ListIterable values = result.getValueForMetaPropertyToMany("values");
            writer.write((Object)values, outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to output stream", e);
        }
    }

    public Console getConsole() {
        return this.console;
    }

    public PureRuntime getPureRuntime() {
        return this.runtime;
    }

    NativeFunction getNativeFunction(String functionName) {
        return (NativeFunction)this.nativeFunctions.get((Object)functionName);
    }

    public String printStack(Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, final ProcessorSupport processorSupport) {
        int size = resolvedTypeParameters.size();
        String result = "";
        for (int i = 0; i < size; ++i) {
            MutableMap map = (MutableMap)resolvedTypeParameters.get(i);
            result = result + i + " :" + map.keyValuesView().collect((org.eclipse.collections.api.block.function.Function)new org.eclipse.collections.api.block.function.Function<Pair<String, CoreInstance>, String>(){

                public String valueOf(Pair<String, CoreInstance> stringCoreInstancePair) {
                    return (String)stringCoreInstancePair.getOne() + "=" + org.finos.legend.pure.m3.navigation.generictype.GenericType.print((CoreInstance)((CoreInstance)stringCoreInstancePair.getTwo()), (ProcessorSupport)processorSupport);
                }
            }).makeString() + "\n";
        }
        return result;
    }

    public CoreInstance executeLambda(LambdaFunction function, ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext context, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport) {
        if (function instanceof LambdaWithContext) {
            context = ((LambdaWithContext)function).getVariableContext();
        }
        return this.executeFunctionExecuteParams((org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.Function)function, params, resolvedTypeParameters, resolvedMultiplicityParameters, context, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport);
    }

    public CoreInstance executeLambdaFromNative(CoreInstance function, ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext context, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport) {
        if (function instanceof LambdaWithContext) {
            context = ((LambdaWithContext)function).getVariableContext();
        }
        return this.executeFunction(false, (org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.Function<CoreInstance>)LambdaFunctionCoreInstanceWrapper.toLambdaFunction((CoreInstance)function), params, resolvedTypeParameters, resolvedMultiplicityParameters, context, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport);
    }

    public void cancelExecution() {
        this.cancelExecution.set(true);
    }

    public CoreInstance executeFunctionExecuteParams(org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.Function function, ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext context, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport) {
        if (!params.isEmpty()) {
            ProcessorSupport processorSupport = this.getProcessorSupport();
            FastList parameters = FastList.newList((int)params.size());
            for (CoreInstance instance : params) {
                Executor executor = FunctionExecutionInterpreted.findValueSpecificationExecutor(instance, functionExpressionToUseInStack, processorSupport, this);
                parameters.add((Object)executor.execute(instance, resolvedTypeParameters, resolvedMultiplicityParameters, functionExpressionToUseInStack, context, profiler, instantiationContext, executionSupport, this, processorSupport));
            }
            params = parameters;
        }
        return this.executeFunction(false, (org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.Function<CoreInstance>)function, (ListIterable<? extends CoreInstance>)params, resolvedTypeParameters, resolvedMultiplicityParameters, context, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport);
    }

    public CoreInstance executeFunction(boolean limitScope, org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.Function<CoreInstance> function, ListIterable<? extends CoreInstance> params, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext varContext, CoreInstance functionExpressionToUseInStack, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport) {
        try {
            if (this.cancelExecution.compareAndSet(true, false)) {
                throw new PureExecutionException("Cancelled!");
            }
            ProcessorSupport processorSupport = this.runtime.getProcessorSupport();
            ListIterable signatureVars = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)processorSupport.function_getFunctionType(function), (String)"parameters", (ProcessorSupport)processorSupport);
            if (signatureVars.size() != params.size()) {
                StringBuilder builder = new StringBuilder();
                Function.print((Appendable)builder, function, (ProcessorSupport)processorSupport);
                String message = "Error executing the function:" + builder + ". Mismatch between the number of function parameters (" + signatureVars.size() + ") and the number of supplied arguments (" + params.size() + ")\n" + params.collect((org.eclipse.collections.api.block.function.Function)new org.eclipse.collections.api.block.function.Function<CoreInstance, String>(){

                    public String valueOf(CoreInstance coreInstance) {
                        return coreInstance.printWithoutDebug("", 3);
                    }
                }).makeString("\n");
                throw new PureExecutionException(functionExpressionToUseInStack == null ? null : functionExpressionToUseInStack.getSourceInformation(), message);
            }
            VariableContext variableContext = this.moveParametersIntoVariableContext(varContext, (ListIterable<? extends CoreInstance>)signatureVars, params, functionExpressionToUseInStack);
            if (limitScope) {
                variableContext.markVariableScopeBoundary();
            }
            if (function instanceof PackageableFunction) {
                for (CoreInstance constraint : ((PackageableFunction)function)._preConstraints()) {
                    CoreInstance definition = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)constraint, (String)"functionDefinition", (ProcessorSupport)processorSupport), (String)"expressionSequence", (ProcessorSupport)processorSupport);
                    String ruleId = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)constraint, (String)"name", (ProcessorSupport)processorSupport).getName();
                    CoreInstance evaluatedConstraint = this.executeValueSpecification(definition, new Stack<MutableMap<String, CoreInstance>>(), new Stack<MutableMap<String, CoreInstance>>(), null, variableContext, VoidProfiler.VOID_PROFILER, instantiationContext, executionSupport);
                    if (!"false".equals(evaluatedConstraint.getValueForMetaPropertyToOne("values").getName())) continue;
                    throw new PureExecutionException(functionExpressionToUseInStack == null ? null : functionExpressionToUseInStack.getSourceInformation(), "Constraint (PRE):[" + (String)ruleId + "] violated. (Function:" + function.getName() + ")");
                }
            }
            CoreInstance result = null;
            if (Instance.instanceOf(function, (String)"meta::pure::metamodel::function::NativeFunction", (ProcessorSupport)processorSupport)) {
                org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.NativeFunction function1 = NativeFunctionCoreInstanceWrapper.toNativeFunction(function);
                NativeFunction nativeFunction = (NativeFunction)this.nativeFunctions.get((Object)function1.getName());
                if (nativeFunction == null) {
                    throw new PureExecutionException(functionExpressionToUseInStack.getSourceInformation(), "The function '" + function1.getName() + "' is not supported by this execution platform");
                }
                result = nativeFunction.execute(params, resolvedTypeParameters, resolvedMultiplicityParameters, variableContext, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport, this.runtime.getContext(), this.runtime.getProcessorSupport());
            } else if (Instance.instanceOf(function, (String)"meta::pure::metamodel::function::property::Property", (ProcessorSupport)processorSupport)) {
                result = this.executeProperty(PropertyCoreInstanceWrapper.toProperty(function), true, resolvedTypeParameters, resolvedMultiplicityParameters, varContext, profiler, params, functionExpressionToUseInStack, instantiationContext, executionSupport);
            } else if (Instance.instanceOf(function, (String)"meta::pure::metamodel::function::FunctionDefinition", (ProcessorSupport)processorSupport)) {
                RichIterable expressions = FunctionDefinitionCoreInstanceWrapper.toFunctionDefinition(function)._expressionSequence();
                CoreInstance returnVal = null;
                for (CoreInstance expression : expressions) {
                    Executor executor = FunctionExecutionInterpreted.findValueSpecificationExecutor(expression, functionExpressionToUseInStack, processorSupport, this);
                    returnVal = executor.execute(expression, resolvedTypeParameters, resolvedMultiplicityParameters, functionExpressionToUseInStack, variableContext, profiler, instantiationContext, executionSupport, this, processorSupport);
                }
                result = returnVal;
            }
            MutableList instances = this.extensions.collect((org.eclipse.collections.api.block.function.Function & Serializable)x -> x.getExtraFunctionExecution(function, params, resolvedTypeParameters, resolvedMultiplicityParameters, variableContext, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport, processorSupport, this)).select((Predicate & Serializable)x -> x != null);
            if (instances.size() == 1) {
                result = (CoreInstance)instances.get(0);
            } else if (result == null) {
                throw new PureExecutionException("Unsupported function for execution " + function.getName());
            }
            if (function instanceof PackageableFunction && ((PackageableFunction)function)._postConstraints().notEmpty()) {
                try {
                    variableContext.registerValue("return", result);
                }
                catch (VariableContext.VariableNameConflictException e) {
                    throw new PureExecutionException(functionExpressionToUseInStack.getSourceInformation(), e.getMessage(), (Throwable)e);
                }
                for (CoreInstance constraint : ((PackageableFunction)function)._postConstraints()) {
                    CoreInstance definition = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)constraint, (String)"functionDefinition", (ProcessorSupport)processorSupport), (String)"expressionSequence", (ProcessorSupport)processorSupport);
                    String ruleId = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)constraint, (String)"name", (ProcessorSupport)processorSupport).getName();
                    CoreInstance evaluatedConstraint = this.executeValueSpecification(definition, new Stack<MutableMap<String, CoreInstance>>(), new Stack<MutableMap<String, CoreInstance>>(), null, variableContext, VoidProfiler.VOID_PROFILER, instantiationContext, executionSupport);
                    if (!"false".equals(evaluatedConstraint.getValueForMetaPropertyToOne("values").getName())) continue;
                    throw new PureExecutionException(functionExpressionToUseInStack == null ? null : functionExpressionToUseInStack.getSourceInformation(), "Constraint (POST):[" + ruleId + "] violated. (Function:" + function.getName() + ")");
                }
            }
            return result;
        }
        catch (PureAssertFailException e) {
            SourceInformation sourceInfo;
            SourceInformation sourceInformation = sourceInfo = functionExpressionToUseInStack == null ? null : functionExpressionToUseInStack.getSourceInformation();
            if (sourceInfo != null && sourceInfo != e.getSourceInformation()) {
                String testPurePlatformFileName = "/platform/pure/basics/tests/";
                boolean allFromAssert = true;
                for (SourceInformation si : e.getPureStackSourceInformation()) {
                    allFromAssert = allFromAssert && si != null && si.getSourceId().startsWith(testPurePlatformFileName);
                }
                if (allFromAssert && !sourceInfo.getSourceId().startsWith(testPurePlatformFileName)) {
                    throw new PureAssertFailException(sourceInfo, e.getInfo());
                }
                throw new PureAssertFailException(sourceInfo, e.getInfo(), e);
            }
            throw e;
        }
        catch (PureException e) {
            SourceInformation sourceInfo;
            if (functionExpressionToUseInStack != null && (sourceInfo = functionExpressionToUseInStack.getSourceInformation()) != null && !sourceInfo.equals((Object)e.getSourceInformation())) {
                throw new PureExecutionException(sourceInfo, e.getInfo(), (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (functionExpressionToUseInStack != null) {
                SourceInformation sourceInfo = functionExpressionToUseInStack.getSourceInformation();
                PureException pureException = PureException.findPureException((Throwable)e);
                if (pureException == null) {
                    if (sourceInfo != null) {
                        throw new PureExecutionException(sourceInfo, e.getMessage(), (Throwable)e);
                    }
                } else {
                    if (sourceInfo != null && sourceInfo != pureException.getSourceInformation()) {
                        if (pureException instanceof PureAssertFailException) {
                            throw new PureAssertFailException(sourceInfo, pureException.getInfo(), (PureAssertFailException)((Object)pureException));
                        }
                        throw new PureExecutionException(sourceInfo, pureException.getInfo(), (Throwable)pureException);
                    }
                    throw pureException;
                }
            }
            throw e;
        }
    }

    public CoreInstance executeProperty(Property property, boolean route, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, VariableContext variableContext, Profiler profiler, ListIterable<? extends CoreInstance> parameters, CoreInstance functionExpressionToUseInStack, InstantiationContext instantiationContext, ExecutionSupport executionSupport) throws PureExecutionException {
        CoreInstance funcToMany;
        ProcessorSupport processorSupport = this.runtime.getProcessorSupport();
        CoreInstance source = (CoreInstance)parameters.get(0);
        boolean executable = ValueSpecification.isExecutable((CoreInstance)source, (ProcessorSupport)processorSupport);
        org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.multiplicity.Multiplicity multiplicity = property._multiplicity();
        CoreInstance evaluatedSource = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)(executable ? FunctionExecutionInterpreted.findValueSpecificationExecutor(source, (CoreInstance)property, processorSupport, this).execute(source, resolvedTypeParameters, resolvedMultiplicityParameters, (CoreInstance)property, variableContext, profiler, instantiationContext, executionSupport, this, processorSupport) : source), (String)"values", (ProcessorSupport)processorSupport);
        if (evaluatedSource == null) {
            throw new PureExecutionException(functionExpressionToUseInStack.getSourceInformation(), "The system can't execute a property function '" + property._name() + "' on a null instance.");
        }
        CoreInstance overrides = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)evaluatedSource, (String)"elementOverride", (ProcessorSupport)processorSupport);
        if (Multiplicity.isToOne((CoreInstance)multiplicity, (boolean)false)) {
            CoreInstance funcToOne;
            CoreInstance coreInstance = funcToOne = overrides != null ? Instance.getValueForMetaPropertyToOneResolved((CoreInstance)overrides, (String)"getterOverrideToOne", (ProcessorSupport)processorSupport) : null;
            if (route && funcToOne != null && !"elementOverride".equals(property._name()) && !"hiddenPayload".equals(property._name()) && !Instance.instanceOf((CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)property._classifierGenericType().getValueForMetaPropertyToMany("typeArguments").get(1)), (String)"rawType", (ProcessorSupport)processorSupport), (String)"meta::pure::metamodel::type::DataType", (ProcessorSupport)processorSupport)) {
                return this.executeFunction(true, (org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.Function<CoreInstance>)FunctionCoreInstanceWrapper.toFunction((CoreInstance)funcToOne), (ListIterable<? extends CoreInstance>)FastList.newListWith((Object[])new CoreInstance[]{ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)evaluatedSource, (boolean)executable, (ProcessorSupport)processorSupport), ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)property, (boolean)executable, (ProcessorSupport)processorSupport)}), resolvedTypeParameters, resolvedMultiplicityParameters, variableContext, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport);
            }
            CoreInstance result = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)evaluatedSource, (CoreInstance)property, (ProcessorSupport)processorSupport);
            return ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)result, (boolean)executable, (ProcessorSupport)processorSupport);
        }
        CoreInstance coreInstance = funcToMany = overrides != null ? Instance.getValueForMetaPropertyToOneResolved((CoreInstance)overrides, (String)"getterOverrideToMany", (ProcessorSupport)processorSupport) : null;
        if (route && funcToMany != null && !"hiddenPayload".equals(property._name()) && !Instance.instanceOf((CoreInstance)Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)property._classifierGenericType().getValueForMetaPropertyToMany("typeArguments").get(1)), (String)"rawType", (ProcessorSupport)processorSupport), (String)"meta::pure::metamodel::type::DataType", (ProcessorSupport)processorSupport)) {
            return this.executeFunction(true, (org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.Function<CoreInstance>)FunctionCoreInstanceWrapper.toFunction((CoreInstance)funcToMany), (ListIterable<? extends CoreInstance>)FastList.newListWith((Object[])new CoreInstance[]{ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)evaluatedSource, (boolean)executable, (ProcessorSupport)processorSupport), ValueSpecificationBootstrap.wrapValueSpecification((CoreInstance)property, (boolean)executable, (ProcessorSupport)processorSupport)}), resolvedTypeParameters, resolvedMultiplicityParameters, variableContext, functionExpressionToUseInStack, profiler, instantiationContext, executionSupport);
        }
        ListIterable result = Instance.getValueForMetaPropertyToManyResolved((CoreInstance)evaluatedSource, (CoreInstance)property, (ProcessorSupport)processorSupport);
        return ValueSpecificationBootstrap.wrapValueSpecification_ForFunctionReturnValue((CoreInstance)org.finos.legend.pure.m3.navigation.generictype.GenericType.resolvePropertyReturnType((CoreInstance)Instance.extractGenericTypeFromInstance((CoreInstance)evaluatedSource, (ProcessorSupport)processorSupport), (CoreInstance)property, (ProcessorSupport)processorSupport), (ListIterable)result, (boolean)executable, (ProcessorSupport)processorSupport);
    }

    public CoreInstance executeValueSpecification(CoreInstance instance, Stack<MutableMap<String, CoreInstance>> resolvedTypeParameters, Stack<MutableMap<String, CoreInstance>> resolvedMultiplicityParameters, CoreInstance functionExpressionToUseInStack, VariableContext variableContext, Profiler profiler, InstantiationContext instantiationContext, ExecutionSupport executionSupport) throws PureExecutionException {
        ProcessorSupport processorSupport = this.getProcessorSupport();
        Executor executor = FunctionExecutionInterpreted.findValueSpecificationExecutor(instance, functionExpressionToUseInStack, processorSupport, this);
        return executor.execute(instance, resolvedTypeParameters, resolvedMultiplicityParameters, functionExpressionToUseInStack, variableContext, profiler, instantiationContext, executionSupport, this, processorSupport);
    }

    public static Executor findValueSpecificationExecutor(CoreInstance instance, CoreInstance functionExpressionToUseInStack, ProcessorSupport processorSupport, FunctionExecutionInterpreted functionExecutionInterpreted) throws PureExecutionException {
        if (!ValueSpecification.isExecutable((CoreInstance)instance, (ProcessorSupport)processorSupport)) {
            return NonExecutableValueSpecificationExecutor.INSTANCE;
        }
        if (functionExecutionInterpreted.cancelExecution.compareAndSet(true, false)) {
            throw new PureExecutionException("Execution cancelled!");
        }
        if (Instance.instanceOf((CoreInstance)instance, (String)"meta::pure::metamodel::valuespecification::FunctionExpression", (ProcessorSupport)processorSupport)) {
            return FunctionExpressionExecutor.INSTANCE;
        }
        if (Instance.instanceOf((CoreInstance)instance, (String)"meta::pure::metamodel::valuespecification::VariableExpression", (ProcessorSupport)processorSupport)) {
            return VariableExpressionExecutor.INSTANCE;
        }
        if (Instance.instanceOf((CoreInstance)instance, (String)"meta::pure::metamodel::valuespecification::InstanceValue", (ProcessorSupport)processorSupport)) {
            return InstanceValueExecutor.INSTANCE;
        }
        if (Instance.instanceOf((CoreInstance)instance, (String)"meta::pure::router::metamodel::clustering::ClusteredValueSpecification", (ProcessorSupport)processorSupport)) {
            return ClusteredValueSpecificationExecutor.INSTANCE;
        }
        if (Instance.instanceOf((CoreInstance)instance, (String)"meta::pure::router::RoutedValueSpecification", (ProcessorSupport)processorSupport)) {
            return RoutedValueSpecificationExecutor.INSTANCE;
        }
        throw new PureExecutionException(functionExpressionToUseInStack.getSourceInformation(), "A new type (" + processorSupport.getClassifier(instance).getName() + ") must have been introduced in the ValueSpecification tree.");
    }

    private VariableContext moveParametersIntoVariableContext(VariableContext variableContext, ListIterable<? extends CoreInstance> signatureVars, ListIterable<? extends CoreInstance> parameters, CoreInstance functionExpressionToUseInStack) {
        VariableContext newVarContext = VariableContext.newVariableContext(variableContext);
        try {
            ProcessorSupport processorSupport = this.runtime.getProcessorSupport();
            int length = signatureVars.size();
            for (int i = 0; i < length; ++i) {
                CoreInstance varName = Instance.getValueForMetaPropertyToOneResolved((CoreInstance)((CoreInstance)signatureVars.get(i)), (String)"name", (ProcessorSupport)processorSupport);
                newVarContext.registerValue(varName == null ? "Unknown" : varName.getName(), (CoreInstance)parameters.get(i));
            }
        }
        catch (VariableContext.VariableNameConflictException e) {
            throw new PureExecutionException(functionExpressionToUseInStack.getSourceInformation(), e.getMessage(), (Throwable)e);
        }
        return newVarContext;
    }

    public boolean isFullyInitializedForExecution() {
        return this.runtime != null && this.runtime.isFullyInitialized();
    }

    public void resetEventHandlers() {
    }

    public ProcessorSupport getProcessorSupport() {
        return this.processorSupport;
    }

    public PureRuntime getRuntime() {
        return this.runtime;
    }

    public OutputWriter newOutputWriter() {
        return new OutputWriterInterpreted();
    }
}

