/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.pure.runtime.java.interpreted;

import java.io.Serializable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.map.strategy.mutable.UnifiedMapWithHashingStrategy;
import org.eclipse.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import org.eclipse.collections.impl.utility.Iterate;
import org.finos.legend.pure.m3.navigation.Instance;
import org.finos.legend.pure.m3.navigation.ProcessorSupport;
import org.finos.legend.pure.m3.navigation._class._Class;
import org.finos.legend.pure.m3.navigation.type.Type;
import org.finos.legend.pure.m3.navigation.valuespecification.ValueSpecification;
import org.finos.legend.pure.m4.coreinstance.CoreInstance;
import org.finos.legend.pure.m4.coreinstance.primitive.PrimitiveCoreInstance;

public class EqualityUtilities {
    private EqualityUtilities() {
    }

    public static boolean eq(CoreInstance left, CoreInstance right, ProcessorSupport processorSupport) {
        if (left == right) {
            return true;
        }
        if (left instanceof PrimitiveCoreInstance && right instanceof PrimitiveCoreInstance) {
            return processorSupport.getClassifier(left).getName().equals(processorSupport.getClassifier(right).getName()) && ((PrimitiveCoreInstance)left).getValue().equals(((PrimitiveCoreInstance)right).getValue());
        }
        CoreInstance type = processorSupport.getClassifier(left);
        if (type != processorSupport.getClassifier(right)) {
            return false;
        }
        return Type.isPrimitiveType((CoreInstance)type, (ProcessorSupport)processorSupport) && left.getName().equals(right.getName());
    }

    public static boolean equal(CoreInstance left, CoreInstance right, RichIterable<? extends CoreInstance> external, ProcessorSupport processorSupport) {
        if (left == right) {
            return true;
        }
        if (left instanceof PrimitiveCoreInstance && right instanceof PrimitiveCoreInstance) {
            return processorSupport.getClassifier(left).getName().equals(processorSupport.getClassifier(right).getName()) && ((PrimitiveCoreInstance)left).getValue().equals(((PrimitiveCoreInstance)right).getValue());
        }
        CoreInstance type = processorSupport.getClassifier(left);
        if (type != processorSupport.getClassifier(right)) {
            return false;
        }
        if (Type.isPrimitiveType((CoreInstance)type, (ProcessorSupport)processorSupport)) {
            return left.getName().equals(right.getName());
        }
        if (Instance.instanceOf((CoreInstance)left, (String)"meta::pure::metamodel::valuespecification::InstanceValue", (ProcessorSupport)processorSupport)) {
            return EqualityUtilities.equal((ListIterable<? extends CoreInstance>)ValueSpecification.getValues((CoreInstance)left, (ProcessorSupport)processorSupport), (ListIterable<? extends CoreInstance>)ValueSpecification.getValues((CoreInstance)right, (ProcessorSupport)processorSupport), processorSupport);
        }
        ListIterable keys = _Class.getEqualityKeyProperties((CoreInstance)type, (ProcessorSupport)processorSupport);
        if (external.isEmpty() && keys.isEmpty()) {
            return false;
        }
        for (CoreInstance key : external.notEmpty() ? external : keys) {
            if (EqualityUtilities.equal((ListIterable<? extends CoreInstance>)Instance.getValueForMetaPropertyToManyResolved((CoreInstance)left, (CoreInstance)key, (ProcessorSupport)processorSupport), (ListIterable<? extends CoreInstance>)Instance.getValueForMetaPropertyToManyResolved((CoreInstance)right, (CoreInstance)key, (ProcessorSupport)processorSupport), processorSupport)) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(ListIterable<? extends CoreInstance> left, ListIterable<? extends CoreInstance> right, ProcessorSupport processorSupport) {
        int size = left.size();
        if (right.size() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (EqualityUtilities.equal((CoreInstance)left.get(i), (CoreInstance)right.get(i), (RichIterable<? extends CoreInstance>)Lists.immutable.empty(), processorSupport)) continue;
            return false;
        }
        return true;
    }

    public static int coreInstanceHashCode(CoreInstance instance, ListIterable<? extends CoreInstance> externalKeys, ProcessorSupport processorSupport) {
        ListIterable keys;
        CoreInstance type = processorSupport.getClassifier(instance);
        if (Type.isPrimitiveType((CoreInstance)type, (ProcessorSupport)processorSupport)) {
            return type.hashCode() ^ instance.getName().hashCode();
        }
        if (Instance.instanceOf((CoreInstance)instance, (String)"meta::pure::metamodel::valuespecification::ValueSpecification", (ProcessorSupport)processorSupport)) {
            int hashCode = type.hashCode();
            for (CoreInstance value : ValueSpecification.getValues((CoreInstance)instance, (ProcessorSupport)processorSupport)) {
                hashCode = 31 * hashCode + EqualityUtilities.coreInstanceHashCode(value, (ListIterable<? extends CoreInstance>)externalKeys, processorSupport);
            }
            return hashCode;
        }
        ListIterable listIterable = keys = externalKeys == null || externalKeys.isEmpty() ? _Class.getEqualityKeyProperties((CoreInstance)processorSupport.getClassifier(instance), (ProcessorSupport)processorSupport) : externalKeys;
        if (keys.isEmpty()) {
            return instance.hashCode();
        }
        int hashCode = type.hashCode();
        for (CoreInstance key : keys) {
            for (CoreInstance value : Instance.getValueForMetaPropertyToManyResolved((CoreInstance)instance, (CoreInstance)key, (ProcessorSupport)processorSupport)) {
                hashCode = 31 * hashCode + EqualityUtilities.coreInstanceHashCode(value, (ListIterable<? extends CoreInstance>)externalKeys, processorSupport);
            }
        }
        return hashCode;
    }

    public static HashingStrategy<CoreInstance> newCoreInstanceHashingStrategy(ProcessorSupport processorSupport) {
        return new CoreInstanceHashingStrategy((ListIterable)Lists.immutable.empty(), processorSupport);
    }

    public static HashingStrategy<CoreInstance> newCoreInstanceHashingStrategy(ListIterable<? extends CoreInstance> keys, ProcessorSupport processorSupport) {
        return new CoreInstanceHashingStrategy(keys, processorSupport);
    }

    public static boolean containsCoreInstance(Iterable<? extends CoreInstance> iterable, CoreInstance instance, ProcessorSupport processorSupport) {
        return iterable instanceof CoreInstanceMutableSet ? ((CoreInstanceMutableSet)((Object)iterable)).contains(instance) : Iterate.anySatisfy(iterable, (Predicate & Serializable)i -> EqualityUtilities.equal(instance, i, (RichIterable<? extends CoreInstance>)Lists.immutable.empty(), processorSupport));
    }

    public static <T extends CoreInstance> MutableSet<T> newCoreInstanceSet(ProcessorSupport processorSupport) {
        return new CoreInstanceMutableSet(processorSupport);
    }

    public static <T extends CoreInstance> MutableSet<T> newCoreInstanceSet(ProcessorSupport processorSupport, int size) {
        return new CoreInstanceMutableSet(processorSupport, size);
    }

    public static <K extends CoreInstance, V> MutableMap<K, V> newCoreInstanceMap(ProcessorSupport processorSupport) {
        return new CoreInstanceMutableMap(processorSupport);
    }

    public static <K extends CoreInstance, V> MutableMap<K, V> newCoreInstanceMap(ProcessorSupport processorSupport, int size) {
        return new CoreInstanceMutableMap(processorSupport, size);
    }

    private static class CoreInstanceMutableMap<K extends CoreInstance, V>
    extends UnifiedMapWithHashingStrategy<K, V> {
        @Deprecated
        public CoreInstanceMutableMap() {
        }

        private CoreInstanceMutableMap(ProcessorSupport processorSupport) {
            super(EqualityUtilities.newCoreInstanceHashingStrategy(processorSupport));
        }

        private CoreInstanceMutableMap(ProcessorSupport processorSupport, int size) {
            super(EqualityUtilities.newCoreInstanceHashingStrategy(processorSupport), size);
        }
    }

    private static class CoreInstanceMutableSet<T extends CoreInstance>
    extends UnifiedSetWithHashingStrategy<T> {
        @Deprecated
        public CoreInstanceMutableSet() {
        }

        private CoreInstanceMutableSet(ProcessorSupport processorSupport) {
            super(EqualityUtilities.newCoreInstanceHashingStrategy(processorSupport));
        }

        private CoreInstanceMutableSet(ProcessorSupport processorSupport, int size) {
            super(EqualityUtilities.newCoreInstanceHashingStrategy(processorSupport), size);
        }
    }

    private static class CoreInstanceHashingStrategy
    implements HashingStrategy<CoreInstance> {
        private final ProcessorSupport processorSupport;
        private final ListIterable<? extends CoreInstance> properties;

        private CoreInstanceHashingStrategy(ListIterable<? extends CoreInstance> properties, ProcessorSupport processorSupport) {
            this.processorSupport = processorSupport;
            this.properties = properties;
        }

        public int computeHashCode(CoreInstance instance) {
            return EqualityUtilities.coreInstanceHashCode(instance, this.properties, this.processorSupport);
        }

        public boolean equals(CoreInstance instance, CoreInstance instance2) {
            return EqualityUtilities.equal(instance, instance2, this.properties, this.processorSupport);
        }
    }
}

