/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.external.format.xml.shared;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.collections.api.factory.Lists;
import org.finos.legend.engine.external.format.xml.shared.XmlUtils;
import org.finos.legend.engine.shared.core.util.LimitedByteArrayOutputStream;

public class XmlReader {
    private static final int EVENT_BUFFER_SIZE = 4096;
    private static final int DEFAULT_CAPTURE_CAPACITY = 4096;
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newFactory();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newFactory();
    private final XMLEventReader reader;
    private final Function<XMLStreamException, ? extends RuntimeException> exceptionHandler;
    private final int captureCapacity;
    private EventBuffer eventBuffer;
    private ReadState currentState;

    private XmlReader(XMLEventReader reader, Function<XMLStreamException, ? extends RuntimeException> exceptionHandler) {
        this(reader, exceptionHandler, 4096);
    }

    private XmlReader(XMLEventReader reader, Function<XMLStreamException, ? extends RuntimeException> exceptionHandler, int captureCapacity) {
        this.reader = reader;
        this.exceptionHandler = exceptionHandler;
        this.captureCapacity = captureCapacity;
        this.eventBuffer = new EventBuffer();
        this.currentState = new NoTransaction();
    }

    public boolean isStartDocument() {
        return this.currentEvent().isStartDocument();
    }

    public boolean isEndDocument() {
        return this.currentEvent().isEndDocument();
    }

    public boolean isStartElement() {
        return this.currentEvent().isStartElement();
    }

    public boolean isStartElement(QName name) {
        return this.isStartElement() && name.equals(this.getName());
    }

    public boolean isStartElement(String namespace, String localPart) {
        return this.isStartElement() && namespace.equals(this.getName().getNamespaceURI()) && localPart.equals(this.getName().getLocalPart());
    }

    public boolean isStartElementLenient(String localPart) {
        return this.isStartElement() && XmlUtils.lenientMatch(localPart, this.getName().getLocalPart());
    }

    public boolean isXsiNil() {
        if (this.isStartElement()) {
            String nil = this.getAttributeValue(XmlUtils.XSI_NIL);
            return nil != null && (nil.equals("true") || nil.equals("1"));
        }
        return false;
    }

    public boolean isEndElement() {
        return this.currentEvent().isEndElement();
    }

    public boolean isEndElement(QName name) {
        return this.isEndElement() && name.equals(this.getName());
    }

    public boolean isEndElement(String namespace, String localPart) {
        return this.isEndElement() && namespace.equals(this.getName().getNamespaceURI()) && localPart.equals(this.getName().getLocalPart());
    }

    public QName getName() {
        return this.currentEvent().isStartElement() ? this.currentEvent().asStartElement().getName() : this.currentEvent().asEndElement().getName();
    }

    public String getElementText() {
        StringBuilder text = new StringBuilder();
        this.next();
        while (this.hasNext() && !this.isEndElement()) {
            if (this.isStartElement() || this.isEndDocument()) {
                throw this.exceptionHandler.apply(new XMLStreamException("Unexpected element in text content", this.currentElement().getLocation()));
            }
            if (this.currentEvent().isCharacters()) {
                Characters characters = this.currentEvent().asCharacters();
                text.append(characters.getData());
            }
            this.next();
        }
        return text.toString();
    }

    public String getAttributeValue(QName name) {
        return this.getAttributeValue(name.getNamespaceURI(), name.getLocalPart());
    }

    public String getAttributeValue(String localPart) {
        return this.getAttributeValue(null, localPart);
    }

    public String getAttributeValue(String namespace, String localPart) {
        Iterator<Attribute> attributes = this.currentElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (namespace != null && !namespace.equals(attribute.getName().getNamespaceURI()) || !localPart.equals(attribute.getName().getLocalPart())) continue;
            return attribute.getValue();
        }
        return null;
    }

    public String getAttributeValueLenient(String attributeName) {
        Iterator<Attribute> attributes = this.currentElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!XmlUtils.lenientMatch(attributeName, attribute.getName().getLocalPart())) continue;
            return attribute.getValue();
        }
        return null;
    }

    public String getAttributeValueOrDefault(QName name, String dflt) {
        String value = this.getAttributeValue(name);
        return value == null ? dflt : value;
    }

    public String getAttributeValueOrDefault(String localPart, String dflt) {
        String value = this.getAttributeValue(localPart);
        return value == null ? dflt : value;
    }

    public String getAttributeValueOrDefault(String namespace, String localPart, String dflt) {
        String value = this.getAttributeValue(namespace, localPart);
        return value == null ? dflt : value;
    }

    public String getAttributeValueLenientOrDefault(String attributeName, String dflt) {
        String value = this.getAttributeValueLenient(attributeName);
        return value == null ? dflt : value;
    }

    public boolean hasAttribute(QName name) {
        return this.hasAttribute(name.getNamespaceURI(), name.getNamespaceURI());
    }

    public boolean hasAttribute(String namespace, String localPart) {
        Iterator<Attribute> attributes = this.currentElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (namespace != null && (!namespace.equals(attribute.getName().getNamespaceURI()) || !localPart.equals(attribute.getName().getLocalPart()))) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeLenient(String attributeName) {
        return this.resolveLenientAttributeName(attributeName) != null;
    }

    public String resolveLenientAttributeName(String attributeName) {
        Iterator<Attribute> attributes = this.currentElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!XmlUtils.lenientMatch(attributeName, attribute.getName().getLocalPart())) continue;
            return attribute.getName().toString();
        }
        return null;
    }

    public void skipElement() {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Cannot goto end of element");
        }
        QName name = this.getName();
        int depth = 0;
        while (depth > 0 || !this.isEndElement(name)) {
            this.nextTag();
            if (this.isStartElement(name)) {
                ++depth;
                continue;
            }
            if (!this.isEndElement(name)) continue;
            --depth;
        }
        this.nextTag();
    }

    public void nextTag() {
        int event = this.next();
        while (event != 8 && event != 1 && event != 2) {
            event = this.next();
        }
    }

    public Supplier<NamespaceContext> getNamespaceContextSupplier() {
        return () -> this.currentState.lastStartElement.asStartElement().getNamespaceContext();
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            throw this.exceptionHandler.apply(e);
        }
    }

    public Location getLocation() {
        return this.currentEvent().getLocation();
    }

    public String describe() {
        StringBuilder builder = new StringBuilder();
        switch (this.currentEvent().getEventType()) {
            case 1: {
                builder.append("START_ELEMENT ").append(this.getName());
                break;
            }
            case 2: {
                builder.append("END_ELEMENT ").append(this.getName());
                break;
            }
            case 4: {
                Characters characters = this.currentEvent().asCharacters();
                if (characters.isWhiteSpace()) {
                    builder.append("WHITESPACE");
                    break;
                }
                if (characters.getData().length() > 50) {
                    builder.append("CHARACTERS ").append(characters.getData(), 0, 50).append("...");
                    break;
                }
                builder.append("CHARACTERS ").append(characters.getData());
                break;
            }
            case 10: {
                builder.append("ATTRIBUTE");
                break;
            }
            case 13: {
                builder.append("NAMESPACE");
                break;
            }
            case 3: {
                builder.append("PROCESSING_INSTRUCTION");
                break;
            }
            case 5: {
                builder.append("COMMENT");
                break;
            }
            case 7: {
                builder.append("START_DOCUMENT");
                break;
            }
            case 8: {
                builder.append("END_DOCUMENT");
                break;
            }
            case 11: {
                builder.append("DTD");
                break;
            }
            default: {
                builder.append("UNKNOWN: ").append(this.currentEvent().getEventType());
            }
        }
        Location location = this.currentEvent().getLocation();
        builder.append(" @ ").append(location.getLineNumber()).append(":").append(location.getColumnNumber());
        return builder.toString();
    }

    public String getRawElementContents() {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            XMLEventWriter writer = XML_OUTPUT_FACTORY.createXMLEventWriter(bytes);
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            writer.setNamespaceContext(this.currentElement().getNamespaceContext());
            this.next();
            int depth = 0;
            writer.add(eventFactory.createStartElement("", "", "WRAPPER"));
            while (this.hasNext() && (depth != 0 || !this.isEndElement())) {
                switch (this.currentEvent().getEventType()) {
                    case 1: {
                        ++depth;
                        writer.add(this.currentEvent());
                        break;
                    }
                    case 2: {
                        --depth;
                        writer.add(this.currentEvent());
                        break;
                    }
                    case 4: 
                    case 5: {
                        writer.add(this.currentEvent());
                    }
                }
                this.next();
            }
            writer.add(eventFactory.createEndElement("", "", "WRAPPER"));
            String s = bytes.toString("UTF-8");
            return s.replace("<WRAPPER>", "").replace("</WRAPPER>", "").replace("<WRAPPER/>", "");
        }
        catch (XMLStreamException e) {
            throw this.exceptionHandler.apply(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getRawElementTextContents() {
        StringBuilder text = new StringBuilder();
        int depth = 0;
        while (this.hasNext() && (depth != 0 || !this.isEndElement())) {
            switch (this.currentEvent().getEventType()) {
                case 1: {
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                    break;
                }
                case 4: {
                    Characters characters = this.currentEvent().asCharacters();
                    text.append(characters.getData());
                }
            }
            this.next();
        }
        return text.toString();
    }

    public Transaction newTransaction() {
        this.currentState = new Transaction(this.currentState);
        return (Transaction)this.currentState;
    }

    public void startCapture() {
        this.currentState.startCapture();
    }

    public String endCapture() {
        return this.currentState.endCapture();
    }

    public boolean hasNext() {
        return this.currentState.hasNext();
    }

    public int next() {
        this.currentState.advance();
        return this.currentEvent().getEventType();
    }

    private XMLEvent currentEvent() {
        return this.currentState.currentEvent;
    }

    private StartElement currentElement() {
        return this.currentEvent().asStartElement();
    }

    public static XmlReader newReader(InputStream stream) {
        return XmlReader.newReader((Reader)new InputStreamReader(stream), (String)null);
    }

    public static XmlReader newReader(InputStream stream, String id) {
        return XmlReader.newReader((Reader)new InputStreamReader(stream), id);
    }

    public static XmlReader newReader(Reader reader) {
        return XmlReader.newReader(reader, (String)null);
    }

    public static XmlReader newReader(Reader reader, String id) {
        return XmlReader.newReader(reader, id, e -> {
            throw new RuntimeException(e.getMessage(), (Throwable)e);
        });
    }

    public static XmlReader newReader(Reader reader, Function<XMLStreamException, ? extends RuntimeException> exceptionHandler) {
        return XmlReader.newReader(reader, null, exceptionHandler);
    }

    public static XmlReader newReader(Reader reader, String id, Function<XMLStreamException, ? extends RuntimeException> exceptionHandler) {
        try {
            return new XmlReader(XML_INPUT_FACTORY.createXMLEventReader(id, reader), exceptionHandler);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public class Transaction
    extends ReadState
    implements Closeable {
        private final ReadState parent;

        private Transaction(ReadState parent) {
            this.parent = parent;
            this.index = parent.index;
            this.currentEvent = parent.currentEvent;
        }

        @Override
        void advance() {
            this.setCurrentEvent(XmlReader.this.eventBuffer.peek(++this.index));
        }

        public void commit() {
            this.parent.advanceTo(this.index);
        }

        @Override
        public void close() {
            XmlReader.this.currentState = this.parent;
        }
    }

    private class NoTransaction
    extends ReadState {
        NoTransaction() {
            this.advanceTo(0L);
        }

        @Override
        void advance() {
            this.setCurrentEvent(XmlReader.this.eventBuffer.moveTo(++this.index));
        }
    }

    private abstract class ReadState {
        long index = -1L;
        XMLEvent currentEvent;
        Capture capture;
        XMLEvent lastStartElement;

        private ReadState() {
        }

        abstract void advance();

        void setCurrentEvent(XMLEvent event) {
            if (this.capture != null) {
                this.capture.add(this.currentEvent);
            }
            this.currentEvent = event;
            if (event.isStartElement()) {
                this.lastStartElement = event;
            }
        }

        void advanceTo(long index) {
            while (this.index < index) {
                this.advance();
            }
        }

        boolean hasNext() {
            return XmlReader.this.eventBuffer.hasEvent(this.index + 1L);
        }

        void startCapture() {
            if (this.capture != null) {
                throw new IllegalStateException("Nested captures not supported");
            }
            this.capture = new Capture(XmlReader.this.captureCapacity);
        }

        String endCapture() {
            if (this.capture == null) {
                throw new IllegalStateException("No capture started");
            }
            String result = this.capture.finish();
            this.capture = null;
            return result;
        }
    }

    private static class Capture {
        private XMLEventWriter captureWriter;
        private ByteArrayOutputStream captureBytes;
        private List<XMLEvent> captureDeferredWhitespace;
        private boolean capturingText;

        Capture(int capacity) {
            try {
                this.captureBytes = new LimitedByteArrayOutputStream(capacity);
                this.captureWriter = XML_OUTPUT_FACTORY.createXMLEventWriter(this.captureBytes);
                this.captureDeferredWhitespace = Lists.mutable.empty();
                this.capturingText = false;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        String finish() {
            try {
                this.captureWriter.flush();
                return this.captureBytes.toString("UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        void add(XMLEvent event) {
            try {
                if (event.isStartElement() || event.isEndElement()) {
                    this.captureWriter.add(event);
                    this.captureDeferredWhitespace.clear();
                    this.capturingText = false;
                } else if (event.isCharacters()) {
                    Characters characters = event.asCharacters();
                    if (!this.capturingText && characters.isWhiteSpace()) {
                        this.captureDeferredWhitespace.add(characters);
                    } else {
                        for (XMLEvent deferred : this.captureDeferredWhitespace) {
                            this.captureWriter.add(deferred);
                        }
                        this.captureWriter.add(event);
                        this.captureDeferredWhitespace.clear();
                        this.capturingText = true;
                    }
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class EventBuffer {
        private XMLEvent[] events = new XMLEvent[4096];
        private long low;
        private long high;
        private long max;

        EventBuffer() {
            if (XmlReader.this.reader.hasNext()) {
                this.max = Long.MAX_VALUE;
                this.high = -1L;
                this.moveTo(0L);
            } else {
                this.max = -1L;
            }
        }

        boolean hasEvent(long index) {
            this.fillTo(index);
            return index <= this.max;
        }

        XMLEvent peek(long index) {
            this.fillTo(index);
            if (index > this.max) {
                throw new IllegalStateException("Attempting to read beyond end of XML events");
            }
            return this.events[(int)(index % 4096L)];
        }

        XMLEvent moveTo(long index) {
            this.low = index;
            return this.peek(index);
        }

        void fillTo(long index) {
            while (index > this.high && index < this.max) {
                if (this.high - this.low >= 4096L) {
                    throw new IllegalStateException("Cannot buffer more than 4096 XML events");
                }
                try {
                    ++this.high;
                    this.events[(int)(this.high % 4096L)] = XmlReader.this.reader.nextEvent();
                    if (XmlReader.this.reader.hasNext()) continue;
                    this.max = this.high;
                }
                catch (XMLStreamException e) {
                    throw (RuntimeException)XmlReader.this.exceptionHandler.apply(e);
                }
            }
        }
    }
}

