/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.pure.runtime.compiler.shared;

import java.io.Serializable;
import java.util.List;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.utility.ListIterate;
import org.finos.legend.engine.language.pure.compiler.Compiler;
import org.finos.legend.engine.language.pure.compiler.toPureGraph.HelperModelBuilder;
import org.finos.legend.engine.language.pure.compiler.toPureGraph.PureModel;
import org.finos.legend.engine.language.pure.grammar.from.PureGrammarParser;
import org.finos.legend.engine.protocol.pure.v1.model.context.PureModelContextData;
import org.finos.legend.engine.protocol.pure.v1.model.packageableElement.domain.Function;
import org.finos.legend.engine.protocol.pure.v1.model.packageableElement.section.SectionIndex;
import org.finos.legend.engine.shared.core.deployment.DeploymentMode;
import org.finos.legend.engine.shared.core.operational.Assert;
import org.finos.legend.pure.m3.coreinstance.Package;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.ModelElementAccessor;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.PackageableElement;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.function.ConcreteFunctionDefinition;
import org.finos.legend.pure.m3.coreinstance.meta.pure.metamodel.valuespecification.ValueSpecification;
import org.finos.legend.pure.runtime.java.compiled.metadata.Metadata;

public class LegendCompile {
    public static MutableList<PackageableElement> doCompile(String code, Metadata metadata) {
        PureModelContextData data = PureGrammarParser.newInstance().parseModel(code);
        PureModel pm = Compiler.compile((PureModelContextData)data, (DeploymentMode)DeploymentMode.PROD, null, (String)"", (Metadata)metadata);
        return LegendCompile.extractCreatedElementFromCompiledGraph(data, pm);
    }

    public static ValueSpecification doCompileVS(String code, Metadata metadata) {
        PureModelContextData data = PureGrammarParser.newInstance().parseModel("function a::f():Any[*]{" + code + "}");
        PureModel pm = Compiler.compile((PureModelContextData)data, (DeploymentMode)DeploymentMode.PROD, null, (String)"", (Metadata)metadata);
        return (ValueSpecification)((ConcreteFunctionDefinition)LegendCompile.extractCreatedElementFromCompiledGraph(data, pm).getFirst())._expressionSequence().getFirst();
    }

    private static MutableList<PackageableElement> extractCreatedElementFromCompiledGraph(PureModelContextData pureModelContextData, PureModel pureModel) {
        return ListIterate.collectIf((List)pureModelContextData.getElements(), (Predicate & Serializable)x -> !(x instanceof SectionIndex) && !(x instanceof Package), (org.eclipse.collections.api.block.function.Function & Serializable)x -> {
            Package elementGraphPackage = (Package)pureModel.getPackageableElement(x._package);
            String elementId = x instanceof Function ? HelperModelBuilder.getSignature((Function)((Function)x)) : x.name;
            PackageableElement graphElement = (PackageableElement)elementGraphPackage._children().detect((Predicate & Serializable)s -> elementId.equals(s._name()));
            Assert.assertTrue((graphElement != null ? 1 : 0) != 0, (Function0 & Serializable)() -> "Element " + elementId + " can't be found in package " + x._package + " children: " + elementGraphPackage._children().collect(ModelElementAccessor::_name).makeString(", "));
            return graphElement;
        });
    }
}

