/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.volatility.swaps;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.eq.shared.EquityUnderlyerProvisionsModel;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import fpml.consolidated.volatility.swaps.VolatilityLeg;
import fpml.consolidated.volatility.swaps.meta.VolatilitySwapTransactionSupplementMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="VolatilitySwapTransactionSupplement", builder=VolatilitySwapTransactionSupplementBuilderImpl.class, version="1.1.0")
@RuneDataType(value="VolatilitySwapTransactionSupplement", model="fpml", builder=VolatilitySwapTransactionSupplementBuilderImpl.class, version="1.1.0")
public interface VolatilitySwapTransactionSupplement
extends Product {
    public static final VolatilitySwapTransactionSupplementMeta metaData = new VolatilitySwapTransactionSupplementMeta();

    public List<? extends VolatilityLeg> getVolatilityLeg();

    public EquityUnderlyerProvisionsModel getEquityUnderlyerProvisionsModel();

    @Override
    public VolatilitySwapTransactionSupplement build();

    @Override
    public VolatilitySwapTransactionSupplementBuilder toBuilder();

    public static VolatilitySwapTransactionSupplementBuilder builder() {
        return new VolatilitySwapTransactionSupplementBuilderImpl();
    }

    default public RosettaMetaData<? extends VolatilitySwapTransactionSupplement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VolatilitySwapTransactionSupplement> getType() {
        return VolatilitySwapTransactionSupplement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("volatilityLeg"), processor, VolatilityLeg.class, this.getVolatilityLeg(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityUnderlyerProvisionsModel"), processor, EquityUnderlyerProvisionsModel.class, this.getEquityUnderlyerProvisionsModel(), new AttributeMeta[0]);
    }

    public static class VolatilitySwapTransactionSupplementBuilderImpl
    extends Product.ProductBuilderImpl
    implements VolatilitySwapTransactionSupplementBuilder {
        protected List<VolatilityLeg.VolatilityLegBuilder> volatilityLeg = new ArrayList<VolatilityLeg.VolatilityLegBuilder>();
        protected EquityUnderlyerProvisionsModel.EquityUnderlyerProvisionsModelBuilder equityUnderlyerProvisionsModel;

        @Override
        @RosettaAttribute(value="volatilityLeg", isRequired=true)
        @RuneAttribute(value="volatilityLeg", isRequired=true)
        public List<? extends VolatilityLeg.VolatilityLegBuilder> getVolatilityLeg() {
            return this.volatilityLeg;
        }

        @Override
        public VolatilityLeg.VolatilityLegBuilder getOrCreateVolatilityLeg(int index) {
            if (this.volatilityLeg == null) {
                this.volatilityLeg = new ArrayList<VolatilityLeg.VolatilityLegBuilder>();
            }
            return (VolatilityLeg.VolatilityLegBuilder)this.getIndex(this.volatilityLeg, index, () -> {
                VolatilityLeg.VolatilityLegBuilder newVolatilityLeg = VolatilityLeg.builder();
                return newVolatilityLeg;
            });
        }

        @Override
        @RosettaAttribute(value="equityUnderlyerProvisionsModel")
        @RuneAttribute(value="equityUnderlyerProvisionsModel")
        public EquityUnderlyerProvisionsModel.EquityUnderlyerProvisionsModelBuilder getEquityUnderlyerProvisionsModel() {
            return this.equityUnderlyerProvisionsModel;
        }

        @Override
        public EquityUnderlyerProvisionsModel.EquityUnderlyerProvisionsModelBuilder getOrCreateEquityUnderlyerProvisionsModel() {
            EquityUnderlyerProvisionsModel.EquityUnderlyerProvisionsModelBuilder result = this.equityUnderlyerProvisionsModel != null ? this.equityUnderlyerProvisionsModel : (this.equityUnderlyerProvisionsModel = EquityUnderlyerProvisionsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public VolatilitySwapTransactionSupplementBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public VolatilitySwapTransactionSupplementBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="volatilityLeg", isRequired=true)
        @RuneAttribute(value="volatilityLeg", isRequired=true)
        public VolatilitySwapTransactionSupplementBuilder addVolatilityLeg(VolatilityLeg _volatilityLeg) {
            if (_volatilityLeg != null) {
                this.volatilityLeg.add(_volatilityLeg.toBuilder());
            }
            return this;
        }

        @Override
        public VolatilitySwapTransactionSupplementBuilder addVolatilityLeg(VolatilityLeg _volatilityLeg, int idx) {
            this.getIndex(this.volatilityLeg, idx, () -> _volatilityLeg.toBuilder());
            return this;
        }

        @Override
        public VolatilitySwapTransactionSupplementBuilder addVolatilityLeg(List<? extends VolatilityLeg> volatilityLegs) {
            if (volatilityLegs != null) {
                for (VolatilityLeg volatilityLeg : volatilityLegs) {
                    this.volatilityLeg.add(volatilityLeg.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="volatilityLeg")
        public VolatilitySwapTransactionSupplementBuilder setVolatilityLeg(List<? extends VolatilityLeg> volatilityLegs) {
            this.volatilityLeg = volatilityLegs == null ? new ArrayList<VolatilityLeg.VolatilityLegBuilder>() : (List)volatilityLegs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="equityUnderlyerProvisionsModel")
        @RuneAttribute(value="equityUnderlyerProvisionsModel")
        public VolatilitySwapTransactionSupplementBuilder setEquityUnderlyerProvisionsModel(EquityUnderlyerProvisionsModel _equityUnderlyerProvisionsModel) {
            this.equityUnderlyerProvisionsModel = _equityUnderlyerProvisionsModel == null ? null : _equityUnderlyerProvisionsModel.toBuilder();
            return this;
        }

        @Override
        public VolatilitySwapTransactionSupplement build() {
            return new VolatilitySwapTransactionSupplementImpl(this);
        }

        @Override
        public VolatilitySwapTransactionSupplementBuilder toBuilder() {
            return this;
        }

        @Override
        public VolatilitySwapTransactionSupplementBuilder prune() {
            super.prune();
            this.volatilityLeg = this.volatilityLeg.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.equityUnderlyerProvisionsModel != null && !this.equityUnderlyerProvisionsModel.prune().hasData()) {
                this.equityUnderlyerProvisionsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getVolatilityLeg() != null && this.getVolatilityLeg().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getEquityUnderlyerProvisionsModel() != null && this.getEquityUnderlyerProvisionsModel().hasData();
        }

        @Override
        public VolatilitySwapTransactionSupplementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VolatilitySwapTransactionSupplementBuilder o = (VolatilitySwapTransactionSupplementBuilder)other;
            merger.mergeRosetta(this.getVolatilityLeg(), o.getVolatilityLeg(), this::getOrCreateVolatilityLeg);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityUnderlyerProvisionsModel(), (RosettaModelObjectBuilder)o.getEquityUnderlyerProvisionsModel(), this::setEquityUnderlyerProvisionsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilitySwapTransactionSupplement _that = (VolatilitySwapTransactionSupplement)this.getType().cast(o);
            if (!ListEquals.listEquals(this.volatilityLeg, _that.getVolatilityLeg())) {
                return false;
            }
            return Objects.equals(this.equityUnderlyerProvisionsModel, _that.getEquityUnderlyerProvisionsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.volatilityLeg != null ? this.volatilityLeg.hashCode() : 0);
            _result = 31 * _result + (this.equityUnderlyerProvisionsModel != null ? this.equityUnderlyerProvisionsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilitySwapTransactionSupplementBuilder {volatilityLeg=" + this.volatilityLeg + ", equityUnderlyerProvisionsModel=" + this.equityUnderlyerProvisionsModel + '}' + " " + super.toString();
        }
    }

    public static interface VolatilitySwapTransactionSupplementBuilder
    extends VolatilitySwapTransactionSupplement,
    Product.ProductBuilder {
        public VolatilityLeg.VolatilityLegBuilder getOrCreateVolatilityLeg(int var1);

        public List<? extends VolatilityLeg.VolatilityLegBuilder> getVolatilityLeg();

        public EquityUnderlyerProvisionsModel.EquityUnderlyerProvisionsModelBuilder getOrCreateEquityUnderlyerProvisionsModel();

        @Override
        public EquityUnderlyerProvisionsModel.EquityUnderlyerProvisionsModelBuilder getEquityUnderlyerProvisionsModel();

        @Override
        public VolatilitySwapTransactionSupplementBuilder setProductModel(ProductModel var1);

        @Override
        public VolatilitySwapTransactionSupplementBuilder setId(String var1);

        public VolatilitySwapTransactionSupplementBuilder addVolatilityLeg(VolatilityLeg var1);

        public VolatilitySwapTransactionSupplementBuilder addVolatilityLeg(VolatilityLeg var1, int var2);

        public VolatilitySwapTransactionSupplementBuilder addVolatilityLeg(List<? extends VolatilityLeg> var1);

        public VolatilitySwapTransactionSupplementBuilder setVolatilityLeg(List<? extends VolatilityLeg> var1);

        public VolatilitySwapTransactionSupplementBuilder setEquityUnderlyerProvisionsModel(EquityUnderlyerProvisionsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("volatilityLeg"), processor, VolatilityLeg.VolatilityLegBuilder.class, this.getVolatilityLeg(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityUnderlyerProvisionsModel"), processor, EquityUnderlyerProvisionsModel.EquityUnderlyerProvisionsModelBuilder.class, this.getEquityUnderlyerProvisionsModel(), new AttributeMeta[0]);
        }

        @Override
        public VolatilitySwapTransactionSupplementBuilder prune();
    }

    public static class VolatilitySwapTransactionSupplementImpl
    extends Product.ProductImpl
    implements VolatilitySwapTransactionSupplement {
        private final List<? extends VolatilityLeg> volatilityLeg;
        private final EquityUnderlyerProvisionsModel equityUnderlyerProvisionsModel;

        protected VolatilitySwapTransactionSupplementImpl(VolatilitySwapTransactionSupplementBuilder builder) {
            super(builder);
            this.volatilityLeg = Optional.ofNullable(builder.getVolatilityLeg()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.equityUnderlyerProvisionsModel = Optional.ofNullable(builder.getEquityUnderlyerProvisionsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="volatilityLeg", isRequired=true)
        @RuneAttribute(value="volatilityLeg", isRequired=true)
        public List<? extends VolatilityLeg> getVolatilityLeg() {
            return this.volatilityLeg;
        }

        @Override
        @RosettaAttribute(value="equityUnderlyerProvisionsModel")
        @RuneAttribute(value="equityUnderlyerProvisionsModel")
        public EquityUnderlyerProvisionsModel getEquityUnderlyerProvisionsModel() {
            return this.equityUnderlyerProvisionsModel;
        }

        @Override
        public VolatilitySwapTransactionSupplement build() {
            return this;
        }

        @Override
        public VolatilitySwapTransactionSupplementBuilder toBuilder() {
            VolatilitySwapTransactionSupplementBuilder builder = VolatilitySwapTransactionSupplement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VolatilitySwapTransactionSupplementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getVolatilityLeg()).ifPresent(builder::setVolatilityLeg);
            Optional.ofNullable(this.getEquityUnderlyerProvisionsModel()).ifPresent(builder::setEquityUnderlyerProvisionsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilitySwapTransactionSupplement _that = (VolatilitySwapTransactionSupplement)this.getType().cast(o);
            if (!ListEquals.listEquals(this.volatilityLeg, _that.getVolatilityLeg())) {
                return false;
            }
            return Objects.equals(this.equityUnderlyerProvisionsModel, _that.getEquityUnderlyerProvisionsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.volatilityLeg != null ? this.volatilityLeg.hashCode() : 0);
            _result = 31 * _result + (this.equityUnderlyerProvisionsModel != null ? this.equityUnderlyerProvisionsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilitySwapTransactionSupplement {volatilityLeg=" + this.volatilityLeg + ", equityUnderlyerProvisionsModel=" + this.equityUnderlyerProvisionsModel + '}' + " " + super.toString();
        }
    }
}

