/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.volatility.swaps;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.volatility.swaps.VolatilityCapSequence;
import fpml.consolidated.volatility.swaps.meta.VolatilityCapMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="VolatilityCap", builder=VolatilityCapBuilderImpl.class, version="1.1.0")
@RuneDataType(value="VolatilityCap", model="fpml", builder=VolatilityCapBuilderImpl.class, version="1.1.0")
public interface VolatilityCap
extends RosettaModelObject {
    public static final VolatilityCapMeta metaData = new VolatilityCapMeta();

    public Boolean getApplicable();

    public BigDecimal getTotalVolatilityCap();

    public VolatilityCapSequence getVolatilityCapSequence();

    public VolatilityCap build();

    public VolatilityCapBuilder toBuilder();

    public static VolatilityCapBuilder builder() {
        return new VolatilityCapBuilderImpl();
    }

    default public RosettaMetaData<? extends VolatilityCap> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VolatilityCap> getType() {
        return VolatilityCap.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("applicable"), Boolean.class, (Object)this.getApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalVolatilityCap"), BigDecimal.class, (Object)this.getTotalVolatilityCap(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("volatilityCapSequence"), processor, VolatilityCapSequence.class, this.getVolatilityCapSequence(), new AttributeMeta[0]);
    }

    public static class VolatilityCapBuilderImpl
    implements VolatilityCapBuilder {
        protected Boolean applicable;
        protected BigDecimal totalVolatilityCap;
        protected VolatilityCapSequence.VolatilityCapSequenceBuilder volatilityCapSequence;

        @Override
        @RosettaAttribute(value="applicable")
        @RuneAttribute(value="applicable")
        public Boolean getApplicable() {
            return this.applicable;
        }

        @Override
        @RosettaAttribute(value="totalVolatilityCap")
        @RuneAttribute(value="totalVolatilityCap")
        public BigDecimal getTotalVolatilityCap() {
            return this.totalVolatilityCap;
        }

        @Override
        @RosettaAttribute(value="volatilityCapSequence")
        @RuneAttribute(value="volatilityCapSequence")
        public VolatilityCapSequence.VolatilityCapSequenceBuilder getVolatilityCapSequence() {
            return this.volatilityCapSequence;
        }

        @Override
        public VolatilityCapSequence.VolatilityCapSequenceBuilder getOrCreateVolatilityCapSequence() {
            VolatilityCapSequence.VolatilityCapSequenceBuilder result = this.volatilityCapSequence != null ? this.volatilityCapSequence : (this.volatilityCapSequence = VolatilityCapSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="applicable")
        @RuneAttribute(value="applicable")
        public VolatilityCapBuilder setApplicable(Boolean _applicable) {
            this.applicable = _applicable == null ? null : _applicable;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalVolatilityCap")
        @RuneAttribute(value="totalVolatilityCap")
        public VolatilityCapBuilder setTotalVolatilityCap(BigDecimal _totalVolatilityCap) {
            this.totalVolatilityCap = _totalVolatilityCap == null ? null : _totalVolatilityCap;
            return this;
        }

        @Override
        @RosettaAttribute(value="volatilityCapSequence")
        @RuneAttribute(value="volatilityCapSequence")
        public VolatilityCapBuilder setVolatilityCapSequence(VolatilityCapSequence _volatilityCapSequence) {
            this.volatilityCapSequence = _volatilityCapSequence == null ? null : _volatilityCapSequence.toBuilder();
            return this;
        }

        @Override
        public VolatilityCap build() {
            return new VolatilityCapImpl(this);
        }

        @Override
        public VolatilityCapBuilder toBuilder() {
            return this;
        }

        @Override
        public VolatilityCapBuilder prune() {
            if (this.volatilityCapSequence != null && !this.volatilityCapSequence.prune().hasData()) {
                this.volatilityCapSequence = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getApplicable() != null) {
                return true;
            }
            if (this.getTotalVolatilityCap() != null) {
                return true;
            }
            return this.getVolatilityCapSequence() != null && this.getVolatilityCapSequence().hasData();
        }

        public VolatilityCapBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            VolatilityCapBuilder o = (VolatilityCapBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVolatilityCapSequence(), (RosettaModelObjectBuilder)o.getVolatilityCapSequence(), this::setVolatilityCapSequence);
            merger.mergeBasic((Object)this.getApplicable(), (Object)o.getApplicable(), this::setApplicable, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTotalVolatilityCap(), (Object)o.getTotalVolatilityCap(), this::setTotalVolatilityCap, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            VolatilityCap _that = this.getType().cast(o);
            if (!Objects.equals(this.applicable, _that.getApplicable())) {
                return false;
            }
            if (!Objects.equals(this.totalVolatilityCap, _that.getTotalVolatilityCap())) {
                return false;
            }
            return Objects.equals(this.volatilityCapSequence, _that.getVolatilityCapSequence());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.applicable != null ? this.applicable.hashCode() : 0);
            _result = 31 * _result + (this.totalVolatilityCap != null ? this.totalVolatilityCap.hashCode() : 0);
            _result = 31 * _result + (this.volatilityCapSequence != null ? this.volatilityCapSequence.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "VolatilityCapBuilder {applicable=" + this.applicable + ", totalVolatilityCap=" + this.totalVolatilityCap + ", volatilityCapSequence=" + this.volatilityCapSequence + '}';
        }
    }

    public static interface VolatilityCapBuilder
    extends VolatilityCap,
    RosettaModelObjectBuilder {
        public VolatilityCapSequence.VolatilityCapSequenceBuilder getOrCreateVolatilityCapSequence();

        @Override
        public VolatilityCapSequence.VolatilityCapSequenceBuilder getVolatilityCapSequence();

        public VolatilityCapBuilder setApplicable(Boolean var1);

        public VolatilityCapBuilder setTotalVolatilityCap(BigDecimal var1);

        public VolatilityCapBuilder setVolatilityCapSequence(VolatilityCapSequence var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("applicable"), Boolean.class, (Object)this.getApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalVolatilityCap"), BigDecimal.class, (Object)this.getTotalVolatilityCap(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("volatilityCapSequence"), processor, VolatilityCapSequence.VolatilityCapSequenceBuilder.class, this.getVolatilityCapSequence(), new AttributeMeta[0]);
        }

        public VolatilityCapBuilder prune();
    }

    public static class VolatilityCapImpl
    implements VolatilityCap {
        private final Boolean applicable;
        private final BigDecimal totalVolatilityCap;
        private final VolatilityCapSequence volatilityCapSequence;

        protected VolatilityCapImpl(VolatilityCapBuilder builder) {
            this.applicable = builder.getApplicable();
            this.totalVolatilityCap = builder.getTotalVolatilityCap();
            this.volatilityCapSequence = Optional.ofNullable(builder.getVolatilityCapSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="applicable")
        @RuneAttribute(value="applicable")
        public Boolean getApplicable() {
            return this.applicable;
        }

        @Override
        @RosettaAttribute(value="totalVolatilityCap")
        @RuneAttribute(value="totalVolatilityCap")
        public BigDecimal getTotalVolatilityCap() {
            return this.totalVolatilityCap;
        }

        @Override
        @RosettaAttribute(value="volatilityCapSequence")
        @RuneAttribute(value="volatilityCapSequence")
        public VolatilityCapSequence getVolatilityCapSequence() {
            return this.volatilityCapSequence;
        }

        @Override
        public VolatilityCap build() {
            return this;
        }

        @Override
        public VolatilityCapBuilder toBuilder() {
            VolatilityCapBuilder builder = VolatilityCap.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VolatilityCapBuilder builder) {
            Optional.ofNullable(this.getApplicable()).ifPresent(builder::setApplicable);
            Optional.ofNullable(this.getTotalVolatilityCap()).ifPresent(builder::setTotalVolatilityCap);
            Optional.ofNullable(this.getVolatilityCapSequence()).ifPresent(builder::setVolatilityCapSequence);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            VolatilityCap _that = this.getType().cast(o);
            if (!Objects.equals(this.applicable, _that.getApplicable())) {
                return false;
            }
            if (!Objects.equals(this.totalVolatilityCap, _that.getTotalVolatilityCap())) {
                return false;
            }
            return Objects.equals(this.volatilityCapSequence, _that.getVolatilityCapSequence());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.applicable != null ? this.applicable.hashCode() : 0);
            _result = 31 * _result + (this.totalVolatilityCap != null ? this.totalVolatilityCap.hashCode() : 0);
            _result = 31 * _result + (this.volatilityCapSequence != null ? this.volatilityCapSequence.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "VolatilityCap {applicable=" + this.applicable + ", totalVolatilityCap=" + this.totalVolatilityCap + ", volatilityCapSequence=" + this.volatilityCapSequence + '}';
        }
    }
}

