/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.valuation.fpmlreporting;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndOptionalSequenceModel;
import fpml.consolidated.msg.NotificationMessage;
import fpml.consolidated.msg.NotificationMessageHeader;
import fpml.consolidated.msg.ReportIdentification;
import fpml.consolidated.riskdef.Market;
import fpml.consolidated.shared.IdentifiedDate;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import fpml.consolidated.valuation.fpmlreporting.PortfolioValuationItem;
import fpml.consolidated.valuation.fpmlreporting.ReportContents;
import fpml.consolidated.valuation.fpmlreporting.TradeValuationItem;
import fpml.consolidated.valuation.fpmlreporting.meta.ValuationReportMeta;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ValuationReport", builder=ValuationReportBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ValuationReport", model="fpml", builder=ValuationReportBuilderImpl.class, version="1.1.0")
public interface ValuationReport
extends NotificationMessage {
    public static final ValuationReportMeta metaData = new ValuationReportMeta();

    public ReportIdentification getReportIdentification();

    public ReportContents getReportContents();

    public IdentifiedDate getAsOfDate();

    public LocalTime getAsOfTime();

    public ZonedDateTime getGeneratedDateTime();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    public Market getMarket();

    public List<? extends PortfolioValuationItem> getPortfolioValuationItem();

    public List<? extends TradeValuationItem> getTradeValuationItem();

    @Override
    public ValuationReport build();

    @Override
    public ValuationReportBuilder toBuilder();

    public static ValuationReportBuilder builder() {
        return new ValuationReportBuilderImpl();
    }

    default public RosettaMetaData<? extends ValuationReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ValuationReport> getType() {
        return ValuationReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportIdentification"), processor, ReportIdentification.class, this.getReportIdentification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportContents"), processor, ReportContents.class, this.getReportContents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("asOfDate"), processor, IdentifiedDate.class, this.getAsOfDate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("asOfTime"), LocalTime.class, (Object)this.getAsOfTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("generatedDateTime"), ZonedDateTime.class, (Object)this.getGeneratedDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("market"), processor, Market.class, this.getMarket(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolioValuationItem"), processor, PortfolioValuationItem.class, this.getPortfolioValuationItem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeValuationItem"), processor, TradeValuationItem.class, this.getTradeValuationItem(), new AttributeMeta[0]);
    }

    public static class ValuationReportBuilderImpl
    extends NotificationMessage.NotificationMessageBuilderImpl
    implements ValuationReportBuilder {
        protected ReportIdentification.ReportIdentificationBuilder reportIdentification;
        protected ReportContents.ReportContentsBuilder reportContents;
        protected IdentifiedDate.IdentifiedDateBuilder asOfDate;
        protected LocalTime asOfTime;
        protected ZonedDateTime generatedDateTime;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;
        protected Market.MarketBuilder market;
        protected List<PortfolioValuationItem.PortfolioValuationItemBuilder> portfolioValuationItem = new ArrayList<PortfolioValuationItem.PortfolioValuationItemBuilder>();
        protected List<TradeValuationItem.TradeValuationItemBuilder> tradeValuationItem = new ArrayList<TradeValuationItem.TradeValuationItemBuilder>();

        @Override
        @RosettaAttribute(value="reportIdentification")
        @RuneAttribute(value="reportIdentification")
        public ReportIdentification.ReportIdentificationBuilder getReportIdentification() {
            return this.reportIdentification;
        }

        @Override
        public ReportIdentification.ReportIdentificationBuilder getOrCreateReportIdentification() {
            ReportIdentification.ReportIdentificationBuilder result = this.reportIdentification != null ? this.reportIdentification : (this.reportIdentification = ReportIdentification.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportContents")
        @RuneAttribute(value="reportContents")
        public ReportContents.ReportContentsBuilder getReportContents() {
            return this.reportContents;
        }

        @Override
        public ReportContents.ReportContentsBuilder getOrCreateReportContents() {
            ReportContents.ReportContentsBuilder result = this.reportContents != null ? this.reportContents : (this.reportContents = ReportContents.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="asOfDate")
        @RuneAttribute(value="asOfDate")
        public IdentifiedDate.IdentifiedDateBuilder getAsOfDate() {
            return this.asOfDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateAsOfDate() {
            IdentifiedDate.IdentifiedDateBuilder result = this.asOfDate != null ? this.asOfDate : (this.asOfDate = IdentifiedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="asOfTime")
        @RuneAttribute(value="asOfTime")
        public LocalTime getAsOfTime() {
            return this.asOfTime;
        }

        @Override
        @RosettaAttribute(value="generatedDateTime")
        @RuneAttribute(value="generatedDateTime")
        public ZonedDateTime getGeneratedDateTime() {
            return this.generatedDateTime;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="market")
        @RuneAttribute(value="market")
        public Market.MarketBuilder getMarket() {
            return this.market;
        }

        @Override
        public Market.MarketBuilder getOrCreateMarket() {
            Market.MarketBuilder result = this.market != null ? this.market : (this.market = Market.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="portfolioValuationItem")
        @RuneAttribute(value="portfolioValuationItem")
        public List<? extends PortfolioValuationItem.PortfolioValuationItemBuilder> getPortfolioValuationItem() {
            return this.portfolioValuationItem;
        }

        @Override
        public PortfolioValuationItem.PortfolioValuationItemBuilder getOrCreatePortfolioValuationItem(int index) {
            if (this.portfolioValuationItem == null) {
                this.portfolioValuationItem = new ArrayList<PortfolioValuationItem.PortfolioValuationItemBuilder>();
            }
            return (PortfolioValuationItem.PortfolioValuationItemBuilder)this.getIndex(this.portfolioValuationItem, index, () -> {
                PortfolioValuationItem.PortfolioValuationItemBuilder newPortfolioValuationItem = PortfolioValuationItem.builder();
                return newPortfolioValuationItem;
            });
        }

        @Override
        @RosettaAttribute(value="tradeValuationItem")
        @RuneAttribute(value="tradeValuationItem")
        public List<? extends TradeValuationItem.TradeValuationItemBuilder> getTradeValuationItem() {
            return this.tradeValuationItem;
        }

        @Override
        public TradeValuationItem.TradeValuationItemBuilder getOrCreateTradeValuationItem(int index) {
            if (this.tradeValuationItem == null) {
                this.tradeValuationItem = new ArrayList<TradeValuationItem.TradeValuationItemBuilder>();
            }
            return (TradeValuationItem.TradeValuationItemBuilder)this.getIndex(this.tradeValuationItem, index, () -> {
                TradeValuationItem.TradeValuationItemBuilder newTradeValuationItem = TradeValuationItem.builder();
                return newTradeValuationItem;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ValuationReportBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ValuationReportBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ValuationReportBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ValuationReportBuilder setHeader(NotificationMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ValuationReportBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel")
        @RuneAttribute(value="correlationAndOptionalSequenceModel")
        public ValuationReportBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ValuationReportBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportIdentification")
        @RuneAttribute(value="reportIdentification")
        public ValuationReportBuilder setReportIdentification(ReportIdentification _reportIdentification) {
            this.reportIdentification = _reportIdentification == null ? null : _reportIdentification.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportContents")
        @RuneAttribute(value="reportContents")
        public ValuationReportBuilder setReportContents(ReportContents _reportContents) {
            this.reportContents = _reportContents == null ? null : _reportContents.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="asOfDate")
        @RuneAttribute(value="asOfDate")
        public ValuationReportBuilder setAsOfDate(IdentifiedDate _asOfDate) {
            this.asOfDate = _asOfDate == null ? null : _asOfDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="asOfTime")
        @RuneAttribute(value="asOfTime")
        public ValuationReportBuilder setAsOfTime(LocalTime _asOfTime) {
            this.asOfTime = _asOfTime == null ? null : _asOfTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="generatedDateTime")
        @RuneAttribute(value="generatedDateTime")
        public ValuationReportBuilder setGeneratedDateTime(ZonedDateTime _generatedDateTime) {
            this.generatedDateTime = _generatedDateTime == null ? null : _generatedDateTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public ValuationReportBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="market")
        @RuneAttribute(value="market")
        public ValuationReportBuilder setMarket(Market _market) {
            this.market = _market == null ? null : _market.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioValuationItem")
        @RuneAttribute(value="portfolioValuationItem")
        public ValuationReportBuilder addPortfolioValuationItem(PortfolioValuationItem _portfolioValuationItem) {
            if (_portfolioValuationItem != null) {
                this.portfolioValuationItem.add(_portfolioValuationItem.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationReportBuilder addPortfolioValuationItem(PortfolioValuationItem _portfolioValuationItem, int idx) {
            this.getIndex(this.portfolioValuationItem, idx, () -> _portfolioValuationItem.toBuilder());
            return this;
        }

        @Override
        public ValuationReportBuilder addPortfolioValuationItem(List<? extends PortfolioValuationItem> portfolioValuationItems) {
            if (portfolioValuationItems != null) {
                for (PortfolioValuationItem portfolioValuationItem : portfolioValuationItems) {
                    this.portfolioValuationItem.add(portfolioValuationItem.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="portfolioValuationItem")
        public ValuationReportBuilder setPortfolioValuationItem(List<? extends PortfolioValuationItem> portfolioValuationItems) {
            this.portfolioValuationItem = portfolioValuationItems == null ? new ArrayList<PortfolioValuationItem.PortfolioValuationItemBuilder>() : (List)portfolioValuationItems.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeValuationItem")
        @RuneAttribute(value="tradeValuationItem")
        public ValuationReportBuilder addTradeValuationItem(TradeValuationItem _tradeValuationItem) {
            if (_tradeValuationItem != null) {
                this.tradeValuationItem.add(_tradeValuationItem.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationReportBuilder addTradeValuationItem(TradeValuationItem _tradeValuationItem, int idx) {
            this.getIndex(this.tradeValuationItem, idx, () -> _tradeValuationItem.toBuilder());
            return this;
        }

        @Override
        public ValuationReportBuilder addTradeValuationItem(List<? extends TradeValuationItem> tradeValuationItems) {
            if (tradeValuationItems != null) {
                for (TradeValuationItem tradeValuationItem : tradeValuationItems) {
                    this.tradeValuationItem.add(tradeValuationItem.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeValuationItem")
        public ValuationReportBuilder setTradeValuationItem(List<? extends TradeValuationItem> tradeValuationItems) {
            this.tradeValuationItem = tradeValuationItems == null ? new ArrayList<TradeValuationItem.TradeValuationItemBuilder>() : (List)tradeValuationItems.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ValuationReport build() {
            return new ValuationReportImpl(this);
        }

        @Override
        public ValuationReportBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationReportBuilder prune() {
            super.prune();
            if (this.reportIdentification != null && !this.reportIdentification.prune().hasData()) {
                this.reportIdentification = null;
            }
            if (this.reportContents != null && !this.reportContents.prune().hasData()) {
                this.reportContents = null;
            }
            if (this.asOfDate != null && !this.asOfDate.prune().hasData()) {
                this.asOfDate = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            if (this.market != null && !this.market.prune().hasData()) {
                this.market = null;
            }
            this.portfolioValuationItem = this.portfolioValuationItem.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.tradeValuationItem = this.tradeValuationItem.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getReportIdentification() != null && this.getReportIdentification().hasData()) {
                return true;
            }
            if (this.getReportContents() != null && this.getReportContents().hasData()) {
                return true;
            }
            if (this.getAsOfDate() != null && this.getAsOfDate().hasData()) {
                return true;
            }
            if (this.getAsOfTime() != null) {
                return true;
            }
            if (this.getGeneratedDateTime() != null) {
                return true;
            }
            if (this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData()) {
                return true;
            }
            if (this.getMarket() != null && this.getMarket().hasData()) {
                return true;
            }
            if (this.getPortfolioValuationItem() != null && this.getPortfolioValuationItem().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getTradeValuationItem() != null && this.getTradeValuationItem().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public ValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ValuationReportBuilder o = (ValuationReportBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportIdentification(), (RosettaModelObjectBuilder)o.getReportIdentification(), this::setReportIdentification);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportContents(), (RosettaModelObjectBuilder)o.getReportContents(), this::setReportContents);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAsOfDate(), (RosettaModelObjectBuilder)o.getAsOfDate(), this::setAsOfDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMarket(), (RosettaModelObjectBuilder)o.getMarket(), this::setMarket);
            merger.mergeRosetta(this.getPortfolioValuationItem(), o.getPortfolioValuationItem(), this::getOrCreatePortfolioValuationItem);
            merger.mergeRosetta(this.getTradeValuationItem(), o.getTradeValuationItem(), this::getOrCreateTradeValuationItem);
            merger.mergeBasic((Object)this.getAsOfTime(), (Object)o.getAsOfTime(), this::setAsOfTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getGeneratedDateTime(), (Object)o.getGeneratedDateTime(), this::setGeneratedDateTime, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValuationReport _that = (ValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.reportIdentification, _that.getReportIdentification())) {
                return false;
            }
            if (!Objects.equals(this.reportContents, _that.getReportContents())) {
                return false;
            }
            if (!Objects.equals(this.asOfDate, _that.getAsOfDate())) {
                return false;
            }
            if (!Objects.equals(this.asOfTime, _that.getAsOfTime())) {
                return false;
            }
            if (!Objects.equals(this.generatedDateTime, _that.getGeneratedDateTime())) {
                return false;
            }
            if (!Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel())) {
                return false;
            }
            if (!Objects.equals(this.market, _that.getMarket())) {
                return false;
            }
            if (!ListEquals.listEquals(this.portfolioValuationItem, _that.getPortfolioValuationItem())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeValuationItem, _that.getTradeValuationItem());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportIdentification != null ? this.reportIdentification.hashCode() : 0);
            _result = 31 * _result + (this.reportContents != null ? this.reportContents.hashCode() : 0);
            _result = 31 * _result + (this.asOfDate != null ? this.asOfDate.hashCode() : 0);
            _result = 31 * _result + (this.asOfTime != null ? this.asOfTime.hashCode() : 0);
            _result = 31 * _result + (this.generatedDateTime != null ? this.generatedDateTime.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            _result = 31 * _result + (this.market != null ? this.market.hashCode() : 0);
            _result = 31 * _result + (this.portfolioValuationItem != null ? this.portfolioValuationItem.hashCode() : 0);
            _result = 31 * _result + (this.tradeValuationItem != null ? this.tradeValuationItem.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ValuationReportBuilder {reportIdentification=" + this.reportIdentification + ", reportContents=" + this.reportContents + ", asOfDate=" + this.asOfDate + ", asOfTime=" + this.asOfTime + ", generatedDateTime=" + this.generatedDateTime + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + ", market=" + this.market + ", portfolioValuationItem=" + this.portfolioValuationItem + ", tradeValuationItem=" + this.tradeValuationItem + '}' + " " + super.toString();
        }
    }

    public static interface ValuationReportBuilder
    extends ValuationReport,
    NotificationMessage.NotificationMessageBuilder {
        public ReportIdentification.ReportIdentificationBuilder getOrCreateReportIdentification();

        @Override
        public ReportIdentification.ReportIdentificationBuilder getReportIdentification();

        public ReportContents.ReportContentsBuilder getOrCreateReportContents();

        @Override
        public ReportContents.ReportContentsBuilder getReportContents();

        public IdentifiedDate.IdentifiedDateBuilder getOrCreateAsOfDate();

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getAsOfDate();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        public Market.MarketBuilder getOrCreateMarket();

        @Override
        public Market.MarketBuilder getMarket();

        public PortfolioValuationItem.PortfolioValuationItemBuilder getOrCreatePortfolioValuationItem(int var1);

        public List<? extends PortfolioValuationItem.PortfolioValuationItemBuilder> getPortfolioValuationItem();

        public TradeValuationItem.TradeValuationItemBuilder getOrCreateTradeValuationItem(int var1);

        public List<? extends TradeValuationItem.TradeValuationItemBuilder> getTradeValuationItem();

        @Override
        public ValuationReportBuilder setFpmlVersion(String var1);

        @Override
        public ValuationReportBuilder setExpectedBuild(Integer var1);

        @Override
        public ValuationReportBuilder setActualBuild(Integer var1);

        @Override
        public ValuationReportBuilder setHeader(NotificationMessageHeader var1);

        @Override
        public ValuationReportBuilder setValidationModel(ValidationModel var1);

        @Override
        public ValuationReportBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public ValuationReportBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ValuationReportBuilder setReportIdentification(ReportIdentification var1);

        public ValuationReportBuilder setReportContents(ReportContents var1);

        public ValuationReportBuilder setAsOfDate(IdentifiedDate var1);

        public ValuationReportBuilder setAsOfTime(LocalTime var1);

        public ValuationReportBuilder setGeneratedDateTime(ZonedDateTime var1);

        public ValuationReportBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        public ValuationReportBuilder setMarket(Market var1);

        public ValuationReportBuilder addPortfolioValuationItem(PortfolioValuationItem var1);

        public ValuationReportBuilder addPortfolioValuationItem(PortfolioValuationItem var1, int var2);

        public ValuationReportBuilder addPortfolioValuationItem(List<? extends PortfolioValuationItem> var1);

        public ValuationReportBuilder setPortfolioValuationItem(List<? extends PortfolioValuationItem> var1);

        public ValuationReportBuilder addTradeValuationItem(TradeValuationItem var1);

        public ValuationReportBuilder addTradeValuationItem(TradeValuationItem var1, int var2);

        public ValuationReportBuilder addTradeValuationItem(List<? extends TradeValuationItem> var1);

        public ValuationReportBuilder setTradeValuationItem(List<? extends TradeValuationItem> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.NotificationMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportIdentification"), processor, ReportIdentification.ReportIdentificationBuilder.class, this.getReportIdentification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportContents"), processor, ReportContents.ReportContentsBuilder.class, this.getReportContents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("asOfDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getAsOfDate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("asOfTime"), LocalTime.class, (Object)this.getAsOfTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("generatedDateTime"), ZonedDateTime.class, (Object)this.getGeneratedDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("market"), processor, Market.MarketBuilder.class, this.getMarket(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolioValuationItem"), processor, PortfolioValuationItem.PortfolioValuationItemBuilder.class, this.getPortfolioValuationItem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeValuationItem"), processor, TradeValuationItem.TradeValuationItemBuilder.class, this.getTradeValuationItem(), new AttributeMeta[0]);
        }

        @Override
        public ValuationReportBuilder prune();
    }

    public static class ValuationReportImpl
    extends NotificationMessage.NotificationMessageImpl
    implements ValuationReport {
        private final ReportIdentification reportIdentification;
        private final ReportContents reportContents;
        private final IdentifiedDate asOfDate;
        private final LocalTime asOfTime;
        private final ZonedDateTime generatedDateTime;
        private final PartiesAndAccountsModel partiesAndAccountsModel;
        private final Market market;
        private final List<? extends PortfolioValuationItem> portfolioValuationItem;
        private final List<? extends TradeValuationItem> tradeValuationItem;

        protected ValuationReportImpl(ValuationReportBuilder builder) {
            super(builder);
            this.reportIdentification = Optional.ofNullable(builder.getReportIdentification()).map(f -> f.build()).orElse(null);
            this.reportContents = Optional.ofNullable(builder.getReportContents()).map(f -> f.build()).orElse(null);
            this.asOfDate = Optional.ofNullable(builder.getAsOfDate()).map(f -> f.build()).orElse(null);
            this.asOfTime = builder.getAsOfTime();
            this.generatedDateTime = builder.getGeneratedDateTime();
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
            this.market = Optional.ofNullable(builder.getMarket()).map(f -> f.build()).orElse(null);
            this.portfolioValuationItem = Optional.ofNullable(builder.getPortfolioValuationItem()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.tradeValuationItem = Optional.ofNullable(builder.getTradeValuationItem()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="reportIdentification")
        @RuneAttribute(value="reportIdentification")
        public ReportIdentification getReportIdentification() {
            return this.reportIdentification;
        }

        @Override
        @RosettaAttribute(value="reportContents")
        @RuneAttribute(value="reportContents")
        public ReportContents getReportContents() {
            return this.reportContents;
        }

        @Override
        @RosettaAttribute(value="asOfDate")
        @RuneAttribute(value="asOfDate")
        public IdentifiedDate getAsOfDate() {
            return this.asOfDate;
        }

        @Override
        @RosettaAttribute(value="asOfTime")
        @RuneAttribute(value="asOfTime")
        public LocalTime getAsOfTime() {
            return this.asOfTime;
        }

        @Override
        @RosettaAttribute(value="generatedDateTime")
        @RuneAttribute(value="generatedDateTime")
        public ZonedDateTime getGeneratedDateTime() {
            return this.generatedDateTime;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        @RosettaAttribute(value="market")
        @RuneAttribute(value="market")
        public Market getMarket() {
            return this.market;
        }

        @Override
        @RosettaAttribute(value="portfolioValuationItem")
        @RuneAttribute(value="portfolioValuationItem")
        public List<? extends PortfolioValuationItem> getPortfolioValuationItem() {
            return this.portfolioValuationItem;
        }

        @Override
        @RosettaAttribute(value="tradeValuationItem")
        @RuneAttribute(value="tradeValuationItem")
        public List<? extends TradeValuationItem> getTradeValuationItem() {
            return this.tradeValuationItem;
        }

        @Override
        public ValuationReport build() {
            return this;
        }

        @Override
        public ValuationReportBuilder toBuilder() {
            ValuationReportBuilder builder = ValuationReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getReportIdentification()).ifPresent(builder::setReportIdentification);
            Optional.ofNullable(this.getReportContents()).ifPresent(builder::setReportContents);
            Optional.ofNullable(this.getAsOfDate()).ifPresent(builder::setAsOfDate);
            Optional.ofNullable(this.getAsOfTime()).ifPresent(builder::setAsOfTime);
            Optional.ofNullable(this.getGeneratedDateTime()).ifPresent(builder::setGeneratedDateTime);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
            Optional.ofNullable(this.getMarket()).ifPresent(builder::setMarket);
            Optional.ofNullable(this.getPortfolioValuationItem()).ifPresent(builder::setPortfolioValuationItem);
            Optional.ofNullable(this.getTradeValuationItem()).ifPresent(builder::setTradeValuationItem);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValuationReport _that = (ValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.reportIdentification, _that.getReportIdentification())) {
                return false;
            }
            if (!Objects.equals(this.reportContents, _that.getReportContents())) {
                return false;
            }
            if (!Objects.equals(this.asOfDate, _that.getAsOfDate())) {
                return false;
            }
            if (!Objects.equals(this.asOfTime, _that.getAsOfTime())) {
                return false;
            }
            if (!Objects.equals(this.generatedDateTime, _that.getGeneratedDateTime())) {
                return false;
            }
            if (!Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel())) {
                return false;
            }
            if (!Objects.equals(this.market, _that.getMarket())) {
                return false;
            }
            if (!ListEquals.listEquals(this.portfolioValuationItem, _that.getPortfolioValuationItem())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeValuationItem, _that.getTradeValuationItem());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportIdentification != null ? this.reportIdentification.hashCode() : 0);
            _result = 31 * _result + (this.reportContents != null ? this.reportContents.hashCode() : 0);
            _result = 31 * _result + (this.asOfDate != null ? this.asOfDate.hashCode() : 0);
            _result = 31 * _result + (this.asOfTime != null ? this.asOfTime.hashCode() : 0);
            _result = 31 * _result + (this.generatedDateTime != null ? this.generatedDateTime.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            _result = 31 * _result + (this.market != null ? this.market.hashCode() : 0);
            _result = 31 * _result + (this.portfolioValuationItem != null ? this.portfolioValuationItem.hashCode() : 0);
            _result = 31 * _result + (this.tradeValuationItem != null ? this.tradeValuationItem.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ValuationReport {reportIdentification=" + this.reportIdentification + ", reportContents=" + this.reportContents + ", asOfDate=" + this.asOfDate + ", asOfTime=" + this.asOfTime + ", generatedDateTime=" + this.generatedDateTime + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + ", market=" + this.market + ", portfolioValuationItem=" + this.portfolioValuationItem + ", tradeValuationItem=" + this.tradeValuationItem + '}' + " " + super.toString();
        }
    }
}

