/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.TradingEventSummary;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.recordkeeping.processes.meta.NonpublicExecutionReportRetractedChoiceSequenceMeta;
import fpml.consolidated.shared.OriginatingEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="NonpublicExecutionReportRetractedChoiceSequence", builder=NonpublicExecutionReportRetractedChoiceSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="NonpublicExecutionReportRetractedChoiceSequence", model="fpml", builder=NonpublicExecutionReportRetractedChoiceSequenceBuilderImpl.class, version="1.1.0")
public interface NonpublicExecutionReportRetractedChoiceSequence
extends RosettaModelObject {
    public static final NonpublicExecutionReportRetractedChoiceSequenceMeta metaData = new NonpublicExecutionReportRetractedChoiceSequenceMeta();

    public OriginatingEvent getOriginatingEvent();

    public Trade getTrade();

    public List<? extends TradingEventSummary> getTradingEvent();

    public NonpublicExecutionReportRetractedChoiceSequence build();

    public NonpublicExecutionReportRetractedChoiceSequenceBuilder toBuilder();

    public static NonpublicExecutionReportRetractedChoiceSequenceBuilder builder() {
        return new NonpublicExecutionReportRetractedChoiceSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends NonpublicExecutionReportRetractedChoiceSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends NonpublicExecutionReportRetractedChoiceSequence> getType() {
        return NonpublicExecutionReportRetractedChoiceSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("originatingEvent"), processor, OriginatingEvent.class, this.getOriginatingEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trade"), processor, Trade.class, this.getTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradingEvent"), processor, TradingEventSummary.class, this.getTradingEvent(), new AttributeMeta[0]);
    }

    public static class NonpublicExecutionReportRetractedChoiceSequenceBuilderImpl
    implements NonpublicExecutionReportRetractedChoiceSequenceBuilder {
        protected OriginatingEvent.OriginatingEventBuilder originatingEvent;
        protected Trade.TradeBuilder trade;
        protected List<TradingEventSummary.TradingEventSummaryBuilder> tradingEvent = new ArrayList<TradingEventSummary.TradingEventSummaryBuilder>();

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public OriginatingEvent.OriginatingEventBuilder getOriginatingEvent() {
            return this.originatingEvent;
        }

        @Override
        public OriginatingEvent.OriginatingEventBuilder getOrCreateOriginatingEvent() {
            OriginatingEvent.OriginatingEventBuilder result = this.originatingEvent != null ? this.originatingEvent : (this.originatingEvent = OriginatingEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="trade", isRequired=true)
        @RuneAttribute(value="trade", isRequired=true)
        public Trade.TradeBuilder getTrade() {
            return this.trade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateTrade() {
            Trade.TradeBuilder result = this.trade != null ? this.trade : (this.trade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradingEvent")
        @RuneAttribute(value="tradingEvent")
        public List<? extends TradingEventSummary.TradingEventSummaryBuilder> getTradingEvent() {
            return this.tradingEvent;
        }

        @Override
        public TradingEventSummary.TradingEventSummaryBuilder getOrCreateTradingEvent(int index) {
            if (this.tradingEvent == null) {
                this.tradingEvent = new ArrayList<TradingEventSummary.TradingEventSummaryBuilder>();
            }
            return (TradingEventSummary.TradingEventSummaryBuilder)this.getIndex(this.tradingEvent, index, () -> {
                TradingEventSummary.TradingEventSummaryBuilder newTradingEvent = TradingEventSummary.builder();
                return newTradingEvent;
            });
        }

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public NonpublicExecutionReportRetractedChoiceSequenceBuilder setOriginatingEvent(OriginatingEvent _originatingEvent) {
            this.originatingEvent = _originatingEvent == null ? null : _originatingEvent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trade", isRequired=true)
        @RuneAttribute(value="trade", isRequired=true)
        public NonpublicExecutionReportRetractedChoiceSequenceBuilder setTrade(Trade _trade) {
            this.trade = _trade == null ? null : _trade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingEvent")
        @RuneAttribute(value="tradingEvent")
        public NonpublicExecutionReportRetractedChoiceSequenceBuilder addTradingEvent(TradingEventSummary _tradingEvent) {
            if (_tradingEvent != null) {
                this.tradingEvent.add(_tradingEvent.toBuilder());
            }
            return this;
        }

        @Override
        public NonpublicExecutionReportRetractedChoiceSequenceBuilder addTradingEvent(TradingEventSummary _tradingEvent, int idx) {
            this.getIndex(this.tradingEvent, idx, () -> _tradingEvent.toBuilder());
            return this;
        }

        @Override
        public NonpublicExecutionReportRetractedChoiceSequenceBuilder addTradingEvent(List<? extends TradingEventSummary> tradingEvents) {
            if (tradingEvents != null) {
                for (TradingEventSummary tradingEventSummary : tradingEvents) {
                    this.tradingEvent.add(tradingEventSummary.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradingEvent")
        public NonpublicExecutionReportRetractedChoiceSequenceBuilder setTradingEvent(List<? extends TradingEventSummary> tradingEvents) {
            this.tradingEvent = tradingEvents == null ? new ArrayList<TradingEventSummary.TradingEventSummaryBuilder>() : (List)tradingEvents.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public NonpublicExecutionReportRetractedChoiceSequence build() {
            return new NonpublicExecutionReportRetractedChoiceSequenceImpl(this);
        }

        @Override
        public NonpublicExecutionReportRetractedChoiceSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public NonpublicExecutionReportRetractedChoiceSequenceBuilder prune() {
            if (this.originatingEvent != null && !this.originatingEvent.prune().hasData()) {
                this.originatingEvent = null;
            }
            if (this.trade != null && !this.trade.prune().hasData()) {
                this.trade = null;
            }
            this.tradingEvent = this.tradingEvent.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getOriginatingEvent() != null && this.getOriginatingEvent().hasData()) {
                return true;
            }
            if (this.getTrade() != null && this.getTrade().hasData()) {
                return true;
            }
            return this.getTradingEvent() != null && this.getTradingEvent().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public NonpublicExecutionReportRetractedChoiceSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            NonpublicExecutionReportRetractedChoiceSequenceBuilder o = (NonpublicExecutionReportRetractedChoiceSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOriginatingEvent(), (RosettaModelObjectBuilder)o.getOriginatingEvent(), this::setOriginatingEvent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrade(), (RosettaModelObjectBuilder)o.getTrade(), this::setTrade);
            merger.mergeRosetta(this.getTradingEvent(), o.getTradingEvent(), this::getOrCreateTradingEvent);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NonpublicExecutionReportRetractedChoiceSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.originatingEvent, _that.getOriginatingEvent())) {
                return false;
            }
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            return ListEquals.listEquals(this.tradingEvent, _that.getTradingEvent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.originatingEvent != null ? this.originatingEvent.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.tradingEvent != null ? this.tradingEvent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NonpublicExecutionReportRetractedChoiceSequenceBuilder {originatingEvent=" + this.originatingEvent + ", trade=" + this.trade + ", tradingEvent=" + this.tradingEvent + '}';
        }
    }

    public static interface NonpublicExecutionReportRetractedChoiceSequenceBuilder
    extends NonpublicExecutionReportRetractedChoiceSequence,
    RosettaModelObjectBuilder {
        public OriginatingEvent.OriginatingEventBuilder getOrCreateOriginatingEvent();

        @Override
        public OriginatingEvent.OriginatingEventBuilder getOriginatingEvent();

        public Trade.TradeBuilder getOrCreateTrade();

        @Override
        public Trade.TradeBuilder getTrade();

        public TradingEventSummary.TradingEventSummaryBuilder getOrCreateTradingEvent(int var1);

        public List<? extends TradingEventSummary.TradingEventSummaryBuilder> getTradingEvent();

        public NonpublicExecutionReportRetractedChoiceSequenceBuilder setOriginatingEvent(OriginatingEvent var1);

        public NonpublicExecutionReportRetractedChoiceSequenceBuilder setTrade(Trade var1);

        public NonpublicExecutionReportRetractedChoiceSequenceBuilder addTradingEvent(TradingEventSummary var1);

        public NonpublicExecutionReportRetractedChoiceSequenceBuilder addTradingEvent(TradingEventSummary var1, int var2);

        public NonpublicExecutionReportRetractedChoiceSequenceBuilder addTradingEvent(List<? extends TradingEventSummary> var1);

        public NonpublicExecutionReportRetractedChoiceSequenceBuilder setTradingEvent(List<? extends TradingEventSummary> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("originatingEvent"), processor, OriginatingEvent.OriginatingEventBuilder.class, this.getOriginatingEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trade"), processor, Trade.TradeBuilder.class, this.getTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradingEvent"), processor, TradingEventSummary.TradingEventSummaryBuilder.class, this.getTradingEvent(), new AttributeMeta[0]);
        }

        public NonpublicExecutionReportRetractedChoiceSequenceBuilder prune();
    }

    public static class NonpublicExecutionReportRetractedChoiceSequenceImpl
    implements NonpublicExecutionReportRetractedChoiceSequence {
        private final OriginatingEvent originatingEvent;
        private final Trade trade;
        private final List<? extends TradingEventSummary> tradingEvent;

        protected NonpublicExecutionReportRetractedChoiceSequenceImpl(NonpublicExecutionReportRetractedChoiceSequenceBuilder builder) {
            this.originatingEvent = Optional.ofNullable(builder.getOriginatingEvent()).map(f -> f.build()).orElse(null);
            this.trade = Optional.ofNullable(builder.getTrade()).map(f -> f.build()).orElse(null);
            this.tradingEvent = Optional.ofNullable(builder.getTradingEvent()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public OriginatingEvent getOriginatingEvent() {
            return this.originatingEvent;
        }

        @Override
        @RosettaAttribute(value="trade", isRequired=true)
        @RuneAttribute(value="trade", isRequired=true)
        public Trade getTrade() {
            return this.trade;
        }

        @Override
        @RosettaAttribute(value="tradingEvent")
        @RuneAttribute(value="tradingEvent")
        public List<? extends TradingEventSummary> getTradingEvent() {
            return this.tradingEvent;
        }

        @Override
        public NonpublicExecutionReportRetractedChoiceSequence build() {
            return this;
        }

        @Override
        public NonpublicExecutionReportRetractedChoiceSequenceBuilder toBuilder() {
            NonpublicExecutionReportRetractedChoiceSequenceBuilder builder = NonpublicExecutionReportRetractedChoiceSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NonpublicExecutionReportRetractedChoiceSequenceBuilder builder) {
            Optional.ofNullable(this.getOriginatingEvent()).ifPresent(builder::setOriginatingEvent);
            Optional.ofNullable(this.getTrade()).ifPresent(builder::setTrade);
            Optional.ofNullable(this.getTradingEvent()).ifPresent(builder::setTradingEvent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NonpublicExecutionReportRetractedChoiceSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.originatingEvent, _that.getOriginatingEvent())) {
                return false;
            }
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            return ListEquals.listEquals(this.tradingEvent, _that.getTradingEvent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.originatingEvent != null ? this.originatingEvent.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.tradingEvent != null ? this.tradingEvent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NonpublicExecutionReportRetractedChoiceSequence {originatingEvent=" + this.originatingEvent + ", trade=" + this.trade + ", tradingEvent=" + this.tradingEvent + '}';
        }
    }
}

