/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.AdditionalEvent;
import fpml.consolidated.business.events.ChangeEventsBaseModel;
import fpml.consolidated.business.events.EventValuationModel;
import fpml.consolidated.business.events.OptionsEventsBaseModel;
import fpml.consolidated.business.events.PostTradeEventsBaseModel;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrectableRequestMessage;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.PortfolioReferenceBaseModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.recordkeeping.processes.NonpublicExecutionReportSequence;
import fpml.consolidated.recordkeeping.processes.meta.NonpublicExecutionReportMeta;
import fpml.consolidated.reg.fpmlreporting.shared.RegulatoryReportingCollateralization;
import fpml.consolidated.shared.IdentifiedDate;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import fpml.consolidated.shared.ScheduledDateBase;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="NonpublicExecutionReport", builder=NonpublicExecutionReportBuilderImpl.class, version="1.1.0")
@RuneDataType(value="NonpublicExecutionReport", model="fpml", builder=NonpublicExecutionReportBuilderImpl.class, version="1.1.0")
public interface NonpublicExecutionReport
extends CorrectableRequestMessage {
    public static final NonpublicExecutionReportMeta metaData = new NonpublicExecutionReportMeta();

    public IdentifiedDate getAsOfDate();

    public LocalTime getAsOfTime();

    public PortfolioReferenceBaseModel getPortfolioReferenceBaseModel();

    public NonpublicExecutionReportSequence getNonpublicExecutionReportSequence();

    public PostTradeEventsBaseModel getPostTradeEventsBaseModel();

    public ChangeEventsBaseModel getChangeEventsBaseModel();

    public OptionsEventsBaseModel getOptionsEventsBaseModel();

    public AdditionalEvent getAdditionalEvent();

    public EventValuationModel getEventValuationModel();

    public List<? extends ScheduledDateBase> getScheduledDate();

    public List<? extends RegulatoryReportingCollateralization> getCollateralization();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public NonpublicExecutionReport build();

    @Override
    public NonpublicExecutionReportBuilder toBuilder();

    public static NonpublicExecutionReportBuilder builder() {
        return new NonpublicExecutionReportBuilderImpl();
    }

    default public RosettaMetaData<? extends NonpublicExecutionReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends NonpublicExecutionReport> getType() {
        return NonpublicExecutionReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("asOfDate"), processor, IdentifiedDate.class, this.getAsOfDate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("asOfTime"), LocalTime.class, (Object)this.getAsOfTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolioReferenceBaseModel"), processor, PortfolioReferenceBaseModel.class, this.getPortfolioReferenceBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonpublicExecutionReportSequence"), processor, NonpublicExecutionReportSequence.class, this.getNonpublicExecutionReportSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("postTradeEventsBaseModel"), processor, PostTradeEventsBaseModel.class, this.getPostTradeEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("changeEventsBaseModel"), processor, ChangeEventsBaseModel.class, this.getChangeEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionsEventsBaseModel"), processor, OptionsEventsBaseModel.class, this.getOptionsEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalEvent"), processor, AdditionalEvent.class, this.getAdditionalEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.class, this.getEventValuationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("scheduledDate"), processor, ScheduledDateBase.class, this.getScheduledDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralization"), processor, RegulatoryReportingCollateralization.class, this.getCollateralization(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class NonpublicExecutionReportBuilderImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageBuilderImpl
    implements NonpublicExecutionReportBuilder {
        protected IdentifiedDate.IdentifiedDateBuilder asOfDate;
        protected LocalTime asOfTime;
        protected PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder portfolioReferenceBaseModel;
        protected NonpublicExecutionReportSequence.NonpublicExecutionReportSequenceBuilder nonpublicExecutionReportSequence;
        protected PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder postTradeEventsBaseModel;
        protected ChangeEventsBaseModel.ChangeEventsBaseModelBuilder changeEventsBaseModel;
        protected OptionsEventsBaseModel.OptionsEventsBaseModelBuilder optionsEventsBaseModel;
        protected AdditionalEvent.AdditionalEventBuilder additionalEvent;
        protected EventValuationModel.EventValuationModelBuilder eventValuationModel;
        protected List<ScheduledDateBase.ScheduledDateBaseBuilder> scheduledDate = new ArrayList<ScheduledDateBase.ScheduledDateBaseBuilder>();
        protected List<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder> collateralization = new ArrayList<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="asOfDate")
        @RuneAttribute(value="asOfDate")
        public IdentifiedDate.IdentifiedDateBuilder getAsOfDate() {
            return this.asOfDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateAsOfDate() {
            IdentifiedDate.IdentifiedDateBuilder result = this.asOfDate != null ? this.asOfDate : (this.asOfDate = IdentifiedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="asOfTime")
        @RuneAttribute(value="asOfTime")
        public LocalTime getAsOfTime() {
            return this.asOfTime;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceBaseModel")
        @RuneAttribute(value="portfolioReferenceBaseModel")
        public PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder getPortfolioReferenceBaseModel() {
            return this.portfolioReferenceBaseModel;
        }

        @Override
        public PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder getOrCreatePortfolioReferenceBaseModel() {
            PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder result = this.portfolioReferenceBaseModel != null ? this.portfolioReferenceBaseModel : (this.portfolioReferenceBaseModel = PortfolioReferenceBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nonpublicExecutionReportSequence")
        @RuneAttribute(value="nonpublicExecutionReportSequence")
        public NonpublicExecutionReportSequence.NonpublicExecutionReportSequenceBuilder getNonpublicExecutionReportSequence() {
            return this.nonpublicExecutionReportSequence;
        }

        @Override
        public NonpublicExecutionReportSequence.NonpublicExecutionReportSequenceBuilder getOrCreateNonpublicExecutionReportSequence() {
            NonpublicExecutionReportSequence.NonpublicExecutionReportSequenceBuilder result = this.nonpublicExecutionReportSequence != null ? this.nonpublicExecutionReportSequence : (this.nonpublicExecutionReportSequence = NonpublicExecutionReportSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="postTradeEventsBaseModel")
        @RuneAttribute(value="postTradeEventsBaseModel")
        public PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder getPostTradeEventsBaseModel() {
            return this.postTradeEventsBaseModel;
        }

        @Override
        public PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder getOrCreatePostTradeEventsBaseModel() {
            PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder result = this.postTradeEventsBaseModel != null ? this.postTradeEventsBaseModel : (this.postTradeEventsBaseModel = PostTradeEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="changeEventsBaseModel")
        @RuneAttribute(value="changeEventsBaseModel")
        public ChangeEventsBaseModel.ChangeEventsBaseModelBuilder getChangeEventsBaseModel() {
            return this.changeEventsBaseModel;
        }

        @Override
        public ChangeEventsBaseModel.ChangeEventsBaseModelBuilder getOrCreateChangeEventsBaseModel() {
            ChangeEventsBaseModel.ChangeEventsBaseModelBuilder result = this.changeEventsBaseModel != null ? this.changeEventsBaseModel : (this.changeEventsBaseModel = ChangeEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionsEventsBaseModel")
        @RuneAttribute(value="optionsEventsBaseModel")
        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOptionsEventsBaseModel() {
            return this.optionsEventsBaseModel;
        }

        @Override
        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOrCreateOptionsEventsBaseModel() {
            OptionsEventsBaseModel.OptionsEventsBaseModelBuilder result = this.optionsEventsBaseModel != null ? this.optionsEventsBaseModel : (this.optionsEventsBaseModel = OptionsEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalEvent")
        @RuneAttribute(value="additionalEvent")
        public AdditionalEvent.AdditionalEventBuilder getAdditionalEvent() {
            return this.additionalEvent;
        }

        @Override
        public AdditionalEvent.AdditionalEventBuilder getOrCreateAdditionalEvent() {
            AdditionalEvent.AdditionalEventBuilder result = this.additionalEvent != null ? this.additionalEvent : (this.additionalEvent = AdditionalEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel() {
            EventValuationModel.EventValuationModelBuilder result = this.eventValuationModel != null ? this.eventValuationModel : (this.eventValuationModel = EventValuationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="scheduledDate")
        @RuneAttribute(value="scheduledDate")
        public List<? extends ScheduledDateBase.ScheduledDateBaseBuilder> getScheduledDate() {
            return this.scheduledDate;
        }

        @Override
        public ScheduledDateBase.ScheduledDateBaseBuilder getOrCreateScheduledDate(int index) {
            if (this.scheduledDate == null) {
                this.scheduledDate = new ArrayList<ScheduledDateBase.ScheduledDateBaseBuilder>();
            }
            return (ScheduledDateBase.ScheduledDateBaseBuilder)this.getIndex(this.scheduledDate, index, () -> {
                ScheduledDateBase.ScheduledDateBaseBuilder newScheduledDate = ScheduledDateBase.builder();
                return newScheduledDate;
            });
        }

        @Override
        @RosettaAttribute(value="collateralization")
        @RuneAttribute(value="collateralization")
        public List<? extends RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder> getCollateralization() {
            return this.collateralization;
        }

        @Override
        public RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder getOrCreateCollateralization(int index) {
            if (this.collateralization == null) {
                this.collateralization = new ArrayList<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder>();
            }
            return (RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder)this.getIndex(this.collateralization, index, () -> {
                RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder newCollateralization = RegulatoryReportingCollateralization.builder();
                return newCollateralization;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public NonpublicExecutionReportBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public NonpublicExecutionReportBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public NonpublicExecutionReportBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public NonpublicExecutionReportBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public NonpublicExecutionReportBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public NonpublicExecutionReportBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public NonpublicExecutionReportBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public NonpublicExecutionReportBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="asOfDate")
        @RuneAttribute(value="asOfDate")
        public NonpublicExecutionReportBuilder setAsOfDate(IdentifiedDate _asOfDate) {
            this.asOfDate = _asOfDate == null ? null : _asOfDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="asOfTime")
        @RuneAttribute(value="asOfTime")
        public NonpublicExecutionReportBuilder setAsOfTime(LocalTime _asOfTime) {
            this.asOfTime = _asOfTime == null ? null : _asOfTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceBaseModel")
        @RuneAttribute(value="portfolioReferenceBaseModel")
        public NonpublicExecutionReportBuilder setPortfolioReferenceBaseModel(PortfolioReferenceBaseModel _portfolioReferenceBaseModel) {
            this.portfolioReferenceBaseModel = _portfolioReferenceBaseModel == null ? null : _portfolioReferenceBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nonpublicExecutionReportSequence")
        @RuneAttribute(value="nonpublicExecutionReportSequence")
        public NonpublicExecutionReportBuilder setNonpublicExecutionReportSequence(NonpublicExecutionReportSequence _nonpublicExecutionReportSequence) {
            this.nonpublicExecutionReportSequence = _nonpublicExecutionReportSequence == null ? null : _nonpublicExecutionReportSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="postTradeEventsBaseModel")
        @RuneAttribute(value="postTradeEventsBaseModel")
        public NonpublicExecutionReportBuilder setPostTradeEventsBaseModel(PostTradeEventsBaseModel _postTradeEventsBaseModel) {
            this.postTradeEventsBaseModel = _postTradeEventsBaseModel == null ? null : _postTradeEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="changeEventsBaseModel")
        @RuneAttribute(value="changeEventsBaseModel")
        public NonpublicExecutionReportBuilder setChangeEventsBaseModel(ChangeEventsBaseModel _changeEventsBaseModel) {
            this.changeEventsBaseModel = _changeEventsBaseModel == null ? null : _changeEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionsEventsBaseModel")
        @RuneAttribute(value="optionsEventsBaseModel")
        public NonpublicExecutionReportBuilder setOptionsEventsBaseModel(OptionsEventsBaseModel _optionsEventsBaseModel) {
            this.optionsEventsBaseModel = _optionsEventsBaseModel == null ? null : _optionsEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalEvent")
        @RuneAttribute(value="additionalEvent")
        public NonpublicExecutionReportBuilder setAdditionalEvent(AdditionalEvent _additionalEvent) {
            this.additionalEvent = _additionalEvent == null ? null : _additionalEvent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public NonpublicExecutionReportBuilder setEventValuationModel(EventValuationModel _eventValuationModel) {
            this.eventValuationModel = _eventValuationModel == null ? null : _eventValuationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="scheduledDate")
        @RuneAttribute(value="scheduledDate")
        public NonpublicExecutionReportBuilder addScheduledDate(ScheduledDateBase _scheduledDate) {
            if (_scheduledDate != null) {
                this.scheduledDate.add(_scheduledDate.toBuilder());
            }
            return this;
        }

        @Override
        public NonpublicExecutionReportBuilder addScheduledDate(ScheduledDateBase _scheduledDate, int idx) {
            this.getIndex(this.scheduledDate, idx, () -> _scheduledDate.toBuilder());
            return this;
        }

        @Override
        public NonpublicExecutionReportBuilder addScheduledDate(List<? extends ScheduledDateBase> scheduledDates) {
            if (scheduledDates != null) {
                for (ScheduledDateBase scheduledDateBase : scheduledDates) {
                    this.scheduledDate.add(scheduledDateBase.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="scheduledDate")
        public NonpublicExecutionReportBuilder setScheduledDate(List<? extends ScheduledDateBase> scheduledDates) {
            this.scheduledDate = scheduledDates == null ? new ArrayList<ScheduledDateBase.ScheduledDateBaseBuilder>() : (List)scheduledDates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralization")
        @RuneAttribute(value="collateralization")
        public NonpublicExecutionReportBuilder addCollateralization(RegulatoryReportingCollateralization _collateralization) {
            if (_collateralization != null) {
                this.collateralization.add(_collateralization.toBuilder());
            }
            return this;
        }

        @Override
        public NonpublicExecutionReportBuilder addCollateralization(RegulatoryReportingCollateralization _collateralization, int idx) {
            this.getIndex(this.collateralization, idx, () -> _collateralization.toBuilder());
            return this;
        }

        @Override
        public NonpublicExecutionReportBuilder addCollateralization(List<? extends RegulatoryReportingCollateralization> collateralizations) {
            if (collateralizations != null) {
                for (RegulatoryReportingCollateralization regulatoryReportingCollateralization : collateralizations) {
                    this.collateralization.add(regulatoryReportingCollateralization.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateralization")
        public NonpublicExecutionReportBuilder setCollateralization(List<? extends RegulatoryReportingCollateralization> collateralizations) {
            this.collateralization = collateralizations == null ? new ArrayList<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder>() : (List)collateralizations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public NonpublicExecutionReportBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public NonpublicExecutionReport build() {
            return new NonpublicExecutionReportImpl(this);
        }

        @Override
        public NonpublicExecutionReportBuilder toBuilder() {
            return this;
        }

        @Override
        public NonpublicExecutionReportBuilder prune() {
            super.prune();
            if (this.asOfDate != null && !this.asOfDate.prune().hasData()) {
                this.asOfDate = null;
            }
            if (this.portfolioReferenceBaseModel != null && !this.portfolioReferenceBaseModel.prune().hasData()) {
                this.portfolioReferenceBaseModel = null;
            }
            if (this.nonpublicExecutionReportSequence != null && !this.nonpublicExecutionReportSequence.prune().hasData()) {
                this.nonpublicExecutionReportSequence = null;
            }
            if (this.postTradeEventsBaseModel != null && !this.postTradeEventsBaseModel.prune().hasData()) {
                this.postTradeEventsBaseModel = null;
            }
            if (this.changeEventsBaseModel != null && !this.changeEventsBaseModel.prune().hasData()) {
                this.changeEventsBaseModel = null;
            }
            if (this.optionsEventsBaseModel != null && !this.optionsEventsBaseModel.prune().hasData()) {
                this.optionsEventsBaseModel = null;
            }
            if (this.additionalEvent != null && !this.additionalEvent.prune().hasData()) {
                this.additionalEvent = null;
            }
            if (this.eventValuationModel != null && !this.eventValuationModel.prune().hasData()) {
                this.eventValuationModel = null;
            }
            this.scheduledDate = this.scheduledDate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.collateralization = this.collateralization.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAsOfDate() != null && this.getAsOfDate().hasData()) {
                return true;
            }
            if (this.getAsOfTime() != null) {
                return true;
            }
            if (this.getPortfolioReferenceBaseModel() != null && this.getPortfolioReferenceBaseModel().hasData()) {
                return true;
            }
            if (this.getNonpublicExecutionReportSequence() != null && this.getNonpublicExecutionReportSequence().hasData()) {
                return true;
            }
            if (this.getPostTradeEventsBaseModel() != null && this.getPostTradeEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getChangeEventsBaseModel() != null && this.getChangeEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getOptionsEventsBaseModel() != null && this.getOptionsEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getAdditionalEvent() != null && this.getAdditionalEvent().hasData()) {
                return true;
            }
            if (this.getEventValuationModel() != null && this.getEventValuationModel().hasData()) {
                return true;
            }
            if (this.getScheduledDate() != null && this.getScheduledDate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCollateralization() != null && this.getCollateralization().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public NonpublicExecutionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            NonpublicExecutionReportBuilder o = (NonpublicExecutionReportBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAsOfDate(), (RosettaModelObjectBuilder)o.getAsOfDate(), this::setAsOfDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPortfolioReferenceBaseModel(), (RosettaModelObjectBuilder)o.getPortfolioReferenceBaseModel(), this::setPortfolioReferenceBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNonpublicExecutionReportSequence(), (RosettaModelObjectBuilder)o.getNonpublicExecutionReportSequence(), this::setNonpublicExecutionReportSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPostTradeEventsBaseModel(), (RosettaModelObjectBuilder)o.getPostTradeEventsBaseModel(), this::setPostTradeEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getChangeEventsBaseModel(), (RosettaModelObjectBuilder)o.getChangeEventsBaseModel(), this::setChangeEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionsEventsBaseModel(), (RosettaModelObjectBuilder)o.getOptionsEventsBaseModel(), this::setOptionsEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdditionalEvent(), (RosettaModelObjectBuilder)o.getAdditionalEvent(), this::setAdditionalEvent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventValuationModel(), (RosettaModelObjectBuilder)o.getEventValuationModel(), this::setEventValuationModel);
            merger.mergeRosetta(this.getScheduledDate(), o.getScheduledDate(), this::getOrCreateScheduledDate);
            merger.mergeRosetta(this.getCollateralization(), o.getCollateralization(), this::getOrCreateCollateralization);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            merger.mergeBasic((Object)this.getAsOfTime(), (Object)o.getAsOfTime(), this::setAsOfTime, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NonpublicExecutionReport _that = (NonpublicExecutionReport)this.getType().cast(o);
            if (!Objects.equals(this.asOfDate, _that.getAsOfDate())) {
                return false;
            }
            if (!Objects.equals(this.asOfTime, _that.getAsOfTime())) {
                return false;
            }
            if (!Objects.equals(this.portfolioReferenceBaseModel, _that.getPortfolioReferenceBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.nonpublicExecutionReportSequence, _that.getNonpublicExecutionReportSequence())) {
                return false;
            }
            if (!Objects.equals(this.postTradeEventsBaseModel, _that.getPostTradeEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.changeEventsBaseModel, _that.getChangeEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.optionsEventsBaseModel, _that.getOptionsEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.additionalEvent, _that.getAdditionalEvent())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.scheduledDate, _that.getScheduledDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralization, _that.getCollateralization())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.asOfDate != null ? this.asOfDate.hashCode() : 0);
            _result = 31 * _result + (this.asOfTime != null ? this.asOfTime.hashCode() : 0);
            _result = 31 * _result + (this.portfolioReferenceBaseModel != null ? this.portfolioReferenceBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.nonpublicExecutionReportSequence != null ? this.nonpublicExecutionReportSequence.hashCode() : 0);
            _result = 31 * _result + (this.postTradeEventsBaseModel != null ? this.postTradeEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.changeEventsBaseModel != null ? this.changeEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.optionsEventsBaseModel != null ? this.optionsEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.additionalEvent != null ? this.additionalEvent.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.scheduledDate != null ? this.scheduledDate.hashCode() : 0);
            _result = 31 * _result + (this.collateralization != null ? this.collateralization.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "NonpublicExecutionReportBuilder {asOfDate=" + this.asOfDate + ", asOfTime=" + this.asOfTime + ", portfolioReferenceBaseModel=" + this.portfolioReferenceBaseModel + ", nonpublicExecutionReportSequence=" + this.nonpublicExecutionReportSequence + ", postTradeEventsBaseModel=" + this.postTradeEventsBaseModel + ", changeEventsBaseModel=" + this.changeEventsBaseModel + ", optionsEventsBaseModel=" + this.optionsEventsBaseModel + ", additionalEvent=" + this.additionalEvent + ", eventValuationModel=" + this.eventValuationModel + ", scheduledDate=" + this.scheduledDate + ", collateralization=" + this.collateralization + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface NonpublicExecutionReportBuilder
    extends NonpublicExecutionReport,
    CorrectableRequestMessage.CorrectableRequestMessageBuilder {
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateAsOfDate();

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getAsOfDate();

        public PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder getOrCreatePortfolioReferenceBaseModel();

        @Override
        public PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder getPortfolioReferenceBaseModel();

        public NonpublicExecutionReportSequence.NonpublicExecutionReportSequenceBuilder getOrCreateNonpublicExecutionReportSequence();

        @Override
        public NonpublicExecutionReportSequence.NonpublicExecutionReportSequenceBuilder getNonpublicExecutionReportSequence();

        public PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder getOrCreatePostTradeEventsBaseModel();

        @Override
        public PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder getPostTradeEventsBaseModel();

        public ChangeEventsBaseModel.ChangeEventsBaseModelBuilder getOrCreateChangeEventsBaseModel();

        @Override
        public ChangeEventsBaseModel.ChangeEventsBaseModelBuilder getChangeEventsBaseModel();

        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOrCreateOptionsEventsBaseModel();

        @Override
        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOptionsEventsBaseModel();

        public AdditionalEvent.AdditionalEventBuilder getOrCreateAdditionalEvent();

        @Override
        public AdditionalEvent.AdditionalEventBuilder getAdditionalEvent();

        public EventValuationModel.EventValuationModelBuilder getOrCreateEventValuationModel();

        @Override
        public EventValuationModel.EventValuationModelBuilder getEventValuationModel();

        public ScheduledDateBase.ScheduledDateBaseBuilder getOrCreateScheduledDate(int var1);

        public List<? extends ScheduledDateBase.ScheduledDateBaseBuilder> getScheduledDate();

        public RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder getOrCreateCollateralization(int var1);

        public List<? extends RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder> getCollateralization();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public NonpublicExecutionReportBuilder setFpmlVersion(String var1);

        @Override
        public NonpublicExecutionReportBuilder setExpectedBuild(Integer var1);

        @Override
        public NonpublicExecutionReportBuilder setActualBuild(Integer var1);

        @Override
        public NonpublicExecutionReportBuilder setHeader(RequestMessageHeader var1);

        @Override
        public NonpublicExecutionReportBuilder setValidationModel(ValidationModel var1);

        @Override
        public NonpublicExecutionReportBuilder setIsCorrection(Boolean var1);

        @Override
        public NonpublicExecutionReportBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public NonpublicExecutionReportBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public NonpublicExecutionReportBuilder setAsOfDate(IdentifiedDate var1);

        public NonpublicExecutionReportBuilder setAsOfTime(LocalTime var1);

        public NonpublicExecutionReportBuilder setPortfolioReferenceBaseModel(PortfolioReferenceBaseModel var1);

        public NonpublicExecutionReportBuilder setNonpublicExecutionReportSequence(NonpublicExecutionReportSequence var1);

        public NonpublicExecutionReportBuilder setPostTradeEventsBaseModel(PostTradeEventsBaseModel var1);

        public NonpublicExecutionReportBuilder setChangeEventsBaseModel(ChangeEventsBaseModel var1);

        public NonpublicExecutionReportBuilder setOptionsEventsBaseModel(OptionsEventsBaseModel var1);

        public NonpublicExecutionReportBuilder setAdditionalEvent(AdditionalEvent var1);

        public NonpublicExecutionReportBuilder setEventValuationModel(EventValuationModel var1);

        public NonpublicExecutionReportBuilder addScheduledDate(ScheduledDateBase var1);

        public NonpublicExecutionReportBuilder addScheduledDate(ScheduledDateBase var1, int var2);

        public NonpublicExecutionReportBuilder addScheduledDate(List<? extends ScheduledDateBase> var1);

        public NonpublicExecutionReportBuilder setScheduledDate(List<? extends ScheduledDateBase> var1);

        public NonpublicExecutionReportBuilder addCollateralization(RegulatoryReportingCollateralization var1);

        public NonpublicExecutionReportBuilder addCollateralization(RegulatoryReportingCollateralization var1, int var2);

        public NonpublicExecutionReportBuilder addCollateralization(List<? extends RegulatoryReportingCollateralization> var1);

        public NonpublicExecutionReportBuilder setCollateralization(List<? extends RegulatoryReportingCollateralization> var1);

        public NonpublicExecutionReportBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("asOfDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getAsOfDate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("asOfTime"), LocalTime.class, (Object)this.getAsOfTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolioReferenceBaseModel"), processor, PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder.class, this.getPortfolioReferenceBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonpublicExecutionReportSequence"), processor, NonpublicExecutionReportSequence.NonpublicExecutionReportSequenceBuilder.class, this.getNonpublicExecutionReportSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("postTradeEventsBaseModel"), processor, PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder.class, this.getPostTradeEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("changeEventsBaseModel"), processor, ChangeEventsBaseModel.ChangeEventsBaseModelBuilder.class, this.getChangeEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionsEventsBaseModel"), processor, OptionsEventsBaseModel.OptionsEventsBaseModelBuilder.class, this.getOptionsEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalEvent"), processor, AdditionalEvent.AdditionalEventBuilder.class, this.getAdditionalEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventValuationModel"), processor, EventValuationModel.EventValuationModelBuilder.class, this.getEventValuationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("scheduledDate"), processor, ScheduledDateBase.ScheduledDateBaseBuilder.class, this.getScheduledDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralization"), processor, RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder.class, this.getCollateralization(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public NonpublicExecutionReportBuilder prune();
    }

    public static class NonpublicExecutionReportImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageImpl
    implements NonpublicExecutionReport {
        private final IdentifiedDate asOfDate;
        private final LocalTime asOfTime;
        private final PortfolioReferenceBaseModel portfolioReferenceBaseModel;
        private final NonpublicExecutionReportSequence nonpublicExecutionReportSequence;
        private final PostTradeEventsBaseModel postTradeEventsBaseModel;
        private final ChangeEventsBaseModel changeEventsBaseModel;
        private final OptionsEventsBaseModel optionsEventsBaseModel;
        private final AdditionalEvent additionalEvent;
        private final EventValuationModel eventValuationModel;
        private final List<? extends ScheduledDateBase> scheduledDate;
        private final List<? extends RegulatoryReportingCollateralization> collateralization;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected NonpublicExecutionReportImpl(NonpublicExecutionReportBuilder builder) {
            super(builder);
            this.asOfDate = Optional.ofNullable(builder.getAsOfDate()).map(f -> f.build()).orElse(null);
            this.asOfTime = builder.getAsOfTime();
            this.portfolioReferenceBaseModel = Optional.ofNullable(builder.getPortfolioReferenceBaseModel()).map(f -> f.build()).orElse(null);
            this.nonpublicExecutionReportSequence = Optional.ofNullable(builder.getNonpublicExecutionReportSequence()).map(f -> f.build()).orElse(null);
            this.postTradeEventsBaseModel = Optional.ofNullable(builder.getPostTradeEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.changeEventsBaseModel = Optional.ofNullable(builder.getChangeEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.optionsEventsBaseModel = Optional.ofNullable(builder.getOptionsEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.additionalEvent = Optional.ofNullable(builder.getAdditionalEvent()).map(f -> f.build()).orElse(null);
            this.eventValuationModel = Optional.ofNullable(builder.getEventValuationModel()).map(f -> f.build()).orElse(null);
            this.scheduledDate = Optional.ofNullable(builder.getScheduledDate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateralization = Optional.ofNullable(builder.getCollateralization()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="asOfDate")
        @RuneAttribute(value="asOfDate")
        public IdentifiedDate getAsOfDate() {
            return this.asOfDate;
        }

        @Override
        @RosettaAttribute(value="asOfTime")
        @RuneAttribute(value="asOfTime")
        public LocalTime getAsOfTime() {
            return this.asOfTime;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceBaseModel")
        @RuneAttribute(value="portfolioReferenceBaseModel")
        public PortfolioReferenceBaseModel getPortfolioReferenceBaseModel() {
            return this.portfolioReferenceBaseModel;
        }

        @Override
        @RosettaAttribute(value="nonpublicExecutionReportSequence")
        @RuneAttribute(value="nonpublicExecutionReportSequence")
        public NonpublicExecutionReportSequence getNonpublicExecutionReportSequence() {
            return this.nonpublicExecutionReportSequence;
        }

        @Override
        @RosettaAttribute(value="postTradeEventsBaseModel")
        @RuneAttribute(value="postTradeEventsBaseModel")
        public PostTradeEventsBaseModel getPostTradeEventsBaseModel() {
            return this.postTradeEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="changeEventsBaseModel")
        @RuneAttribute(value="changeEventsBaseModel")
        public ChangeEventsBaseModel getChangeEventsBaseModel() {
            return this.changeEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="optionsEventsBaseModel")
        @RuneAttribute(value="optionsEventsBaseModel")
        public OptionsEventsBaseModel getOptionsEventsBaseModel() {
            return this.optionsEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="additionalEvent")
        @RuneAttribute(value="additionalEvent")
        public AdditionalEvent getAdditionalEvent() {
            return this.additionalEvent;
        }

        @Override
        @RosettaAttribute(value="eventValuationModel")
        @RuneAttribute(value="eventValuationModel")
        public EventValuationModel getEventValuationModel() {
            return this.eventValuationModel;
        }

        @Override
        @RosettaAttribute(value="scheduledDate")
        @RuneAttribute(value="scheduledDate")
        public List<? extends ScheduledDateBase> getScheduledDate() {
            return this.scheduledDate;
        }

        @Override
        @RosettaAttribute(value="collateralization")
        @RuneAttribute(value="collateralization")
        public List<? extends RegulatoryReportingCollateralization> getCollateralization() {
            return this.collateralization;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public NonpublicExecutionReport build() {
            return this;
        }

        @Override
        public NonpublicExecutionReportBuilder toBuilder() {
            NonpublicExecutionReportBuilder builder = NonpublicExecutionReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NonpublicExecutionReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAsOfDate()).ifPresent(builder::setAsOfDate);
            Optional.ofNullable(this.getAsOfTime()).ifPresent(builder::setAsOfTime);
            Optional.ofNullable(this.getPortfolioReferenceBaseModel()).ifPresent(builder::setPortfolioReferenceBaseModel);
            Optional.ofNullable(this.getNonpublicExecutionReportSequence()).ifPresent(builder::setNonpublicExecutionReportSequence);
            Optional.ofNullable(this.getPostTradeEventsBaseModel()).ifPresent(builder::setPostTradeEventsBaseModel);
            Optional.ofNullable(this.getChangeEventsBaseModel()).ifPresent(builder::setChangeEventsBaseModel);
            Optional.ofNullable(this.getOptionsEventsBaseModel()).ifPresent(builder::setOptionsEventsBaseModel);
            Optional.ofNullable(this.getAdditionalEvent()).ifPresent(builder::setAdditionalEvent);
            Optional.ofNullable(this.getEventValuationModel()).ifPresent(builder::setEventValuationModel);
            Optional.ofNullable(this.getScheduledDate()).ifPresent(builder::setScheduledDate);
            Optional.ofNullable(this.getCollateralization()).ifPresent(builder::setCollateralization);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NonpublicExecutionReport _that = (NonpublicExecutionReport)this.getType().cast(o);
            if (!Objects.equals(this.asOfDate, _that.getAsOfDate())) {
                return false;
            }
            if (!Objects.equals(this.asOfTime, _that.getAsOfTime())) {
                return false;
            }
            if (!Objects.equals(this.portfolioReferenceBaseModel, _that.getPortfolioReferenceBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.nonpublicExecutionReportSequence, _that.getNonpublicExecutionReportSequence())) {
                return false;
            }
            if (!Objects.equals(this.postTradeEventsBaseModel, _that.getPostTradeEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.changeEventsBaseModel, _that.getChangeEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.optionsEventsBaseModel, _that.getOptionsEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.additionalEvent, _that.getAdditionalEvent())) {
                return false;
            }
            if (!Objects.equals(this.eventValuationModel, _that.getEventValuationModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.scheduledDate, _that.getScheduledDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralization, _that.getCollateralization())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.asOfDate != null ? this.asOfDate.hashCode() : 0);
            _result = 31 * _result + (this.asOfTime != null ? this.asOfTime.hashCode() : 0);
            _result = 31 * _result + (this.portfolioReferenceBaseModel != null ? this.portfolioReferenceBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.nonpublicExecutionReportSequence != null ? this.nonpublicExecutionReportSequence.hashCode() : 0);
            _result = 31 * _result + (this.postTradeEventsBaseModel != null ? this.postTradeEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.changeEventsBaseModel != null ? this.changeEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.optionsEventsBaseModel != null ? this.optionsEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.additionalEvent != null ? this.additionalEvent.hashCode() : 0);
            _result = 31 * _result + (this.eventValuationModel != null ? this.eventValuationModel.hashCode() : 0);
            _result = 31 * _result + (this.scheduledDate != null ? this.scheduledDate.hashCode() : 0);
            _result = 31 * _result + (this.collateralization != null ? this.collateralization.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "NonpublicExecutionReport {asOfDate=" + this.asOfDate + ", asOfTime=" + this.asOfTime + ", portfolioReferenceBaseModel=" + this.portfolioReferenceBaseModel + ", nonpublicExecutionReportSequence=" + this.nonpublicExecutionReportSequence + ", postTradeEventsBaseModel=" + this.postTradeEventsBaseModel + ", changeEventsBaseModel=" + this.changeEventsBaseModel + ", optionsEventsBaseModel=" + this.optionsEventsBaseModel + ", additionalEvent=" + this.additionalEvent + ", eventValuationModel=" + this.eventValuationModel + ", scheduledDate=" + this.scheduledDate + ", collateralization=" + this.collateralization + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

