/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.recordkeeping.processes.ESMAIndexIdentification;
import fpml.consolidated.recordkeeping.processes.meta.ESMAProductUnderlyerSequenceMeta;
import fpml.consolidated.shared.InstrumentId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ESMAProductUnderlyerSequence", builder=ESMAProductUnderlyerSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ESMAProductUnderlyerSequence", model="fpml", builder=ESMAProductUnderlyerSequenceBuilderImpl.class, version="1.1.0")
public interface ESMAProductUnderlyerSequence
extends RosettaModelObject {
    public static final ESMAProductUnderlyerSequenceMeta metaData = new ESMAProductUnderlyerSequenceMeta();

    public List<? extends InstrumentId> getInstrumentId();

    public ESMAIndexIdentification getIndex();

    public ZonedDateTime getMaturityDate();

    public ESMAProductUnderlyerSequence build();

    public ESMAProductUnderlyerSequenceBuilder toBuilder();

    public static ESMAProductUnderlyerSequenceBuilder builder() {
        return new ESMAProductUnderlyerSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends ESMAProductUnderlyerSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ESMAProductUnderlyerSequence> getType() {
        return ESMAProductUnderlyerSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("index"), processor, ESMAIndexIdentification.class, this.getIndex(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDate"), ZonedDateTime.class, (Object)this.getMaturityDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ESMAProductUnderlyerSequenceBuilderImpl
    implements ESMAProductUnderlyerSequenceBuilder {
        protected List<InstrumentId.InstrumentIdBuilder> instrumentId = new ArrayList<InstrumentId.InstrumentIdBuilder>();
        protected ESMAIndexIdentification.ESMAIndexIdentificationBuilder index;
        protected ZonedDateTime maturityDate;

        @Override
        @RosettaAttribute(value="instrumentId")
        @RuneAttribute(value="instrumentId")
        public List<? extends InstrumentId.InstrumentIdBuilder> getInstrumentId() {
            return this.instrumentId;
        }

        @Override
        public InstrumentId.InstrumentIdBuilder getOrCreateInstrumentId(int _index) {
            if (this.instrumentId == null) {
                this.instrumentId = new ArrayList<InstrumentId.InstrumentIdBuilder>();
            }
            return (InstrumentId.InstrumentIdBuilder)this.getIndex(this.instrumentId, _index, () -> {
                InstrumentId.InstrumentIdBuilder newInstrumentId = InstrumentId.builder();
                return newInstrumentId;
            });
        }

        @Override
        @RosettaAttribute(value="index")
        @RuneAttribute(value="index")
        public ESMAIndexIdentification.ESMAIndexIdentificationBuilder getIndex() {
            return this.index;
        }

        @Override
        public ESMAIndexIdentification.ESMAIndexIdentificationBuilder getOrCreateIndex() {
            ESMAIndexIdentification.ESMAIndexIdentificationBuilder result = this.index != null ? this.index : (this.index = ESMAIndexIdentification.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="maturityDate")
        @RuneAttribute(value="maturityDate")
        public ZonedDateTime getMaturityDate() {
            return this.maturityDate;
        }

        @Override
        @RosettaAttribute(value="instrumentId")
        @RuneAttribute(value="instrumentId")
        public ESMAProductUnderlyerSequenceBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public ESMAProductUnderlyerSequenceBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public ESMAProductUnderlyerSequenceBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public ESMAProductUnderlyerSequenceBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList<InstrumentId.InstrumentIdBuilder>() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="index")
        @RuneAttribute(value="index")
        public ESMAProductUnderlyerSequenceBuilder setIndex(ESMAIndexIdentification _index) {
            this.index = _index == null ? null : _index.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDate")
        @RuneAttribute(value="maturityDate")
        public ESMAProductUnderlyerSequenceBuilder setMaturityDate(ZonedDateTime _maturityDate) {
            this.maturityDate = _maturityDate == null ? null : _maturityDate;
            return this;
        }

        @Override
        public ESMAProductUnderlyerSequence build() {
            return new ESMAProductUnderlyerSequenceImpl(this);
        }

        @Override
        public ESMAProductUnderlyerSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public ESMAProductUnderlyerSequenceBuilder prune() {
            this.instrumentId = this.instrumentId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.index != null && !this.index.prune().hasData()) {
                this.index = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getInstrumentId() != null && this.getInstrumentId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getIndex() != null && this.getIndex().hasData()) {
                return true;
            }
            return this.getMaturityDate() != null;
        }

        public ESMAProductUnderlyerSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ESMAProductUnderlyerSequenceBuilder o = (ESMAProductUnderlyerSequenceBuilder)other;
            merger.mergeRosetta(this.getInstrumentId(), o.getInstrumentId(), this::getOrCreateInstrumentId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndex(), (RosettaModelObjectBuilder)o.getIndex(), this::setIndex);
            merger.mergeBasic((Object)this.getMaturityDate(), (Object)o.getMaturityDate(), this::setMaturityDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ESMAProductUnderlyerSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.instrumentId, _that.getInstrumentId())) {
                return false;
            }
            if (!Objects.equals(this.index, _that.getIndex())) {
                return false;
            }
            return Objects.equals(this.maturityDate, _that.getMaturityDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.instrumentId != null ? this.instrumentId.hashCode() : 0);
            _result = 31 * _result + (this.index != null ? this.index.hashCode() : 0);
            _result = 31 * _result + (this.maturityDate != null ? this.maturityDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ESMAProductUnderlyerSequenceBuilder {instrumentId=" + this.instrumentId + ", index=" + this.index + ", maturityDate=" + this.maturityDate + '}';
        }
    }

    public static interface ESMAProductUnderlyerSequenceBuilder
    extends ESMAProductUnderlyerSequence,
    RosettaModelObjectBuilder {
        public InstrumentId.InstrumentIdBuilder getOrCreateInstrumentId(int var1);

        public List<? extends InstrumentId.InstrumentIdBuilder> getInstrumentId();

        public ESMAIndexIdentification.ESMAIndexIdentificationBuilder getOrCreateIndex();

        @Override
        public ESMAIndexIdentification.ESMAIndexIdentificationBuilder getIndex();

        public ESMAProductUnderlyerSequenceBuilder addInstrumentId(InstrumentId var1);

        public ESMAProductUnderlyerSequenceBuilder addInstrumentId(InstrumentId var1, int var2);

        public ESMAProductUnderlyerSequenceBuilder addInstrumentId(List<? extends InstrumentId> var1);

        public ESMAProductUnderlyerSequenceBuilder setInstrumentId(List<? extends InstrumentId> var1);

        public ESMAProductUnderlyerSequenceBuilder setIndex(ESMAIndexIdentification var1);

        public ESMAProductUnderlyerSequenceBuilder setMaturityDate(ZonedDateTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("index"), processor, ESMAIndexIdentification.ESMAIndexIdentificationBuilder.class, this.getIndex(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDate"), ZonedDateTime.class, (Object)this.getMaturityDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ESMAProductUnderlyerSequenceBuilder prune();
    }

    public static class ESMAProductUnderlyerSequenceImpl
    implements ESMAProductUnderlyerSequence {
        private final List<? extends InstrumentId> instrumentId;
        private final ESMAIndexIdentification index;
        private final ZonedDateTime maturityDate;

        protected ESMAProductUnderlyerSequenceImpl(ESMAProductUnderlyerSequenceBuilder builder) {
            this.instrumentId = Optional.ofNullable(builder.getInstrumentId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.index = Optional.ofNullable(builder.getIndex()).map(f -> f.build()).orElse(null);
            this.maturityDate = builder.getMaturityDate();
        }

        @Override
        @RosettaAttribute(value="instrumentId")
        @RuneAttribute(value="instrumentId")
        public List<? extends InstrumentId> getInstrumentId() {
            return this.instrumentId;
        }

        @Override
        @RosettaAttribute(value="index")
        @RuneAttribute(value="index")
        public ESMAIndexIdentification getIndex() {
            return this.index;
        }

        @Override
        @RosettaAttribute(value="maturityDate")
        @RuneAttribute(value="maturityDate")
        public ZonedDateTime getMaturityDate() {
            return this.maturityDate;
        }

        @Override
        public ESMAProductUnderlyerSequence build() {
            return this;
        }

        @Override
        public ESMAProductUnderlyerSequenceBuilder toBuilder() {
            ESMAProductUnderlyerSequenceBuilder builder = ESMAProductUnderlyerSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ESMAProductUnderlyerSequenceBuilder builder) {
            Optional.ofNullable(this.getInstrumentId()).ifPresent(builder::setInstrumentId);
            Optional.ofNullable(this.getIndex()).ifPresent(builder::setIndex);
            Optional.ofNullable(this.getMaturityDate()).ifPresent(builder::setMaturityDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ESMAProductUnderlyerSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.instrumentId, _that.getInstrumentId())) {
                return false;
            }
            if (!Objects.equals(this.index, _that.getIndex())) {
                return false;
            }
            return Objects.equals(this.maturityDate, _that.getMaturityDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.instrumentId != null ? this.instrumentId.hashCode() : 0);
            _result = 31 * _result + (this.index != null ? this.index.hashCode() : 0);
            _result = 31 * _result + (this.maturityDate != null ? this.maturityDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ESMAProductUnderlyerSequence {instrumentId=" + this.instrumentId + ", index=" + this.index + ", maturityDate=" + this.maturityDate + '}';
        }
    }
}

