/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.msg;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.AdditionalData;
import fpml.consolidated.doc.Reason;
import fpml.consolidated.msg.meta.ExceptionModelMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExceptionModel", builder=ExceptionModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ExceptionModel", model="fpml", builder=ExceptionModelBuilderImpl.class, version="1.1.0")
public interface ExceptionModel
extends RosettaModelObject {
    public static final ExceptionModelMeta metaData = new ExceptionModelMeta();

    public List<? extends Reason> getReason();

    public AdditionalData getAdditionalData();

    public ExceptionModel build();

    public ExceptionModelBuilder toBuilder();

    public static ExceptionModelBuilder builder() {
        return new ExceptionModelBuilderImpl();
    }

    default public RosettaMetaData<? extends ExceptionModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExceptionModel> getType() {
        return ExceptionModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("reason"), processor, Reason.class, this.getReason(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalData"), processor, AdditionalData.class, this.getAdditionalData(), new AttributeMeta[0]);
    }

    public static class ExceptionModelBuilderImpl
    implements ExceptionModelBuilder {
        protected List<Reason.ReasonBuilder> reason = new ArrayList<Reason.ReasonBuilder>();
        protected AdditionalData.AdditionalDataBuilder additionalData;

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason.ReasonBuilder> getReason() {
            return this.reason;
        }

        @Override
        public Reason.ReasonBuilder getOrCreateReason(int index) {
            if (this.reason == null) {
                this.reason = new ArrayList<Reason.ReasonBuilder>();
            }
            return (Reason.ReasonBuilder)this.getIndex(this.reason, index, () -> {
                Reason.ReasonBuilder newReason = Reason.builder();
                return newReason;
            });
        }

        @Override
        @RosettaAttribute(value="additionalData")
        @RuneAttribute(value="additionalData")
        public AdditionalData.AdditionalDataBuilder getAdditionalData() {
            return this.additionalData;
        }

        @Override
        public AdditionalData.AdditionalDataBuilder getOrCreateAdditionalData() {
            AdditionalData.AdditionalDataBuilder result = this.additionalData != null ? this.additionalData : (this.additionalData = AdditionalData.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public ExceptionModelBuilder addReason(Reason _reason) {
            if (_reason != null) {
                this.reason.add(_reason.toBuilder());
            }
            return this;
        }

        @Override
        public ExceptionModelBuilder addReason(Reason _reason, int idx) {
            this.getIndex(this.reason, idx, () -> _reason.toBuilder());
            return this;
        }

        @Override
        public ExceptionModelBuilder addReason(List<? extends Reason> reasons) {
            if (reasons != null) {
                for (Reason reason : reasons) {
                    this.reason.add(reason.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reason")
        public ExceptionModelBuilder setReason(List<? extends Reason> reasons) {
            this.reason = reasons == null ? new ArrayList<Reason.ReasonBuilder>() : (List)reasons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalData")
        @RuneAttribute(value="additionalData")
        public ExceptionModelBuilder setAdditionalData(AdditionalData _additionalData) {
            this.additionalData = _additionalData == null ? null : _additionalData.toBuilder();
            return this;
        }

        @Override
        public ExceptionModel build() {
            return new ExceptionModelImpl(this);
        }

        @Override
        public ExceptionModelBuilder toBuilder() {
            return this;
        }

        @Override
        public ExceptionModelBuilder prune() {
            this.reason = this.reason.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.additionalData != null && !this.additionalData.prune().hasData()) {
                this.additionalData = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getReason() != null && this.getReason().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAdditionalData() != null && this.getAdditionalData().hasData();
        }

        public ExceptionModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExceptionModelBuilder o = (ExceptionModelBuilder)other;
            merger.mergeRosetta(this.getReason(), o.getReason(), this::getOrCreateReason);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdditionalData(), (RosettaModelObjectBuilder)o.getAdditionalData(), this::setAdditionalData);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExceptionModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.reason, _that.getReason())) {
                return false;
            }
            return Objects.equals(this.additionalData, _that.getAdditionalData());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            _result = 31 * _result + (this.additionalData != null ? this.additionalData.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExceptionModelBuilder {reason=" + this.reason + ", additionalData=" + this.additionalData + '}';
        }
    }

    public static interface ExceptionModelBuilder
    extends ExceptionModel,
    RosettaModelObjectBuilder {
        public Reason.ReasonBuilder getOrCreateReason(int var1);

        public List<? extends Reason.ReasonBuilder> getReason();

        public AdditionalData.AdditionalDataBuilder getOrCreateAdditionalData();

        @Override
        public AdditionalData.AdditionalDataBuilder getAdditionalData();

        public ExceptionModelBuilder addReason(Reason var1);

        public ExceptionModelBuilder addReason(Reason var1, int var2);

        public ExceptionModelBuilder addReason(List<? extends Reason> var1);

        public ExceptionModelBuilder setReason(List<? extends Reason> var1);

        public ExceptionModelBuilder setAdditionalData(AdditionalData var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("reason"), processor, Reason.ReasonBuilder.class, this.getReason(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalData"), processor, AdditionalData.AdditionalDataBuilder.class, this.getAdditionalData(), new AttributeMeta[0]);
        }

        public ExceptionModelBuilder prune();
    }

    public static class ExceptionModelImpl
    implements ExceptionModel {
        private final List<? extends Reason> reason;
        private final AdditionalData additionalData;

        protected ExceptionModelImpl(ExceptionModelBuilder builder) {
            this.reason = Optional.ofNullable(builder.getReason()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.additionalData = Optional.ofNullable(builder.getAdditionalData()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason> getReason() {
            return this.reason;
        }

        @Override
        @RosettaAttribute(value="additionalData")
        @RuneAttribute(value="additionalData")
        public AdditionalData getAdditionalData() {
            return this.additionalData;
        }

        @Override
        public ExceptionModel build() {
            return this;
        }

        @Override
        public ExceptionModelBuilder toBuilder() {
            ExceptionModelBuilder builder = ExceptionModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExceptionModelBuilder builder) {
            Optional.ofNullable(this.getReason()).ifPresent(builder::setReason);
            Optional.ofNullable(this.getAdditionalData()).ifPresent(builder::setAdditionalData);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExceptionModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.reason, _that.getReason())) {
                return false;
            }
            return Objects.equals(this.additionalData, _that.getAdditionalData());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            _result = 31 * _result + (this.additionalData != null ? this.additionalData.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExceptionModel {reason=" + this.reason + ", additionalData=" + this.additionalData + '}';
        }
    }
}

